/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.common.helper.ModelHelper;

public class BodySysMangeSaveValidator
extends AbstractTmcBizOppValidator {
    private static final Pattern PATTERN = Pattern.compile("^\\s.*|.*\\s$");

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applyrereportentry");
        selector.add("name");
        selector.add("applyrereportentry.rerporttype");
        selector.add("applyrereportentry.rereporttypestatus");
        selector.add("applyrereportentry.isroll");
        selector.add("applyrereportentry.rollnumber");
        selector.add("applyrereportentry.iscontaindetail");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ExtendedDataEntity extendedDataEntity = extendedDataEntities[0];
        DynamicObject dyObj = extendedDataEntity.getDataEntity();
        DynamicObjectCollection reReportTypeColl = dyObj.getDynamicObjectCollection("applyrereportentry");
        if (!this.reportTypeValidator(extendedDataEntity, reReportTypeColl).booleanValue()) {
            return;
        }
        String systemName = dyObj.getString("name");
        Matcher matcher = PATTERN.matcher(systemName);
        if (matcher.matches()) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4f53\u7cfb\u540d\u79f0\u524d\u540e\u4e0d\u5141\u8bb8\u6709\u7a7a\u683c\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BodySysMangeSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return;
        }
    }

    private Boolean reportTypeValidator(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection reReportTypeColl) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long systemId = dataEntity.getLong("id");
        boolean isOnlyOneOpen = Boolean.FALSE;
        boolean isOnlyOneEnable = Boolean.TRUE;
        HashSet<String> orgReportCycleSet = new HashSet<String>(reReportTypeColl.size());
        for (DynamicObject reportType : reReportTypeColl) {
            DynamicObject reReportType = reportType.getDynamicObject("rerporttype");
            if ("enable".equals(reportType.get("rereporttypestatus")) && !reReportType.getBoolean("enable")) {
                this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u6240\u5f15\u7528\u7684\u7f16\u62a5\u7c7b\u578b%1$s\u5df2\u7981\u7528\u3002", (String)"BodySysMangeSaveValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), reReportType.getString("name")), ErrorLevel.Error);
                return Boolean.FALSE;
            }
            if (reportType.getBoolean("isroll")) {
                Object rollNumber = reportType.get("rollnumber");
                if (rollNumber == null || Integer.valueOf(0).equals(rollNumber)) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f00\u542f\u6eda\u52a8\u7f16\u5236\u65f6\uff0c\u6eda\u52a8\u671f\u6570\u5fc5\u5f55\u3002", (String)"BodySysMangeSaveValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), ErrorLevel.Error);
                    return Boolean.FALSE;
                }
                Integer rollNum = Integer.valueOf(rollNumber.toString());
                if (rollNum > 12 || rollNum < 2) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6eda\u52a8\u671f\u6570\u8d85\u51fa\u53d6\u6570\u8303\u56f4[2,12]\u3002", (String)"BodySysMangeSaveValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), ErrorLevel.Error);
                    return Boolean.FALSE;
                }
            }
            if ("enable".equals(reportType.get("rereporttypestatus"))) {
                isOnlyOneOpen = Boolean.TRUE;
            }
            String reReportTypeStatus = reportType.getString("rereporttypestatus");
            if (!Objects.nonNull(reReportType)) continue;
            String orgReportCycle = reReportType.getString("orgreportcycle");
            if (!"enable".equals(reReportTypeStatus) || orgReportCycleSet.add(orgReportCycle)) continue;
            isOnlyOneEnable = Boolean.FALSE;
        }
        if (!isOnlyOneOpen) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4f53\u7cfb\u9879\u4e0b\u9002\u7528\u7f16\u62a5\u7c7b\u578b\u4e0d\u53ef\u5168\u4e3a\u201c\u7981\u7528\u201d\uff0c\u8bf7\u81f3\u5c11\u542f\u7528\u4e00\u4e2a\u7f16\u62a5\u7c7b\u578b\u3002", (String)"BodySysMangeSaveValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return Boolean.FALSE;
        }
        if (!isOnlyOneEnable) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u4f53\u7cfb\u4e0b\u540c\u4e00\u7f16\u62a5\u5468\u671f\u4ec5\u80fd\u5b58\u5728\u4e00\u6761\u542f\u7528\u7684\u8bb0\u5f55\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539", (String)"BodySysMangeSaveValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return Boolean.FALSE;
        }
        List disableReportTypeList = reReportTypeColl.stream().filter(e -> "disable".equals(e.get("rereporttypestatus"))).collect(Collectors.toList());
        if (!((Boolean)ModelHelper.reReportTypeDisableValidator((Object)extendedDataEntity.getDataEntity().getPkValue(), disableReportTypeList).getLeft()).booleanValue()) {
            return Boolean.FALSE;
        }
        List sumOpenList = reReportTypeColl.stream().filter(e -> e.getBoolean("issumreport")).collect(Collectors.toList());
        if (!ModelHelper.reReportTypeOpenValidator(sumOpenList).booleanValue()) {
            return Boolean.FALSE;
        }
        List sumCloseList = reReportTypeColl.stream().filter(e -> !e.getBoolean("issumreport")).collect(Collectors.toList());
        if (!ModelHelper.reReportTypeOpenValidator(sumCloseList).booleanValue()) {
            return Boolean.FALSE;
        }
        String reportTypeIdKey = "applyrereportentry.rerporttype";
        String isRollKey = "applyrereportentry.isroll";
        String rollNumberKey = "applyrereportentry.rollnumber";
        String isContainDetailKey = "applyrereportentry.iscontaindetail";
        String selectSysProp = String.join((CharSequence)",", reportTypeIdKey, isRollKey, rollNumberKey, isContainDetailKey);
        DynamicObjectCollection bodyReportTypeInfo = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)selectSysProp, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)systemId)});
        if (CollectionUtils.isEmpty((Collection)bodyReportTypeInfo)) {
            return true;
        }
        ArrayList<Long> reportTypeId = new ArrayList<Long>(bodyReportTypeInfo.size());
        Map dbSystemInfoByReportTypeIdMap = bodyReportTypeInfo.stream().collect(Collectors.toMap(k -> k.getLong(reportTypeIdKey), Function.identity()));
        for (DynamicObject typeInfo : reReportTypeColl) {
            DynamicObject reReportType = typeInfo.getDynamicObject("rerporttype");
            long id = reReportType.getLong("id");
            DynamicObject dbInfo = (DynamicObject)dbSystemInfoByReportTypeIdMap.get(id);
            if (Objects.isNull(dbInfo)) continue;
            boolean isRoll = typeInfo.getBoolean("isroll");
            int rollNum = typeInfo.getInt("rollnumber");
            boolean isContain = typeInfo.getBoolean("iscontaindetail");
            if (!Objects.equals(dbInfo.getBoolean(isRollKey), isRoll)) {
                reportTypeId.add(id);
                continue;
            }
            if (!Objects.equals(dbInfo.getInt(rollNumberKey), rollNum)) {
                reportTypeId.add(id);
                continue;
            }
            if (Objects.equals(dbInfo.getBoolean(isContainDetailKey), isContain)) continue;
            reportTypeId.add(id);
        }
        if (CollectionUtils.isEmpty(reportTypeId)) {
            return true;
        }
        String selectProp = String.join((CharSequence)",", "reportperiod.name", "reportperiod.reporttype.id", "reportperiod.reporttype.name");
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_report", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)systemId), new QFilter("reportperiod.reporttype.id", "in", reportTypeId), new QFilter("planstatus", "in", ReportStatus.unEnableStatus())});
        if (!CollectionUtils.isEmpty((Collection)queryResult)) {
            String errMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u201c%1$s\u201d\u4e0b%2$s\u5b58\u5728\u672a\u751f\u6548\u7684\u8ba1\u5212\u7f16\u5236\u5355\u636e\uff0c\u6682\u4e0d\u5141\u8bb8\u4fee\u6539\u6eda\u52a8\u7f16\u5236\u76f8\u5173\u7684\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BodySysMangeSaveValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]);
            Map<Long, List<DynamicObject>> reportTypeMap = queryResult.stream().collect(Collectors.groupingBy(k -> k.getLong("reportperiod.reporttype.id")));
            reportTypeMap.forEach((k, v) -> {
                DynamicObject dynamicObject = (DynamicObject)v.get(0);
                String typeName = dynamicObject.getString("reportperiod.reporttype.name");
                StringBuilder periodName = new StringBuilder();
                Set nameList = v.stream().map(item -> item.getString("reportperiod.name")).collect(Collectors.toSet());
                for (String period : nameList) {
                    periodName.append("\"").append(period).append("\"");
                    periodName.append(",");
                }
                if (periodName.length() > 0) {
                    periodName.deleteCharAt(periodName.length() - 1);
                }
                String format = String.format(errMsg, typeName, periodName);
                this.addErrorMessage(extendedDataEntity, format);
            });
            return false;
        }
        return Boolean.TRUE;
    }
}

