/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class CurrencyMapConfigConfirmValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject dynamicObject = entity.getDataEntity();
            if (dynamicObject.getString("name").length() > 50) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26", (String)"CurrencyMapConfigConfirmValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            if (dynamicObject.getString("number").length() > 50) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"CurrencyMapConfigConfirmValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8bbe\u7f6e\u4e00\u6761\u5e01\u79cd\u6298\u7b97\u6620\u5c04\u65b9\u6848\u3002", (String)"CurrencyMapConfigConfirmValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(dynamicObjectCollection.size());
            HashMap downLevelMap = new HashMap(dynamicObjectCollection.size());
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject dy = (DynamicObject)dynamicObjectCollection.get(i);
                DynamicObject currencyMember = dy.getDynamicObject("sumcurrencymemberid");
                if (Objects.isNull(currencyMember)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u6c47\u603b\u7684\u6210\u5458\u5e01\u79cd\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CurrencyMapConfigConfirmValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), i + 1));
                    continue;
                }
                DynamicObjectCollection objectCollection = dy.getDynamicObjectCollection("submainreportcurrencyid");
                if (CollectionUtils.isEmpty((Collection)objectCollection)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u4e0b\u7ea7\u4e3b\u4f53\u7684\u62a5\u9001\u5e01\u79cd\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CurrencyMapConfigConfirmValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]), i + 1));
                    continue;
                }
                Object pkValue = dy.getPkValue();
                if (hashMap.containsKey(pkValue)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u6c47\u603b\u7684\u6210\u5458\u5e01\u79cd\u201d\u4e0e\u7b2c%2$s\u884c\u7684\u201c\u6c47\u603b\u7684\u6210\u5458\u5e01\u79cd\u201d\u91cd\u590d\u3002", (String)"CurrencyMapConfigConfirmValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]), i + 1, hashMap.get(pkValue)));
                    continue;
                }
                Integer index = i;
                Map downLevelEntryMap = objectCollection.stream().map(ds -> ds.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toMap(Function.identity(), t -> index));
                HashSet downLevelSet = new HashSet(downLevelMap.keySet());
                HashSet downLevelEntrySet = new HashSet(downLevelEntryMap.keySet());
                downLevelEntrySet.retainAll(downLevelSet);
                if (!downLevelEntrySet.isEmpty()) {
                    Object next = downLevelEntrySet.iterator().next();
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u6c47\u603b\u7684\u6210\u5458\u5e01\u79cd\u201d\u4e0e\u7b2c%2$s\u884c\u7684\u201c\u6c47\u603b\u7684\u6210\u5458\u5e01\u79cd\u201d\u91cd\u590d\u3002", (String)"CurrencyMapConfigConfirmValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]), i + 1, downLevelMap.get(next)));
                    continue;
                }
                hashMap.put(pkValue, i + 1);
            }
        }
    }
}

