/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;

public class InternalCancelRuleDisableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys");
        selector.add("number");
        selector.add("name");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set innerCancelRuleIdSet = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        Set systemIdSet = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getDynamicObject("bodysys")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        String selectFields = String.join((CharSequence)",", "id", "billno");
        QFilter qFilter = new QFilter("bodysys", "in", systemIdSet).and("planstatus", "!=", (Object)ReportPlanStatusEnum.EFFECTIVE.getValue());
        Object[] load = TmcDataServiceHelper.load((String)"fpm_reportplansum", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])load)) {
            return;
        }
        Map sumPlanMap = Arrays.stream(load).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        QFilter innerCancelFilter = new QFilter("sumplanrecordid", "in", sumPlanMap.keySet()).and("systemid", "in", systemIdSet).and("cancelruleid", "in", innerCancelRuleIdSet);
        String select = String.join((CharSequence)",", "sumplanrecordid", "cancelruleid");
        Object[] dynamicObjects = TmcDataServiceHelper.load((String)"fpm_innercancelrecord", (String)select, (QFilter[])new QFilter[]{innerCancelFilter});
        if (EmptyUtil.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        Map innerCancelSumRecordMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("cancelruleid").getPkValue(), Collectors.mapping(dy -> dy.getDynamicObject("sumplanrecordid").getPkValue(), Collectors.toSet())));
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject innerCancelRule = extendedDataEntity.getDataEntity();
            Object pkValue = innerCancelRule.getPkValue();
            Set sumRecordIds = innerCancelSumRecordMap.get(pkValue);
            if (EmptyUtil.isEmpty(sumRecordIds)) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u6240\u9009\u62b5\u6d88\u89c4\u5219\u3010%1$s %2$s\u3011\u5df2\u88ab\u5728\u9014\u7684\u6c47\u603b\u7f16\u62a5\u5355\u636e\u3010%3$s\u3011\u5173\u8054\u4f7f\u7528\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u7981\u7528\u64cd\u4f5c\u3002", (String)"InternalCancelRuleDisableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), innerCancelRule.getString("number"), innerCancelRule.getString("name"), sumPlanMap.values().stream().filter(dy -> sumRecordIds.contains(dy.getPkValue())).map(dy -> dy.getString("billno")).collect(Collectors.joining(","))));
        }
    }
}

