/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class MatchRuleEnableValidator
extends AbstractTmcBizOppValidator {
    private static final String ID = "id";

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (Objects.isNull(extendedDataEntities) || extendedDataEntities.length == 0) {
            return;
        }
        List idList = Stream.of(extendedDataEntities).map(e -> e.getBillPkId()).collect(Collectors.toList());
        DynamicObject[] dbDataArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_matchrule"));
        HashSet bodySysIdSet = new HashSet(extendedDataEntities.length);
        Map dynamicObjectMap = Stream.of(dbDataArr).map(dynamicObject -> {
            bodySysIdSet.add(dynamicObject.getDynamicObject("bodysys").getPkValue());
            return dynamicObject;
        }).collect(Collectors.toMap(e -> e.getPkValue(), Function.identity()));
        HashMap<String, DynamicObject> enabled = new HashMap<String, DynamicObject>(extendedDataEntities.length);
        StringBuilder sb = new StringBuilder();
        String selectFields = String.join((CharSequence)",", ID, "bodysys", "businessbill", "name", "number");
        QFilter qFilter = new QFilter("bodysys", "in", bodySysIdSet).and("enable", "=", (Object)"1");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_matchrule", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        Map<String, List<DynamicObject>> existsEnabled = dynamicObjectCollection.stream().collect(Collectors.groupingBy(o -> o.getString("bodysys") + "_" + o.getString("businessbill")));
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject enabledDynamicObject = null;
            Object id = extendedDataEntity.getBillPkId();
            DynamicObject dbData = (DynamicObject)dynamicObjectMap.get(id);
            if (dbData.getBoolean("enable")) continue;
            Object bodySys = dbData.get("bodysys.id");
            DynamicObject businessBillObj = (DynamicObject)dbData.get("businessbill");
            String businessBill = businessBillObj.getString("number");
            String key = sb.append(bodySys).append("_").append(businessBill).toString();
            sb.delete(0, sb.length());
            List<DynamicObject> dynamicObjectList = existsEnabled.get(key);
            if (CollectionUtils.isNotEmpty(dynamicObjectList)) {
                enabledDynamicObject = dynamicObjectList.get(0);
            }
            if (Objects.isNull(enabledDynamicObject)) {
                enabledDynamicObject = (DynamicObject)enabled.get(key);
            }
            if (Objects.nonNull(enabledDynamicObject)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u7cfb\u7edf\u5df2\u5b58\u5728\u201c\u53ef\u7528\u201d\u72b6\u6001\u4e0b\u7684%1$s\u8d44\u91d1\u8ba1\u5212\u6267\u884c\u7684\u53d6\u6570\u89c4\u5219\u201c%2$s\u201d\uff08%3$s\uff09\u3002\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"MatchRuleEnableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), businessBillObj.getString("name"), enabledDynamicObject.getString("number"), enabledDynamicObject.getString("name")));
                continue;
            }
            if (enabled.containsKey(key)) continue;
            enabled.put(key, dbData);
        }
    }
}

