/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.convert.IEGatherSchemeDataConvert;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;

public class StartIntelligentGatherValidator
extends AbstractTmcBizOppValidator {
    private static final String HEAD_SOURCEBILL = "sourcebill";
    private static final String HEAD_ORGRANGE = "orgrange";
    private static final String HEAD_FBASEDATAID_ID = "fbasedataid.id";
    private static final String HEAD_FBASEDATAID_NAME = "fbasedataid.name";

    public List<String> getSelector() {
        List seletor = super.getSelector();
        seletor.add(HEAD_SOURCEBILL);
        seletor.add(HEAD_ORGRANGE);
        return seletor;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            Set orgs;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String sourceBill = dataEntity.getDynamicObject(HEAD_SOURCEBILL).getString("number");
            String billName = MetadataServiceHelper.getDataEntityType((String)sourceBill).getDisplayName().getLocaleValue();
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter(HEAD_SOURCEBILL, "=", (Object)sourceBill));
            DynamicObject[] smartCollectPlans = TmcDataServiceHelper.load((String)"fpm_smartcollect", (String)String.format("%s,%s", "name", "id"), (QFilter[])new QFilter[]{filter});
            Set<Long> schemeIds = Arrays.stream(smartCollectPlans).filter(Objects::nonNull).map(smartColPlan -> smartColPlan.getLong("id")).collect(Collectors.toSet());
            List<IntelligentGatherScheme> schemes = IEGatherSchemeDataConvert.getSmartCollectScheme(schemeIds);
            Optional<IntelligentGatherScheme> any = schemes.stream().filter(Objects::nonNull).filter(scheme -> scheme.getApplyOrgs().isEmpty()).findAny();
            DynamicObjectCollection orgDys = dataEntity.getDynamicObjectCollection(HEAD_ORGRANGE);
            ArrayList<String> checkOrgMsgs = new ArrayList<String>(10);
            HashSet<Long> removeOrgIds = new HashSet<Long>(orgDys.size());
            if (!any.isPresent()) {
                Set schemeInOrgs = schemes.stream().filter(Objects::nonNull).map(scheme -> scheme.getApplyOrgs()).flatMap(Collection::stream).map(org -> org.getOrgId()).collect(Collectors.toSet());
                for (DynamicObject orgDy : orgDys) {
                    long orgId2 = orgDy.getLong(HEAD_FBASEDATAID_ID);
                    if (schemeInOrgs.contains(orgId2)) continue;
                    String orgName = orgDy.getString(HEAD_FBASEDATAID_NAME);
                    String checkMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u7ec4\u7ec7\u3010%1$s\u3011\u5bf9\u5e94\u3010%2$s\u3011\u5355\u636e\u4e0b\u201c\u53ef\u7528\u201d\u72b6\u6001\u7684\u667a\u80fd\u91c7\u96c6\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"StartIntelligentGatherValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), orgName, billName);
                    checkOrgMsgs.add(checkMsg);
                    removeOrgIds.add(orgId2);
                }
            }
            if (EmptyUtil.isNoEmpty(checkOrgMsgs)) {
                String tipMsg = checkOrgMsgs.stream().collect(Collectors.joining(";\n"));
                this.addWarningMessage(extendedDataEntity, tipMsg);
            }
            if (!EmptyUtil.isEmpty(orgs = orgDys.stream().filter(Objects::nonNull).map(o -> o.getLong(HEAD_FBASEDATAID_ID)).filter(orgId -> removeOrgIds.add((Long)orgId)).collect(Collectors.toSet()))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u60a8\u6240\u9009\u9002\u7528\u7ec4\u7ec7\u7684\u53ef\u7528\u667a\u80fd\u91c7\u96c6\u65b9\u6848", (String)"StartIntelligentGatherValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }
}

