/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.ReportPlanTypeEnum;

public class SummaryConfigDeleteValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys");
        selector.add("sumreporttype");
        selector.add("enable");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (EmptyUtil.isEmpty((Object[])dataEntity)) {
            return;
        }
        List enableData = Arrays.stream(dataEntity).filter(item -> BaseEnableEnum.ENABLE.getValue().equals(item.getDataEntity().get("enable"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(enableData)) {
            this.getFalseDataEntities().addAll(enableData);
        }
        if ((dataEntity = Arrays.stream(dataEntity).filter(item -> BaseEnableEnum.DISABLE.getValue().equals(item.getDataEntity().get("enable"))).collect(Collectors.toList()).toArray(new ExtendedDataEntity[0])).length == 0) {
            return;
        }
        Long systemId = (Long)dataEntity[0].getDataEntity().getDynamicObject("bodysys").getPkValue();
        Set reportTypeSet = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getDynamicObjectCollection("sumreporttype")).flatMap(Collection::stream).map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet());
        String reportTypeProp = String.join((CharSequence)".", "reportperiod", "reporttype");
        String selectFields = String.join((CharSequence)",", "id", reportTypeProp);
        Object[] load = TmcDataServiceHelper.load((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)systemId).and(reportTypeProp, "in", reportTypeSet).and("reportplantype", "=", (Object)ReportPlanTypeEnum.SUMPLAN.getValue())});
        if (EmptyUtil.isEmpty((Object[])load)) {
            return;
        }
        Map reportTypeMap = Arrays.stream(load).map(dy -> dy.getDynamicObject(reportTypeProp)).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
        block0: for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = entity.getDynamicObjectCollection("sumreporttype");
            for (DynamicObject reportType : dynamicObjectCollection) {
                Object pkValue;
                DynamicObject dynamicObject = reportType.getDynamicObject("fbasedataid");
                if (EmptyUtil.isEmpty((DynamicObject)dynamicObject) || !reportTypeMap.containsKey(pkValue = dynamicObject.getPkValue())) continue;
                DynamicObject rt = (DynamicObject)reportTypeMap.get(pkValue);
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5f53\u524d\u4f53\u7cfb\u4e0b\u5bf9\u5e94\u7f16\u62a5\u7c7b\u578b\u3010%1$s\u3011\u5df2\u5b58\u5728\u6c47\u603b\u7f16\u5236\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5220\u9664\u64cd\u4f5c", (String)"SummaryConfigDeleteValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), rt.getString("name")));
                continue block0;
            }
        }
    }
}

