/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.domain.enums.TaskStatus;

public class TaskRecordExecuteValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("status");
        selector.add("tasktype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set taskTypes = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getString("tasktype")).collect(Collectors.toSet());
        if (taskTypes.size() > 1) {
            String message = ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4efb\u52a1\u7c7b\u578b\u7684\u4efb\u52a1\u6267\u884c\u3002", (String)"TaskRecordExecuteValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            String message;
            DynamicObject entity = extendedDataEntity.getDataEntity();
            String status = entity.getString("status");
            if (Objects.equals(status, TaskStatus.DONE.name())) {
                message = ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210\u7684\u4efb\u52a1\u4e0d\u80fd\u518d\u6b21\u6267\u884c\u3002", (String)"TaskRecordExecuteValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
                this.addErrorMessage(extendedDataEntity, message);
                continue;
            }
            if (!Objects.equals(status, TaskStatus.HANDLING.name())) continue;
            message = ResManager.loadKDString((String)"\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u4e0d\u80fd\u518d\u6b21\u6267\u884c\u3002", (String)"TaskRecordExecuteValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, message);
        }
    }
}

