/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.domain.enums.DimensionType;

public class MemberEnableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("name");
        selector.add("parent");
        selector.add("bodysystem");
        selector.add("dimtype");
        selector.add("parent");
        selector.add("enable");
        selector.add("level");
        selector.add("enddate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (extendedDataEntities.length == 0) {
            return;
        }
        String dimType = extendedDataEntities[0].getDataEntity().getString("dimtype");
        ArrayList<Long> enableList = new ArrayList<Long>(extendedDataEntities.length);
        Arrays.sort(extendedDataEntities, (o1, o2) -> {
            Long level1 = o1.getDataEntity().getLong("level");
            Long level2 = o2.getDataEntity().getLong("level");
            return level1.compareTo(level2);
        });
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            Boolean validate = Boolean.TRUE;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long memberId = dataEntity.getLong("id");
            if (DimensionType.PERIOD.getNumber().equals(dimType)) {
                DynamicObject parent = dataEntity.getDynamicObject("parent");
                if (parent != null && !parent.getBoolean("enable") && !enableList.contains(parent.getLong("id"))) {
                    String errorInfo = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u82e5\u9700\u66f4\u65b0\u660e\u7ec6\u671f\u95f4\u6210\u5458\u4f7f\u7528\u72b6\u6001\uff0c\u8bf7\u9488\u5bf9\u5176\u4e0a\u7ea7\u8282\u70b9\u8fdb\u884c\u201c\u542f\u7528\u201d\u5904\u7406\u3002", (String)"MemberEnableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorInfo);
                    validate = Boolean.FALSE;
                }
                Date endDate = dataEntity.getDate("enddate");
                if (DateUtils.getCurrentTime().compareTo(endDate) > 0) {
                    String errorInfo = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u5c0f\u4e8e\u7cfb\u7edf\u5f53\u524d\u65e5\u65f6\uff0c\u6682\u4e0d\u652f\u6301\u542f\u7528\u64cd\u4f5c\u3002", (String)"MemberEnableValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorInfo);
                    validate = Boolean.FALSE;
                }
            }
            if (!validate.booleanValue()) continue;
            enableList.add(memberId);
        }
    }
}

