/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.dimension;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;

public class MemberSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (EmptyUtil.isEmpty((Object[])dataEntity)) {
            return;
        }
        Set orgMemberIdSet = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).filter(dy -> Objects.equals(dy.getString("dimtype"), DimensionType.ORG.getNumber())).map(DataEntityBase::getPkValue).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(orgMemberIdSet)) {
            return;
        }
        Map<Object, Object> orgMemberParentIdMap = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).filter(dy -> orgMemberIdSet.contains(dy.getPkValue())).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> {
            DynamicObject parent = dy.getDynamicObject("parent");
            if (EmptyUtil.isEmpty((DynamicObject)parent)) {
                return 0L;
            }
            return parent.getPkValue();
        }));
        Object[] existsOrgMemberArr = TmcDataServiceHelper.load((Object[])orgMemberIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_member"));
        if (EmptyUtil.isEmpty((Object[])existsOrgMemberArr)) {
            return;
        }
        Set hasChangedParentOrgIdSet = Arrays.stream(existsOrgMemberArr).filter(dy -> {
            Object pkValue = dy.getPkValue();
            DynamicObject parent = dy.getDynamicObject("parent");
            Object pid = 0L;
            if (EmptyUtil.isNoEmpty((DynamicObject)parent)) {
                pid = parent.getPkValue();
            }
            return !Objects.equals(pid, orgMemberParentIdMap.get(pkValue));
        }).filter(Objects::nonNull).map(DataEntityBase::getPkValue).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(hasChangedParentOrgIdSet)) {
            return;
        }
        String selectFields = String.join((CharSequence)",", "id", "reportorg", "billno");
        Object[] load = TmcDataServiceHelper.load((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("reportorg", "in", hasChangedParentOrgIdSet).and("planstatus", "!=", (Object)ReportPlanStatusEnum.EFFECTIVE.getValue())});
        if (EmptyUtil.isEmpty((Object[])load)) {
            return;
        }
        Map<Object, List<DynamicObject>> objectListMap = Arrays.stream(load).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("reportorg").getPkValue()));
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            List<DynamicObject> dynamicObjects;
            DynamicObject entity = extendedDataEntity.getDataEntity();
            Object pkValue = entity.getPkValue();
            if (EmptyUtil.isEmpty((Object)pkValue) || !objectListMap.containsKey(pkValue) || EmptyUtil.isEmpty(dynamicObjects = objectListMap.get(pkValue))) continue;
            String sumRecordNums = dynamicObjects.stream().map(dy -> dy.getString("billno")).collect(Collectors.joining(","));
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fee\u6539\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u7f16\u62a5\u4e3b\u4f53\u5b58\u5728\u5728\u9014\u672a\u751f\u6548\u7684\u7f16\u5236\u5355\u636e\u3010%1$s\u3011\uff0c\u6682\u4e0d\u5141\u8bb8\u8c03\u6574\u6240\u5728\u4e0a\u7ea7\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"MemberSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), sumRecordNums));
        }
    }
}

