/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.inoutpool;

import java.util.Arrays;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CronPlanCollectGenerateBillValidate
extends AbstractTmcBizOppValidator {
    private static final Log LOGGER = LogFactory.getLog(CronPlanCollectGenerateBillValidate.class);

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        OperateOption option = this.getOption();
        String days = option.getVariableValue("GENERATE_OPERATOR_VARIABLE_DAYS");
        if (StringUtils.isEmpty((CharSequence)days)) {
            for (ExtendedDataEntity entity : dataEntity) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4f20\u5165\u751f\u6210\u56fa\u5b9a\u6536\u652f\u7684\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"CronPlanCollectGenerateBillValidate_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            return;
        }
        try {
            int day = Integer.parseInt(days);
            if (day < 1 || day > 998) {
                for (ExtendedDataEntity entity : dataEntity) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4f20\u5165\u751f\u6210\u56fa\u5b9a\u6536\u652f\u7684\u65e5\u671f\u8303\u56f4\u5fc5\u987b\u4e3a\uff080-999\uff09\u6574\u6570", (String)"CronPlanCollectGenerateBillValidate_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            for (ExtendedDataEntity entity : dataEntity) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4f20\u5165\u751f\u6210\u56fa\u5b9a\u6536\u652f\u7684\u65e5\u671f\u8303\u56f4\u5fc5\u987b\u4e3a\u6574\u6570", (String)"CronPlanCollectGenerateBillValidate_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            return;
        }
        String variableValue = option.getVariableValue("GENERATE_OPERATOR_VARIABLE_TEMPLATE_ID");
        if (StringUtils.isEmpty((CharSequence)variableValue)) {
            String selectFields = String.join((CharSequence)",", "id", "enable");
            QFilter qFilter = new QFilter("id", "in", Arrays.stream(dataEntity).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toSet()));
            DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_cronplanmaintain", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
            String collect = Arrays.stream(load).filter(dy -> dy.getBoolean("enable")).map(DataEntityBase::getPkValue).filter(EmptyUtil::isNoEmpty).map(String::valueOf).collect(Collectors.joining(","));
            option.setVariableValue("GENERATE_OPERATOR_VARIABLE_TEMPLATE_ID", collect);
            for (ExtendedDataEntity entity : dataEntity) {
                String billNo = entity.getBillNo();
                if (collect.indexOf(billNo) != -1) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u6a21\u677f:%1$s\u4e0d\u53ef\u7528", (String)"CronPlanCollectGenerateBillValidate_3", (String)"tmc-fpm-business", (Object[])new Object[0]), billNo));
            }
            return;
        }
        String[] split = variableValue.split(",");
        try {
            Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            for (ExtendedDataEntity entity : dataEntity) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4f20\u5165\u751f\u6210\u56fa\u5b9a\u6536\u652f\u7684\u6a21\u677fid\u5fc5\u987b\u4e3a\u4ee5\u9017\u53f7\u5206\u9694\u7684\u6574\u578b\u5b57\u7b26\u4e32", (String)"CronPlanCollectGenerateBillValidate_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
    }
}

