/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.inspection;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.common.enums.InspectionScopeEnum;

public class InspectControlTraceValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("inspectionscope");
        selectors.add("bodysys.id");
        return selectors;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (Objects.isNull(dataEntity) || dataEntity.length == 0) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            String inspectScope = entity.getString("inspectionscope");
            InspectionScopeEnum inspectionScopeEnum = InspectionScopeEnum.getByValue((String)inspectScope);
            if (inspectionScopeEnum == InspectionScopeEnum.BILL_INSPECTION) continue;
            String errorMsg = ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u5f53\u524d\u914d\u7f6e\u7684\u5de1\u68c0\u8303\u56f4\u4e3a\uff1a\u3010%1$s\u3011\uff0c\u4e0d\u652f\u6301\u94fe\u8def\u5de1\u68c0\u3002", (String)"InspectControlTraceValidator_0", (String)"tmc-fpm-business", (Object[])new Object[]{Objects.isNull(inspectionScopeEnum) ? inspectScope : inspectionScopeEnum.getName()});
            this.addErrorMessage(extendedDataEntity, errorMsg);
        }
    }
}

