/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.helper.SumPlanRelationHelper;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import org.apache.commons.collections4.CollectionUtils;

public class ReportChangeAuditValidator
extends AbstractTmcBizOppValidator {
    private ISummaryConfigService iSummaryConfigService = FpmServiceFactory.getBizService(ISummaryConfigService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("originalreportids");
        selector.add("bodysys.id");
        selector.add("reportorg.id");
        selector.add("reporttype.id");
        selector.add("reportperiod.id");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Map<String, SumPlanParamConfig> sameBatchSumParamConfigMap = this.loadAdjustBillSumPlanParamConfigMap(extendedDataEntities);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            this.validateParentSumReportStatus(extendedDataEntity, sameBatchSumParamConfigMap);
        }
    }

    private String getBatchKey(DynamicObject billDy) {
        Long reportTypeId = billDy.getLong("reporttype.id");
        Long reportPeriodId = billDy.getLong("reportperiod.id");
        return String.join((CharSequence)"#", String.valueOf(reportTypeId), String.valueOf(reportPeriodId));
    }

    private Map<String, SumPlanParamConfig> loadAdjustBillSumPlanParamConfigMap(ExtendedDataEntity[] extendedDataEntities) {
        Map<String, List> sameBatchBillMap = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.groupingBy(key -> this.getBatchKey((DynamicObject)key), Collectors.toCollection(LinkedList::new)));
        HashMap sameBatchSumParamConfigMap = Maps.newHashMapWithExpectedSize((int)sameBatchBillMap.size());
        for (Map.Entry<String, List> batchBillEntry : sameBatchBillMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)batchBillEntry.getValue())) continue;
            DynamicObject adjustBillDy = (DynamicObject)batchBillEntry.getValue().get(0);
            String originalReportIds = adjustBillDy.getString("originalreportids");
            String[] originalReportIdArray = originalReportIds.split(",");
            SumPlanParamConfig sumPlanParamConfig = this.iSummaryConfigService.getSummaryParamConfig(Long.valueOf(originalReportIdArray[0]));
            sameBatchSumParamConfigMap.put(this.getBatchKey(adjustBillDy), sumPlanParamConfig);
        }
        return sameBatchSumParamConfigMap;
    }

    private boolean validateParentSumReportStatus(ExtendedDataEntity extendedDataEntity, Map<String, SumPlanParamConfig> sameBatchSumParamConfigMap) {
        DynamicObject adjustBillDy = extendedDataEntity.getDataEntity();
        Long systemId = adjustBillDy.getLong("bodysys.id");
        String adjustBillNo = adjustBillDy.getString("billno");
        Long reportPeriodId = adjustBillDy.getLong("reportperiod.id");
        SumPlanParamConfig sumPlanParamConfig = sameBatchSumParamConfigMap.get(this.getBatchKey(adjustBillDy));
        if (EmptyUtil.isEmpty((Object)sumPlanParamConfig)) {
            QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId).and("reportperiod", "=", (Object)reportPeriodId).and("reportplantype", "=", (Object)ReportPlanType.SUMPLAN.getNumber());
            List sameBatchSumReportIds = QueryServiceHelper.queryPrimaryKeys((String)"fpm_report", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
            if (CollectionUtils.isNotEmpty((Collection)sameBatchSumReportIds)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5ba1\u6838\u5931\u8d25\uff0c\u8c03\u6574\u5355\u539f\u8868\u5b58\u5728\u4e0a\u7ea7\u6c47\u603b\u8868\uff0c\u4f46\u4e0d\u5b58\u5728\u6c47\u603b\u53c2\u6570\u5907\u4efd\uff01\u8bf7\u8fdb\u884c\u5386\u53f2\u6570\u636e\u5347\u7ea7\u3002", (String)"ReportChangeAuditValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), adjustBillNo));
                return false;
            }
            return true;
        }
        Long reportOrgId = adjustBillDy.getLong("reportorg.id");
        List<Long> allParentSumOrgMemberIdList = SumPlanRelationHelper.listAllParentSumOrgId(reportOrgId, sumPlanParamConfig);
        if (CollectionUtils.isEmpty(allParentSumOrgMemberIdList)) {
            return true;
        }
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId).and("reportorg", "in", allParentSumOrgMemberIdList).and("reportperiod", "=", (Object)reportPeriodId).and("reportplantype", "=", (Object)ReportPlanType.SUMPLAN.getNumber()).and("billstatus", "<>", (Object)BillStatusEnum.AUDIT.getValue());
        boolean existUnAuditSumReport = QueryServiceHelper.exists((String)"fpm_report", (QFilter[])qFilter.toArray());
        if (existUnAuditSumReport) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5ba1\u6838\u5931\u8d25\uff0c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4e0a\u7ea7\u6c47\u603b\u8868\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ReportChangeAuditValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), adjustBillNo));
            return false;
        }
        return true;
    }
}

