/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.common.enums.ReportPlanChangeStatusEnum;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReportPlanChangeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("planstatus");
        selector.add("billno");
        selector.add("reportorg");
        selector.add("reportperiod");
        selector.add("parenttemplate");
        selector.add("changestatus");
        selector.add("name");
        selector.add("template.ismaintable");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List<DynamicObject> dataList = Arrays.stream(extendedDataEntities).map(item -> item.getDataEntity()).collect(Collectors.toList());
        boolean belongSameTable = this.belongSameTable(dataList);
        if (!belongSameTable) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u201c\u540c\u4e00\u4e2a\u7f16\u62a5\u4e3b\u4f53\u5728\u540c\u4e00\u7f16\u62a5\u671f\u95f4\u4e0b\uff0c\u4e14\u5bf9\u5e94\u540c\u4e00\u5957\u4e3b\u5b50\u8868\u8303\u56f4\u5185\u7684\u4e00\u5f20/\u591a\u5f20\u5355\u636e\u201d\u53d1\u8d77\u8ba1\u5212\u989d\u5ea6\u8c03\u6574\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u672c\u6b21\u8c03\u6574\u7684\u8ba1\u5212\u7f16\u5236\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanChangeValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        List unEffectList = dataList.stream().filter(item -> !ReportPlanStatusEnum.EFFECTIVE.getValue().equals(item.getString("planstatus"))).collect(Collectors.toList());
        if (unEffectList.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u62e9\u7684\u8d44\u91d1\u8ba1\u5212\u5355\u636e\u4e2d\uff0c\u5355\u636e\u201c%s\u201d\u7684\u8ba1\u5212\u72b6\u6001\u5c1a\u672a\u751f\u6548\u3002\u6682\u4e0d\u652f\u6301\u8fdb\u884c\u8ba1\u5212\u989d\u5ea6\u8c03\u6574\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u64cd\u4f5c\u3002", (String)"ReportPlanChangeValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), ((DynamicObject)unEffectList.get(0)).getString("billno")));
        }
        Pair<Boolean, DynamicObject> changeIng = this.isChangeIng(dataList);
        if (((Boolean)changeIng.getLeft()).booleanValue()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u62e9\u7684\u8ba1\u5212\u7f16\u5236\u5355\u636e\u201c%s\u201d\u7684\u8c03\u6574\u72b6\u6001\u4e3a\u201c\u8ba1\u5212\u8c03\u6574\u4e2d\u201d\u3002\u6682\u4e0d\u652f\u6301\u53d1\u8d77\u8c03\u6574\u3002", (String)"ReportPlanChangeValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), ((DynamicObject)changeIng.getRight()).getString("name")));
        }
    }

    private boolean belongSameTable(List<DynamicObject> selectedDataS) {
        Long orgId;
        Long periodId;
        Long templateId;
        List mainTableList = selectedDataS.stream().filter(item -> item.getBoolean("template.ismaintable")).collect(Collectors.toList());
        if (mainTableList.size() > 1) {
            return false;
        }
        List<Object> subDataList = selectedDataS;
        if (CollectionUtils.isNotEmpty(mainTableList)) {
            DynamicObject mainTable = (DynamicObject)mainTableList.get(0);
            templateId = mainTable.getLong("template.id");
            periodId = mainTable.getLong("reportperiod.id");
            orgId = mainTable.getLong("reportorg.id");
            subDataList = selectedDataS.stream().filter(item -> !item.getBoolean("template.ismaintable")).collect(Collectors.toList());
        } else {
            DynamicObject firstSubData = selectedDataS.get(0);
            templateId = firstSubData.getLong("parenttemplate.id");
            periodId = firstSubData.getLong("reportperiod.id");
            orgId = firstSubData.getLong("reportorg.id");
        }
        return !subDataList.stream().anyMatch(item -> !templateId.equals(item.getLong("parenttemplate.id")) || !periodId.equals(item.getLong("reportperiod.id")) || !orgId.equals(item.getLong("reportorg.id")));
    }

    private Pair<Boolean, DynamicObject> isChangeIng(List<DynamicObject> selectedDataS) {
        Optional<DynamicObject> first = selectedDataS.stream().filter(item -> item.getBoolean("template.ismaintable")).findFirst();
        DynamicObject mainTable = null;
        if (first.isPresent()) {
            mainTable = first.get();
        } else {
            DynamicObject firstSubData = selectedDataS.get(0);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
            qFilterList.add(new QFilter("reportorg.id", "=", (Object)firstSubData.getLong("reportorg.id")));
            qFilterList.add(new QFilter("reportperiod.id", "=", (Object)firstSubData.getLong("reportperiod.id")));
            qFilterList.add(new QFilter("template.id", "=", (Object)firstSubData.getLong("parenttemplate.id")));
            DynamicObject[] mainTableArr = TmcDataServiceHelper.load((String)"fpm_report", (String)"id,changestatus,name", (QFilter[])qFilterList.toArray(new QFilter[0]));
            mainTable = mainTableArr[0];
        }
        return Pair.of((Object)mainTable.getString("changestatus").equals(ReportPlanChangeStatusEnum.CHANGING.getValue()), (Object)mainTable);
    }
}

