/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.domain.enums.ReportStatus;

public class ReportPlanRecalculateAmtValidator
extends AbstractTmcBizOppValidator {
    private static final int MAX_BILL_SIZE = 50;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys.id");
        selector.add("reportperiod.id");
        selector.add("reportorg.id");
        selector.add("billno");
        selector.add("planstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (extendedDataEntities.length > 50) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u4e0b\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanRecalculateAmtValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), 50));
            }
            return;
        }
        Set reportPeriodIdSet = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("reportperiod.id")).collect(Collectors.toSet());
        if (reportPeriodIdSet.size() > 1) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u4e0b\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u5355\u636e\u8303\u56f4\u3002", (String)"ReportPlanRecalculateAmtValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), 50));
            }
            return;
        }
        boolean noneMatchEnableReport = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).noneMatch(dy -> ReportStatus.ENABLE == ReportStatus.getByVal(dy.getString("planstatus")));
        if (noneMatchEnableReport) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5df2\u751f\u6548\u7684\u8ba1\u5212\u8868\u6267\u884c\u6570\u636e\u4fee\u590d\u3002", (String)"ReportPlanRecalculateAmtValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            return;
        }
        this.validateOtherTxLock(extendedDataEntities);
    }

    private void validateOtherTxLock(ExtendedDataEntity[] extendedDataEntities) {
        List businessIdList = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dataEntity -> dataEntity.getLong("id")).map(String::valueOf).collect(Collectors.toList());
        if (businessIdList.isEmpty()) {
            return;
        }
        List lockBusinessIds = TxCheckUtil.loadUnfinishedTx(businessIdList);
        if (!lockBusinessIds.isEmpty()) {
            HashSet lockBusinessIdSet = new HashSet(lockBusinessIds);
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                DynamicObject dataEntity2 = extendedDataEntity.getDataEntity();
                Long reportId = dataEntity2.getLong("id");
                if (!lockBusinessIdSet.contains(String.valueOf(reportId))) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba1\u5212\u7f16\u5236\u5355\u636e %1$s \u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"ReportPlanUnAuditValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), dataEntity2.getString("billno")));
            }
        }
    }
}

