/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.enums.BillStatusEnum;
import kd.tmc.fpm.common.enums.ReportPlanTypeEnum;

public class ReportPlanSmartGelValValidator
extends AbstractTmcBizOppValidator {
    private IControlRepository iControlRepository = FpmServiceFactory.getBizService(IControlRepository.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys.id");
        selector.add("billno");
        selector.add("reportplantype");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (this.isManySystem(extendedDataEntities)) {
            return;
        }
        List<Long> systemIds = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("bodysys.id")).distinct().collect(Collectors.toList());
        Set<Long> existRuleSystemIdSet = this.iControlRepository.existPlanMatchRule("fpm_inoutcollect", systemIds);
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject reportDy = dataEntity.getDataEntity();
            String billNo = reportDy.getString("billno");
            Long systemId = reportDy.getLong("bodysys.id");
            if (!existRuleSystemIdSet.contains(systemId)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u62a5\u8868\u3010%1$s\u3011\u6240\u5c5e\u4f53\u7cfb\u4e0b\u65e0\u53ef\u7528\u72b6\u6001\u7684\u8ba1\u5212\u7f16\u5236\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"ReportPlanSmartGelValValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), billNo));
                continue;
            }
            if (!Objects.equals(ReportPlanTypeEnum.REPORTPLAN.getValue(), reportDy.getString("reportplantype"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u62a5\u8868\u3010%1$s\u3011\u4e0d\u662f\u8ba1\u5212\u7f16\u5236\u7c7b\u578b\u3002", (String)"ReportPlanSmartGelValValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), billNo));
                continue;
            }
            if (Objects.equals(BillStatusEnum.STAGE.getCode(), reportDy.getString("billstatus"))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u62a5\u8868\u3010%1$s\u3011\u4e0d\u662f\u6682\u5b58\u72b6\u6001\u3002", (String)"ReportPlanSmartGelValValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), billNo));
        }
    }

    private boolean isManySystem(ExtendedDataEntity[] extendedDataEntities) {
        Set systemIdSet = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("bodysys.id")).collect(Collectors.toSet());
        if (systemIdSet.size() > 1) {
            for (ExtendedDataEntity dataEntity : extendedDataEntities) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u591a\u4e2a\u62a5\u8868\u667a\u80fd\u53d6\u6570\u5fc5\u987b\u5904\u4e8e\u540c\u4e00\u4f53\u7cfb\u4e0b\u3002", (String)"ReportPlanSmartGelValValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }
}

