/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ReportSumPlanRecalculateAmtValidator
extends AbstractTmcBizOppValidator {
    private ISummaryConfigService iSummaryConfigService = FpmServiceFactory.getBizService(ISummaryConfigService.class);
    private static final int MAX_BILL_SIZE = 5;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("billstatus");
        selector.add("planstatus");
        selector.add("bodysys.id");
        selector.add("reporttype.id");
        selector.add("reportperiod.id");
        selector.add("originalreportids");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (extendedDataEntities.length > 5) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u9700\u8981\u4e3a\u540c\u4e00\u6c47\u603b\u5c42\u7ea7\u4e0b\u7684\u76f8\u540c\u7f16\u62a5\u671f\u95f4\u7684\u5355\u636e\uff0c\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u6c47\u603b\u5355\u636e\u8303\u56f4\u3002", (String)"ReportSumPlanRecalculateAmtValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), 5));
            }
            return;
        }
        Set reportPeriodIdSet = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("reportperiod.id")).collect(Collectors.toSet());
        if (reportPeriodIdSet.size() > 1) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u9700\u8981\u4e3a\u540c\u4e00\u6c47\u603b\u5c42\u7ea7\u4e0b\u7684\u76f8\u540c\u7f16\u62a5\u671f\u95f4\u7684\u5355\u636e\uff0c\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u6c47\u603b\u5355\u636e\u8303\u56f4\u3002", (String)"ReportSumPlanRecalculateAmtValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), 5));
            }
            return;
        }
        boolean noneMatchEnableReport = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).noneMatch(dy -> ReportStatus.ENABLE == ReportStatus.getByVal(dy.getString("planstatus")));
        if (noneMatchEnableReport) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5df2\u751f\u6548\u7684\u8ba1\u5212\u8868\u6267\u884c\u6570\u636e\u4fee\u590d\u3002", (String)"ReportSumPlanRecalculateAmtValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            return;
        }
        Long enableSumReportId = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).filter(dy -> ReportStatus.ENABLE == ReportStatus.getByVal(dy.getString("planstatus"))).map(dy -> dy.getString("originalreportids")).map(Long::parseLong).findAny().get();
        SumPlanParamConfig sumPlanParamConfig = this.iSummaryConfigService.getSummaryParamConfig(enableSumReportId);
        Map<Long, Integer> org2LevelMap = sumPlanParamConfig.getConfigInfoList().stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, SumPlanParamConfigInfo::getLevel));
        Set orgLevelSet = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("reportorg.id")).map(org2LevelMap::get).collect(Collectors.toSet());
        if (orgLevelSet.size() > 1) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6279\u91cf\u6267\u884c\u6570\u636e\u4fee\u590d\u65f6\uff0c\u7cfb\u7edf\u9650\u5236\u9700\u8981\u4e3a\u540c\u4e00\u6c47\u603b\u5c42\u7ea7\u4e0b\u7684\u76f8\u540c\u7f16\u62a5\u671f\u95f4\u7684\u5355\u636e\uff0c\u4e14\u6570\u91cf\u4e0d\u8d85\u8fc7%1$s\u5355\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u6c47\u603b\u5355\u636e\u8303\u56f4\u3002", (String)"ReportSumPlanRecalculateAmtValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), 5));
            }
        }
        this.validateOtherTxLock(extendedDataEntities);
    }

    private void validateOtherTxLock(ExtendedDataEntity[] extendedDataEntities) {
        List businessIdList = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dataEntity -> dataEntity.getLong("id")).map(String::valueOf).collect(Collectors.toList());
        if (businessIdList.isEmpty()) {
            return;
        }
        List lockBusinessIds = TxCheckUtil.loadUnfinishedTx(businessIdList);
        if (!lockBusinessIds.isEmpty()) {
            HashSet lockBusinessIdSet = new HashSet(lockBusinessIds);
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                DynamicObject dataEntity2 = extendedDataEntity.getDataEntity();
                Long reportId = dataEntity2.getLong("id");
                if (!lockBusinessIdSet.contains(String.valueOf(reportId))) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba1\u5212\u7f16\u5236\u5355\u636e %1$s \u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"ReportPlanUnAuditValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), dataEntity2.getString("billno")));
            }
        }
    }
}

