/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import org.apache.commons.collections4.MapUtils;

public class SumPlanAllowSubmitDownReportNotReportedValidator
extends AbstractTmcBizOppValidator {
    private static final SumPlanRepository sumPlanRepository = new SumPlanRepository();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("reporttype.id");
        selector.add("bodysys.id");
        selector.add("reportorg.id");
        selector.add("reportperiod.id");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (dataEntity == null || dataEntity.length == 0) {
            return;
        }
        BitMap<Long, SumPlanParamConfig> sumPlanConfigBitMap = this.getSumPlanConfigBitMap(dataEntity);
        HashMap sumOrgChildIdMap = new HashMap(16);
        HashSet<Long> reportPeriodIds = new HashSet<Long>(16);
        OperateOption option = this.getOption();
        StringBuilder sb = new StringBuilder();
        ArrayList<ExtendedDataEntity> needValidateList = new ArrayList<ExtendedDataEntity>(10);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            Set<Long> keys = ListHelper.asSet(entity.getLong("bodysys.id"), entity.getLong("reporttype.id"));
            SumPlanParamConfig one = sumPlanConfigBitMap.findOne(keys);
            if (one == null || one.isAllowSubmit()) {
                sb.append(extendedDataEntity.getBillPkId()).append(",");
                continue;
            }
            long reportOrgId = entity.getLong("reportorg.id");
            List<SumPlanParamConfigInfo> configInfoList = one.getConfigInfoList();
            Optional<SumPlanParamConfigInfo> first = configInfoList.stream().filter(sumPlanParamConfigInfo -> Objects.equals(reportOrgId, sumPlanParamConfigInfo.getOrgMemberId())).findFirst();
            if (!first.isPresent()) continue;
            SumPlanParamConfigInfo sumPlanParamConfigInfo2 = first.get();
            List<SumPlanParamConfigInfo> allChildren = sumPlanParamConfigInfo2.getAllChildren();
            Set set = sumOrgChildIdMap.computeIfAbsent(reportOrgId, k -> new HashSet(16));
            if (EmptyUtil.isEmpty(allChildren)) continue;
            allChildren.stream().map(SumPlanParamConfigInfo::getOrgMemberId).forEach(set::add);
            reportPeriodIds.add(entity.getLong("reportperiod.id"));
            needValidateList.add(extendedDataEntity);
        }
        if (EmptyUtil.isNoEmpty(reportPeriodIds) && MapUtils.isNotEmpty(sumOrgChildIdMap)) {
            Set reportOrgIds = sumOrgChildIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            String selectFields = String.join((CharSequence)",", "reportorg", "reportperiod");
            QFilter qFilter = new QFilter("reportorg", "in", reportOrgIds).and(new QFilter("reportperiod", "in", reportPeriodIds)).and(new QFilter("planstatus", "!=", (Object)ReportPlanStatusEnum.REPORTING.getValue()));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
            BitMap<Long, AtomicInteger> bitMap = new BitMap<Long, AtomicInteger>(16);
            for (DynamicObject dynamicObject : query) {
                bitMap.addValue(ListHelper.asSet(dynamicObject.getLong("reportorg"), dynamicObject.getLong("reportperiod")), new AtomicInteger(1));
            }
            for (ExtendedDataEntity extendedDataEntity : needValidateList) {
                DynamicObject entity = extendedDataEntity.getDataEntity();
                long reportOrgId = entity.getLong("reportorg.id");
                long reportPeriodId = entity.getLong("reportperiod.id");
                Set childReportOrgIds = sumOrgChildIdMap.getOrDefault(reportOrgId, Collections.emptySet());
                int count = 0;
                for (Long childReportOrgId : childReportOrgIds) {
                    List list = bitMap.findList(ListHelper.asSet(childReportOrgId, reportPeriodId));
                    count += list.size();
                }
                if (count == 0) continue;
                String errorMsg = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u6c47\u603b\u5904\u7406\u5355\u3010%1$s\u3011\u5f53\u524d\u672a\u4e0a\u62a5\u5355\u636e\u6570\u91cf\u4e3a%2$s\u5f20\uff0c\u8bf7\u7b49\u5f85\u4e0b\u7ea7\u5747\u4e0a\u62a5\u540e\u518d\u63d0\u4ea4\u3002", (String)"SumPlanAllowSubmitDownReportNotReportedValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), entity.getString("billno"), count);
                this.addErrorMessage(extendedDataEntity, errorMsg);
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        option.setVariableValue("allowSubmitIds", sb.toString());
    }

    private BitMap<Long, SumPlanParamConfig> getSumPlanConfigBitMap(ExtendedDataEntity[] dataEntity) {
        HashSet<Long> systemIds = new HashSet<Long>(16);
        HashSet<Long> reportTypeIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            systemIds.add(entity.getLong("bodysys.id"));
            reportTypeIds.add(entity.getLong("reporttype.id"));
        }
        List<SumPlanParamConfig> sumPlanParamConfigList = sumPlanRepository.loadSumConfigBySystems(systemIds, reportTypeIds, true);
        BitMap<Long, SumPlanParamConfig> bitMap = new BitMap<Long, SumPlanParamConfig>(16);
        for (SumPlanParamConfig sumPlanParamConfig : sumPlanParamConfigList) {
            bitMap.addValue(sumPlanParamConfig.getSystemId(), sumPlanParamConfig);
            bitMap.addValue(new HashSet<Long>(sumPlanParamConfig.getReportPeriodTypeIdS()), sumPlanParamConfig);
        }
        return bitMap;
    }
}

