/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.template;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.DimLevelEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.RowColType;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;

public class DimLayoutConfirmValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ExtendedDataEntity extendedDataEntity = extendedDataEntities[0];
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String templateType = dataEntity.getString("templatetype");
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        Map<String, List<DynamicObject>> dimInfoMap = entryEntity.stream().collect(Collectors.groupingBy(e -> e.getString("dimtype")));
        List<DynamicObject> pageDimList = dimInfoMap.get(RowColType.PAGE.getValue());
        if (EmptyUtil.isEmpty(pageDimList)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u4fdd\u5b58\u5931\u8d25\uff0c\u9875\u9762\u7ef4\u5ea6\u6570\u91cf\u4e0d\u80fd\u4e3a0\u4e2a\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u5e76\u4fee\u6539\u3002", (String)"DimLayoutConfirmValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return;
        }
        List noHidePageDimList = pageDimList.stream().filter(item -> !item.getBoolean("ishide")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(noHidePageDimList) && noHidePageDimList.size() > 3) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u4fdd\u5b58\u5931\u8d25\uff0c\u9875\u9762\u7ef4\u5ea6\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc7\u4e09\u4e2a\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u5e76\u4fee\u6539\u3002", (String)"DimLayoutConfirmValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return;
        }
        Optional<DynamicObject> first = pageDimList.stream().filter(item -> DimsionEnums.PERIOD.getNumber().equals(item.get("dim.basedata"))).findFirst();
        if (first.isPresent()) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4f5c\u4e3a\u9875\u9762\u7ef4\u3002", (String)"DimLayoutConfirmValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return;
        }
        if (TemplateTypeEnum.DETAIL.getValue().equals(templateType) ? this.detailValidator(extendedDataEntity, entryEntity) == false : TemplateTypeEnum.FIXED.getValue().equals(templateType) && this.fixValidator(extendedDataEntity, entryEntity) == false) {
            return;
        }
    }

    private Boolean detailValidator(ExtendedDataEntity entity, DynamicObjectCollection dimInfoColl) {
        List openList = dimInfoColl.stream().filter(e -> e.getBoolean("isopen")).collect(Collectors.toList());
        if (openList != null && openList.size() > 0) {
            if (openList.size() > 1) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u7ef4\u5ea6\u652f\u6301\u6210\u5458\u5e73\u94fa\u5c55\u5f00\u3002", (String)"DimLayoutConfirmValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            for (DynamicObject dimInfo : openList) {
                DynamicObject dim = (DynamicObject)dimInfo.get("dim");
                DynamicObjectCollection memberColl = dimInfo.getDynamicObjectCollection("expandmember");
                if (DimsionEnums.PERIOD.getNumber().equals(dim.get("basedata")) || memberColl.size() != 0) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6210\u5458\u5e73\u94fa\u5c55\u5f00\u65f6\u5c55\u5f00\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimLayoutConfirmValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private Boolean fixValidator(ExtendedDataEntity entity, DynamicObjectCollection dimInfoColl) {
        Map<String, List<DynamicObject>> dimInfoMap = dimInfoColl.stream().collect(Collectors.groupingBy(e -> e.getString("dimtype")));
        List<DynamicObject> colDimList = dimInfoMap.get(RowColType.COL.getValue());
        List<DynamicObject> rowDimList = dimInfoMap.get(RowColType.ROW.getValue());
        if (colDimList != null && colDimList.size() > 0) {
            if (colDimList.stream().filter(item -> item.getInt("dimlevel") == 0).findFirst().isPresent()) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u4e3a\u884c\u7ef4\u6216\u5217\u7ef4\u65f6\u884c\u5217\u7ef4\u7ea7\u522b\u5fc5\u586b\u3002", (String)"DimLayoutConfirmValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            if (colDimList.size() > 3) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u4fdd\u5b58\u5931\u8d25\uff0c\u5217\u7ef4\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc73\u4e2a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"DimLayoutConfirmValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            HashMap<Integer, String> colLevelRowMap = new HashMap<Integer, String>(8);
            ArrayList<Integer> levelList = new ArrayList<Integer>(3);
            for (int i = 0; i < colDimList.size(); ++i) {
                DynamicObject twoObj = colDimList.get(i);
                Integer colLevel = twoObj.getInt("dimlevel");
                String dimName = twoObj.getString("dim.name");
                if (colLevelRowMap.containsKey(colLevel)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4%1$s\u548c%2$s\u884c\u5217\u7ef4\u7ea7\u522b\uff0c\u4e0d\u53ef\u76f8\u540c\u3002", (String)"DimLayoutConfirmValidator_7", (String)"tmc-fpm-business", (Object[])new Object[0]), colLevelRowMap.get(colLevel), dimName));
                    return Boolean.FALSE;
                }
                levelList.add(colLevel);
                colLevelRowMap.put(colLevel, dimName);
            }
            List levelSortList = levelList.stream().sorted(Comparator.comparing(Integer::intValue)).collect(Collectors.toList());
            for (int i = 0; i < levelSortList.size(); ++i) {
                Integer level = (Integer)levelSortList.get(i);
                if (level == i + 1) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728%1$s\u7ef4\u5ea6\u7684\u60c5\u51b5\u4e0b\uff0c\u7ef4\u5ea6\u7ea7\u522b\u4e0d\u80fd\u9009\u62e9%2$s\u3002", (String)"DimLayoutConfirmValidator_8", (String)"tmc-fpm-business", (Object[])new Object[0]), DimLevelEnum.getName((String)String.valueOf(level - 1)), DimLevelEnum.getName((String)String.valueOf(level))));
                return Boolean.FALSE;
            }
        }
        if (rowDimList != null && rowDimList.size() > 0) {
            if (rowDimList.stream().filter(item -> item.getInt("dimlevel") == 0).findFirst().isPresent()) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u4e3a\u884c\u7ef4\u6216\u5217\u7ef4\u65f6\u884c\u5217\u7ef4\u7ea7\u522b\u5fc5\u586b\u3002", (String)"DimLayoutConfirmValidator_9", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            DynamicObject oneObj = rowDimList.get(0);
            if (rowDimList.size() > 2) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u4fdd\u5b58\u5931\u8d25\uff0c\u884c\u7ef4\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc72\u4e2a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"DimLayoutConfirmValidator_10", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            if (rowDimList.size() == 2) {
                DynamicObject twoObj = rowDimList.get(1);
                if (oneObj.get("dimlevel").equals(twoObj.get("dimlevel"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4%1$s\u548c%2$s\u884c\u5217\u7ef4\u7ea7\u522b\uff0c\u4e0d\u53ef\u76f8\u540c\u3002", (String)"DimLayoutConfirmValidator_11", (String)"tmc-fpm-business", (Object[])new Object[0]), oneObj.get("dim.name"), twoObj.get("dim.name")));
                    return Boolean.FALSE;
                }
                if (oneObj.getInt("dimlevel") > 2 || twoObj.getInt("dimlevel") > 2) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4%1$s\u548c%2%1$s\u884c\u5217\u7ef4\u7ea7\u522b\uff0c\u884c\u7ef4\u7ea7\u522b\u4e0d\u80fd\u8d85\u8fc72\u7ea7\u3002", (String)"DimLayoutConfirmValidator_12", (String)"tmc-fpm-business", (Object[])new Object[0]), oneObj.get("dim.name"), twoObj.get("dim.name")));
                    return Boolean.FALSE;
                }
            } else {
                if (DimLevelEnum.TWO.getValue().equals(oneObj.getInt("dimlevel"))) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e00\u7ea7\u7ef4\u5ea6\u7684\u60c5\u51b5\u4e0b\u7ef4\u5ea6\u7ea7\u522b\u4e0d\u80fd\u9009\u62e9\u4e8c\u7ea7\u3002", (String)"DimLayoutConfirmValidator_13", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    return Boolean.FALSE;
                }
                if (DimLevelEnum.THREE.getValue().equals(oneObj.getInt("dimlevel"))) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u884c\u7ef4\u4e0d\u5141\u8bb8\u9009\u62e9\u4e09\u7ea7", (String)"DimLayoutConfirmValidator_14", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    return Boolean.FALSE;
                }
            }
        }
        return Boolean.TRUE;
    }
}

