/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.template;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateInfoDeleteValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("id");
        selectors.add("templateuses");
        selectors.add("name");
        return selectors;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List ids = Arrays.stream(extendedDataEntities).filter(item -> TemplateUsesEnum.ANALYSIS.getValue().equals(item.getDataEntity().getString("templateuses"))).filter(item -> "0".equals(item.getDataEntity().getString("enable"))).map(item -> item.getDataEntity().getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        String statTemplate = String.join((CharSequence)".", "statanalysistemplate", "fbasedataid", "id");
        QFilter qFilter = new QFilter(statTemplate, "in", ids);
        HashMap relateMap = new HashMap();
        String fields = String.join((CharSequence)",", "id", "name", statTemplate);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_template", (String)fields, (QFilter[])new QFilter[]{qFilter});
        query.forEach(dy -> {
            Long accId = dy.getLong(statTemplate);
            String mainTplName = dy.getString("name");
            if (relateMap.containsKey(accId)) {
                String names = (String)relateMap.get(accId);
                names = names + "\u3001\u3010" + mainTplName + "\u3011";
                relateMap.put(accId, names);
            } else {
                relateMap.put(accId, "\u3010" + mainTplName + "\u3011");
            }
        });
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long id = (Long)dataEntity.getPkValue();
            String name = dataEntity.getString("name");
            if (!relateMap.containsKey(id)) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u5148\u89e3\u9664\u5f53\u524d\u6a21\u677f\u3010%1$s\u3011\u4e0e\u6c47\u603b\u7f16\u5236\u6a21\u677f%1$s\u7684\u5173\u8054\u5f15\u7528\u5173\u7cfb\u540e\u518d\u64cd\u4f5c\u3002", (String)"TemplateInfoDeleteValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), name, relateMap.get(id)));
        }
    }
}

