/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.template;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateInfoDisableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("ismaintable");
        selector.add("reporttype");
        selector.add("templateuses");
        selector.add("id");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List<Long> analysisIds = Arrays.stream(extendedDataEntities).filter(item -> TemplateUsesEnum.ANALYSIS.getValue().equals(item.getDataEntity().getString("templateuses"))).filter(item -> "1".equals(item.getDataEntity().getString("enable"))).map(item -> item.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map<Long, String> analysisRelateMap = this.getAnalysisRelateMap(analysisIds);
        List idList = Stream.of(extendedDataEntities).filter(e -> !e.getDataEntity().getBoolean("ismaintable")).filter(item -> !TemplateUsesEnum.ANALYSIS.getValue().equals(item.getDataEntity().getString("templateuses"))).map(e -> e.getBillPkId()).collect(Collectors.toList());
        DynamicObject[] subTemplateColl = TmcDataServiceHelper.load((String)"fpm_template", (String)"id,name,subjecttentry.subtemplate", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("subjecttentry.subtemplate.id", "in", idList)});
        HashMap<Object, DynamicObject> subTemplateMap = new HashMap<Object, DynamicObject>(1);
        if (subTemplateColl.length > 0) {
            for (DynamicObject dynamicObject : subTemplateColl) {
                DynamicObjectCollection subjectEntry = dynamicObject.getDynamicObjectCollection("subjecttentry");
                for (DynamicObject subjectDY : subjectEntry) {
                    subTemplateMap.put(subjectDY.get("subtemplate.id"), dynamicObject);
                }
            }
        }
        for (DynamicObject dynamicObject : extendedDataEntities) {
            DynamicObject dataEntity = dynamicObject.getDataEntity();
            Object billPkId = dynamicObject.getBillPkId();
            Long id = (Long)dataEntity.getPkValue();
            String name = dataEntity.getString("name");
            Object value = dynamicObject.getValue("ismaintable");
            if (!Boolean.TRUE.equals(dynamicObject.getValue("ismaintable")) && subTemplateMap != null && subTemplateMap.get(billPkId) != null) {
                DynamicObject relMainDY = (DynamicObject)subTemplateMap.get(billPkId);
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u8bf7\u5148\u89e3\u9664\u5f53\u524d\u6a21\u677f\u4e0e%1$s\u6a21\u677f\u7684\u4e3b\u5b50\u8868\u5173\u8054\u5173\u7cfb\u540e\u518d\u64cd\u4f5c\u3002", (String)"TemplateInfoDisableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), relMainDY.get("name")));
            }
            DynamicObjectCollection reportType = (DynamicObjectCollection)dynamicObject.getValue("reporttype");
            List reportTypeIdS = reportType.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("reportperiod.reporttype.id", "in", reportTypeIdS);
            qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
            qFilter.and(new QFilter("template", "=", (Object)id));
            DynamicObject[] reportArr = TmcDataServiceHelper.load((String)"fpm_report", (String)"id,name,reportperiod", (QFilter[])new QFilter[]{qFilter});
            if (reportArr.length > 0) {
                HashSet reportPeriodNames = new HashSet(reportArr.length);
                Arrays.stream(reportArr).forEach(o -> {
                    DynamicObject reportperiod = o.getDynamicObject("reportperiod");
                    reportPeriodNames.add(reportperiod.getString("name"));
                });
                String reportPeriodName = reportPeriodNames.stream().collect(Collectors.joining(","));
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, String.format(ResManager.loadKDString((String)"\u6a21\u677f\u201c%1$s\u201d\u7981\u7528\u5931\u8d25\u3002\u539f\u56e0\u4e3a\uff1a\u5173\u8054\u7f16\u62a5\u671f\u95f4\u201c%2$s\u201d\u4e0b\u5b58\u5728\u672a\u751f\u6548\u7684\u7f16\u5236\u5355\u636e\u3002", (String)"TemplateInfoDisableValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), name, reportPeriodName));
            }
            if (!analysisRelateMap.containsKey(id)) continue;
            this.addErrorMessage((ExtendedDataEntity)dynamicObject, String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u6a21\u677f\u3010%1$s\uff08%2$s\uff09\u3011\u5df2\u88ab\u201c\u53ef\u7528\u201d\u72b6\u6001\u4e0b\u7684\u4e3b\u8868\u6a21\u677f%3$s\u5173\u8054\u5f15\u7528\uff0c\u6682\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"TemplateInfoDisableValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), dataEntity.getString("number"), name, analysisRelateMap.get(id)));
        }
    }

    private Map<Long, String> getAnalysisRelateMap(List<Long> analysisIds) {
        if (CollectionUtils.isEmpty(analysisIds)) {
            return new HashMap<Long, String>(0);
        }
        String statTemplate = String.join((CharSequence)".", "statanalysistemplate", "fbasedataid", "id");
        QFilter qFilter = new QFilter(statTemplate, "in", analysisIds).and("enable", "=", (Object)"1");
        String fields = String.join((CharSequence)",", "id", "name", "number", statTemplate);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_template", (String)fields, (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, String> relateMap = new HashMap<Long, String>(query.size());
        query.forEach(dynamicObject -> {
            long analysisId = dynamicObject.getLong(statTemplate);
            String tplName = dynamicObject.getString("number") + "(" + dynamicObject.getString("name") + ")";
            if (relateMap.containsKey(analysisId)) {
                String names = (String)relateMap.get(analysisId);
                names = names + "\u3001\u3010" + tplName + "\u3011";
                relateMap.put(analysisId, names);
            } else {
                relateMap.put(analysisId, "\u3010" + tplName + "\u3011");
            }
        });
        return relateMap;
    }
}

