/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.common.enums.DimsionEnums;
import org.apache.commons.lang3.tuple.Pair;

public class TemplateInfoEnableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("ismaintable");
        selector.add("model");
        selector.add("user");
        selector.add("reporttype");
        selector.add("subjectmember");
        selector.add("currencymember");
        selector.add("subject");
        selector.add("subjecttentry");
        selector.add("subjecttentry.subtemplate");
        selector.add("dimsettingentry.dim");
        selector.add("dimsettingentry.plantemplatemember");
        selector.add("reporttypeentry.newreferencepos");
        selector.add("statanalysistemplate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List modelIdList = Stream.of(extendedDataEntities).filter(e -> Boolean.TRUE.equals(e.getDataEntity().get("ismaintable"))).map(e -> e.getDataEntity().getDynamicObject("model").getPkValue()).collect(Collectors.toList());
        DynamicObjectCollection templateColl = QueryServiceHelper.query((String)"fpm_template", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("model.id", "in", modelIdList), new QFilter("ismaintable", "=", (Object)"1")});
        Map<Object, List<DynamicObject>> modelTemplateMap = null;
        if (templateColl.size() > 0) {
            List templateIdList = templateColl.stream().map(e -> e.get("id")).collect(Collectors.toList());
            DynamicObject[] templateArr = TmcDataServiceHelper.load((Object[])templateIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"));
            modelTemplateMap = Stream.of(templateArr).collect(Collectors.groupingBy(i -> i.get("model.id")));
        }
        Set statAnalysisTemplateIds = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getDynamicObjectCollection("statanalysistemplate")).filter(Objects::nonNull).flatMap(Collection::stream).map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        HashMap statAnalysisTemplateMap = new HashMap(statAnalysisTemplateIds.size());
        if (EmptyUtil.isNoEmpty(statAnalysisTemplateIds)) {
            String selectFields = String.join((CharSequence)",", "id", "enable");
            DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_template", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", statAnalysisTemplateIds)});
            statAnalysisTemplateMap.putAll(Arrays.stream(load).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity())));
        }
        DynamicObjectCollection disableMember = this.getDisableMemberSet(extendedDataEntities);
        Map disableMemberIdMap = disableMember.stream().collect(Collectors.toMap(k -> k.getLong("id"), Function.identity()));
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObjectCollection dimSettingCollection;
            Optional<DynamicObject> member;
            Object modelId;
            List<DynamicObject> currModelTemplate;
            Pair<Boolean, DynamicObject> booleanDynamicObjectPair;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (dataEntity.getBoolean("enable")) continue;
            DynamicObjectCollection statAnalysisTemplates = dataEntity.getDynamicObjectCollection("statanalysistemplate");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)statAnalysisTemplates)) {
                String msg = statAnalysisTemplates.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(statAnalysisTemplate -> (DynamicObject)statAnalysisTemplateMap.get(statAnalysisTemplate.getPkValue())).filter(Objects::nonNull).filter(dy -> !dy.getBoolean("enable")).map(dy -> "\u3010" + dy.getString("number") + " " + dy.getString("name") + "\u3011").collect(Collectors.joining("\u3001"));
                if (!EmptyUtil.isNoEmpty((String)msg)) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5173\u8054\u7684\u7edf\u8ba1\u5206\u6790\u6a21\u677f%1$s\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u5173\u8054\u7684\u7edf\u8ba1\u5206\u6790\u6a21\u677f", (String)"TemplateInfoEnableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), msg));
                continue;
            }
            DynamicObjectCollection subjectEntry = dataEntity.getDynamicObjectCollection("subjecttentry");
            List unEnableSubTemplate = subjectEntry.stream().filter(item -> item.getDynamicObject("subtemplate") != null && !item.getBoolean("subtemplate.enable")).map(item -> item.getDynamicObject("subtemplate")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(unEnableSubTemplate)) {
                Set name = unEnableSubTemplate.stream().map(item -> item.getString("name")).collect(Collectors.toSet());
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5173\u8054\u7684\u5b50\u8868\u6a21\u677f%1$s\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u5173\u8054\u7684\u5b50\u8868\u6a21\u677f%2$s", (String)"TemplateInfoEnableValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), String.join((CharSequence)",", name), String.join((CharSequence)",", name)));
            }
            if (Boolean.TRUE.equals(extendedDataEntity.getValue("ismaintable")) && modelTemplateMap != null && !((Boolean)(booleanDynamicObjectPair = TemplateInfoHelper.uniqueValidator(dataEntity, currModelTemplate = modelTemplateMap.get(modelId = dataEntity.get("model.id")))).getLeft()).booleanValue()) {
                DynamicObject right = (DynamicObject)booleanDynamicObjectPair.getRight();
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e0e%1$s\u6a21\u677f\u7684\u552f\u4e00\u6027\u6821\u9a8c\u51b2\u7a81\uff0c\u5373\u540c\u4e00\u4e2a\u7f16\u62a5\u7ec4\u7ec7\u5728\u540c\u4e00\u4e2a\u7f16\u62a5\u7c7b\u578b\u4e0b\u53ef\u7528\u72b6\u6001\u4e0b\u7684\u4e3b\u8868\u6a21\u677f\u201c\u79d1\u76ee+\u5e01\u79cd\u201d\u4e0d\u552f\u4e00", (String)"TemplateInfoEnableValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), right.get("name")));
            }
            if ((member = (dimSettingCollection = dataEntity.getDynamicObjectCollection("dimsettingentry")).stream().map(item -> item.getDynamicObjectCollection("plantemplatemember")).flatMap(Collection::stream).filter(item -> disableMemberIdMap.containsKey(item.getLong("fbasedataid.id"))).findFirst()).isPresent()) {
                DynamicObject memberObj = (DynamicObject)disableMemberIdMap.get(member.get().getLong("fbasedataid.id"));
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u7684%2$s\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateInfoEnableValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), DimsionEnums.getDimsionByNumber((String)memberObj.getString("dimtype")).getName(), memberObj.getString("name")));
            }
            DynamicObjectCollection metricRefCollection = dataEntity.getDynamicObjectCollection("reporttypeentry");
            Optional<Long> metricId = metricRefCollection.stream().map(item -> item.getDynamicObjectCollection("newreferencepos")).filter(Objects::nonNull).flatMap(Collection::stream).map(item -> item.getLong("fbasedataid.id")).filter(disableMemberIdMap::containsKey).findFirst();
            if (!metricId.isPresent()) continue;
            DynamicObject memberObj = (DynamicObject)disableMemberIdMap.get(metricId.get());
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u7684%2$s\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateInfoEnableValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), DimsionEnums.getDimsionByNumber((String)memberObj.getString("dimtype")).getName(), memberObj.getString("name")));
        }
    }

    private DynamicObjectCollection getDisableMemberSet(ExtendedDataEntity[] extendedDataEntities) {
        ArrayList memberIdList = new ArrayList(16);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            List metricMemId;
            List memberList;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection dimSettingCollection = dataEntity.getDynamicObjectCollection("dimsettingentry");
            if (CollectionUtils.isEmpty((Collection)dimSettingCollection) || CollectionUtils.isEmpty(memberList = dimSettingCollection.stream().map(item -> item.getDynamicObjectCollection("plantemplatemember")).flatMap(Collection::stream).map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList()))) continue;
            memberIdList.addAll(memberList);
            DynamicObjectCollection metricRef = dataEntity.getDynamicObjectCollection("reporttypeentry");
            if (CollectionUtils.isEmpty((Collection)metricRef) || CollectionUtils.isEmpty(metricMemId = metricRef.stream().map(item -> item.getDynamicObjectCollection("newreferencepos")).filter(Objects::nonNull).flatMap(Collection::stream).map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList()))) continue;
            memberIdList.addAll(metricMemId);
        }
        String prop = "id,name,dimtype";
        DynamicObjectCollection disableMembers = QueryServiceHelper.query((String)"fpm_member", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "in", memberIdList), new QFilter("enable", "=", (Object)BaseEnableEnum.DISABLE.getValue())});
        return disableMembers;
    }

    private Map<Long, DynamicObject> getTemplateRefMap(String entity, List<Long> memberIdList, long systemId) {
        String entryBaseDataIdProp = "dimsettingentry.plantemplatemember.fbasedataid";
        QFilter qFilter = new QFilter("model", "=", (Object)systemId);
        qFilter.and(entryBaseDataIdProp, "in", memberIdList);
        qFilter.and("enable", "=", (Object)BaseEnableEnum.DISABLE.getValue());
        String selectProp = String.join((CharSequence)",", "id,name", entryBaseDataIdProp);
        DynamicObjectCollection refColl = QueryServiceHelper.query((String)entity, (String)selectProp, (QFilter[])new QFilter[]{qFilter});
        Map<Long, DynamicObject> refMap = refColl.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong(entryBaseDataIdProp), v -> v, (k1, k2) -> k1));
        return refMap;
    }
}

