/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.impl.TemplateService;
import kd.tmc.fpm.business.helper.SumPlanRelationHelper;
import kd.tmc.fpm.business.mvc.converter.TemplatePOConverter;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.service.dto.TemplateParamDTO;

public class TemplateReleaseValidator
extends AbstractTmcBizOppValidator {
    private TemplateService service = new TemplateService();
    private DimensionRepository repository = new DimensionRepository();
    private ISumPlanRepository sumPlanRepository = new SumPlanRepository();

    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("releasestatus");
        selectors.add("model");
        selectors.add("templateuses");
        selectors.add("statanalysistemplate");
        selectors.add("ismaintable");
        selectors.add("name");
        selectors.add("number");
        selectors.add("user");
        return selectors;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List objectList = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).filter(entity -> Objects.equals(entity.getString("templateuses"), TemplateUseType.PLANING.getNumber()) || Objects.equals(entity.getString("templateuses"), TemplateUseType.SUMMARY.getNumber())).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(objectList)) {
            return;
        }
        List idList = Arrays.stream(extendedDataEntities).map(item -> item.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map dbDataMap = Arrays.stream(TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"))).collect(Collectors.toMap(item -> item.get("id"), Function.identity()));
        ExtendedDataEntity extendedDataEntity = extendedDataEntities[0];
        long systemId = extendedDataEntity.getDataEntity().getLong("model.id");
        FundPlanSystem system = this.repository.loadSystem(systemId);
        List<SumPlanParamConfig> sumPlanParamConfigList = this.sumPlanRepository.loadSumConfigBySystem(systemId);
        HashMap<Long, Set> tempMemberMap = new HashMap<Long, Set>(8);
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDataEntity().getDynamicObjectCollection("user");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) continue;
            Long tempId = (Long)dataEntity.getBillPkId();
            Set memberIdSet = tempMemberMap.computeIfAbsent(tempId, key -> new HashSet(8));
            memberIdSet.addAll(dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet()));
        }
        Map reportTemplateMap = dbDataMap.values().stream().map(TemplatePOConverter::convertToTemplate).collect(Collectors.toMap(ReportTemplate::getId, Function.identity()));
        Map<Long, List<TemplateParamDTO.RelationTemplate>> downRelationTemplateMap = SumPlanRelationHelper.getRelationTemplateToMap(reportTemplateMap.values(), system, false);
        Map<Long, List<TemplateParamDTO.RelationTemplate>> upperRelationTemplateMap = SumPlanRelationHelper.getRelationTemplateToMap(reportTemplateMap.values(), system, true);
        List subTemplateIdS = dbDataMap.values().stream().map(item -> item.getDynamicObjectCollection("subjecttentry")).flatMap(Collection::stream).map(o -> o.get("subtemplate.id")).filter(o -> o != null && !o.equals(0L)).collect(Collectors.toList());
        Map subTplDataMap = Arrays.stream(TmcDataServiceHelper.load((Object[])subTemplateIdS.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"))).collect(Collectors.toMap(item -> item.get("id"), Function.identity()));
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject template = dataEntity.getDataEntity();
            if (!Objects.equals(template.getString("templateuses"), TemplateUseType.PLANING.getNumber()) && !Objects.equals(template.getString("templateuses"), TemplateUseType.SUMMARY.getNumber())) continue;
            Long templateId = template.getLong("id");
            template = (DynamicObject)dbDataMap.get(templateId);
            DynamicObjectCollection subjectSetEntry = template.getDynamicObjectCollection("subjecttentry");
            List subTplIdList = subjectSetEntry.stream().map(item -> item.getLong("subtemplate.id")).filter(o -> o != null && !o.equals(0L)).collect(Collectors.toList());
            ArrayList<ReportTemplate> subTplList = new ArrayList<ReportTemplate>(subTplIdList.size());
            for (Long subTplId : subTplIdList) {
                DynamicObject subTpl = (DynamicObject)subTplDataMap.get(subTplId);
                subTplList.add(TemplatePOConverter.convertToTemplate(subTpl));
            }
            ReportTemplate reportTemplate = (ReportTemplate)reportTemplateMap.get(templateId);
            FpmOperateResult fpmOperateResult = this.service.checkTemplate(TemplateParamDTO.builder().system(system).template(reportTemplate).subTemplateList(subTplList).sumPlanParamConfigList(sumPlanParamConfigList).upperRelationTemplates(upperRelationTemplateMap.get(templateId)).downRelationTemplates(downRelationTemplateMap.get(templateId)).opKey("releaseop").build());
            if (!fpmOperateResult.isSuccess()) {
                this.addErrorMessage(dataEntity, String.join((CharSequence)";", fpmOperateResult.getMessageList()));
                continue;
            }
            Boolean isRelease = template.getBoolean("releasestatus");
            if (!isRelease.booleanValue()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u7684\u6a21\u677f\u4e0d\u80fd\u518d\u53d1\u5e03\u3002", (String)"TemplateReleaseValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }
}

