/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.spread.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.util.StringUtils;
import kd.tmc.fpm.spread.command.event.AskExecuteEvent;
import kd.tmc.fpm.spread.command.event.CellValueEvent;
import kd.tmc.fpm.spread.command.event.SpreadActionListener;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.widget.AskExecuteCmdEnum;
import kd.tmc.fpm.spread.widget.FormulaCell;
import kd.tmc.fpm.spread.widget.SpreadSelector;
import kd.tmc.fpm.spread.widget.core.Cell;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;

public class FpmSpreadActionAdapter
extends SpreadActionAdapter {
    private static String AMOUNT_PATTERN = "^\\(?((-?([0-9]+|[0-9]{1,3}(,[0-9]{3})*))(.[0-9]{1,})?)\\)?$";

    public FpmSpreadActionAdapter(AbstractFormPlugin plugin) {
        super(plugin);
    }

    public void updateCellValue(SpreadEvent event) {
        super.updateCellValue(event);
        this.cellValueUpdate(event);
    }

    public void selectedSpread(SpreadEvent event) {
        SpreadPostDataInfo data = event.getPostData();
        if (data.getSelRows() != null && data.getSelRows().size() > 0 && data.getSelCols() != null && data.getSelCols().size() > 0) {
            this.sortSelectData(data);
            int focusCellRow_st = (Integer)data.getSelRows().get(0);
            int focusCellRow_end = (Integer)data.getSelRows().get(data.getSelRows().size() - 1);
            int focusCellCol_st = (Integer)data.getSelCols().get(0);
            int focusCellCol_end = (Integer)data.getSelCols().get(data.getSelCols().size() - 1);
            SpreadSelector spreadSelector = new SpreadSelector(focusCellRow_st, focusCellCol_st, focusCellRow_end, focusCellCol_end);
            ((AbstractSpreadPlugin)this.plugin).setSpreadSelector(spreadSelector);
            if (this.plugin instanceof SpreadActionListener) {
                ((SpreadActionListener)SpreadActionListener.class.cast(this.plugin)).cellClick(spreadSelector);
            }
        }
    }

    public void invokePluginMethod(SpreadEvent event) {
        String methodname = (String)event.getPostData().getInvokeParams().get("invokemethod");
        if ("spreadF7LookUpData".equals(methodname)) {
            this.invokePluginMethod(methodname, event.getPostData().getInvokeParams());
        } else {
            try {
                MethodUtils.invokeMethod((Object)this.plugin, (String)methodname, (Object)event);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void invokePluginMethod(String methodName, Object params) {
        try {
            MethodUtils.invokeMethod((Object)this.plugin, (String)methodName, (Object)params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void showFormulaPanel(SpreadEvent event) {
        this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6682\u4e0d\u652f\u6301\u516c\u5f0f\u5411\u5bfc\u3002", (String)"SpreadJsAction_0", (String)"tmc-fpm-spread", (Object[])new Object[0]));
    }

    private void sortSelectData(SpreadPostDataInfo data) {
        data.getSelRows().sort(this.sortSmallTobig());
        data.getSelCols().sort(this.sortSmallTobig());
        int rowindex = data.getSelRows().indexOf(-1);
        int colindex = data.getSelCols().indexOf(-1);
        if (rowindex != -1) {
            data.getSelRows().remove(rowindex);
        }
        if (colindex != -1) {
            data.getSelCols().remove(colindex);
        }
    }

    private Comparator<Integer> sortSmallTobig() {
        return (o1, o2) -> {
            if (o1 < o2) {
                return -1;
            }
            return 1;
        };
    }

    protected boolean isNotSupportExcelFormat(String data) {
        String vdata = this.removeAmountSign(data);
        return StringUtils.isNotEmpty((String)vdata) && Pattern.matches(AMOUNT_PATTERN, vdata.trim());
    }

    protected String removeAmountSign(String data) {
        return data.replaceAll("[\\\\$,US\\\\$,\u00a3,\u00a5]", "");
    }

    protected void cellValueUpdate(SpreadEvent event) {
        Spread spread = (Spread)event.getSource();
        SpreadPostDataInfo data = spread.getPostDataInfo();
        List updateCellValues = data.getValues();
        ArrayList<CellValueEvent> eventList = new ArrayList<CellValueEvent>(updateCellValues.size());
        for (LinkedHashMap updateCellValue : updateCellValues) {
            Cell cell = new Cell();
            cell.setRowAndCol(Integer.parseInt(updateCellValue.get("r").toString()), Integer.parseInt(updateCellValue.get("c").toString()));
            CellValueEvent cellValueEvent = new CellValueEvent(cell.getDisplayValue(), updateCellValue.get("v"), cell);
            eventList.add(cellValueEvent);
        }
        ((SpreadActionListener)SpreadActionListener.class.cast(this.plugin)).cellValueUpdate(eventList);
    }

    public void getLookupData(SpreadEvent event) {
        if (event.getPostData().getInvokeParams() != null) {
            int r = (Integer)event.getPostData().getInvokeParams().get("r");
            int c = (Integer)event.getPostData().getInvokeParams().get("c");
            Map lookupDataInfo = (Map)event.getPostData().getInvokeParams().get("lookupInfo");
            LookUpDataArgs bean = new LookUpDataArgs();
            this.populate(bean, lookupDataInfo);
            bean.setR(r);
            bean.setC(c);
            if (bean.getValue() != null) {
                this.invokePluginMethod("spreadF7LookUpData", bean);
            }
        }
    }

    public void updateFormula(SpreadEvent event) {
        Spread spread = (Spread)event.getSource();
        SpreadPostDataInfo data = spread.getPostDataInfo();
        ArrayList formulas = (ArrayList)data.getInvokeParams().get("formulas");
        ArrayList<FormulaCell> formulaCells = new ArrayList<FormulaCell>(formulas.size());
        for (LinkedHashMap formula : formulas) {
            Integer r = Integer.valueOf(formula.get("r").toString());
            Integer c = Integer.valueOf(formula.get("c").toString());
            String f = (String)formula.get("f");
            Cell cell = new Cell();
            cell.setRowAndCol(r, c);
            FormulaCell formulaCell = new FormulaCell(cell, null);
            formulaCells.add(formulaCell);
        }
        ((SpreadActionListener)SpreadActionListener.class.cast(this.plugin)).cellFormulaUpdate(formulaCells);
    }

    protected void populate(Object bean, Map<String, ? extends Object> values) {
        try {
            BeanUtils.populate((Object)bean, values);
        }
        catch (IllegalAccessException | InvocationTargetException var4) {
            throw new RuntimeException(var4);
        }
    }

    public void askExecute(SpreadEvent event) {
        super.askExecute(event);
        String method = (String)event.getPostData().getInvokeParamValue("method");
        AskExecuteEvent ev = new AskExecuteEvent();
        ev.setParams(event.getPostData().getInvokeParamValue("data"));
        ev.setAskExecuteCmd(AskExecuteCmdEnum.getExecCmdEnum(method));
        ((SpreadActionListener)SpreadActionListener.class.cast(this.plugin)).askExecute(ev);
    }
}

