/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.spread.command;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.orm.util.ReflectionUtils;
import kd.tmc.fpm.spread.command.SpreadProperties;
import kd.tmc.fpm.spread.widget.ButtonCell;
import kd.tmc.fpm.spread.widget.CellArea;
import kd.tmc.fpm.spread.widget.ComboboxCell;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.CustomFormula;
import kd.tmc.fpm.spread.widget.FormulaCell;
import kd.tmc.fpm.spread.widget.RedPointCell;
import kd.tmc.fpm.spread.widget.SheetFrozenInfo;
import kd.tmc.fpm.spread.widget.Shortcut;
import kd.tmc.fpm.spread.widget.ToolBarItemsEnum;
import kd.tmc.fpm.spread.widget.WorkbookOptions;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.AreasStyle;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import kd.tmc.fpm.spread.widget.style.ContextMenuWorkArea;

public class SpreadCommandInvoker {
    private String key;
    private IClientViewProxy clientViewProxy;

    public SpreadCommandInvoker(IFormView view, String key) {
        this.clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        this.key = key;
    }

    public void setStatusBarText(List<Map<String, Object>> params) {
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetDisplayContentMethod.SETDISPALYCONTENT.k(), new Object[]{params});
    }

    public void clearStatusBarText(List<String> clearKeys) {
        this.clientViewProxy.invokeControlMethod(this.key, "clearDisplayContent", new Object[]{clearKeys});
    }

    public void callbackAction(String plugin_methodname) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", plugin_methodname);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.CallBackActionMethod.CALLBACKACTION.k(), new Object[]{params});
    }

    public void rebuildSpread(String json) {
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetSpreadJsonMethod.SETSPREADJSON.k(), new Object[]{json});
    }

    public void appendRowCols(int rows, int cols) {
        if (rows > 0) {
            HashMap<String, Integer> rowcounts = new HashMap<String, Integer>();
            rowcounts.put("count", rows);
            this.clientViewProxy.invokeControlMethod(this.key, "appendRows", new Object[]{rowcounts});
        }
        if (cols > 0) {
            HashMap<String, Integer> colcounts = new HashMap<String, Integer>();
            colcounts.put("count", cols);
            this.clientViewProxy.invokeControlMethod(this.key, "appendCols", new Object[]{colcounts});
        }
    }

    public void deleteRowCol(List<Integer> rowindexs, List<Integer> colindexs) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            rowindexs.sort((o1, o2) -> o2 - o1);
            parasmap = new HashMap<String, Object>();
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            this.clientViewProxy.invokeControlMethod(this.key, "deleteRow", new Object[]{parasmap});
        }
        if (colindexs != null && colindexs.size() > 0) {
            colindexs.sort((o1, o2) -> o2 - o1);
            parasmap = new HashMap();
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            this.clientViewProxy.invokeControlMethod(this.key, "deleteCol", new Object[]{parasmap});
        }
    }

    public void insertRowCol(List<Integer> rowindexs, List<Integer> colindexs) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            parasmap = new HashMap<String, Object>();
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            this.clientViewProxy.invokeControlMethod(this.key, "insertRow", new Object[]{parasmap});
        }
        if (colindexs != null && colindexs.size() > 0) {
            parasmap = new HashMap();
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            this.clientViewProxy.invokeControlMethod(this.key, "insertCol", new Object[]{parasmap});
        }
    }

    public void insertRowCol(List<Integer> rowindexs, List<Integer> colindexs, boolean copyStyle) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            parasmap = new HashMap<String, Object>();
            parasmap.put("copyStyle", copyStyle);
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            this.clientViewProxy.invokeControlMethod(this.key, "insertRow", new Object[]{parasmap});
        }
        if (colindexs != null && colindexs.size() > 0) {
            parasmap = new HashMap();
            parasmap.put("copyStyle", copyStyle);
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            this.clientViewProxy.invokeControlMethod(this.key, "insertCol", new Object[]{parasmap});
        }
    }

    public void setColumnsWidth(List<Integer> colindexs, int width) {
        if (colindexs == null || colindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("index", colindexs);
        parasmap.put("num", width);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k(), new Object[]{parasmap});
    }

    public void setRowsHeight(List<Integer> rowindexs, int height) {
        if (rowindexs == null || rowindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("index", rowindexs);
        parasmap.put("num", height);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetRowsHeightMethod.SETROWSHEIGHT.k(), new Object[]{parasmap});
    }

    public void lockCells(List<CellArea> paras) {
        if (paras == null || paras.size() == 0) {
            return;
        }
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.LockCellMethod.LOACKCELL.k(), new Object[]{paras});
    }

    public void lockECells(List<Cell> paras) {
        if (paras == null || paras.size() == 0) {
            return;
        }
        ArrayList<CellArea> areas = new ArrayList<CellArea>(paras.size());
        for (Cell para : paras) {
            areas.add(new CellArea(para.getRow(), para.getCol(), 1, 1));
        }
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.LockCellMethod.LOACKCELL.k(), new Object[]{areas});
    }

    public void unlockCells(List<CellArea> paras) {
        if (paras == null || paras.size() == 0) {
            return;
        }
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.UnlockCellMethod.UNLOACKCELL.k(), new Object[]{paras});
    }

    public void lockSheets(List<String> sheetnames) {
        if (sheetnames != null && sheetnames.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.LockSheetMethod.LOACKSHEET.k(), new Object[]{sheetnames});
        }
    }

    public void unlockSheets(List<String> sheetnames) {
        if (sheetnames != null && sheetnames.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.UnLockSheetMethod.UNLOACKSHEET.k(), new Object[]{sheetnames});
        }
    }

    public void updateCellValue2(List<Cell> cells) {
        ArrayList parameters = new ArrayList(cells.size());
        for (Cell cell : cells) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            valMap.put(SpreadProperties.UpdataValueMethod.R.k(), cell.getRow());
            valMap.put(SpreadProperties.UpdataValueMethod.C.k(), cell.getCol());
            valMap.put(SpreadProperties.UpdataValueMethod.V.k(), cell.getDisplayValue());
            parameters.add(valMap);
        }
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), new Object[]{parameters});
    }

    public void updateCellValue(List<Map<String, Object>> parameters) {
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), new Object[]{parameters});
    }

    public void setSpan(List<CellArea> areas) {
        if (areas != null && areas.size() > 0) {
            HashMap<String, List<CellArea>> parasmap = new HashMap<String, List<CellArea>>();
            parasmap.put("range", areas);
            this.clientViewProxy.invokeControlMethod(this.key, "setSpan", new Object[]{parasmap});
        }
    }

    public void setCellStyle(List<AreasStyle> areasStyles) {
        if (areasStyles == null || areasStyles.size() == 0) {
            return;
        }
        Object paras = this.packageAreaStyles(areasStyles);
        if (paras != null) {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), new Object[]{paras});
        }
    }

    public void fieldInsertRowCol(CellArea range, int index, int count, int styleIndex, boolean isrow) {
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        parasmap.put("range", range);
        parasmap.put("index", Integer.valueOf(index));
        parasmap.put("count", Integer.valueOf(count));
        parasmap.put("styleIndex", Integer.valueOf(styleIndex));
        if (isrow) {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.FieldInsertMethod.FIELDINSERTROW.k(), new Object[]{parasmap});
        } else {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.FieldInsertMethod.FIELDINSERTCOL.k(), new Object[]{parasmap});
        }
    }

    public void fieldDeleteRowCol(CellArea range, int index, int count, boolean isrow) {
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        CellArea range01 = new CellArea(range.getR(), range.getC(), range.getRc(), range.getCc());
        parasmap.put("range", range01);
        parasmap.put("index", Integer.valueOf(index));
        parasmap.put("count", Integer.valueOf(count));
        if (isrow) {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.FieldDelMethod.FIELDDELROW.k(), new Object[]{parasmap});
        } else {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.FieldDelMethod.FIELDDELCOL.k(), new Object[]{parasmap});
        }
    }

    public void setFListCells(List<Cell> cells, boolean fuzzyQuery, boolean combobox) {
        ArrayList celllist = new ArrayList(cells.size());
        for (Cell cell : cells) {
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            cellmap.put("r", cell.getRow());
            cellmap.put("c", cell.getCol());
            celllist.add(cellmap);
        }
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        parasmap.put("cell", celllist);
        parasmap.put("selectType", Integer.valueOf(fuzzyQuery ? 0 : 1));
        parasmap.put("dst", Integer.valueOf(combobox ? 1 : 0));
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{parasmap});
    }

    public void setFListCellArea(List<CellArea> cellAreas, boolean fuzzyQuery, boolean combobox) {
        LinkedHashMap<String, Object> parasmap = new LinkedHashMap<String, Object>();
        parasmap.put("cell", cellAreas);
        parasmap.put("selectType", fuzzyQuery ? 0 : 1);
        parasmap.put("dst", combobox ? 1 : 0);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{parasmap});
    }

    public void setComboCell(List<ComboboxCell> comboboxCells) {
        this.clientViewProxy.invokeControlMethod(this.key, "setComboCell", new Object[]{comboboxCells});
    }

    public void setBtnCell(List<ButtonCell> buttonCells) {
        this.clientViewProxy.invokeControlMethod(this.key, "setBtnCell", new Object[]{buttonCells});
    }

    public void setCustomBtnCell(List<ButtonCell> buttonCells) {
        this.clientViewProxy.invokeControlMethod(this.key, "setCustomBtnCell", new Object[]{buttonCells});
    }

    public void setCellTag(List<RedPointCell> redPointCells) {
        this.clientViewProxy.invokeControlMethod(this.key, "setCellTag", new Object[]{redPointCells});
    }

    public void resetCell(List<CellArea> areas) {
        HashMap<String, List<CellArea>> parasmap = new HashMap<String, List<CellArea>>();
        parasmap.put("range", areas);
        this.clientViewProxy.invokeControlMethod(this.key, "resetCell", new Object[]{parasmap});
    }

    public void getSpreadJson(String callBack_MethodName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", callBack_MethodName);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.GetSpreadJsonMethod.GETSPREADMETHOD.k(), new Object[]{params});
    }

    public void getRangeStyles(List<Object> area, String si, String callBack_MethodName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", "invokeAction");
        params.put("range", area);
        params.put("si", si);
        params.put("invokemethod", callBack_MethodName);
        this.clientViewProxy.invokeControlMethod(this.key, "getRangeStyles", new Object[]{Lists.newArrayList((Object[])new Map[]{params})});
    }

    public void getRangeValues(List<Object> range, String si, String callBack_MethodName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", "invokeAction");
        params.put("range", range);
        params.put("si", si);
        params.put("invokemethod", callBack_MethodName);
        this.clientViewProxy.invokeControlMethod(this.key, "getRangeValues", new Object[]{Lists.newArrayList((Object[])new Map[]{params})});
    }

    public void setLookupData(Cell cell, Object data) {
        LinkedHashMap<String, Object> parasmap = new LinkedHashMap<String, Object>();
        parasmap.put("r", cell.getRow());
        parasmap.put("c", cell.getCol());
        parasmap.put("data", data);
        this.clientViewProxy.invokeControlMethod(this.key, "setLookupData", new Object[]{parasmap});
    }

    public void setCustomFormulaCell(List<Cell> cells) {
        ArrayList paraslist = new ArrayList(cells.size());
        for (Cell cell : cells) {
            LinkedHashMap<String, Integer> parasmap = new LinkedHashMap<String, Integer>();
            parasmap.put("r", cell.getRow());
            parasmap.put("c", cell.getCol());
            paraslist.add(parasmap);
        }
        if (paraslist.size() > 0) {
            HashMap cellsmap = new HashMap();
            cellsmap.put("cell", paraslist);
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetCustomFormulaCellMethod.SETCUSTOMFORMULACELL.k(), new Object[]{cellsmap});
        }
    }

    public void setAllCustomFormulaCell() {
        this.clientViewProxy.invokeControlMethod(this.key, "setAllCustomFormulaCell", new Object[0]);
    }

    public void registerCustomFormula(List<CustomFormula> customFormulas) {
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.RegisterCustomFormulaMethod.REGISTERCUSTOMFORMULA.k(), new Object[]{customFormulas});
    }

    public void setFormula(List<FormulaCell> formulaCells) {
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetFormulaMethod.SETFORMULA.k(), new Object[]{formulaCells});
    }

    public void setSelections(CellArea cellArea) {
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetSelectionsMethod.SETSELECTIONS.k(), new Object[]{cellArea});
    }

    public void exportExcelFile(String fileName) {
        HashMap<String, String> parasmap = new HashMap<String, String>();
        parasmap.put("fileName", fileName);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.ExportExcelFileMethod.EXPORTEXCELFILE.k(), new Object[]{parasmap});
    }

    public void lockToolbarItems(List<ToolBarItemsEnum> lockItems, List<ToolBarItemsEnum> unlockItems) {
        LinkedHashMap<String, Object> lockmap;
        ArrayList locks = new ArrayList(10);
        if (lockItems != null) {
            for (ToolBarItemsEnum lockItem : lockItems) {
                lockmap = new LinkedHashMap<String, Object>();
                lockmap.put("name", lockItem.getNumber());
                lockmap.put("isLock", 1);
                locks.add(lockmap);
            }
        }
        if (unlockItems != null) {
            for (ToolBarItemsEnum lockItem : unlockItems) {
                lockmap = new LinkedHashMap();
                lockmap.put("name", lockItem.getNumber());
                lockmap.put("isLock", 0);
                locks.add(lockmap);
            }
        }
        if (locks.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.LockToolbarItemsMethod.LOCKTOOLBARITEMS.k(), new Object[]{locks});
        }
    }

    public void hideContextMenuItems(List<ContextMenuItemsEnum> hideItems, List<ContextMenuItemsEnum> showItems) {
        LinkedHashMap<String, Object> lockmap;
        HashMap<String, Integer> lockmap2;
        ArrayList paraslist = new ArrayList();
        if (showItems != null && showItems.size() > 0) {
            if (showItems.size() == ContextMenuItemsEnum.values().length) {
                lockmap2 = new HashMap();
                lockmap2.put("isHide", 0);
                this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), new Object[]{lockmap2});
            } else {
                for (ContextMenuItemsEnum showItem : showItems) {
                    lockmap = new LinkedHashMap<String, Object>();
                    lockmap.put("name", showItem.getNumber());
                    lockmap.put("isHide", 0);
                    paraslist.add(lockmap);
                }
            }
        }
        if (hideItems != null && hideItems.size() > 0) {
            if (hideItems.size() == ContextMenuItemsEnum.values().length) {
                lockmap2 = new HashMap<String, Integer>();
                lockmap2.put("isHide", (Integer)((Object)"1"));
                this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), new Object[]{lockmap2});
            } else {
                for (ContextMenuItemsEnum hideItem : hideItems) {
                    lockmap = new LinkedHashMap();
                    lockmap.put("name", hideItem.getNumber());
                    lockmap.put("isHide", 1);
                    paraslist.add(lockmap);
                }
            }
        }
        if (paraslist.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), new Object[]{paraslist});
        }
    }

    public void hideContextMenuItemsByKey(List<String> hideItems, List<String> showItems) {
        LinkedHashMap<String, Object> lockmap;
        ArrayList paraslist = new ArrayList();
        if (showItems != null && showItems.size() > 0) {
            for (String showItem : showItems) {
                lockmap = new LinkedHashMap<String, Object>();
                lockmap.put("name", showItem);
                lockmap.put("isHide", 0);
                paraslist.add(lockmap);
            }
        }
        if (hideItems != null && hideItems.size() > 0) {
            for (String hideItem : hideItems) {
                lockmap = new LinkedHashMap();
                lockmap.put("name", hideItem);
                lockmap.put("isHide", 1);
                paraslist.add(lockmap);
            }
        }
        if (paraslist.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), new Object[]{paraslist});
        }
    }

    public void addContextMenuItems(String callBackMethod, String title, ContextMenuWorkArea contextMenuWorkArea) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("callback", "invokeAction");
        ArrayList items = new ArrayList();
        HashMap<String, Object> items_map = new HashMap<String, Object>();
        paras.put("items", items);
        items.add(items_map);
        items_map.put("name", callBackMethod);
        items_map.put("text", title);
        items_map.put("workArea", contextMenuWorkArea.getList());
        this.clientViewProxy.invokeControlMethod(this.key, "addContextMenuItems", new Object[]{paras});
    }

    public void setDisplayLeftText(String text) {
        this.clientViewProxy.invokeControlMethod(this.key, "setDisplayLeftText", new Object[]{text});
    }

    public void setDisplayCenterText(String text) {
        this.clientViewProxy.invokeControlMethod(this.key, "setDisplayCenterText", new Object[]{text});
    }

    public void clearCellsStyle(List<CellArea> cellAreas) {
        this.clientViewProxy.invokeControlMethod(this.key, "clearCellsStyle", new Object[]{cellAreas});
    }

    public void controlToolbarItems(List<ToolBarItemsEnum> needControl, List<ToolBarItemsEnum> notneedControl) {
        HashMap<String, String> parasmap;
        ArrayList paraslist = new ArrayList();
        if (needControl != null && needControl.size() > 0) {
            for (ToolBarItemsEnum toolBarItemsEnum : needControl) {
                parasmap = new HashMap<String, String>();
                parasmap.put("name", toolBarItemsEnum.getNumber());
                parasmap.put("isCtl", "true'");
                paraslist.add(parasmap);
            }
        }
        if (notneedControl != null && notneedControl.size() > 0) {
            for (ToolBarItemsEnum toolBarItemsEnum : notneedControl) {
                parasmap = new HashMap();
                parasmap.put("name", toolBarItemsEnum.getNumber());
                parasmap.put("isCtl", "false'");
                paraslist.add(parasmap);
            }
        }
        if (paraslist.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.key, "controlToolbarItems", new Object[]{paraslist});
        }
    }

    public void closeToolbar() {
        HashMap parasmap = new HashMap();
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.CloseToolBar.CLOSETOOLBAR.k(), new Object[]{parasmap});
    }

    public void closeToolbar(Boolean showExpandBtnVisible) {
        HashMap parasmap = new HashMap();
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.CloseToolBar.CLOSETOOLBAR.k(), new Object[]{parasmap});
        this.setToolbarExpandBtnVisible(showExpandBtnVisible);
    }

    public void setToolbarExpandBtnVisible(Boolean visible) {
        HashMap<String, Boolean> parasmap = new HashMap<String, Boolean>();
        parasmap.put("visible", visible);
        this.clientViewProxy.invokeControlMethod(this.key, "setExpandBtnVisible", new Object[]{parasmap});
    }

    public void frozenSheet(SheetFrozenInfo frozenInfo) {
        this.clientViewProxy.invokeControlMethod(this.key, "frozenSheet", new Object[]{frozenInfo});
    }

    public void setRowsAutoFit(List<Integer> rows) {
        HashMap<String, List<Integer>> paras = new HashMap<String, List<Integer>>();
        paras.put(SpreadProperties.AutoFitRows.R.k(), rows);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.AutoFitRows.AUTOFITROWS.k(), new Object[]{paras});
    }

    public void setColsAutoFit(List<Integer> cols) {
        HashMap<String, List<Integer>> paras = new HashMap<String, List<Integer>>();
        paras.put(SpreadProperties.AutoFitColumns.C.k(), cols);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.AutoFitColumns.AUTOFITCOLUMNS.k(), new Object[]{paras});
    }

    public void setShortcutKey(Shortcut shortcut) {
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetShortcutKey.SETSHORTCUTKEY.k(), new Object[]{shortcut});
    }

    public void setWorkbookOptions(WorkbookOptions workbookOptions) {
        this.clientViewProxy.invokeControlMethod(this.key, "setWorkbookOptions", new Object[]{workbookOptions});
    }

    private Object packageAreaStyles(List<AreasStyle> areasStyles) {
        ArrayList rangestyles = new ArrayList();
        for (AreasStyle areasStyle : areasStyles) {
            List<CellArea> areas;
            if (areasStyle == null || (areas = areasStyle.getRange()) == null || areas.size() == 0) continue;
            CellStyleInfo cellStyleInfo = areasStyle.getStyle();
            Field[] fields = cellStyleInfo.getClass().getDeclaredFields();
            LinkedHashMap<String, Object> style = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> bls = new LinkedHashMap<String, Object>();
            for (Field field : fields) {
                String fieldname = field.getName();
                Object value = null;
                try {
                    ReflectionUtils.makeAccessible((Field)field);
                    value = field.get(cellStyleInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) continue;
                if ("bls".equals(fieldname) || "blc".equals(fieldname)) {
                    bls.put(fieldname, value);
                    continue;
                }
                style.put(fieldname, value);
            }
            if (bls.size() > 0) {
                style.put("bl", bls);
            }
            if (style.size() <= 0 || areas.size() <= 0) continue;
            LinkedHashMap<String, Object> rangestyle = new LinkedHashMap<String, Object>();
            rangestyle.put("range", areas);
            rangestyle.put("style", style);
            rangestyles.add(rangestyle);
        }
        if (rangestyles.size() > 0) {
            return rangestyles;
        }
        return null;
    }

    public void setDisplayContent(String status, String cellMsg, String convertStatus) {
        this.setDisplayContent("", status, cellMsg, convertStatus);
    }

    public void setDisplayContent(String attachement, String status, String cellMsg, String convertStatus) {
        Map<String, Object> attachementArea = SpreadCommandInvoker.getStatusBarArea("attachement", attachement, "60pt", "#000000", "flex-start");
        Map<String, Object> statusArea = SpreadCommandInvoker.getStatusBarArea("status", status, "8%", "#000000", "flex-grow");
        Map<String, Object> cellMsgArea = SpreadCommandInvoker.getStatusBarArea("cellMsg", cellMsg, "55%", "#000000", "flex-grow");
        Map<String, Object> convertStatusArea = SpreadCommandInvoker.getStatusBarArea("convertStatus", convertStatus, "15%", "#000000", "flex-grow");
        ArrayList<Map<String, Object>> areaList = new ArrayList<Map<String, Object>>();
        areaList.add(attachementArea);
        areaList.add(statusArea);
        areaList.add(convertStatusArea);
        areaList.add(cellMsgArea);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetDisplayContentMethod.SETDISPALYCONTENT.k(), new Object[]{areaList});
    }

    private static Map<String, Object> getStatusBarArea(String key, String text, String w, String fc, String gr) {
        LinkedHashMap<String, Object> area = new LinkedHashMap<String, Object>();
        area.put(SpreadProperties.SetDisplayContentMethod.key.k(), key);
        area.put(SpreadProperties.SetDisplayContentMethod.TEXT.k(), text);
        LinkedHashMap<String, String> areaStyle = new LinkedHashMap<String, String>();
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.w.k(), w);
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.fc.k(), fc);
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.gr.k(), gr);
        area.put(SpreadProperties.SetDisplayContentMethod.s.k(), areaStyle);
        return area;
    }

    public void getColumnsWidth(Integer[] cols, String callBackMethodName) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("index", cols);
        paras.put("callback", "invokeAction");
        paras.put("invokemethod", callBackMethodName);
        this.clientViewProxy.invokeControlMethod(this.key, "getColumnsWidth", new Object[]{paras});
    }

    public void getColumnsWidth(List<Integer> cols, String callBackMethodName) {
        this.getColumnsWidth(cols.toArray(new Integer[0]), callBackMethodName);
    }

    public void getRowsHeight(Integer[] rows, String callBackMethodName) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("index", rows);
        paras.put("callback", "invokeAction");
        paras.put("invokemethod", callBackMethodName);
        this.clientViewProxy.invokeControlMethod(this.key, "getRowsHeight", new Object[]{paras});
    }

    public void getRowsHeight(List<Integer> rows, String callBackMethodName) {
        this.getRowsHeight(rows.toArray(new Integer[0]), callBackMethodName);
    }

    public void setOutlineColumn(int col, Boolean showCheckBox, Integer maxLevel, boolean default_collapsed) {
        HashMap<String, Serializable> datas = new HashMap<String, Serializable>();
        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
        if (showCheckBox != null) {
            options.put("showCheckBox", showCheckBox);
            options.put("maxLevel", maxLevel);
            options.put("collapsed", Boolean.valueOf(default_collapsed));
        }
        if (options.size() > 0) {
            datas.put("options", options);
        }
        datas.put("c", Integer.valueOf(col));
        this.clientViewProxy.invokeControlMethod(this.key, "setOutlineColumn", new Object[]{datas});
    }

    public void setVirtualMode(String callbackMethod, boolean isopen) {
        this.setVirtualMode(callbackMethod, isopen, 100);
    }

    public void setVirtualMode(String callbackMethod, boolean isopen, Integer delay) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", callbackMethod);
        params.put("isOpen", isopen);
        if (delay != null) {
            params.put("delay", delay);
        }
        this.clientViewProxy.invokeControlMethod(this.key, "setVirtualMode", new Object[]{params});
    }

    public void addSheets(int index, String name, int rc, int cc) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object[]> fea = new HashMap<String, Object[]>();
        Object[] objects = new Object[]{params};
        params.put("index", index);
        params.put("name", name);
        params.put("rc", rc);
        params.put("cc", cc);
        fea.put("sheets", objects);
        this.clientViewProxy.invokeControlMethod(this.key, "addSheets", new Object[]{fea});
    }

    public void updateCellValueAddSheet(List<Map<String, Object>> parameters, int si) {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("si", si);
        para.put("cells", parameters);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), new Object[]{para});
    }

    public void setColumnsWidthAddSheet(Map<String, Object> parasmap) {
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k(), new Object[]{parasmap});
    }

    public void appendRowColsAddSheet(int rows, int cols, int si) {
        if (rows > 0) {
            HashMap<String, Integer> rowcounts = new HashMap<String, Integer>();
            rowcounts.put("count", rows);
            rowcounts.put("si", si);
            this.clientViewProxy.invokeControlMethod(this.key, "appendRows", new Object[]{rowcounts});
        }
        if (cols > 0) {
            HashMap<String, Integer> colcounts = new HashMap<String, Integer>();
            colcounts.put("count", cols);
            colcounts.put("si", si);
            this.clientViewProxy.invokeControlMethod(this.key, "appendCols", new Object[]{colcounts});
        }
    }

    public void setCol0rRowGroupbyOnesheet(int count, int index, int si, boolean isRow) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        LinkedHashMap<String, Integer> rowcounts = new LinkedHashMap<String, Integer>();
        Object[] objects = new Object[1];
        rowcounts.put("index", index);
        rowcounts.put("count", count);
        objects[0] = rowcounts;
        feature.put("groups", objects);
        feature.put("si", si);
        if (isRow) {
            this.clientViewProxy.invokeControlMethod(this.key, "setRowOutlines", new Object[]{feature});
        } else {
            this.clientViewProxy.invokeControlMethod(this.key, "setColumnOutlines", new Object[]{feature});
        }
    }

    public void expandRowOrColOutlines(int maxlevels, boolean expand, int si, boolean isRow) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        Object[] objects = new Object[]{0, maxlevels};
        feature.put("levels", objects);
        feature.put("expand", expand);
        feature.put("si", si);
        if (isRow) {
            this.clientViewProxy.invokeControlMethod(this.key, "expandRowOutlines", new Object[]{feature});
        } else {
            this.clientViewProxy.invokeControlMethod(this.key, "expandColumnOutlines", new Object[]{feature});
        }
    }

    public void insertRowColAddSheet(List<Integer> rowindexs, List<Integer> colindexs, int si) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            parasmap = new HashMap<String, Object>();
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            parasmap.put("si", si);
            parasmap.put("copyStyle", false);
            this.clientViewProxy.invokeControlMethod(this.key, "insertRow", new Object[]{parasmap});
        }
        if (colindexs != null && colindexs.size() > 0) {
            parasmap = new HashMap();
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            parasmap.put("copyStyle", false);
            parasmap.put("si", si);
            this.clientViewProxy.invokeControlMethod(this.key, "insertCol", new Object[]{parasmap});
        }
    }

    public void setCellStyleAddSheet(List<AreasStyle> areasStyles, int si) {
        HashMap<String, Object> featuer = new HashMap<String, Object>();
        if (areasStyles == null || areasStyles.size() == 0) {
            return;
        }
        Object paras = this.packageAreaStyles(areasStyles);
        featuer.put("si", si);
        featuer.put("data", paras);
        if (paras != null) {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), new Object[]{featuer});
        }
    }

    public void setCellTags(List<Map<String, Object>> cellTags) {
        if (cellTags == null || cellTags.size() == 0) {
            return;
        }
        this.clientViewProxy.invokeControlMethod(this.key, "setCellTag", new Object[]{cellTags});
    }

    public void setComment(List<Map<String, Object>> data, int si) {
        if (data == null || data.size() == 0) {
            return;
        }
        ArrayList data11 = new ArrayList();
        HashMap<String, Object> optionMap1 = new HashMap<String, Object>();
        optionMap1.put("si", si);
        optionMap1.put("options", data);
        data11.add(optionMap1);
        this.clientViewProxy.invokeControlMethod(this.key, "setComment", new Object[]{data11});
    }

    public void addContextMenuItems(String callBackMethod, String title, List<Map<String, Object>> subMenus, ContextMenuWorkArea contextMenuWorkArea) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("callback", "invokeAction");
        ArrayList items = new ArrayList();
        HashMap<String, Object> items_map = new HashMap<String, Object>();
        paras.put("items", items);
        items.add(items_map);
        items_map.put("name", callBackMethod);
        items_map.put("text", title);
        items_map.put("workArea", contextMenuWorkArea.getList());
        if (subMenus != null && !subMenus.isEmpty()) {
            items_map.put("subMenu", subMenus);
        }
        this.clientViewProxy.invokeControlMethod(this.key, "addContextMenuItems", new Object[]{paras});
    }

    public void hideContextSubMenuItems(List<String[]> hideItems, List<String[]> showItems) {
        LinkedHashMap<String, Object> lockmap;
        ArrayList paraslist = new ArrayList();
        if (showItems != null && showItems.size() > 0) {
            for (String[] showItem : showItems) {
                lockmap = new LinkedHashMap<String, Object>();
                lockmap.put("name", showItem[0]);
                if (showItem.length > 1 && showItem[1] != null) {
                    lockmap.put("subMenu", showItem[1]);
                }
                lockmap.put("isHide", 0);
                paraslist.add(lockmap);
            }
        }
        if (hideItems != null && hideItems.size() > 0) {
            for (String[] hideItem : hideItems) {
                lockmap = new LinkedHashMap();
                lockmap.put("name", hideItem[0]);
                if (hideItem.length > 1 && hideItem[1] != null) {
                    lockmap.put("subMenu", hideItem[1]);
                }
                lockmap.put("isHide", 1);
                paraslist.add(lockmap);
            }
        }
        if (paraslist.size() > 0) {
            this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), new Object[]{paraslist});
        }
    }

    public void insertRowsBelow(List<Integer> rowindexs, boolean copyStyle) {
        if (rowindexs != null && rowindexs.size() > 0) {
            HashMap<String, Object> parasmap = new HashMap<String, Object>();
            parasmap.put("copyStyle", copyStyle);
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            parasmap.put("dir", "bottom");
            this.clientViewProxy.invokeControlMethod(this.key, "insertRow", new Object[]{parasmap});
        }
    }

    public void setRowsVisible(List<Integer> rowindexs, boolean isVisible) {
        if (rowindexs == null || rowindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("rows", rowindexs);
        parasmap.put("value", isVisible);
        this.clientViewProxy.invokeControlMethod(this.key, "setRowsVisible", new Object[]{parasmap});
    }

    public void setColumnsVisible(List<Integer> colindexs, boolean isVisible) {
        if (colindexs == null || colindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("cols", colindexs);
        parasmap.put("value", isVisible);
        this.clientViewProxy.invokeControlMethod(this.key, "setColumnsVisible", new Object[]{parasmap});
    }

    public void setFListCells(List<Cell> cells, boolean fuzzyQuery, boolean combobox, boolean showAddBtnWhenNoData, boolean lockClickable) {
        ArrayList celllist = new ArrayList(cells.size());
        for (Cell cell : cells) {
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            cellmap.put("r", cell.getRow());
            cellmap.put("c", cell.getCol());
            celllist.add(cellmap);
        }
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        parasmap.put("cell", celllist);
        parasmap.put("selectType", Integer.valueOf(fuzzyQuery ? 0 : 1));
        parasmap.put("dst", Integer.valueOf(combobox ? 1 : 0));
        parasmap.put("showAddBtnWhenNoData", Boolean.valueOf(showAddBtnWhenNoData));
        parasmap.put("lockClickable", Boolean.valueOf(lockClickable));
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{parasmap});
    }

    public void setFListCellArea(List<CellArea> cellAreas, boolean fuzzyQuery, boolean combobox, boolean showAddBtnWhenNoData, boolean lockClickable) {
        LinkedHashMap<String, Object> parasmap = new LinkedHashMap<String, Object>();
        parasmap.put("cell", cellAreas);
        parasmap.put("selectType", fuzzyQuery ? 0 : 1);
        parasmap.put("dst", combobox ? 1 : 0);
        parasmap.put("showAddBtnWhenNoData", showAddBtnWhenNoData);
        parasmap.put("lockClickable", lockClickable);
        this.clientViewProxy.invokeControlMethod(this.key, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{parasmap});
    }

    public void print() {
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("index", 0);
        parasmap.put("showPanel", true);
        ArrayList printInfo = new ArrayList(1);
        HashMap<String, Cloneable> printInfoParams = new HashMap<String, Cloneable>();
        printInfoParams.put("index", new ArrayList());
        printInfoParams.put("info", new HashMap());
        printInfo.add(printInfoParams);
        parasmap.put("printInfo", printInfo);
        this.clientViewProxy.invokeControlMethod(this.key, "print", new Object[]{parasmap});
    }
}

