/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.spread.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.tmc.fpm.spread.command.FpmSpreadActionAdapter;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.command.event.AskExecuteEvent;
import kd.tmc.fpm.spread.command.event.CellValueEvent;
import kd.tmc.fpm.spread.command.event.SpreadActionListener;
import kd.tmc.fpm.spread.widget.AskExecuteCmdEnum;
import kd.tmc.fpm.spread.widget.FormulaCell;
import kd.tmc.fpm.spread.widget.SpreadSelector;

public abstract class AbstractSpreadPlugin
extends AbstractFormPlugin
implements SpreadActionListener {
    protected SpreadCommandInvoker spreadContainer = null;
    private SpreadSelector spreadSelector = null;
    private static final String SPREAD_SELECTOR_CACHE_KEY = "spread_selector_cache_key";
    public static final String SPREAD_MANANGER_CACHE_KEY = "spread_mananger_cache_key";

    public void initialize() {
        super.initialize();
        this.getView().addService(ISpreadAction.class, (Object)new FpmSpreadActionAdapter(this));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    protected abstract String getSpreadKey();

    protected SpreadCommandInvoker getSpreadCommandInvoker() {
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadCommandInvoker(this.getView(), this.getSpreadKey());
        }
        return this.spreadContainer;
    }

    public SpreadSelector getSpreadSelector() {
        String serial;
        if (this.spreadSelector == null && StringUtils.isNotEmpty((CharSequence)(serial = this.getPageCache().get(SPREAD_SELECTOR_CACHE_KEY)))) {
            this.spreadSelector = (SpreadSelector)SerializationUtils.deSerializeFromBase64((String)serial);
        }
        return this.spreadSelector;
    }

    public void setSpreadSelector(SpreadSelector spreadSelector) {
        this.spreadSelector = spreadSelector;
        this.cacheSpreadSelector();
    }

    private void cacheSpreadSelector() {
        if (this.spreadSelector == null) {
            this.getPageCache().put(SPREAD_SELECTOR_CACHE_KEY, null);
        } else {
            this.getPageCache().put(SPREAD_SELECTOR_CACHE_KEY, SerializationUtils.serializeToBase64((Object)this.spreadSelector));
        }
    }

    @Override
    public void cellClick(SpreadSelector selector) {
    }

    @Override
    public void cellValueUpdate(List<CellValueEvent> cellValueEvent) {
    }

    @Override
    public void cellFormulaUpdate(List<FormulaCell> formulaCells) {
        SpreadActionListener.super.cellFormulaUpdate(formulaCells);
    }

    @Override
    public final void askExecute(AskExecuteEvent event) {
        if (event.getAskExecuteCmd() == AskExecuteCmdEnum.DELETEROWS) {
            this.deleteRows(event);
        }
    }

    @Override
    public void deleteRows(AskExecuteEvent event) {
        SpreadActionListener.super.deleteRows(event);
    }

    @Override
    public void addRows(AskExecuteEvent event) {
        SpreadActionListener.super.addRows(event);
    }
}

