/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.spread.widget;

import java.io.Serializable;
import kd.tmc.fpm.spread.utils.ExcelUtils;

public class SpreadSelector
implements Serializable {
    private int startRow = -1;
    private int startCol = -1;
    private int endRow = -1;
    private int endCol = -1;

    public SpreadSelector(int startRow, int startCol, int endRow, int endCol) {
        this.startRow = startRow < 0 ? 0 : startRow;
        this.startCol = startCol < 0 ? 0 : startCol;
        this.endRow = endRow < 0 ? 0 : endRow;
        this.endCol = endCol < 0 ? 0 : endCol;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getEndCol() {
        return this.endCol;
    }

    public boolean isMultiSelectCells() {
        return this.startRow != this.endRow || this.startCol != this.endCol;
    }

    public String getRangePosition() {
        return this.getStartPosition() + ":" + this.getEndPosition();
    }

    public String getEndPosition() {
        return ExcelUtils.xy2Pos(this.endCol, this.endRow);
    }

    public String getStartPosition() {
        return ExcelUtils.xy2Pos(this.startCol, this.startRow);
    }

    public String getRect() {
        return this.getStartPosition() + ":" + this.getEndPosition();
    }
}

