/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.spread.zdemo.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import kd.tmc.fpm.spread.utils.Point;

public class SpreadDemoModel
implements Serializable {
    private String startPoint = null;
    private String selectArea = null;
    private Map<String, String> rowDims = new HashMap<String, String>(8);
    private Map<String, String> colDims = new HashMap<String, String>(8);
    private Long tempId = null;
    private String tempName = null;

    public int getEndRowIndex() {
        String[] areaPoints = this.selectArea.split(":");
        Point areaEndPoint = ExcelUtils.pos2Point(areaPoints[1]);
        return areaEndPoint.y + this.getDeltaXY().get("deltaY");
    }

    public int getEndColIndex() {
        String[] areaPoints = this.selectArea.split(":");
        Point areaEndPoint = ExcelUtils.pos2Point(areaPoints[1]);
        return areaEndPoint.x + this.getDeltaXY().get("deltaX");
    }

    public static String serialize(SpreadDemoModel model) {
        return FpmSerializeUtil.serialize((Object)model);
    }

    public static SpreadDemoModel deserialize(String json) {
        return (SpreadDemoModel)FpmSerializeUtil.deserialize((String)json, SpreadDemoModel.class);
    }

    public Map<String, Integer> getDeltaXY() {
        HashMap<String, Integer> deltaXY = new HashMap<String, Integer>(3);
        Point startPoint = ExcelUtils.pos2Point(this.startPoint);
        String[] areaPoints = this.selectArea.split(":");
        Point areaStartPoint = ExcelUtils.pos2Point(areaPoints[0]);
        Point areaEndPoint = ExcelUtils.pos2Point(areaPoints[1]);
        deltaXY.put("deltaX", startPoint.x - areaStartPoint.x + 1);
        deltaXY.put("deltaY", startPoint.y - areaStartPoint.y + 1);
        return deltaXY;
    }

    public int[] getAreaRangeByStartPoint() {
        int[] areas = new int[4];
        Point startPoint = ExcelUtils.pos2Point(this.startPoint);
        areas[0] = startPoint.y;
        areas[1] = startPoint.x;
        Map<String, Integer> lenXY = this.getLengthOfXY();
        areas[2] = lenXY.get("lengthX");
        areas[3] = lenXY.get("lengthY");
        return areas;
    }

    public Map<String, Integer> getLengthOfXY() {
        HashMap<String, Integer> lengthXY = new HashMap<String, Integer>(3);
        String[] areaPoints = this.selectArea.split(":");
        Point areaStartPoint = ExcelUtils.pos2Point(areaPoints[0]);
        Point areaEndPoint = ExcelUtils.pos2Point(areaPoints[1]);
        lengthXY.put("lengthX", areaEndPoint.x - areaStartPoint.x + 1);
        lengthXY.put("lengthY", areaEndPoint.y - areaStartPoint.y + 1);
        return lengthXY;
    }

    public String getYAreaByX() {
        Map<String, Integer> lengthXY = this.getLengthOfXY();
        String endStr = ExcelUtils.offsetAxisByRow(this.startPoint, lengthXY.get("lengthY"));
        return String.format("%s:%s", this.startPoint, endStr);
    }

    public int getYAreaEnd() {
        Map<String, Integer> lengthXY = this.getLengthOfXY();
        String endStr = ExcelUtils.offsetAxisByRow(this.startPoint, lengthXY.get("lengthY"));
        return ExcelUtils.pos2Y(endStr);
    }

    public String getXAreaByY() {
        Map<String, Integer> lengthXY = this.getLengthOfXY();
        String endStr = ExcelUtils.offsetAxisByCol(this.startPoint, lengthXY.get("lengthX"));
        return String.format("%s:%s", this.startPoint, endStr);
    }

    public int getXAreaEnd() {
        Map<String, Integer> lengthXY = this.getLengthOfXY();
        String endStr = ExcelUtils.offsetAxisByCol(this.startPoint, lengthXY.get("lengthX"));
        return ExcelUtils.pos2X(endStr);
    }

    public SpreadDemoModel(String startPoint, String selectArea, Map<String, String> rowDims, Map<String, String> colDims, Long tempId, String tempName) {
        this.startPoint = startPoint;
        this.selectArea = selectArea;
        this.rowDims = rowDims;
        this.colDims = colDims;
        this.tempId = tempId;
        this.tempName = tempName;
    }

    public String getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(String startPoint) {
        this.startPoint = startPoint;
    }

    public Point getStartPos() {
        return ExcelUtils.pos2Point(this.startPoint);
    }

    public String getSelectArea() {
        return this.selectArea;
    }

    public void setSelectArea(String selectArea) {
        this.selectArea = selectArea;
    }

    public Map<String, String> getRowDims() {
        return this.rowDims;
    }

    public void setRowDims(String key, String value) {
        this.rowDims.put(key, value);
    }

    public void setRowDims(Map<String, String> map) {
        this.rowDims = map;
    }

    public Map<String, String> getColDims() {
        return this.colDims;
    }

    public void setColDims(String key, String value) {
        this.colDims.put(key, value);
    }

    public void setColDims(Map<String, String> map) {
        this.colDims = map;
    }

    public Long getTempId() {
        return this.tempId;
    }

    public void setTempId(Long tempId) {
        this.tempId = tempId;
    }

    public String getTempName() {
        return this.tempName;
    }

    public void setTempName(String tempName) {
        this.tempName = tempName;
    }
}

