/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.sumplan.AccurateMatchScheme;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.common.enums.MatchRelationEnum;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import org.apache.commons.collections.CollectionUtils;

public class AccurateMatchSchemePlugin
extends AbstractBasePlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long systemId = Optional.ofNullable(fsp.getCustomParams().get("pass_param_system")).map(a -> Long.valueOf(a.toString())).orElse(0L);
        FundPlanSystem fundPlanSystem = new DimensionRepository().loadSystem(systemId.longValue());
        this.initDownBox(fundPlanSystem);
        Object o = fsp.getCustomParams().get("pass_param_accuratematchscheme");
        if (EmptyUtil.isNoEmpty(o)) {
            this.initParameters(o.toString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        if (operateKey.equals("confirm") && event.getOperationResult().isSuccess()) {
            DynamicObjectCollection schemeEntryDys = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)schemeEntryDys)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u586b\u5199\u914d\u7f6e\u65b9\u6848\u4fe1\u606f\u3002", (String)"AccurateMatchSchemePlugin_01", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return;
            }
            AccurateMatchScheme scheme = new AccurateMatchScheme();
            DynamicObject oneDy = (DynamicObject)schemeEntryDys.get(0);
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Long systemId = Optional.ofNullable(fsp.getCustomParams().get("pass_param_system")).map(a -> Long.valueOf(a.toString())).orElse(0L);
            FundPlanSystem fundPlanSystem = new DimensionRepository().loadSystem(systemId.longValue());
            HashMap<String, Dimension> mappingMap = new HashMap<String, Dimension>(16);
            for (Dimension dimension : fundPlanSystem.getDimList()) {
                String key = dimension.getNumber();
                if (dimension.getDimType() == DimensionType.DETAILDIM) {
                    key = dimension.getDetailDimType().getNumber();
                }
                mappingMap.put(key, dimension);
            }
            String oneOurSideField = Optional.ofNullable(oneDy.getString("entry_our_match_field")).map(o -> ((Dimension)mappingMap.get(o)).getName()).orElse("");
            String oneOtherSideField = Optional.ofNullable(oneDy.getString("entry_other_match_field")).map(o -> ((Dimension)mappingMap.get(o)).getName()).orElse("");
            String oneRelation = Optional.ofNullable(oneDy.getString("entry_match_relation")).map(MatchRelationEnum::getDescName).orElse("");
            scheme.setName(String.format("'%1$s' %2$s '%3$s'", oneOurSideField, oneRelation, oneOtherSideField));
            int correspondenceOrgUniqueFlag = 0;
            ArrayList<AccurateMatchScheme.AccurateMatchSchemeEntry> schemeEntries = new ArrayList<AccurateMatchScheme.AccurateMatchSchemeEntry>(schemeEntryDys.size());
            HashMap<String, Integer> ourSideMap = new HashMap<String, Integer>(16);
            HashMap<String, Integer> otherSideMap = new HashMap<String, Integer>(16);
            for (int i = 0; i < schemeEntryDys.size(); ++i) {
                DynamicObject entry = (DynamicObject)schemeEntryDys.get(i);
                AccurateMatchScheme.AccurateMatchSchemeEntry schemeEntry = new AccurateMatchScheme.AccurateMatchSchemeEntry();
                String ourSideField = entry.getString("entry_our_match_field");
                Integer row1 = (Integer)ourSideMap.get(ourSideField);
                if (EmptyUtil.isNoEmpty((Integer)row1)) {
                    ComboEdit comboEdit = (ComboEdit)this.getControl("entry_our_match_field");
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7b2c\u201c%1$s\u201d\u884c\u53ca\u7b2c\u201c%2$s\u201d\u5206\u5f55\u4e2d\uff0c%3$s\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"AccurateMatchSchemePlugin_04", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), i + 1, row1, comboEdit.getProperty().getDisplayName().getLocaleValue()));
                    return;
                }
                ourSideMap.put(ourSideField, i + 1);
                String otherSideField = entry.getString("entry_other_match_field");
                Integer row2 = (Integer)otherSideMap.get(otherSideField);
                if (EmptyUtil.isNoEmpty((Integer)row2)) {
                    ComboEdit comboEdit = (ComboEdit)this.getControl("entry_our_match_field");
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7b2c\u201c%1$s\u201d\u884c\u53ca\u7b2c\u201c%2$s\u201d\u5206\u5f55\u4e2d\uff0c%3$s\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"AccurateMatchSchemePlugin_04", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), i + 1, row2, comboEdit.getProperty().getDisplayName().getLocaleValue()));
                    return;
                }
                otherSideMap.put(otherSideField, i + 1);
                if (ourSideField.equals(otherSideField)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u7b2c\u201c%1$s\u201d\u884c\u5206\u5f55\u4e2d\uff0c\u672c\u65b9\u53ca\u5bf9\u65b9\u5339\u914d\u7684\u7ef4\u5ea6/\u5b57\u6bb5\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u540c\u4e00\u4e2a\u3002\u8bf7\u786e\u8ba4\u3002", (String)"AccurateMatchSchemePlugin_03", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), i + 1));
                    return;
                }
                schemeEntry.setRelation(MatchRelationEnum.getRelation((String)entry.getString("entry_match_relation")));
                String attr = entry.getString("entry_match_attr");
                Dimension ourSideDimension = (Dimension)mappingMap.get(ourSideField);
                Dimension otherSideDimension = (Dimension)mappingMap.get(otherSideField);
                if ((ourSideDimension.getMemberType() == MemberType.TEXT || otherSideDimension.getMemberType() == MemberType.TEXT) && attr.equals("number")) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u7b2c\u201c%1$s\u201d\u884c\u5206\u5f55\u4e2d\uff0c\u4ea4\u6613\u53cc\u65b9\u7684\u5339\u914d\u6240\u914d\u7f6e\u5b57\u6bb5\u5b58\u5728\u7eaf\u6587\u672c\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u901a\u8fc7\u201c\u7f16\u7801\u201d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AccurateMatchSchemePlugin_05", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), i + 1));
                    return;
                }
                boolean isCorrespondenceOrg = entry.getBoolean("entry_correspondence_org");
                schemeEntry.setCorrespondenceOrg(isCorrespondenceOrg);
                if (isCorrespondenceOrg) {
                    ++correspondenceOrgUniqueFlag;
                }
                schemeEntry.setAttr(attr);
                schemeEntry.setOtherSideField(otherSideField);
                schemeEntry.setOurSideField(ourSideField);
                schemeEntries.add(schemeEntry);
            }
            if (CollectionUtils.isNotEmpty((Collection)schemeEntryDys) && correspondenceOrgUniqueFlag != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u8bbe\u7f6e\u552f\u4e00\u7684\u4e00\u7ec4\u5339\u914d\u5b57\u6bb5\u8bb0\u5f55\u4f5c\u4e3a\u5f80\u6765\u7ec4\u7ec7\u6807\u8bc6\u3002", (String)"AccurateMatchSchemePlugin_02", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return;
            }
            scheme.setSchemeEntrys(schemeEntries);
            this.getView().returnDataToParent((Object)scheme);
            this.getView().close();
        }
    }

    private void initParameters(String json) {
        AccurateMatchScheme scheme = (AccurateMatchScheme)FpmSerializeUtil.deserialize((String)json, AccurateMatchScheme.class);
        List schemeEntrys = scheme.getSchemeEntrys();
        if (CollectionUtils.isEmpty((Collection)schemeEntrys)) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        List entryValueMap = schemeEntrys.stream().map(schemeItem -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("entry_our_match_field", schemeItem.getOurSideField());
            params.put("entry_match_relation", schemeItem.getRelation().getRelation());
            params.put("entry_other_match_field", schemeItem.getOtherSideField());
            params.put("entry_match_attr", schemeItem.getAttr());
            params.put("entry_correspondence_org", schemeItem.isCorrespondenceOrg());
            return params;
        }).collect(Collectors.toList());
        TmcViewInputHelper.batchFillEntity((String)"entryentity", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), entryValueMap);
        this.getView().updateView("entryentity");
    }

    private void initDownBox(FundPlanSystem fundPlanSystem) {
        this.initOurSideField(fundPlanSystem);
        this.initOtherSideField(fundPlanSystem);
    }

    private void initOtherSideField(FundPlanSystem fundPlanSystem) {
        ArrayList dimList = new ArrayList(5);
        List dimensions = fundPlanSystem.getDimList().stream().filter(o -> o.getDimType() != DimensionType.DETAILDIM && o.getDimType() != DimensionType.METRIC).filter(o -> o.getDimType() != DimensionType.PERIOD && o.getDimType() != DimensionType.CURRENCY && o.getDimType() != DimensionType.SUBJECTS && o.getDimType() != DimensionType.ORG).collect(Collectors.toList());
        dimList.addAll(dimensions);
        List detailDimensions = fundPlanSystem.getDimList().stream().filter(o -> o.getDimType() == DimensionType.DETAILDIM).filter(Dimension::isVisible).filter(o -> o.getMemberType() == MemberType.BASE_DATA || o.getMemberType() == MemberType.TEXT || o.getMemberType() == MemberType.MUTI_BASE_DATA).collect(Collectors.toList());
        dimList.addAll(detailDimensions);
        ArrayList comboItems = new ArrayList(dimList.size());
        dimList.forEach(o -> {
            String number = o.getNumber();
            if (o.getDimType() == DimensionType.DETAILDIM) {
                DetailDimType detailDimType = o.getDetailDimType();
                number = detailDimType.getNumber();
            }
            ComboItem combo = new ComboItem(new LocaleString(o.getName()), number);
            comboItems.add(combo);
        });
        ComboEdit sourcebillCombo = (ComboEdit)this.getControl("entry_other_match_field");
        sourcebillCombo.setComboItems(comboItems);
        detailDimensions.stream().filter(item -> item.getDetailDimType() == DetailDimType.COUNTERPARTY_NAME).findFirst().ifPresent(counterPartyNameDim -> this.getModel().setValue("entry_other_match_field", (Object)counterPartyNameDim.getDetailDimType().getNumber(), 0));
    }

    private void initOurSideField(FundPlanSystem fundPlanSystem) {
        List dimList = fundPlanSystem.getDimList().stream().filter(o -> o.getDimType() != DimensionType.DETAILDIM && o.getDimType() != DimensionType.METRIC).filter(o -> o.getDimType() != DimensionType.PERIOD && o.getDimType() != DimensionType.CURRENCY && o.getDimType() != DimensionType.SUBJECTS).collect(Collectors.toList());
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(dimList.size());
        for (Dimension dimension : dimList) {
            ComboItem combo = new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber());
            comboItems.add(combo);
        }
        ComboEdit sourceBillCombo = (ComboEdit)this.getControl("entry_our_match_field");
        sourceBillCombo.setComboItems(comboItems);
        this.getModel().setValue("entry_our_match_field", (Object)DimensionType.ORG.getNumber(), 0);
    }
}

