/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ActualReleaseAmountFieldSelectorPlugin
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initActualReleaseAmountFields();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (Objects.isNull(formShowParameter)) {
            return;
        }
        Object amountField = formShowParameter.getCustomParam("amountField");
        if (EmptyUtil.isEmpty((Object)amountField)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int row = -1;
        for (int i = 0; i < entryEntity.size(); ++i) {
            String filedCode = ((DynamicObject)entryEntity.get(i)).getString("fieldcode");
            if (!Objects.equals(filedCode, amountField)) continue;
            row = i;
            break;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (row != -1) {
            entryGrid.selectRows(row, true);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                this.returnDataToParent();
                break;
            }
        }
    }

    private void returnDataToParent() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u8bb0\u5f55\u3002", (String)"ActualReleaseAmountFieldSelectorPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(4);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRows[0]);
        map.put("key", dynamicObject.getString("fieldcode"));
        map.put("name", dynamicObject.getString("fieldname"));
        this.getView().returnDataToParent(map);
        this.getView().invokeOperation("close");
    }

    private void initActualReleaseAmountFields() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entryName = (String)formShowParameter.getCustomParam("entryName");
        String businessBillNumber = (String)formShowParameter.getCustomParam("businessEntityType");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)businessBillNumber);
        Map allEntities = dataEntityType.getAllEntities();
        EntityType entityType = (EntityType)allEntities.get(entryName);
        if (Objects.isNull(entityType)) {
            return;
        }
        boolean isEntry = StringUtils.isNotBlank((CharSequence)entryName) && !StringUtils.equals((CharSequence)entryName, (CharSequence)businessBillNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        Map entityPropertyMap = properties.stream().collect(Collectors.toMap(IMetadata::getName, Function.identity()));
        Map fieldColumn = ExpressionFromHelper.getFieldColumn((String)dataEntityType.getName(), (boolean)false, (boolean)true, (String[])new String[0]);
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.clear();
        for (Map.Entry entry : fieldColumn.entrySet()) {
            boolean isAmountFiled;
            String field = (String)entry.getKey();
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entityPropertyMap.get(field);
            if (Objects.isNull(iDataEntityProperty) || !(isAmountFiled = iDataEntityProperty instanceof AmountProp)) continue;
            DynamicObject dynamicObject = entryEntity.addNew();
            LocaleString displayName = (LocaleString)entry.getValue();
            sb.delete(0, sb.length());
            dynamicObject.set("fieldcode", (Object)(isEntry ? sb.append(entryName).append(".").append(field).toString() : field));
            dynamicObject.set("fieldname", (Object)(isEntry ? this.getFullDisplayName(displayName, entityType.getDisplayName(), sb) : displayName));
        }
    }

    private LocaleString getFullDisplayName(LocaleString simpleDisplayName, LocaleString entryDisplayName, StringBuilder sb) {
        sb.delete(0, sb.length());
        LocaleString displayName = LocaleString.fromMap((Map)simpleDisplayName);
        for (Map.Entry localStringEntry : entryDisplayName.entrySet()) {
            String languageType = (String)localStringEntry.getKey();
            String displayNameSimple = (String)displayName.get((Object)languageType);
            displayNameSimple = Objects.isNull(displayNameSimple) ? "" : displayNameSimple;
            displayName.put(languageType, (Object)sb.append((String)localStringEntry.getValue()).append(".").append(displayNameSimple).toString());
            sb.delete(0, sb.length());
        }
        return displayName;
    }
}

