/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.TemplateDimBDTypeEnum;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.enums.WaysEnum;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;

public class BatchSettingPlugin
extends AbstractBasePlugIn {
    private static final String BTN_COMFIRM = "btnok";
    private static final String SIGN_LINK_TEMPLATE = "linksontemplate";
    private static final String SIGN_WAYS = "ways";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_COMFIRM});
        BasedataEdit templateF7 = (BasedataEdit)this.getView().getControl(SIGN_LINK_TEMPLATE);
        templateF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            List<QFilter> templateQFilters = this.getFilters();
            sp.getListFilterParameter().setQFilters(templateQFilters);
            sp.setMultiSelect(false);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_COMFIRM.equals(key)) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String ways = dataEntity.getString(SIGN_WAYS);
            params.put(SIGN_WAYS, ways);
            if (ways.equals(WaysEnum.DETAILED_REPORT.getValue())) {
                Object templateId = Optional.ofNullable(dataEntity.getDynamicObject(SIGN_LINK_TEMPLATE)).map(o -> o.getPkValue()).orElseGet(() -> null);
                params.put("templateId", templateId);
            }
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    private List<QFilter> getFilters() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map customParams = fsp.getCustomParams();
        ReportTemplate reportTemplate = Optional.ofNullable(customParams.get("reportTemplate")).map(o -> (ReportTemplate)FpmSerializeUtil.deserialize((String)o.toString(), ReportTemplate.class)).orElseGet(() -> null);
        Set acctIds = Optional.ofNullable(customParams.get("acctIds")).map(o -> new HashSet(JSONObject.parseArray((String)o.toString(), Long.class))).orElseGet(() -> null);
        if (EmptyUtil.isEmpty((Collection)acctIds)) {
            return Collections.singletonList(new QFilter("id", "=", (Object)0L));
        }
        List<QFilter> qFilters = Arrays.asList(new QFilter("ismaintable", "=", (Object)"0"), new QFilter("releasestatus", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1"), new QFilter("model.id", "=", (Object)reportTemplate.getSystemId()), new QFilter("templateuses", "=", (Object)reportTemplate.getTemplateUse().getNumber()));
        DynamicObject[] templates = TmcDataServiceHelper.load((String)"fpm_template", (String)"id", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        if (templates.length == 0) {
            return Collections.singletonList(new QFilter("id", "=", (Object)0L));
        }
        List ids = Arrays.stream(templates).map(item -> item.get("id")).collect(Collectors.toList());
        templates = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"));
        List visibleDimIds = reportTemplate.getAllTemplateDim().stream().filter(TemplateDim::isVisible).map(TemplateDim::getId).collect(Collectors.toList());
        DynamicObject[] dimensions = TmcDataServiceHelper.load((Object[])visibleDimIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_dimension"));
        Set mainTableDimTypes = Arrays.stream(dimensions).map(v -> v.getString("basedata")).collect(Collectors.toSet());
        List reportPeriods = reportTemplate.getReportPeriods();
        HashSet<Long> templateIds = new HashSet<Long>(templates.length);
        for (DynamicObject template : templates) {
            DynamicObjectCollection reporttypes;
            List reporttypeFromDBIds;
            DynamicObjectCollection layoutEntrys;
            Set sonTabledimTypes;
            boolean isLegal = false;
            DynamicObjectCollection dimSetEntry = template.getDynamicObjectCollection("layoutentry");
            List subDimIdList = dimSetEntry.stream().filter(item -> !item.getBoolean("dimhide")).map(item -> item.getLong("layoutdim.id")).collect(Collectors.toList());
            TemplateLayout dimLayout = reportTemplate.getDimLayout();
            List dimLayoutInfoList = dimLayout.getDimLayoutInfoList();
            List currDimIdList = dimLayoutInfoList.stream().filter(item -> item.isVisible()).map(item -> item.getDimensionId()).collect(Collectors.toList());
            if (subDimIdList.size() < currDimIdList.size() || currDimIdList.removeAll(subDimIdList) && currDimIdList.size() != 0) continue;
            Set subjectIds = null;
            if (template.getString("templatetype").equals(TemplateTypeEnum.FIXED.getValue())) {
                DynamicObjectCollection subjectEntrys = template.getDynamicObjectCollection("subjecttentry");
                subjectIds = subjectEntrys.stream().map(v -> v.getDynamicObject("subject").getLong("id")).collect(Collectors.toSet());
            } else {
                dimSetEntry = template.getDynamicObjectCollection("dimsettingentry");
                Optional<DynamicObject> first = dimSetEntry.stream().filter(item -> TemplateDimBDTypeEnum.DIM.getValue().equals(item.getString("dimbdtype")) && DimsionEnums.SUBJECT.getNumber().equals(item.get("dimbd.basedata"))).findFirst();
                if (!first.isPresent()) continue;
                DynamicObject subjectDimEntry = first.get();
                DynamicObjectCollection subjectMember = subjectDimEntry.getDynamicObjectCollection("plantemplatemember");
                subjectIds = subjectMember.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            }
            isLegal = subjectIds.containsAll(acctIds);
            if (!isLegal) continue;
            List currencyIds = reportTemplate.getCurrencyMemberIdList();
            DynamicObjectCollection currencys = template.getDynamicObjectCollection("currencymember");
            List currencyFromDBIds = currencys.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            boolean bl = isLegal = CollectionUtils.isEmpty((Collection)currencyIds) ? true : currencyFromDBIds.containsAll(currencyIds);
            if (!isLegal || !(isLegal = (sonTabledimTypes = (layoutEntrys = template.getDynamicObjectCollection("layoutentry")).stream().filter(v -> v.getBoolean("dimhide")).map(v -> v.getDynamicObject("layoutdim").getString("basedata")).collect(Collectors.toSet())).containsAll(mainTableDimTypes)) || !(isLegal = (reporttypeFromDBIds = (reporttypes = template.getDynamicObjectCollection("reporttype")).stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())).containsAll(reportPeriods))) continue;
            templateIds.add(template.getLong("id"));
        }
        if (CollectionUtils.isEmpty(templateIds)) {
            return Collections.singletonList(new QFilter("id", "=", (Object)0L));
        }
        return Collections.singletonList(new QFilter("id", "in", (Object)templateIds.toArray()));
    }
}

