/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fpm.common.enums.BodySysManagerTypeEnum;
import kd.tmc.fpm.common.enums.OrgControlEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BodySysManageEdit
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(BodySysManageEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initOrgF7();
        this.initReportF7();
        this.getView().getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        String userId = RequestContext.get().getUserId();
        this.getModel().setValue("creatormanage", (Object)userId);
        this.getModel().setValue("managertype", (Object)BodySysManagerTypeEnum.CREATER.getValue());
        this.getModel().setValue("manager", (Object)userId);
        this.initCombo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object value = this.getModel().getValue("id");
        if (!Long.valueOf(0L).equals(value)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("applyrereportentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject data = (DynamicObject)entryEntity.get(i);
            if (data.getBoolean("issumreport")) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"issumreporttext", (Object)ResManager.loadKDString((String)"\u662f", (String)"BodySysManageEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), (int)i);
                continue;
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"issumreporttext", (Object)ResManager.loadKDString((String)"\u5426", (String)"BodySysManageEdit_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), (int)i);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if ("org".equals(key) && newValue != null) {
            Object orgId = ((DynamicObject)newValue).getPkValue();
            DynamicObject orgObj = QueryServiceHelper.queryOne((String)"bos_org", (String)"fisaccounting", (QFilter[])new QFilter[]{new QFilter("id", "=", orgId)});
            if (Objects.isNull(orgObj)) {
                return;
            }
            if (!orgObj.getBoolean("fisaccounting")) {
                return;
            }
            DynamicObject accountingSysBase = QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)"id,basecurrrency,exratetable", (QFilter[])new QFilter[]{new QFilter("baseacctorg", "=", orgId)});
            if (accountingSysBase != null) {
                this.getModel().setValue("currency", (Object)accountingSysBase.getLong("basecurrrency"));
                this.getModel().setValue("ratetype", (Object)accountingSysBase.getLong("exratetable"));
            } else {
                this.getModel().setValue("currency", null);
                this.getModel().setValue("ratetype", null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("rereporttypedelete".equals(key)) {
            this.reReportTypeDeleteValidator(args);
        } else if ("rereporttypeenable".equals(key)) {
            this.reReportTypeEnableValidator(args);
        } else if ("rereporttypedisable".equals(key)) {
            this.reReportTypeDisableValidator(args);
        } else if ("issumreportopen".equals(key)) {
            this.reReportTypeOpenValidator(args);
        } else if ("issumreportclose".equals(key)) {
            this.reReportTypeCloseValidator(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("rereporttypedelete".equals(operateKey)) {
            if (args.getOperationResult().isSuccess()) {
                this.getView().invokeOperation("deleteentry");
            }
        } else if ("rereporttypedisable".equals(operateKey)) {
            this.setItemStatus("disable");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"BodySysManageEdit_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        } else if ("rereporttypeenable".equals(operateKey)) {
            this.setReReportTypeEnable();
        } else if ("issumreportopen".equals(operateKey)) {
            this.setIsSum(Boolean.TRUE);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6c47\u603b\u4e0a\u62a5\u5df2\u6210\u529f\u5f00\u542f\u3002", (String)"BodySysManageEdit_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        } else if ("issumreportclose".equals(operateKey)) {
            this.setIsSum(Boolean.FALSE);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6c47\u603b\u4e0a\u62a5\u5df2\u53d6\u6d88\u3002", (String)"BodySysManageEdit_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void reReportTypeDeleteValidator(BeforeDoOperationEventArgs args) {
        Pair<Boolean, Map<Integer, DynamicObject>> entrySelectedRows = this.getEntrySelectedRows("applyrereportentry");
        if (!((Boolean)entrySelectedRows.getLeft()).booleanValue()) {
            args.setCancel(true);
            return;
        }
        Map right = (Map)entrySelectedRows.getRight();
        ArrayList selectedList = new ArrayList(right.values());
        Object bodysystem = this.getModel().getDataEntity().getPkValue();
        boolean validatorResult = Boolean.FALSE;
        for (DynamicObject selected : selectedList) {
            DynamicObject rerporttype = selected.getDynamicObject("rerporttype");
            if (rerporttype == null) continue;
            QFilter tQFilter = new QFilter("model", "=", bodysystem);
            tQFilter.and("reporttype.fbasedataid", "=", rerporttype.getPkValue());
            validatorResult = TmcDataServiceHelper.exists((String)"fpm_template", (QFilter[])new QFilter[]{tQFilter});
            if (!validatorResult) continue;
            args.setCancel(true);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff08%2$s\uff09\u5df2\u88ab\u8d44\u91d1\u8ba1\u5212\u6a21\u677f\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"BodySysManageEdit_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), rerporttype.getString("number"), rerporttype.getString("name")));
            return;
        }
    }

    private void reReportTypeEnableValidator(BeforeDoOperationEventArgs args) {
        Pair<Boolean, Map<Integer, DynamicObject>> entrySelectedRows = this.getEntrySelectedRows("applyrereportentry");
        if (!((Boolean)entrySelectedRows.getLeft()).booleanValue()) {
            args.setCancel(true);
        }
        Map right = (Map)entrySelectedRows.getRight();
        ArrayList<DynamicObject> selectedList = new ArrayList<DynamicObject>(right.values());
        Pair<List<DynamicObject>, List<DynamicObject>> listListPair = this.buildEnableAndDisableData(selectedList);
        List needDisable = (List)listListPair.getLeft();
        List needEnable = (List)listListPair.getRight();
        Pair booleanStringPair = Pair.of((Object)Boolean.TRUE, null);
        if (needDisable.size() > 0) {
            booleanStringPair = ModelHelper.reReportTypeDisableValidator((Object)this.getModel().getDataEntity().getPkValue(), (List)needDisable);
        }
        if (!((Boolean)booleanStringPair.getLeft()).booleanValue()) {
            args.setCancel(true);
            this.getView().showTipNotification((String)booleanStringPair.getRight());
            return;
        }
        booleanStringPair = ModelHelper.reReportTypeEnableValidator((List)needEnable);
        if (!((Boolean)booleanStringPair.getLeft()).booleanValue()) {
            this.getView().showTipNotification((String)booleanStringPair.getRight());
            args.setCancel(true);
            return;
        }
    }

    private void reReportTypeDisableValidator(BeforeDoOperationEventArgs args) {
        Pair<Boolean, Map<Integer, DynamicObject>> entrySelectedRows = this.getEntrySelectedRows("applyrereportentry");
        if (!((Boolean)entrySelectedRows.getLeft()).booleanValue()) {
            args.setCancel(true);
        }
        Map right = (Map)entrySelectedRows.getRight();
        ArrayList selectedList = new ArrayList(right.values());
        Pair booleanStringPair = ModelHelper.reReportTypeDisableValidator((Object)this.getModel().getDataEntity().getPkValue(), selectedList);
        if (!((Boolean)booleanStringPair.getLeft()).booleanValue()) {
            args.setCancel(true);
            this.getView().showTipNotification((String)booleanStringPair.getRight());
            return;
        }
    }

    private void reReportTypeCloseValidator(BeforeDoOperationEventArgs args) {
        Map right;
        ArrayList selectedList;
        List enableList;
        Pair<Boolean, Map<Integer, DynamicObject>> entrySelectedRows = this.getEntrySelectedRows("applyrereportentry");
        if (!((Boolean)entrySelectedRows.getLeft()).booleanValue()) {
            args.setCancel(true);
        }
        if (!ModelHelper.reReportTypeCloseValidator(enableList = (selectedList = new ArrayList((right = (Map)entrySelectedRows.getRight()).values())).stream().filter(i -> "enable".equals(i.get("rereporttypestatus"))).collect(Collectors.toList())).booleanValue()) {
            return;
        }
    }

    private void reReportTypeOpenValidator(BeforeDoOperationEventArgs args) {
        Map right;
        ArrayList selectedList;
        List enableList;
        Pair<Boolean, Map<Integer, DynamicObject>> entrySelectedRows = this.getEntrySelectedRows("applyrereportentry");
        if (!((Boolean)entrySelectedRows.getLeft()).booleanValue()) {
            args.setCancel(true);
        }
        if (!ModelHelper.reReportTypeOpenValidator(enableList = (selectedList = new ArrayList((right = (Map)entrySelectedRows.getRight()).values())).stream().filter(i -> "enable".equals(i.get("rereporttypestatus"))).collect(Collectors.toList())).booleanValue()) {
            return;
        }
    }

    private Pair<List<DynamicObject>, List<DynamicObject>> buildEnableAndDisableData(List<DynamicObject> selectedList) {
        Map<String, List<DynamicObject>> groupOrgReportInfo = selectedList.stream().filter(i -> i.get("rerporttype") != null).collect(Collectors.groupingBy(i -> i.getString("rerporttype.orgreportcycle")));
        DynamicObjectCollection allReportColl = this.getModel().getEntryEntity("applyrereportentry");
        Map<String, List<DynamicObject>> otherUnSelectData = allReportColl.stream().filter(i -> i.get("rerporttype") != null && !selectedList.contains(i)).collect(Collectors.groupingBy(i -> i.getString("rerporttype.orgreportcycle")));
        Iterator<Map.Entry<String, List<DynamicObject>>> iterator = groupOrgReportInfo.entrySet().iterator();
        ArrayList<DynamicObject> needDisable = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needEnable = new ArrayList<DynamicObject>(10);
        while (iterator.hasNext()) {
            Map.Entry<String, List<DynamicObject>> next = iterator.next();
            List<DynamicObject> value = next.getValue();
            if (value.size() > 1) {
                needDisable.addAll(value.subList(1, value.size()));
            }
            needEnable.add(value.get(0));
            List<DynamicObject> dynamicObjects = otherUnSelectData.get(next.getKey());
            if (dynamicObjects == null || dynamicObjects.size() <= 0) continue;
            needDisable.addAll(dynamicObjects);
        }
        return Pair.of(needDisable, needEnable);
    }

    private void setReReportTypeEnable() {
        Pair<Boolean, Map<Integer, DynamicObject>> entrySelectedRows = this.getEntrySelectedRows("applyrereportentry");
        Map selectedMap = (Map)entrySelectedRows.getRight();
        ArrayList<DynamicObject> selectedList = new ArrayList<DynamicObject>(selectedMap.values());
        Pair<List<DynamicObject>, List<DynamicObject>> listListPair = this.buildEnableAndDisableData(selectedList);
        List needDisable = (List)listListPair.getLeft();
        List needEnable = (List)listListPair.getRight();
        DynamicObjectCollection allDataColl = this.getModel().getEntryEntity("applyrereportentry");
        for (int i = 0; i < allDataColl.size(); ++i) {
            if (needDisable.size() > 0 && needDisable.contains(allDataColl.get(i))) {
                this.getModel().setValue("rereporttypestatus", (Object)"disable", i);
                continue;
            }
            if (needEnable.size() <= 0 || !needEnable.contains(allDataColl.get(i))) continue;
            this.getModel().setValue("rereporttypestatus", (Object)"enable", i);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"BodySysManageEdit_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private void setItemStatus(String status) {
        int[] selectRows;
        EntryGrid control = (EntryGrid)this.getView().getControl("applyrereportentry");
        for (int selectRow : selectRows = control.getSelectRows()) {
            this.getModel().setValue("rereporttypestatus", (Object)status, selectRow);
        }
    }

    private void setIsSum(Boolean isSum) {
        int[] selectRows;
        EntryGrid control = (EntryGrid)this.getView().getControl("applyrereportentry");
        for (int selectRow : selectRows = control.getSelectRows()) {
            this.getModel().setValue("issumreport", (Object)isSum, selectRow);
        }
    }

    private Pair<Boolean, Map<Integer, DynamicObject>> getEntrySelectedRows(String entryName) {
        EntryGrid control = (EntryGrid)this.getView().getControl(entryName);
        int[] selectRows = control.getSelectRows();
        HashMap<Integer, DynamicObject> selectedMap = new HashMap<Integer, DynamicObject>(10);
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BodySysManageEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return Pair.of((Object)Boolean.FALSE, selectedMap);
        }
        for (int selectRow : selectRows) {
            selectedMap.put(selectRow, this.getModel().getEntryRowEntity(entryName, selectRow));
        }
        return Pair.of((Object)Boolean.TRUE, selectedMap);
    }

    protected void initOrgF7() {
        BasedataEdit orgBE = (BasedataEdit)this.getControl("org");
        orgBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"fpm", (String)"fpm_bodysysmanage", (String)"47150e89000000ac");
            QFilter idQFilter = new QFilter("id", "in", (Object)orgIds);
            showParameter.getListFilterParameter().setFilter(idQFilter);
        });
    }

    protected void initReportF7() {
        BasedataEdit reportBE = (BasedataEdit)this.getControl("rerporttype");
        reportBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7f16\u62a5\u7c7b\u578b", (String)"BodySysManageEdit_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection reReportTypeColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("applyrereportentry");
            List idList = reReportTypeColl.stream().filter(item -> item.getDynamicObject("rerporttype") != null).map(item -> item.getDynamicObject("rerporttype").getPkValue()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(idList)) {
                qFilter.and(new QFilter("id", "not in", idList));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void initCombo() {
        ComboEdit orgControl = (ComboEdit)this.getView().getControl("orgcontrol");
        List orgControlItemList = Arrays.stream(OrgControlEnum.values()).map(item -> new ComboItem(new LocaleString(item.getName()), item.getCode())).collect(Collectors.toList());
        orgControl.setComboItems(orgControlItemList);
    }
}

