/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.task.ReportImportDataClickTask;
import kd.tmc.fpm.business.task.SystemExportTask;
import kd.tmc.fpm.business.task.result.TaskResult;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.formplugin.helper.JobFormInfoHelper;
import org.apache.commons.collections.CollectionUtils;

public class BodySysManageList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean lookUp = listShowParameter.isLookUp();
        if (!lookUp) {
            qFilters.add(ModelHelper.getAllAuthQFilter());
            qFilters.add(new QFilter("applyrereportentry.rereporttypestatus", "=", (Object)"enable"));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection collection = this.getSelectedRows();
        Set pkIds = collection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        switch (itemKey) {
            case "bar_copy": {
                if (pkIds.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5907\u4efd\u7684\u4f53\u7cfb\u6570\u636e\u3002", (String)"BodySysManageList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (pkIds.size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5907\u4efd\uff0c\u8bf7\u9009\u62e91\u6761\u6570\u636e\u3002", (String)"BodySysManageList_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "deleteop": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "sys_copy": {
                this.sysCopy();
                break;
            }
            case "bodysys_export": {
                this.export();
                break;
            }
        }
    }

    private void export() {
        ListSelectedRowCollection collection = this.getSelectedRows();
        List systemIds = collection.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Long.class::cast).distinct().collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(systemIds)) {
            JobFormInfoHelper.dispatch(JobFormInfoHelper.getJobFormInfoParam().setFormView(this.getView()).setTaskClassName(SystemExportTask.class.getName()).setName(ResManager.loadKDString((String)"\u4f53\u7cfb\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1", (String)"BodySysManageList_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).setCaption(ResManager.loadKDString((String)"\u6267\u884c\u4f53\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1", (String)"BodySysManageList_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).addParam("systemIds", systemIds).addParam("pageId", this.getView().getPageId()).setClickClassName(ReportImportDataClickTask.class.getName()).setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bodysys_export")));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (Objects.isNull(e.getReturnData())) {
            return;
        }
        switch (e.getActionId()) {
            case "systemCopyCloseCallBack": {
                this.handleSystemCopyCallBack(e);
                break;
            }
            case "bodysys_import": {
                break;
            }
            case "bodysys_export": {
                this.handleSystemExport(e);
                break;
            }
        }
    }

    private void handleSystemExport(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        TaskResult taskResult = JobFormInfoHelper.parseTaskResult(returnData);
        if (taskResult == null) {
            return;
        }
        if (!taskResult.isSuccess()) {
            String errorMessage = taskResult.getErrorMessage();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u4f53\u7cfb\u5bfc\u51fa\u4efb\u52a1\u5f02\u5e38\uff1a%1$s", (String)"BodySysManageList_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errorMessage));
            return;
        }
        this.getView().download((String)taskResult.getResultInfo("exportUrl", String.class));
    }

    private void handleSystemCopyCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (!(returnData instanceof Map)) {
            return;
        }
        Map result = (Map)returnData;
        Object taskInfoObj = result.get("taskinfo");
        if (EmptyUtil.isEmpty(taskInfoObj)) {
            return;
        }
        String taskInfoStr = (String)taskInfoObj;
        if (EmptyUtil.isEmpty((String)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (!taskInfo.isTaskEnd()) {
            return;
        }
        String data = taskInfo.getData();
        Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        boolean success = (Boolean)mapData.get("success");
        if (!success) {
            List errorMessage = (List)mapData.get("errorMessage");
            if (!CollectionUtils.isEmpty((Collection)errorMessage)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u4f53\u7cfb\u5907\u4efd\u4efb\u52a1\u5f02\u5e38\uff1a%1$s", (String)"BodySysManageList_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errorMessage.stream().reduce((a, b) -> a + '\n' + b).orElse(""));
                this.getView().showErrorNotification(errMsg);
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u5907\u4efd\u6210\u529f\u3002", (String)"BodySysManageList_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void sysCopy() {
        ListSelectedRowCollection collection = this.getSelectedRows();
        List<Object> systemIds = collection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(systemIds)) {
            JobFormInfo systemCopyJob = BodySysManageList.getSystemCopyJob(systemIds, this.getView());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "systemCopyCloseCallBack");
            systemCopyJob.setCloseCallBack(closeCallBack);
            JobForm.dispatch((JobFormInfo)systemCopyJob, (IFormView)this.getView());
        }
    }

    public static JobFormInfo getSystemCopyJob(List<Object> systemIds, IFormView formView) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(formView.getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setTaskClassname("kd.tmc.fpm.business.task.SystemBackupsTask");
        jobInfo.setName(ResManager.loadKDString((String)"\u4f53\u7cfb\u5907\u4efd\u8c03\u5ea6\u4efb\u52a1", (String)"BodySysManageList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setCanStop(Boolean.valueOf(false));
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u4f53\u7cfb\u5907\u4efd\u8c03\u5ea6\u4efb\u52a1", (String)"BodySysManageList_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("systemId", systemIds.get(0));
        params.put("pageId", formView.getPageId());
        params.put("appId", formView.getFormShowParameter().getServiceAppId());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo();
        jobFormInfo.setJobInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName("kd.tmc.fpm.business.task.ReportImportDataClickTask");
        return jobFormInfo;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        ListSelectedRowCollection collection = this.getSelectedRows();
        Set pkIds = collection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        switch (operate.getOperateKey()) {
            case "bodysys_export": {
                if (pkIds.size() == 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u5bfc\u51fa", (String)"BodySysManageList_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "bodysys_import": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("fpm_bodysysimport");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bodysys_import"));
                this.getView().showForm(formShowParameter);
            }
        }
    }
}

