/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.enums.PeriodControlStrategyEnum;
import kd.tmc.fpm.common.enums.WaysEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.property.ControlWayConfigProp;
import kd.tmc.fpm.utils.control.ControlWayUtil;
import org.apache.commons.collections.CollectionUtils;

public class ControlWayConfigEdit
extends AbstractBasePlugIn {
    private static final String DISABLE_VALUE_FOR_REFRESH = "DISABLE_VALUE_FOR_REFRESH";
    private static Map<String, String> BATCH_SET_FIELD_MAP = Collections.unmodifiableMap(new HashMap<String, String>(8){
        {
            this.put("entry_controlintensity", "controlintensity");
            this.put("entry_controlcoefficient", "controlcoefficient");
            this.put("entry_detailcontrol", "detailcontrol");
            this.put("entry_detailcontrolbasis", "detailcontrolbasis");
        }
    });
    public static Set<DimensionType> RULE_OUT_DIMENSION_TYPE = Collections.unmodifiableSet(new HashSet<DimensionType>(8){
        {
            this.add(DimensionType.ORG);
            this.add(DimensionType.PERIOD);
            this.add(DimensionType.CURRENCY);
            this.add(DimensionType.SUBJECTS);
        }
    });

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"expandall", "expandalldes", "closeall", "closealldes"});
        this.addItemClickListeners(new String[]{"batchset", "clean"});
        this.initF7();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"closeall", "closealldes"});
        IDataModel model = this.getModel();
        Object value = model.getValue("bodysys");
        if (Objects.isNull(value)) {
            return;
        }
        DynamicObject bodySys = (DynamicObject)value;
        this.initDetailControlBasis((Long)bodySys.getPkValue());
        String enable = (String)model.getValue("enable");
        String number = (String)model.getValue("number");
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"fpm_controlwayconfig", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        boolean flag = EmptyUtil.isEmpty((Collection)idList);
        if (flag) {
            this.doGrabSubjectsByBodySys(bodySys);
            this.setCopyValueIfNeed();
            this.getModel().setValue("periodstrategy", (Object)PeriodControlStrategyEnum.CURRENT_CONTROL.getValue());
        } else {
            DynamicObjectCollection subjectsByBodySys = this.getSubjectsByBodySys((Long)bodySys.getPkValue());
            List<SubjectTree> subjectTreeList = this.convertToSubjectTree((Collection<DynamicObject>)subjectsByBodySys);
            this.cacheFormulaSubject(subjectTreeList);
            this.disableControlIntensityForFormula();
            MulBasedataDynamicObjectCollection dynamicObjectCollection = (MulBasedataDynamicObjectCollection)model.getValue("reporttype");
            this.initPeriodStrategyCombo((DynamicObjectCollection)dynamicObjectCollection);
        }
        if (!flag && StringUtils.equals((CharSequence)enable, (CharSequence)"1")) {
            this.getPageCache().put(DISABLE_VALUE_FOR_REFRESH, DISABLE_VALUE_FOR_REFRESH);
            this.disnableAll();
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "bodysys": {
                this.grabSubjectsByBodySys(e);
                break;
            }
            case "reporttype": {
                this.setPeriodStrategyComboIfNeed(e);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "refresh": {
                this.closeAll(true);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "expandall": 
            case "expandalldes": {
                this.expandAll();
                break;
            }
            case "closeall": 
            case "closealldes": {
                this.closeAll(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "batchset": {
                this.showBatchSetForm(args);
                break;
            }
            case "clean": {
                this.clean(args);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                Tuple<Boolean, String> checkBeforeSave = ControlWayUtil.checkBeforeSave(this.getModel().getDataEntity(), this.getModel().getEntryEntity("entryentity"));
                if (((Boolean)checkBeforeSave.item1).booleanValue()) break;
                this.getView().showConfirm("", (String)checkBeforeSave.item2, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("bar_save", (IFormPlugin)this));
                evt.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "clean": {
                this.cleanOrCancel(result);
                break;
            }
            case "bar_save": {
                this.disableThenSave(result);
            }
        }
    }

    private void disableThenSave(MessageBoxResult result) {
        if (MessageBoxResult.No.equals((Object)result)) {
            return;
        }
        List<Object> needDisablePkIdList = ControlWayUtil.getNeedDisablePkIdList(this.getModel().getDataEntity(), this.getModel().getEntryEntity("entryentity"));
        OperationResult disable = TmcOperateServiceHelper.execOperate((String)"disable", (String)"fpm_controlwayconfig", (Object[])needDisablePkIdList.toArray(), (OperateOption)OperateOption.create());
        if (disable.isSuccess()) {
            this.getView().invokeOperation("save");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "batchset": {
                this.batchSetEntry(closedCallBackEvent);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String modelId = parentView.getPageCache().get("CONTROL_WAY_CONFIG_BODY_SYS_ID_KEY");
            if (Objects.isNull(modelId)) {
                return;
            }
            if (modelId.indexOf("[") != -1) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
                modelId = modelIdArr[0].trim();
            }
            this.getModel().setValue("bodysys", (Object)modelId);
        }
    }

    private void setCopyValueIfNeed() {
        DynamicObject dynamicObject = this.getFromCopy();
        if (Objects.isNull(dynamicObject)) {
            return;
        }
        for (Map.Entry entry : ControlWayConfigProp.COPY_PROP_MAP.entrySet()) {
            String entityName = (String)entry.getKey();
            List propList = (List)entry.getValue();
            if (StringUtils.isBlank((CharSequence)entityName)) {
                for (String prop : propList) {
                    this.getModel().setValue(prop, dynamicObject.get(prop));
                }
                continue;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityName);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entityName);
            for (int i = 0; i < entryEntity.size(); ++i) {
                for (String prop : propList) {
                    this.getModel().setValue(prop, ((DynamicObject)dynamicObjectCollection.get(i)).get(prop), i);
                }
            }
        }
    }

    private DynamicObject getFromCopy() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return null;
        }
        String id = parentView.getPageCache().get("COPY_ID");
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        parentView.getPageCache().put("COPY_ID", null);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(id), (String)"fpm_controlwayconfig");
        return dynamicObject;
    }

    private void setPeriodStrategyComboIfNeed(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObjectCollection newValue = new DynamicObjectCollection();
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            newValue = (DynamicObjectCollection)changeData.getNewValue();
        }
        this.initPeriodStrategyCombo(newValue);
        this.getModel().setValue("periodstrategy", (Object)PeriodControlStrategyEnum.CURRENT_CONTROL.getValue());
    }

    private void initPeriodStrategyCombo(DynamicObjectCollection newValue) {
        boolean flag = false;
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)newValue)) {
            List objectIds = newValue.stream().map(dynamicObject -> Long.parseLong(dynamicObject.getDynamicObject("fbasedataid").getPkValue().toString())).collect(Collectors.toList());
            String selectProp = String.join((CharSequence)",", "id", "orgreporttype");
            DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_orgreporttype", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("id", "in", objectIds)});
            flag = queryResult.stream().anyMatch(dynamicObject -> !EmptyUtil.isEmpty((String)dynamicObject.getString("orgreporttype")));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("periodstrategy");
        PeriodControlStrategyEnum[] strategyEnums = PeriodControlStrategyEnum.values();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(strategyEnums.length);
        for (PeriodControlStrategyEnum periodControlStrategyEnum : strategyEnums) {
            if (!flag && periodControlStrategyEnum == PeriodControlStrategyEnum.DETAIL_PERIOD_CONTROL) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(periodControlStrategyEnum.getValue());
            comboItem.setCaption(new LocaleString(periodControlStrategyEnum.getName()));
            comboItemList.add(comboItem);
        }
        comboEdit.setComboItems(comboItemList);
    }

    private void disnableAll() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        view.setEnable(Boolean.FALSE, new String[]{"bodysys"});
        view.setEnable(Boolean.FALSE, new String[]{"name"});
        view.setEnable(Boolean.FALSE, new String[]{"reporttype"});
        view.setEnable(Boolean.FALSE, new String[]{"periodstrategy"});
        view.setEnable(Boolean.FALSE, new String[]{"unavailablewarn"});
        view.setEnable(Boolean.FALSE, new String[]{"comment"});
        DynamicObjectCollection entryEntity = model.getEntryEntity("treeentryentity");
        String[] toArray = BATCH_SET_FIELD_MAP.keySet().toArray(new String[0]);
        for (int i = 0; i < entryEntity.size(); ++i) {
            view.setEnable(Boolean.FALSE, i, toArray);
        }
        DynamicObjectCollection modelEntryEntity = model.getEntryEntity("entryentity");
        for (int i = 0; i < modelEntryEntity.size(); ++i) {
            view.setEnable(Boolean.FALSE, i, new String[]{"entry_reportorg"});
        }
        view.setEnable(Boolean.FALSE, new String[]{"batchset", "clean"});
        view.setEnable(Boolean.FALSE, new String[]{"btn_add", "btn_del"});
    }

    private void clean(BeforeDoOperationEventArgs args) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (Objects.isNull(selectRows) || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6e05\u9664\u7684\u8bb0\u5f55\u3002", (String)"ControlWayConfigEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String detailMessage = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u6e05\u9664\u6240\u9009\u8bb0\u5f55\u7684\u63a7\u5236\u7b56\u7565\u76f8\u5173\u8bbe\u7f6e\u9879\uff0c\u6062\u590d\u5230\u521d\u59cb\u9ed8\u8ba4\u72b6\u6001\u3002", (String)"ControlWayConfigEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm("", detailMessage, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("clean", (IFormPlugin)this));
    }

    private void cleanOrCancel(MessageBoxResult result) {
        if (MessageBoxResult.No.equals((Object)result)) {
            return;
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        IDataModel model = this.getModel();
        for (int i : selectRows) {
            model.setValue("entry_controlintensity", (Object)"", i);
            model.setValue("entry_detailcontrol", (Object)Boolean.FALSE, i);
            model.setValue("entry_detailcontrolbasis", (Object)"", i);
        }
    }

    private void batchSetEntry(ClosedCallBackEvent closedCallBackEvent) {
        String jsonString = (String)closedCallBackEvent.getReturnData();
        if (EmptyUtil.isEmpty((String)jsonString)) {
            return;
        }
        Map resultMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("treeentryentity");
        for (int selectIndex : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectIndex);
            this.setStrategyConfigValue(model, dynamicObject, selectIndex, resultMap);
        }
    }

    private void setStrategyConfigValue(IDataModel model, DynamicObject dynamicObject, int index, Map<Object, Object> resultMap) {
        DynamicObject subjectObj = dynamicObject.getDynamicObject("entry_subjectnumber");
        String subjectFlow = subjectObj.getString("flow");
        for (Map.Entry<String, String> entry : BATCH_SET_FIELD_MAP.entrySet()) {
            if (StringUtils.equals((CharSequence)subjectFlow, (CharSequence)FlowEnum.BALANCE.getValue())) {
                return;
            }
            model.setValue(entry.getKey(), resultMap.get(entry.getValue()), index);
        }
    }

    private void showBatchSetForm(BeforeDoOperationEventArgs args) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (Objects.isNull(selectRows) || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6279\u91cf\u8bbe\u7f6e\u7684\u8bb0\u5f55\u3002", (String)"ControlWayConfigEdit_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_batchset");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchset"));
        DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
        if (Objects.isNull(bodySys)) {
            this.showBodySysNotification();
            return;
        }
        showParameter.getCustomParams().put("bodysys", bodySys.getPkValue());
        this.getView().showForm(showParameter);
    }

    private void expandAll() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        treeEntryGrid.setCollapse(false);
        this.getView().updateView("treeentryentity");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"expandall", "expandalldes"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"closeall", "closealldes"});
        this.disableControlIntensityForFormula();
        this.disableIfNeed();
    }

    private void disableIfNeed() {
        String disable = this.getPageCache().get(DISABLE_VALUE_FOR_REFRESH);
        if (EmptyUtil.isEmpty((String)disable)) {
            return;
        }
        this.disnableAll();
    }

    private void closeAll(boolean needUpdateView) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        if (needUpdateView) {
            treeEntryGrid.setCollapse(true);
            this.getView().updateView("treeentryentity");
        }
        this.disableControlIntensityForFormula();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"expandall", "expandalldes"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"closeall", "closealldes"});
        this.disableIfNeed();
    }

    private void disableControlIntensityForFormula() {
        String formulaSubject = this.getPageCache().get("FORMULA_SUBJECT");
        if (StringUtils.isEmpty((CharSequence)formulaSubject)) {
            return;
        }
        String[] split = formulaSubject.split(",");
        Set formulaIds = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toSet());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            Long subjectId = (Long)dynamicObject.getDynamicObject("entry_subjectnumber").getPkValue();
            if (!formulaIds.contains(subjectId)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"entry_controlintensity"});
        }
    }

    private void grabSubjectsByBodySys(PropertyChangedArgs propertyChangedArgs) {
        ChangeData[] changeSet = propertyChangedArgs.getChangeSet();
        Object newValue = null;
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            newValue = changeData.getNewValue();
        }
        if (Objects.isNull(newValue)) {
            this.showBodySysNotification();
            return;
        }
        this.doGrabSubjectsByBodySys((DynamicObject)newValue);
    }

    private void showBodySysNotification() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u4f53\u7cfb\u3002", (String)"ControlWayConfigEdit_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private void doGrabSubjectsByBodySys(DynamicObject newValue) {
        DynamicObject bodySysNewObject = newValue;
        Long bodySysPkValue = (Long)bodySysNewObject.getPkValue();
        this.initDetailControlBasis(bodySysPkValue);
        DynamicObjectCollection subjectsByBodySys = this.getSubjectsByBodySys(bodySysPkValue);
        IDataModel model = this.getModel();
        model.deleteEntryData("treeentryentity");
        model.deleteEntryData("entryentity");
        List<SubjectTree> subjectTreeList = this.convertToSubjectTree((Collection<DynamicObject>)subjectsByBodySys);
        this.setEntrySubjectsField(subjectTreeList);
        this.cacheFormulaSubject(subjectTreeList);
        this.cleanData();
        this.closeAll(false);
    }

    private void cacheFormulaSubject(List<SubjectTree> subjectTreeList) {
        HashSet<Long> formulaWaySubjectId = new HashSet<Long>(16);
        for (SubjectTree subjectTree : subjectTreeList) {
            this.hasFormulaWay(subjectTree, formulaWaySubjectId);
        }
        this.getPageCache().put("FORMULA_SUBJECT", formulaWaySubjectId.stream().map(String::valueOf).collect(Collectors.joining(",")));
    }

    private boolean hasFormulaWay(SubjectTree subjectTree, Set<Long> formulaWaySubjectId) {
        List<SubjectTree> children;
        boolean flag = false;
        if (Objects.equals(subjectTree.getWays(), WaysEnum.FORMULA_TERM.getValue())) {
            formulaWaySubjectId.add(subjectTree.getId());
            flag = true;
        }
        if (CollectionUtils.isEmpty(children = subjectTree.getChildren())) {
            return flag;
        }
        for (SubjectTree child : children) {
            boolean hasFormulaWay = this.hasFormulaWay(child, formulaWaySubjectId);
            if (!hasFormulaWay || !formulaWaySubjectId.add(subjectTree.getId())) continue;
            flag = true;
        }
        return flag;
    }

    private void cleanData() {
        IDataModel model = this.getModel();
        model.setValue("reporttype", (Object)"");
        model.setValue("periodstrategy", null);
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            model.setValue("entry_reportorg", (Object)"", i);
        }
    }

    private void initDetailControlBasis(Long bodySysPkValue) {
        List<Dimension> listByBodySysId = this.getDimensionListByBodySysId(bodySysPkValue);
        ComboEdit detailControlBasis = (ComboEdit)this.getControl("entry_detailcontrolbasis");
        ArrayList<ComboItem> detailControlBasisComboItemList = new ArrayList<ComboItem>(listByBodySysId.size());
        for (Dimension dimension : listByBodySysId) {
            MemberType memberType;
            DimensionType dimType = dimension.getDimType();
            if (RULE_OUT_DIMENSION_TYPE.contains(dimType) || dimType == DimensionType.METRIC || dimType == DimensionType.DETAILDIM && (!dimension.isVisible() || (memberType = dimension.getMemberType()) == MemberType.AMOUNT || memberType == MemberType.DATE)) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(dimension.getName()));
            comboItem.setValue(this.getValue(dimension));
            detailControlBasisComboItemList.add(comboItem);
        }
        detailControlBasis.setComboItems(detailControlBasisComboItemList);
    }

    private String getValue(Dimension dimension) {
        DimensionType dimType = dimension.getDimType();
        StringBuilder sb = new StringBuilder();
        if (DimensionType.DETAILDIM != dimType) {
            sb.append(dimType.getNumber()).append("#").append(dimension.getId());
        } else {
            sb.append(dimension.getDetailDimType().getNumber()).append("#").append(dimension.getId());
        }
        return sb.toString();
    }

    private List<Dimension> getDimensionListByBodySysId(Long bodySysPkValue) {
        ArrayList<Dimension> dimensionList;
        DimensionRepository dimensionRepository = new DimensionRepository();
        FundPlanSystem fundPlanSystem = dimensionRepository.loadSystem(bodySysPkValue.longValue());
        if (fundPlanSystem == null || CollectionUtils.isEmpty((Collection)(dimensionList = fundPlanSystem.getDimList()))) {
            dimensionList = new ArrayList<Dimension>(2);
        }
        return dimensionList;
    }

    private List<SubjectTree> convertToSubjectTree(Collection<DynamicObject> subjectsByBodySys) {
        ArrayList<SubjectTree> subjectTreeList = new ArrayList<SubjectTree>(subjectsByBodySys.size());
        List dynamicObjectList = subjectsByBodySys.stream().sorted(Comparator.comparing(ControlWayConfigEdit::getLevel)).collect(Collectors.toList());
        HashMap<Long, SubjectTree> subjectTreeMap = new HashMap<Long, SubjectTree>(subjectsByBodySys.size());
        for (DynamicObject dynamicObject : dynamicObjectList) {
            SubjectTree subjectTree = SubjectTree.getInstanceFormDynamicObject(dynamicObject);
            Long parentId = subjectTree.getParentId();
            if (EmptyUtil.isEmpty((Long)parentId)) {
                subjectTreeList.add(subjectTree);
            }
            if (subjectTreeMap.containsKey(parentId)) {
                SubjectTree parentSubjectTree = (SubjectTree)subjectTreeMap.get(parentId);
                List<SubjectTree> children = parentSubjectTree.getChildren();
                if (CollectionUtils.isEmpty(children)) {
                    children = new ArrayList<SubjectTree>(4);
                    parentSubjectTree.setChildren(children);
                }
                children.add(subjectTree);
            }
            subjectTreeMap.put(subjectTree.getId(), subjectTree);
        }
        return subjectTreeList;
    }

    private void setEntrySubjectsField(List<SubjectTree> subjectTreeList) {
        IDataModel model = this.getModel();
        boolean dataChanged = model.getDataChanged();
        for (SubjectTree subjectTree : subjectTreeList) {
            int newEntryRow = model.createNewEntryRow("treeentryentity");
            this.setValue(model, subjectTree, newEntryRow);
            List<SubjectTree> children = subjectTree.getChildren();
            if (!CollectionUtils.isNotEmpty(children)) continue;
            this.createChildrenEntryAndSet(children, newEntryRow);
        }
        if (!dataChanged) {
            model.setDataChanged(false);
        }
    }

    private void createChildrenEntryAndSet(List<SubjectTree> children, int parentIndex) {
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        IDataModel model = this.getModel();
        for (SubjectTree subjectTree : children) {
            int insertEntryRow = model.insertEntryRow("treeentryentity", parentIndex);
            this.setValue(model, subjectTree, insertEntryRow);
            List<SubjectTree> childList = subjectTree.getChildren();
            if (!CollectionUtils.isNotEmpty(childList)) continue;
            this.createChildrenEntryAndSet(childList, insertEntryRow);
        }
    }

    private void setValue(IDataModel model, SubjectTree subjectTree, int newEntryRow) {
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"entry_subjectnumber", (Object)subjectTree.getId(), (int)newEntryRow);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"entry_subjectflow", (Object)subjectTree.getFlow(), (int)newEntryRow);
    }

    private DynamicObjectCollection getSubjectsByBodySys(Long bodySysPkValue) {
        String selectFields = String.join((CharSequence)",", "id", "number", "name", "level", "flow", "parent", "ways");
        QFilter qFilter = new QFilter("bodysysmanage", "=", (Object)bodySysPkValue).and("dimtype", "=", (Object)DimensionType.SUBJECTS.getNumber()).and(new QFilter("enable", "=", (Object)"1"));
        return QueryServiceHelper.query((String)"fpm_membersubject", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"sortcode");
    }

    private static int getLevel(DynamicObject dynamicObject) {
        return dynamicObject.getInt("level");
    }

    private void initF7() {
        this.bodySysF7Model();
        this.reportTypeF7Model();
        this.reportOrgModel();
    }

    private void reportOrgModel() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("entry_reportorg");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
            if (Objects.isNull(bodySys)) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            List idList = entryEntity.stream().map(dynamicObject -> dynamicObject.getDynamicObject("entry_reportorg")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            String appId = this.getView().getFormShowParameter().getAppId();
            QFilter filter = new QFilter("bodysystem", "=", bodySys.getPkValue());
            filter.and(new QFilter("dimtype", "=", (Object)DimensionType.ORG.getNumber()));
            filter.and(new QFilter("enable", "=", (Object)"1"));
            filter.and(ModelHelper.getOrgAuthWithCheckManagerFilter((String)appId, (String)"fpm_controlwayconfig"));
            filter.and(new QFilter("id", "not in", idList));
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(filter));
            showParameter.setCaption(ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"ControlWayConfigEdit_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        });
    }

    private QFilter[] getqFilter(DynamicObject bodySys) {
        QFilter authQFilter = ModelHelper.getAuthQFilter();
        authQFilter.and(new QFilter("id", "=", bodySys.getPkValue()));
        if (QueryServiceHelper.exists((String)"fpm_bodysysmanage", (QFilter[])new QFilter[]{authQFilter})) {
            QFilter qFilter = new QFilter("bodysystem", "=", bodySys.getPkValue()).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("dimtype", "=", (Object)DimensionType.ORG.getNumber()));
            return new QFilter[]{qFilter};
        }
        DynamicObject bodySysObj = FpmDataServiceHelper.getBodySystemByCache((Long)((Long)bodySys.getPkValue()));
        DynamicObjectCollection dynamicObjectCollection = bodySysObj.getDynamicObjectCollection("usermanage");
        List userIdList = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getPkValue()).collect(Collectors.toList());
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgList = userIdList.stream().map(userObjId -> {
            List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"fpm_controlwayconfig", (String)"47150e89000000ac");
            return authorizedBankOrgId;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        QFilter qFilter = new QFilter("caporg", "in", authOrgList).or("relcaporg", "in", authOrgList).or("bodysystem", "=", bodySys.getPkValue());
        QFilter orgFilter = new QFilter("dimtype", "=", (Object)DimensionType.ORG.getNumber()).and("enable", "=", (Object)"1");
        return new QFilter[]{qFilter, orgFilter};
    }

    private void reportTypeF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("reporttype");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
            if (Objects.isNull(bodySys)) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            bodySys = FpmDataServiceHelper.getBodySystemByCache((Long)((Long)bodySys.getPkValue()));
            DynamicObjectCollection dynamicObjectCollection = bodySys.getDynamicObjectCollection("applyrereportentry");
            List objectList = dynamicObjectCollection.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)"enable", (CharSequence)dynamicObject.getString("rereporttypestatus"))).map(dynamicObject -> dynamicObject.get("rerporttype.id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", objectList).and(new QFilter("enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void bodySysF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("bodysys");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter authQFilter = ModelHelper.getAuthQFilter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"fpm_controlwayconfig", (String)"47150e89000000ac");
            QFilter qFilter = new QFilter("caporg", "in", (Object)authOrgList).or("relcaporg", "in", (Object)authOrgList);
            QFilter orgFilter = new QFilter("dimtype", "=", (Object)DimensionType.ORG.getNumber());
            DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_member", (String)"bodysystem", (QFilter[])new QFilter[]{orgFilter, qFilter});
            List bodySysIdList = queryResult.stream().map(dynamicObject -> dynamicObject.get("bodysystem")).filter(Objects::nonNull).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", bodySysIdList).and(new QFilter("enable", "=", (Object)"1"));
            authQFilter.or(filter);
            showParameter.getListFilterParameter().setFilter(authQFilter);
        });
    }

    static class SubjectTree {
        private Long id;
        private Long parentId;
        private String number;
        private String name;
        private int level;
        private String flow;
        private List<SubjectTree> children;
        private String ways;

        public SubjectTree() {
        }

        public SubjectTree(Long id, Long parentId, String number, String name, Integer level, String flow, String ways) {
            this.id = id;
            this.parentId = parentId;
            this.number = number;
            this.name = name;
            this.level = level;
            this.flow = flow;
            this.ways = ways;
        }

        public static SubjectTree getInstanceFormDynamicObject(DynamicObject dynamicObject) {
            long parentId = dynamicObject.getLong("parent");
            Long id = dynamicObject.getLong("id");
            String number = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            int level = dynamicObject.getInt("level");
            String flow = dynamicObject.getString("flow");
            String ways = dynamicObject.getString("ways");
            return new SubjectTree(id, parentId, number, name, level, flow, ways);
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getParentId() {
            return this.parentId;
        }

        public void setParentId(Long parentId) {
            this.parentId = parentId;
        }

        public List<SubjectTree> getChildren() {
            return this.children;
        }

        public void setChildren(List<SubjectTree> children) {
            this.children = children;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getFlow() {
            return this.flow;
        }

        public void setFlow(String flow) {
            this.flow = flow;
        }

        public String getWays() {
            return this.ways;
        }

        public void setWays(String ways) {
            this.ways = ways;
        }
    }
}

