/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.common.bean.CurrencyMapConfig;
import kd.tmc.fpm.listener.TmcBaseBeforeF7SelectListener;
import org.apache.commons.lang3.StringUtils;

public class CurrencyMapConfigPlugin
extends AbstractBasePlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        String currencyMapConfigJson = (String)this.getView().getFormShowParameter().getCustomParam("CURRENCY_MAP_CONFIG");
        if (StringUtils.isEmpty((CharSequence)currencyMapConfigJson)) {
            return;
        }
        CurrencyMapConfig currencyMapConfig = (CurrencyMapConfig)SerializationUtils.fromJsonString((String)currencyMapConfigJson, CurrencyMapConfig.class);
        this.init(currencyMapConfig);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("sumcurrencymemberid");
        basedataEdit.addBeforeF7SelectListener(this.getF7Listener());
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("submainreportcurrencyid");
        mulBasedataEdit.addBeforeF7SelectListener(this.getF7Listener());
    }

    private BeforeF7SelectListener getF7Listener() {
        final long bodySysId = this.getModel().getDataEntity().getLong("bodysysid");
        return new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)bodySysId)).build();
            }
        };
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"confirm")) {
            return;
        }
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)this.getCurrencyMapConfig()));
        this.getView().close();
    }

    private void init(CurrencyMapConfig currencyMapConfig) {
        IDataModel model = this.getModel();
        model.setValue("name", (Object)currencyMapConfig.getName());
        model.setValue("number", (Object)currencyMapConfig.getNumber());
        model.setValue("bodysysid", (Object)currencyMapConfig.getBodySysId());
        List mapConfigList = currencyMapConfig.getMapConfigList();
        if (CollectionUtils.isEmpty((Collection)mapConfigList)) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        for (CurrencyMapConfig.MapConfig mapConfig : mapConfigList) {
            int newEntryRow = model.createNewEntryRow("entryentity");
            model.setValue("sumcurrencymemberid", (Object)mapConfig.getSumCurrencyMemberId(), newEntryRow);
            model.setValue("submainreportcurrencyid", (Object)mapConfig.getSubMainReportCurrencyId().toArray(), newEntryRow);
        }
    }

    private CurrencyMapConfig getCurrencyMapConfig() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        CurrencyMapConfig currencyMapConfig = new CurrencyMapConfig();
        currencyMapConfig.setName(dataEntity.getString("name"));
        currencyMapConfig.setNumber(dataEntity.getString("number"));
        currencyMapConfig.setBodySysId(Long.valueOf(dataEntity.getLong("bodysysid")));
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<CurrencyMapConfig.MapConfig> mapConfigList = new ArrayList<CurrencyMapConfig.MapConfig>(dynamicObjectCollection.size());
        for (DynamicObject dy : dynamicObjectCollection) {
            CurrencyMapConfig.MapConfig mapConfig = new CurrencyMapConfig.MapConfig();
            mapConfig.setSumCurrencyMemberId((Long)dy.getDynamicObject("sumcurrencymemberid").getPkValue());
            mapConfig.setSubMainReportCurrencyId(dy.getDynamicObjectCollection("submainreportcurrencyid").stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toList()));
            mapConfigList.add(mapConfig);
        }
        currencyMapConfig.setMapConfigList(mapConfigList);
        return currencyMapConfig;
    }
}

