/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.DetailDimTypeEnum;
import kd.tmc.fpm.common.enums.DetailPlanFieldDataTypeEnum;
import kd.tmc.fpm.common.helper.DetailPlanFieldsHelper;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.utils.system.DefaultModelHelper;

public class DetailPlanFieldsEdit
extends AbstractFormPlugin {
    private boolean isTriggerChange = true;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initModelF7();
    }

    public void afterCreateNewData(EventObject e) {
        Long systemId = DefaultModelHelper.getBaseDataDefaultSystemId();
        if (systemId != null) {
            DynamicObject systemDy = TmcDataServiceHelper.loadSingle((Object)systemId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_bodysysmanage"));
            this.getModel().setValue("bodysys", (Object)systemDy);
        }
        this.loadData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object bdObj;
        Boolean validator;
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (!this.isTriggerChange) {
            return;
        }
        if ("bodysys".equals(name)) {
            this.loadData();
            if (EmptyUtil.isNoEmpty((Object)newValue)) {
                long systemId = ((DynamicObject)newValue).getLong("id");
                DefaultModelHelper.save(systemId);
            }
        } else if ("isshow".equals(name)) {
            Boolean validator2;
            Object bdObj2 = this.getModel().getValue("bodysys");
            if (bdObj2 != null && Boolean.FALSE.equals(newValue) && !(validator2 = DetailPlanFieldsHelper.showChangeValidator((Object)((DynamicObject)bdObj2).getPkValue(), (Object)((DynamicObject)this.getModel().getValue("fieldbd")).getPkValue())).booleanValue()) {
                this.getModel().setValue("isshow", (Object)true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5b57\u6bb5\u4e0d\u53ef\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u89c1\uff0c\u5b83\u5df2\u88ab\u6a21\u677f\u5f15\u7528\u5e76\u5df2\u88ab\u9009\u4e2d\u3002", (String)"DetailPlanFieldsEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return;
            }
            String value = (String)this.getModel().getValue("detaildimtype");
            if (DetailDimTypeEnum.CONNTERPARTY_TYPE.getValue().equals(value) || DetailDimTypeEnum.COUNTERPARTY_NAME.getValue().equals(value)) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                String targetName = DetailDimTypeEnum.CONNTERPARTY_TYPE.getValue().equals(value) ? DetailDimTypeEnum.COUNTERPARTY_NAME.getValue() : DetailDimTypeEnum.CONNTERPARTY_TYPE.getValue();
                for (int i = 0; i < entryEntity.size(); ++i) {
                    if (entryEntity.get(i) == null || ((DynamicObject)entryEntity.get(i)).get("detaildimtype") == null || !((DynamicObject)entryEntity.get(i)).get("detaildimtype").equals(targetName)) continue;
                    this.getModel().setValue("isshow", newValue, i);
                    break;
                }
            }
        } else if ("datatype".equals(name)) {
            if (EmptyUtil.isEmpty((Object)oldValue)) {
                this.fastFailIfMultiBaseData(newValue, oldValue);
                return;
            }
            List<String> referTypeCodeList = Arrays.asList(DetailPlanFieldDataTypeEnum.BASEDATA.getValue(), DetailPlanFieldDataTypeEnum.DATE.getValue(), DetailPlanFieldDataTypeEnum.AMOUNT.getValue());
            List<String> textTypeCodeList = Arrays.asList(DetailPlanFieldDataTypeEnum.TEXT.getValue(), DetailPlanFieldDataTypeEnum.ENUM.getValue());
            Object bdObj3 = this.getModel().getValue("bodysys");
            Boolean validator3 = DetailPlanFieldsHelper.showChangeValidator((Object)((DynamicObject)bdObj3).getPkValue(), (Object)((DynamicObject)this.getModel().getValue("fieldbd")).getPkValue());
            if (referTypeCodeList.contains(oldValue.toString())) {
                if (!validator3.booleanValue()) {
                    this.updateDataTypeWithoutPropertyChanged(oldValue);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5b57\u6bb5\u5df2\u88ab\u6a21\u677f\u5173\u8054\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DetailPlanFieldsEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                } else if (!DetailPlanFieldDataTypeEnum.BASEDATA.getValue().equals(newValue)) {
                    this.getModel().setValue("basedatatype", null);
                }
            } else if (textTypeCodeList.contains(oldValue.toString())) {
                if (!textTypeCodeList.contains(newValue.toString()) && !validator3.booleanValue()) {
                    this.updateDataTypeWithoutPropertyChanged(oldValue);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5b57\u6bb5\u5df2\u88ab\u6a21\u677f\u5173\u8054\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5c06\u201c\u6587\u672c/\u679a\u4e3e\u9009\u62e9\u201d\u7684\u6570\u636e\u7c7b\u578b\u4fee\u6539\u4e3a\u5176\u4ed6\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DetailPlanFieldsEdit_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                } else if (!DetailPlanFieldDataTypeEnum.ENUM.getValue().equals(newValue)) {
                    this.getModel().setValue("option", null);
                }
            }
            this.fastFailIfMultiBaseData(newValue, oldValue);
        } else if ("basedatatype".equals(name) && !(validator = DetailPlanFieldsHelper.showChangeValidator((Object)((DynamicObject)(bdObj = this.getModel().getValue("bodysys"))).getPkValue(), (Object)((DynamicObject)this.getModel().getValue("fieldbd")).getPkValue())).booleanValue()) {
            this.isTriggerChange = false;
            this.getModel().setValue("basedatatype", oldValue);
            this.isTriggerChange = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u4e0e\u6a21\u677f\u5173\u8054\uff0c\u65e0\u6cd5\u4fee\u6539\u57fa\u7840\u8d44\u6599\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DetailPlanFieldsEdit_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateDataTypeWithoutPropertyChanged(Object oldValue) {
        this.isTriggerChange = false;
        this.getModel().setValue("datatype", oldValue);
        this.isTriggerChange = true;
    }

    private void fastFailIfMultiBaseData(Object newValue, Object oldValue) {
        if (DetailPlanFieldDataTypeEnum.MUTIBASEDATA.getValue().equals(newValue)) {
            if (EmptyUtil.isNoEmpty((Object)oldValue)) {
                this.updateDataTypeWithoutPropertyChanged(oldValue);
            } else {
                this.getModel().setValue("datatype", null);
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u6682\u4e0d\u652f\u6301\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"DetailPlanFieldsEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("saveop".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.loadData();
        } else if ("newextraentry".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.addNewExtraEntry();
        }
    }

    private void addNewExtraEntry() {
        Object modelObj = this.getModel().getValue("bodysys");
        String selectFields = String.join((CharSequence)",", "sort", "detaildimtype");
        DynamicObjectCollection dataColl = QueryServiceHelper.query((String)"fpm_detailplanfields", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bodysys.id", "=", ((DynamicObject)modelObj).getPkValue()), new QFilter("detaildimtype", "like", (Object)"EXTRA_%")}, (String)"sort desc");
        if (dataColl.size() >= 22) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff0c\u81ea\u5b9a\u4e49\u660e\u7ec6\u8ba1\u5212\u5b57\u6bb5\u4e0d\u5141\u8bb8\u8d85\u8fc722\u4e2a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DetailPlanFieldsEdit_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = (DynamicObject)dataColl.get(0);
        int sortPrevious = dynamicObject.getInt("sort");
        String extraTypePrevious = dynamicObject.getString("detaildimtype");
        String extraIdxPrevious = extraTypePrevious.split("_")[1];
        String typeNumber = "EXTRA_" + (Integer.parseInt(extraIdxPrevious) + 1);
        DetailDimTypeEnum extraDetailType = DetailDimTypeEnum.getByValue((String)typeNumber);
        if (extraDetailType == null) {
            return;
        }
        DynamicObject newObj = TmcDataServiceHelper.newDynamicObject((String)"fpm_detailplanfields");
        newObj.set("bodysys", modelObj);
        newObj.set("createtime", (Object)new Date());
        newObj.set("creator", (Object)RequestContext.get().getUserId());
        newObj.set("enable", (Object)"1");
        newObj.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        newObj.set("sort", (Object)(sortPrevious + 1));
        newObj.set("modifytime", (Object)new Date());
        newObj.set("modifier", (Object)RequestContext.get().getUserId());
        newObj.set("syssetpre", (Object)Boolean.FALSE);
        newObj.set("fieldname", (Object)extraDetailType.getName());
        newObj.set("detaildimtype", (Object)extraDetailType.getValue());
        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_detailplanfields", (DynamicObject[])new DynamicObject[]{newObj}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
    }

    private void loadData() {
        DynamicObjectCollection dataColl;
        this.isTriggerChange = false;
        Object modelObj = this.getModel().getValue("bodysys");
        this.getModel().deleteEntryData("entryentity");
        if (modelObj != null && (dataColl = QueryServiceHelper.query((String)"fpm_detailplanfields", (String)"id", (QFilter[])new QFilter[]{new QFilter("bodysys.id", "=", ((DynamicObject)modelObj).getPkValue()), new QFilter("enable", "=", (Object)"1")})).size() != 0) {
            List idList = dataColl.stream().map(e -> e.get("id")).collect(Collectors.toList());
            DynamicObject[] dataArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_detailplanfields"));
            List sortedDataList = Stream.of(dataArr).sorted(Comparator.comparing(e -> e.getInt("sort"))).collect(Collectors.toList());
            for (DynamicObject data : sortedDataList) {
                int newEntryRow = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("fieldbd", data.get("id"), newEntryRow);
                this.getModel().setValue("fieldname", data.get("fieldname"), newEntryRow);
                this.getModel().setValue("fieldshowname", data.get("name"), newEntryRow);
                this.getModel().setValue("syssetpre", data.get("syssetpre"), newEntryRow);
                this.getModel().setValue("datatype", data.get("datatype"), newEntryRow);
                this.getModel().setValue("option", data.get("option"), newEntryRow);
                this.getModel().setValue("isshow", data.get("isshow"), newEntryRow);
                this.getModel().setValue("ismustinput", data.get("ismustinput"), newEntryRow);
                this.getModel().setValue("detaildimtype", data.get("detaildimtype"), newEntryRow);
                this.getModel().setValue("basedatatype", data.get("basedatatype"), newEntryRow);
            }
        }
        this.isTriggerChange = true;
    }

    protected void initModelF7() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("bodysys");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter authQFilter = ModelHelper.getAuthQFilter();
            showParameter.getListFilterParameter().setFilter(authQFilter);
        });
        String nonSelectedBaseDataPrefix = "fpm%";
        BasedataEdit baseDataTypeEdit = (BasedataEdit)this.getControl("basedatatype");
        baseDataTypeEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("number", "not like", (Object)nonSelectedBaseDataPrefix);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }
}

