/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.formop.ImportEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.enums.BizBDRangeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.helper.StringHelper;
import org.apache.commons.lang3.StringUtils;

public class DimensionMemberEdit
extends AbstractBasePlugIn {
    private static final String CACHE_KEY_F7_OLD_VALUE = "CACHE_KEY_F7_OLD_VALUE";
    private static final String CACHE_KEY_F7_NEW_VALUE = "CACHE_KEY_F7_NEW_VALUE";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bizbasedatadetail", "assistbasedatadetail"});
        this.initDimMemberF7();
        this.initModelF7();
        this.initDimF7();
        this.initBaseDataF7();
    }

    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String modelId = parentView.getPageCache().get("KEY_MODEL_ID");
            if (Objects.isNull(modelId)) {
                return;
            }
            if (modelId.indexOf(91) != -1) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
                modelId = modelIdArr[0].trim();
            }
            if (!StringUtils.isNumeric((CharSequence)modelId)) {
                return;
            }
            this.getModel().setValue("bodysysmanage", (Object)modelId);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("bizbasedatadetail".equals(key) || "assistbasedatadetail".equals(key)) {
            this.buildBaseDataDialog(key);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = null;
        Object oldValue = null;
        ChangeData changeData = null;
        if (changeSet != null && changeSet.length > 0) {
            changeData = changeSet[0];
            newValue = changeData.getNewValue();
            oldValue = changeData.getOldValue();
        }
        if ("bizbasedata".equals(name) || "assistbizbasedata".equals(name)) {
            Object bizData;
            Object assBizData;
            if ("break".equals(this.getPageCache().get(CACHE_KEY_F7_NEW_VALUE))) {
                this.getPageCache().remove(CACHE_KEY_F7_NEW_VALUE);
                return;
            }
            Boolean isPass = true;
            if ("bizbasedata".equals(name) && (assBizData = this.getModel().getValue("assistbizbasedata")) != null && newValue != null && newValue.equals(assBizData)) {
                isPass = false;
            }
            if ("assistbizbasedata".equals(name) && (bizData = this.getModel().getValue("bizbasedata")) != null && newValue != null && newValue.equals(bizData)) {
                isPass = false;
            }
            if (!isPass.booleanValue() && oldValue == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u548c\u8f85\u52a9\u57fa\u7840\u8d44\u6599\u4e0d\u53ef\u91cd\u590d\u3002", (String)"DimensionMemberEdit_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                this.getPageCache().put(CACHE_KEY_F7_NEW_VALUE, "break");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)name, (Object)"");
                return;
            }
            if (newValue != null) {
                this.getPageCache().put(CACHE_KEY_F7_NEW_VALUE, ((DynamicObject)newValue).getPkValue().toString());
            } else {
                this.getPageCache().put(CACHE_KEY_F7_NEW_VALUE, null);
            }
            if (oldValue != null) {
                this.getPageCache().put(CACHE_KEY_F7_OLD_VALUE, ((DynamicObject)oldValue).getPkValue().toString());
                this.getView().showConfirm("", ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u5c06\u6e05\u9664\u5f53\u524d\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DimensionMemberEdit_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(name, (IFormPlugin)this));
            } else {
                this.getPageCache().put(CACHE_KEY_F7_OLD_VALUE, null);
            }
        } else if ("dimension".equals(name)) {
            if (oldValue != null) {
                this.getPageCache().put(CACHE_KEY_F7_OLD_VALUE, ((DynamicObject)oldValue).getPkValue().toString());
                this.getView().showConfirm("", ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u7ef4\u5ea6\u4fe1\u606f\u5c06\u6e05\u9664\u5f53\u524d\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DimensionMemberEdit_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(name, (IFormPlugin)this));
            }
        } else if ("useassistbasedata".equals(name)) {
            if (Boolean.TRUE.equals(newValue)) {
                ((FieldEdit)this.getView().getControl("assistbizbasedata")).setMustInput(true);
                ((FieldEdit)this.getView().getControl("assistbasedatadetail")).setMustInput(true);
                ((FieldEdit)this.getView().getControl("assistbasedatadetailcode")).setMustInput(true);
            } else {
                ((FieldEdit)this.getView().getControl("assistbizbasedata")).setMustInput(false);
                ((FieldEdit)this.getView().getControl("assistbasedatadetail")).setMustInput(false);
                ((FieldEdit)this.getView().getControl("assistbasedatadetailcode")).setMustInput(false);
            }
        }
        switch (name) {
            case "bizbasedatadetail": {
                this.clearBaseDataDetailCodeIfNeed("bizbasedatadetailcode", changeData, newValue);
                break;
            }
            case "assistbasedatadetail": {
                this.clearBaseDataDetailCodeIfNeed("assistbasedatadetailcode", changeData, newValue);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("bizbasedata".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                Object assBizData = this.getModel().getValue("assistbizbasedata");
                String newValuePk = this.getPageCache().get(CACHE_KEY_F7_NEW_VALUE);
                if (assBizData != null && ((DynamicObject)assBizData).getPkValue().equals(newValuePk)) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)callBackId, (Object)this.getPageCache().get(CACHE_KEY_F7_OLD_VALUE));
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u548c\u8f85\u52a9\u57fa\u7840\u8d44\u6599\u4e0d\u53ef\u91cd\u590d\u3002", (String)"DimensionMemberEdit_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                this.clearEntryData(entryEntity);
                this.getView().updateView("entryentity");
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizbasedata", (Object)this.getPageCache().get(CACHE_KEY_F7_OLD_VALUE));
            }
        } else if ("assistbizbasedata".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                Object bizData = this.getModel().getValue("bizbasedata");
                String newValuePk = this.getPageCache().get(CACHE_KEY_F7_NEW_VALUE);
                if (bizData != null && ((DynamicObject)bizData).getPkValue().equals(newValuePk)) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)callBackId, (Object)this.getPageCache().get(CACHE_KEY_F7_OLD_VALUE));
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u548c\u8f85\u52a9\u57fa\u7840\u8d44\u6599\u4e0d\u53ef\u91cd\u590d\u3002", (String)"DimensionMemberEdit_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                this.clearEntryData(entryEntity);
                this.getView().updateView("entryentity");
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"assistbizbasedata", (Object)this.getPageCache().get(CACHE_KEY_F7_OLD_VALUE));
            }
        } else if ("dimension".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                this.clearEntryData(entryEntity);
                this.getView().updateView("entryentity");
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"dimension", (Object)this.getPageCache().get(CACHE_KEY_F7_OLD_VALUE));
            }
        }
    }

    private void clearEntryData(DynamicObjectCollection entryEntity) {
        for (DynamicObject dynamicObject : entryEntity) {
            dynamicObject.set("bizbasedatadetail", null);
            dynamicObject.set("bizbasedatadetailcode", null);
            dynamicObject.set("bizbasedatadetailid", null);
            dynamicObject.set("bizbdrange", null);
            dynamicObject.set("assistbasedatadetail", null);
            dynamicObject.set("assistbasedatadetailcode", null);
            dynamicObject.set("bizbasedatadetail", null);
            dynamicObject.set("assistbasedatadetailid", null);
            dynamicObject.set("dimmember", null);
        }
    }

    private void buildBaseDataDialog(String key) {
        Object bizBaseData;
        String formId = "";
        CloseCallBack closeCallBack = null;
        if ("bizbasedatadetail".equals(key)) {
            bizBaseData = this.getModel().getValue("bizbasedata");
            if (bizBaseData == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u672c\u4fe1\u606f-\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u3002", (String)"DimensionMemberEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return;
            }
            formId = ((DynamicObject)bizBaseData).getString("number");
            closeCallBack = new CloseCallBack((IFormPlugin)this, "bizbasedatadetail");
        } else if ("assistbasedatadetail".equals(key)) {
            bizBaseData = this.getModel().getValue("assistbizbasedata");
            if (bizBaseData == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u3002", (String)"DimensionMemberEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return;
            }
            formId = ((DynamicObject)bizBaseData).getString("number");
            closeCallBack = new CloseCallBack((IFormPlugin)this, "assistbasedatadetail");
        } else {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(formId);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formId);
        if (formConfig == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u7684\u5217\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"DimensionMemberEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String f7ListFormId = formConfig.getF7ListFormId();
        showParameter.setFormId(f7ListFormId);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowApproved(false);
        showParameter.setShowTitle(false);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("550");
        css.setWidth("900");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        QFilter baseQFilter = new QFilter("enable", "=", (Object)"1");
        showParameter.getListFilterParameter().setFilter(baseQFilter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("bizbasedatadetail".equals(actionId) || "assistbasedatadetail".equals(actionId)) {
            this.fillBaseDataInfo(e, actionId);
        }
    }

    private void fillBaseDataInfo(ClosedCallBackEvent e, String action) {
        ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)e.getReturnData();
        if (selectedRowCollection != null && selectedRowCollection.size() != 0) {
            Object bizBaseData;
            ListSelectedRow returnData = selectedRowCollection.get(0);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRows[0]);
            Long primaryKeyValue = 0L;
            try {
                primaryKeyValue = returnData.getPrimaryKeyValue() instanceof String ? Long.valueOf(Long.parseLong(returnData.getPrimaryKeyValue().toString())) : (Long)returnData.getPrimaryKeyValue();
            }
            catch (Exception var16) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636eID\u5e94\u4e3a\u6574\u6570\u3002", (String)"DimensionMemberEdit_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return;
            }
            String formId = "";
            if ("bizbasedatadetail".equals(action)) {
                bizBaseData = this.getModel().getValue("bizbasedata");
                formId = ((DynamicObject)bizBaseData).getString("number");
            } else if ("assistbasedatadetail".equals(action)) {
                bizBaseData = this.getModel().getValue("assistbizbasedata");
                formId = ((DynamicObject)bizBaseData).getString("number");
            }
            DynamicObject bdObj = TmcDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)formId);
            if (bdObj != null) {
                String bdDetailKey = "bizbasedatadetail";
                String bdCodeKey = "bizbasedatadetailcode";
                String bdCodeId = "bizbasedatadetailid";
                if ("assistbasedatadetail".equals(action)) {
                    bdDetailKey = "assistbasedatadetail";
                    bdCodeKey = "assistbasedatadetailcode";
                    bdCodeId = "assistbasedatadetailid";
                }
                dynamicObject.set(bdCodeId, (Object)primaryKeyValue);
                try {
                    Object number = bdObj.get("number");
                    dynamicObject.set(bdCodeKey, number);
                }
                catch (Exception exception) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u6ca1\u6709\u7f16\u7801\u5b57\u6bb5\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u3002", (String)"DimensionMemberEdit_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                try {
                    Object name = bdObj.get("name");
                    dynamicObject.set(bdDetailKey, name);
                }
                catch (Exception exception) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u6ca1\u6709\u540d\u79f0\u5b57\u6bb5\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u3002", (String)"DimensionMemberEdit_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("bizbasedatadetail".equals(action)) {
                    boolean isLeaf;
                    ArrayList<String> filed = new ArrayList<String>(10);
                    boolean levelData = this.isLevelData(formId, filed);
                    boolean bl = isLeaf = !levelData ? true : this.isLeaf(bdObj, formId, filed);
                    if (isLeaf) {
                        dynamicObject.set("bizbdrange", (Object)BizBDRangeEnum.ONLYSELF.getValue());
                    } else {
                        dynamicObject.set("bizbdrange", (Object)BizBDRangeEnum.SUBLEVEL.getValue());
                    }
                }
            }
            this.getView().updateView("entryentity");
        }
    }

    public boolean isLevelData(String form, List<String> filed) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)form);
        IDataEntityProperty parent = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)"parent");
        IDataEntityProperty parentId = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)"parentid");
        if ((parent == null || parent.getAlias().isEmpty()) && (parentId == null || parentId.getAlias().isEmpty())) {
            return false;
        }
        if (parent != null) {
            filed.add("parent");
        } else if (parentId != null) {
            filed.add("parentid");
        }
        return true;
    }

    private boolean isLeaf(DynamicObject doj, String formId, List<String> filed) {
        String value = filed.get(0);
        ArrayList<QFilter> qfBuilder = new ArrayList<QFilter>();
        if (!formId.equals("bos_org_structure") && !formId.equals("bos_adminorg_structure")) {
            qfBuilder.add(new QFilter(value, "=", (Object)doj.getLong("id")));
        } else {
            qfBuilder.add(new QFilter(value, "=", (Object)doj.getLong("org.id")));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)formId, (String)"1", (QFilter[])qfBuilder.toArray(new QFilter[0]));
        return query.size() <= 0;
    }

    protected void initDimMemberF7() {
        IDataModel model = this.getView().getModel();
        BasedataEdit dimMember = (BasedataEdit)this.getControl("dimmember");
        Object dim = model.getValue("dimension");
        Object bodySys = model.getValue("bodysysmanage");
        dimMember.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (bodySys == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u4f53\u7cfb\u3002", (String)"DimensionMemberEdit_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (dim == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u7ef4\u5ea6\u3002", (String)"DimensionMemberEdit_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long dimId = ((DynamicObject)dim).getLong("id");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("dimension", (Object)dimId);
            showParameter.setCustomParam("modelId", ((DynamicObject)bodySys).getPkValue());
            QFilter qFilter = new QFilter("bodysystem", "=", ((DynamicObject)bodySys).getPkValue()).and("dimension", "=", (Object)dimId);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    protected void initModelF7() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("bodysysmanage");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter authQFilter = ModelHelper.getAuthQFilter();
            showParameter.getListFilterParameter().setFilter(authQFilter);
        });
    }

    protected void initDimF7() {
        IDataModel model = this.getView().getModel();
        BasedataEdit dim = (BasedataEdit)this.getControl("dimension");
        dim.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object bodySys = model.getValue("bodysysmanage");
            if (bodySys == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u4f53\u7cfb\u3002", (String)"DimensionMemberEdit_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<String> hideDimList = new ArrayList<String>(8);
            hideDimList.add(DimsionEnums.PERIOD.getNumber());
            hideDimList.add(DimsionEnums.METRIC.getNumber());
            QFilter qFilter = new QFilter("bodysystem", "=", ((DynamicObject)bodySys).getPkValue());
            qFilter.and(new QFilter("basedata", "not in", hideDimList));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimension"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    protected void initBaseDataF7() {
        BasedataEdit bdBE = (BasedataEdit)this.getControl("bizbasedata");
        bdBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        });
        BasedataEdit assBdBE = (BasedataEdit)this.getControl("assistbizbasedata");
        assBdBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        });
    }

    private void clearBaseDataDetailCodeIfNeed(String propertyName, ChangeData changeData, Object newValue) {
        if (Objects.nonNull(changeData) && EmptyUtil.isEmpty((Object)newValue)) {
            this.getModel().setValue(propertyName, null, changeData.getRowIndex());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof ImportEntry) {
            Object assisBaseData;
            boolean value;
            DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysysmanage");
            if (Objects.isNull(bodySys)) {
                args.setCancel(true);
                this.showNotification("bodysysmanage");
                return;
            }
            DynamicObject baseData = (DynamicObject)this.getModel().getValue("bizbasedata");
            if (Objects.isNull(baseData)) {
                args.setCancel(true);
                this.showNotification("bizbasedata");
                return;
            }
            DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
            if (Objects.isNull(dimension)) {
                args.setCancel(true);
                this.showNotification("dimension");
            }
            if ((value = ((Boolean)this.getModel().getValue("useassistbasedata")).booleanValue()) && Objects.isNull(assisBaseData = this.getModel().getValue("assistbizbasedata"))) {
                args.setCancel(true);
                this.showNotification("assistbizbasedata");
            }
        }
    }

    public void beforeImportEntry(BeforeImportEntryEventArgs e) {
        super.beforeImportEntry(e);
        Map logMap = e.getEntryDataMap();
        ImportLogger importLogger = (ImportLogger)((List)logMap.get("entryentity")).get(0);
        Map entryDataMap = (Map)e.getSource();
        ImportManager importManager = new ImportManager(this, importLogger, (List)entryDataMap.get("entryentity"));
        importManager.checkData();
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        super.queryImportBasedata(e);
        Set<Long> dimMemberIds = this.getDimMemberIds();
        Map searchResult = e.getSearchResult();
        for (Map.Entry entry : searchResult.entrySet()) {
            BasedataItem basedataItem = (BasedataItem)entry.getKey();
            String fieldKey = basedataItem.getFieldKey();
            List objectList = (List)entry.getValue();
            if (!Objects.equals(fieldKey, "dimmember")) continue;
            objectList.removeIf(id -> !dimMemberIds.contains(id));
        }
    }

    private Set<Long> getDimMemberIds() {
        DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysysmanage");
        Object systemId = bodySys.getPkValue();
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        Object dimensionId = dimension.getPkValue();
        QFilter qFilter = new QFilter("bodysystem", "=", systemId).and(new QFilter("dimension", "=", dimensionId));
        List list = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        return list.stream().map(Long.class::cast).collect(Collectors.toSet());
    }

    private void showNotification(String field) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fpm_dimensionmember");
        DynamicProperty property = dataEntityType.getProperty(field);
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u672c\u4fe1\u606f-%1$s\u3002", (String)"DimensionMemberEdit_15", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), property.getDisplayName().getLocaleValue()));
    }

    private BitMap<String, IndexDynamicObject> getEntryDynamicObjectBitMap() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        BitMap entryBitMap = new BitMap(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            IndexDynamicObject indexDynamicObject = new IndexDynamicObject(i, dynamicObject);
            entryBitMap.addValue((Object)dynamicObject.getString("bizbasedatadetail"), (Object)indexDynamicObject);
            entryBitMap.addValue((Object)dynamicObject.getString("bizbasedatadetailcode"), (Object)indexDynamicObject);
            entryBitMap.addValue((Object)dynamicObject.getString("assistbasedatadetail"), (Object)indexDynamicObject);
            entryBitMap.addValue((Object)dynamicObject.getString("assistbasedatadetailcode"), (Object)indexDynamicObject);
            entryBitMap.addValue((Object)StringHelper.getStringValue((Object)dynamicObject.getLong("bizbasedatadetailid")), (Object)indexDynamicObject);
            entryBitMap.addValue((Object)StringHelper.getStringValue((Object)dynamicObject.getLong("assistbasedatadetailid")), (Object)indexDynamicObject);
        }
        return entryBitMap;
    }

    static class BizFieldInfo {
        private String bizCodeField;
        private String bizNameField;
        private String bizIdField;

        public BizFieldInfo(String bizCodeField, String bizNameField, String bizIdField) {
            this.bizCodeField = bizCodeField;
            this.bizNameField = bizNameField;
            this.bizIdField = bizIdField;
        }

        public String getBizCodeField() {
            return this.bizCodeField;
        }

        public void setBizCodeField(String bizCodeField) {
            this.bizCodeField = bizCodeField;
        }

        public String getBizNameField() {
            return this.bizNameField;
        }

        public void setBizNameField(String bizNameField) {
            this.bizNameField = bizNameField;
        }

        public String getBizIdField() {
            return this.bizIdField;
        }

        public void setBizIdField(String bizIdField) {
            this.bizIdField = bizIdField;
        }
    }

    static class ImportManager {
        private DimensionMemberEdit dimensionMemberEdit;
        private ImportLogger importLogger;
        private List<ImportEntryData> importEntryDataList;
        private BaseDataProvider bizBaseDataProvider;
        private BaseDataProvider bizBaseDataNameProvider;
        private BaseDataProvider secondBaseDataProvider;
        private BaseDataProvider secondBaseDataNameProvider;
        private Set<Integer> errorRows;

        public ImportManager(DimensionMemberEdit dimensionMemberEdit, ImportLogger importLogger, List<ImportEntryData> importEntryDataList) {
            this.dimensionMemberEdit = dimensionMemberEdit;
            this.importLogger = importLogger;
            this.importEntryDataList = importEntryDataList;
            this.errorRows = new HashSet<Integer>(16);
            this.init();
        }

        private void init() {
            HashSet<String> bizNumbers = new HashSet<String>(this.importEntryDataList.size());
            HashSet<String> secondsNumbers = new HashSet<String>(this.importEntryDataList.size());
            HashSet<String> bizNames = new HashSet<String>(this.importEntryDataList.size());
            HashSet<String> secondsNames = new HashSet<String>(this.importEntryDataList.size());
            for (ImportEntryData importEntryData : this.importEntryDataList) {
                JSONObject jsonObject = importEntryData.getData();
                String bizCode = jsonObject.getString("bizbasedatadetailcode");
                if (EmptyUtil.isNoEmpty((String)bizCode)) {
                    bizNumbers.add(bizCode);
                } else {
                    String bizName = jsonObject.getString("bizbasedatadetail");
                    if (EmptyUtil.isNoEmpty((String)bizName)) {
                        bizNames.add(bizName);
                    }
                }
                String secondCode = jsonObject.getString("assistbasedatadetailcode");
                if (EmptyUtil.isNoEmpty((String)secondCode)) {
                    secondsNumbers.add(secondCode);
                    continue;
                }
                String secondName = jsonObject.getString("assistbasedatadetail");
                if (!EmptyUtil.isNoEmpty((String)secondName)) continue;
                secondsNames.add(secondName);
            }
            DynamicObject baseData = (DynamicObject)this.dimensionMemberEdit.getModel().getValue("bizbasedata");
            this.bizBaseDataProvider = new BaseDataProvider((String)baseData.getPkValue(), bizNumbers, true);
            this.bizBaseDataNameProvider = new BaseDataProvider((String)baseData.getPkValue(), bizNames, "name", true);
            DynamicObject secondBaseData = (DynamicObject)this.dimensionMemberEdit.getModel().getValue("assistbizbasedata");
            if (Objects.nonNull(secondBaseData) && EmptyUtil.isNoEmpty(secondsNumbers)) {
                this.secondBaseDataProvider = new BaseDataProvider((String)secondBaseData.getPkValue(), secondsNumbers);
            }
            if (Objects.nonNull(secondBaseData) && EmptyUtil.isNoEmpty(secondsNames)) {
                this.secondBaseDataNameProvider = new BaseDataProvider((String)secondBaseData.getPkValue(), secondsNames, "name", false);
            }
        }

        public void checkData() {
            BitMap entryDynamicObjectBitMap = this.dimensionMemberEdit.getEntryDynamicObjectBitMap();
            BitMap entryDataBitMap = new BitMap(this.importEntryDataList.size());
            boolean flag = (Boolean)this.dimensionMemberEdit.getModel().getValue("useassistbasedata");
            for (int idx = 0; idx < this.importEntryDataList.size(); ++idx) {
                ImportEntryData entryData;
                Set keys;
                IndexDynamicObject one;
                ImportEntryData importEntryData2 = this.importEntryDataList.get(idx);
                JSONObject jsonObject = importEntryData2.getData();
                String bizCode = StringHelper.getStringValue((Object)jsonObject.getString("bizbasedatadetailcode"));
                String bizName = StringHelper.getStringValue((Object)jsonObject.getString("bizbasedatadetail"));
                String secondBizCode = StringHelper.getStringValue((Object)jsonObject.getString("assistbasedatadetailcode"));
                String secondBizName = StringHelper.getStringValue((Object)jsonObject.getString("assistbasedatadetail"));
                if (this.doCheckData(importEntryData2, bizCode, bizName, "bizbasedata")) {
                    if (!flag && (EmptyUtil.isNoEmpty((String)secondBizCode) || EmptyUtil.isNoEmpty((String)secondBizName))) {
                        String errorMsg = ResManager.loadKDString((String)"\u672a\u5f00\u542f\u662f\u5426\u4f7f\u7528\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u3002", (String)"DimensionMemberEdit_19", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                        this.fail(importEntryData2, errorMsg);
                        continue;
                    }
                    this.doCheckData(importEntryData2, secondBizCode, secondBizName, "assistbizbasedata");
                }
                if (this.errorRows.contains(importEntryData2.getData().getInteger("rowNum"))) continue;
                bizName = jsonObject.getString("bizbasedatadetail");
                secondBizName = jsonObject.getString("assistbasedatadetail");
                if (EmptyUtil.isEmpty((String)bizCode)) {
                    bizCode = jsonObject.getString("bizbasedatadetailcode");
                }
                if (EmptyUtil.isEmpty((String)secondBizCode)) {
                    secondBizCode = jsonObject.getString("assistbasedatadetailcode");
                }
                if ((one = (IndexDynamicObject)entryDynamicObjectBitMap.findOne(keys = ListHelper.asSet((Object[])new String[]{bizCode, bizName, secondBizCode, secondBizName}))) != null) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u4e0e\u5206\u5f55\u4e2d\u7684\u7b2c%1$s\u884c\u6570\u636e\u91cd\u590d\u3002", (String)"DimensionMemberEdit_20", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), one.index + 1);
                    this.fail(importEntryData2, errorMsg);
                    continue;
                }
                IndexDynamicObject one$ = (IndexDynamicObject)entryDynamicObjectBitMap.findOne(ListHelper.asSet((Object[])new String[]{jsonObject.getString("bizbasedatadetailid"), jsonObject.getString("assistbasedatadetailid")}));
                if (one$ != null) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u4e0e\u5206\u5f55\u4e2d\u7684\u7b2c%1$s\u884c\u6570\u636e\u91cd\u590d\u3002", (String)"DimensionMemberEdit_20", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), one$.index + 1);
                    this.fail(importEntryData2, errorMsg);
                }
                if (Objects.isNull(entryData = (ImportEntryData)entryDataBitMap.findOne(keys))) {
                    entryDataBitMap.addValue(keys, (Object)importEntryData2);
                    continue;
                }
                String errorMsg = String.format(ResManager.loadKDString((String)"\u4e0e\u5bfc\u5165\u6570\u636e\u4e2d\u7684\u7b2c%1$s\u884c\u6570\u636e\u91cd\u590d\u3002", (String)"DimensionMemberEdit_18", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), entryData.getData().getInteger("rowNum"));
                this.fail(importEntryData2, errorMsg);
            }
            this.importEntryDataList.removeIf(importEntryData -> this.errorRows.contains(importEntryData.getData().getInteger("rowNum")));
        }

        private boolean doCheckData(ImportEntryData importEntryData, String bizCode, String bizName, String bizFieldProp) {
            if (EmptyUtil.isEmpty((String)bizCode) && EmptyUtil.isEmpty((String)bizName)) {
                return true;
            }
            BaseDataProvider baseDataProvider = this.getBaseDataProvider(bizFieldProp, bizCode);
            if (baseDataProvider == null) {
                return false;
            }
            List<DynamicObject> dynamicObjectList = baseDataProvider.getDynamicObjectList(bizName, bizCode);
            if (EmptyUtil.isEmpty(dynamicObjectList)) {
                String prefix = this.getPrefix(bizFieldProp, bizCode, bizName);
                this.fail(importEntryData, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff0c\u7b26\u5408\u201c%2$s\u201d\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6\u7684\u201c%3$s\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"DimensionMemberEdit_16", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), prefix, this.getBizEntityName(bizFieldProp), this.getBizPropName(bizFieldProp)));
                return false;
            }
            if (dynamicObjectList.size() > 1) {
                String bizFieldName = this.getBizPropName(bizFieldProp);
                String prefix = this.getPrefix(bizFieldProp, bizCode, bizName);
                this.fail(importEntryData, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff0c\u7b26\u5408\u201c%2$s\u201d\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6\u7684\u201c%3$s\u201d\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230\u591a\u4e2a\u91cd\u590d\u7684\u6570\u636e\u3002", (String)"DimensionMemberEdit_17", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), prefix, this.getBizEntityName(bizFieldProp), bizFieldName));
                return false;
            }
            DynamicObject dynamicObject = dynamicObjectList.get(0);
            Long pkValue = dynamicObject.getLong("id");
            JSONObject jsonObject = importEntryData.getData();
            BizFieldInfo bizFieldInfo = this.getBizFieldInfo(bizFieldProp);
            jsonObject.put(bizFieldInfo.getBizIdField(), (Object)pkValue);
            jsonObject.put(bizFieldInfo.getBizNameField(), (Object)dynamicObject.getString("name"));
            if (EmptyUtil.isEmpty((String)bizCode)) {
                jsonObject.put(bizFieldInfo.getBizCodeField(), (Object)dynamicObject.getString("number"));
            }
            BizBDRangeEnum range = BizBDRangeEnum.ONLYSELF;
            if (baseDataProvider.hasChildIds.contains(pkValue) && baseDataProvider == this.bizBaseDataProvider) {
                range = BizBDRangeEnum.SUBLEVEL;
            }
            if (jsonObject.containsKey((Object)"bizbdrange") && baseDataProvider == this.bizBaseDataProvider) {
                jsonObject.put("bizbdrange", (Object)range.getName());
            } else {
                jsonObject.putIfAbsent((Object)"bizbdrange", (Object)range.getValue());
            }
            return true;
        }

        private String getPrefix(String bizFieldProp, String bizCode, String bizName) {
            StringBuilder prefix = new StringBuilder();
            String bizPropName = this.getBizPropName(bizFieldProp);
            prefix.append(bizPropName);
            boolean flag = false;
            if (EmptyUtil.isNoEmpty((String)bizCode)) {
                prefix.append(".").append(this.getBizPropName("number")).append("=").append("\u3010").append(bizCode).append("\u3011");
                flag = true;
            }
            if (EmptyUtil.isNoEmpty((String)bizName)) {
                if (flag) {
                    prefix.append(" && ").append(bizPropName);
                }
                prefix.append(".").append(this.getBizPropName("name")).append("=").append("\u3010").append(bizName).append("\u3011");
            }
            return prefix.toString();
        }

        private void fail(ImportEntryData importEntryData, String errorMsg) {
            int rowIndex = importEntryData.getData().getInteger("rowNum");
            this.importLogger.log(Integer.valueOf(rowIndex), errorMsg);
            this.importLogger.fail();
            this.importLogger.setTotal(this.importLogger.getTotal() + 1);
            this.errorRows.add(rowIndex);
        }

        private BaseDataProvider getBaseDataProvider(String bizFieldProp, String bizCode) {
            if (Objects.equals(bizFieldProp, "bizbasedata")) {
                return EmptyUtil.isEmpty((String)bizCode) ? this.bizBaseDataNameProvider : this.bizBaseDataProvider;
            }
            return EmptyUtil.isEmpty((String)bizCode) ? this.secondBaseDataNameProvider : this.secondBaseDataProvider;
        }

        private String getBizPropName(String bizFieldProp) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fpm_dimensionmember");
            return dataEntityType.getProperty(bizFieldProp).getDisplayName().getLocaleValue();
        }

        private String getBizEntityName(String bizFieldProp) {
            DynamicObject value = (DynamicObject)this.dimensionMemberEdit.getModel().getValue(bizFieldProp);
            return EntityMetadataCache.getDataEntityType((String)((String)value.getPkValue())).getDisplayName().getLocaleValue();
        }

        private BizFieldInfo getBizFieldInfo(String bizFieldProp) {
            if (Objects.equals(bizFieldProp, "bizbasedata")) {
                return new BizFieldInfo("bizbasedatadetailcode", "bizbasedatadetail", "bizbasedatadetailid");
            }
            return new BizFieldInfo("assistbasedatadetailcode", "assistbasedatadetail", "assistbasedatadetailid");
        }
    }

    static class BaseDataProvider {
        private String entityType;
        private BitMap<String, DynamicObject> bitMap;
        private Set<String> numbers;
        private boolean queryParent;
        private Set<Long> hasChildIds;
        private String conditionProp;

        public BaseDataProvider(String entityType, Set<String> numbers) {
            this(entityType, numbers, "number", false);
        }

        public BaseDataProvider(String entityType, Set<String> numbers, boolean queryParent) {
            this(entityType, numbers, "number", queryParent);
        }

        public BaseDataProvider(String entityType, Set<String> numbers, String conditionProp, boolean queryParent) {
            this.entityType = entityType;
            this.numbers = numbers;
            this.queryParent = queryParent;
            this.bitMap = new BitMap(numbers.size());
            this.hasChildIds = new HashSet<Long>(16);
            this.conditionProp = conditionProp;
            this.init();
        }

        private void init() {
            if (EmptyUtil.isEmpty(this.numbers)) {
                return;
            }
            String selectFields = String.join((CharSequence)",", "name", "id", "number");
            String parentProp = "";
            if (this.queryParent) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityType);
                IDataEntityProperty parent = (IDataEntityProperty)dataEntityType.getProperties().get((Object)"parent");
                IDataEntityProperty parentId = (IDataEntityProperty)dataEntityType.getProperties().get((Object)"parentid");
                if (Objects.nonNull(parent) && EmptyUtil.isNoEmpty((String)parent.getAlias())) {
                    parentProp = parent.getName();
                } else if (Objects.nonNull(parentId) && EmptyUtil.isNoEmpty((String)parentId.getAlias())) {
                    parentProp = parentId.getName();
                }
            }
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)this.entityType, (String)selectFields, (QFilter[])new QFilter[]{new QFilter(this.conditionProp, "in", this.numbers)});
            HashSet<Long> needQueryParentId = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                this.bitMap.addValue((Object)dynamicObject.getString("name"), (Object)dynamicObject);
                this.bitMap.addValue((Object)dynamicObject.getString("number"), (Object)dynamicObject);
                if (!EmptyUtil.isNoEmpty((String)parentProp)) continue;
                needQueryParentId.add(dynamicObject.getLong("id"));
            }
            if (EmptyUtil.isEmpty(needQueryParentId)) {
                return;
            }
            String parentProp$ = parentProp;
            String parentSelectFields = String.join((CharSequence)",", parentProp, "id");
            DynamicObjectCollection query = QueryServiceHelper.query((String)this.entityType, (String)parentSelectFields, (QFilter[])new QFilter[]{new QFilter(parentProp, "in", needQueryParentId)});
            query.stream().map(dy -> dy.getLong(parentProp$)).forEach(this.hasChildIds::add);
        }

        public List<DynamicObject> getDynamicObjectList(String name, String number) {
            return this.bitMap.findList(new HashSet(ListHelper.asList((Object[])new String[]{name, number})));
        }
    }

    static class IndexDynamicObject {
        private int index;
        private DynamicObject dynamicObject;

        public IndexDynamicObject(int index, DynamicObject dynamicObject) {
            this.index = index;
            this.dynamicObject = dynamicObject;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public DynamicObject getDynamicObject() {
            return this.dynamicObject;
        }

        public void setDynamicObject(DynamicObject dynamicObject) {
            this.dynamicObject = dynamicObject;
        }
    }
}

