/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.enums.DetailDimTypeEnum;
import kd.tmc.fpm.common.enums.MatchRuleBusinessBillEnum;
import kd.tmc.fpm.common.enums.MatchRuleFetchPurposeEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.property.ExecuteTimeProp;

public class ExecuteTimeEdit
extends AbstractBasePlugIn {
    private static final String FIELD_SEPARATOR = ",";
    private static final String ID = "id";
    private static final Set<String> OPERATOR_PROP = Collections.unmodifiableSet(new HashSet<String>(8){
        {
            this.add("key");
            this.add("name");
            this.add("type");
        }
    });
    private static final String PAYMENT_ORDER_OPERATOR_CONFIRM_PAY = "pay";
    private static final String PAYMENT_ORDER_OPERATOR_BACK_PAY = "refundsave";
    private static final String PAYMENT_ORDER_OPERATOR_CANCEL_BACK_PAY = "";
    private static final String PAYMENT_ORDER_OPERATOR_CANCEL_PAY = "cancelpay";
    private static final String GENERATION_ORDER_OPERATOR_CONFIRM_PAY = "pay";
    private static final String GENERATION_ORDER_OPERATOR_BACK_PAY = "";
    private static final String GENERATION_ORDER_OPERATOR_CANCEL_BACK_PAY = "";
    private static final String GENERATION_ORDER_OPERATOR_CANCEL_PAY = "cancelpay";
    private static final String COLLECTION_ORDER_OPERATOR_COLLECTION_CONFIRM = "receivingrec";
    private static final String COLLECTION_ORDER_OPERATOR_CANCEL_BACK_PAY = "cancelrefund";
    private static final String COLLECTION_ORDER_OPERATOR_CHANGE_CONFIRM = "recinfochg";
    private static final String COLLECTION_ORDER_OPERATOR_CANCEL_COLLECTION = "cancelrec";
    private static final String COLLECTION_ORDER_OPERATOR_CONFIRM_BACK_TICKET = "refund";
    private static final String COLLECTION_ORDER_OPERATOR_BACK_PAY = "returnmoney";
    private static final String COLLECTION_ORDER_OPERATOR_ORGS_DIVIDE = "orgsdivide";
    private static final String COLLECTION_ORDER_OPERATOR_SUPPLE_CONTRACT = "supplecontract";
    private static final Map<MatchRuleBusinessBillEnum, Map<String, Set<String>>> BILL_ACTUAL_DEFAULT_OPERATOR = Collections.unmodifiableMap(new HashMap<MatchRuleBusinessBillEnum, Map<String, Set<String>>>(8){
        {
            this.put(MatchRuleBusinessBillEnum.PAYMENT_ORDER, new HashMap<String, Set<String>>(4){
                {
                    super(x0);
                    this.put("entry_acldeductioncode", new HashSet<String>(8){
                        {
                            super(x0);
                            this.add("pay");
                            this.add("");
                        }
                    });
                    this.put("entry_unacldeductioncode", new HashSet<String>(2){
                        {
                            super(x0);
                            this.add("cancelpay");
                        }
                    });
                    this.put("entry_releaseacltimecode", new HashSet<String>(2){});
                }
            });
            this.put(MatchRuleBusinessBillEnum.GENERATION_ORDER, new HashMap<String, Set<String>>(4){
                {
                    super(x0);
                    this.put("entry_acldeductioncode", new HashSet<String>(8){
                        {
                            super(x0);
                            this.add("pay");
                        }
                    });
                    this.put("entry_unacldeductioncode", new HashSet<String>(2){
                        {
                            super(x0);
                            this.add("cancelpay");
                        }
                    });
                    this.put("entry_releaseacltimecode", new HashSet<String>(2){});
                }
            });
            this.put(MatchRuleBusinessBillEnum.COLLECTION_ORDER, new HashMap<String, Set<String>>(4){
                {
                    super(x0);
                    this.put("entry_acldeductioncode", new HashSet<String>(8){
                        {
                            super(x0);
                            this.add(ExecuteTimeEdit.COLLECTION_ORDER_OPERATOR_COLLECTION_CONFIRM);
                        }
                    });
                    this.put("entry_unacldeductioncode", new HashSet<String>(8){
                        {
                            super(x0);
                            this.add(ExecuteTimeEdit.COLLECTION_ORDER_OPERATOR_CANCEL_COLLECTION);
                        }
                    });
                    this.put("entry_releaseacltimecode", new HashSet<String>(2){});
                }
            });
        }
    });

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"entry_preemptedtime", "entry_unpreempted", "entry_release", "entry_acldeduction", "entry_unacldeduction", "entry_releaseacltime", "entry_factbackamountname", "entry_aclupdatetime", "entry_aclupdateamtname"});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1"});
        this.initF7Model();
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        boolean flag = this.checkBusinessField(key);
        switch (key) {
            case "entry_unpreempted": 
            case "entry_release": {
                if (!flag) break;
                flag = this.checkPreemptedTime();
                break;
            }
            case "entry_unacldeduction": 
            case "entry_releaseacltime": 
            case "entry_aclupdatetime": {
                if (!flag) break;
                flag = this.checkAclDeductionTime() && this.checkUpdateReleaseTimeOnlyOne(key);
                break;
            }
            case "entry_factbackamountname": {
                if (!flag) break;
                flag = this.checkActualReleaseTime();
                break;
            }
            case "entry_aclupdateamtname": {
                if (!flag) break;
                flag = this.checkActualUpdateTime();
                break;
            }
        }
        if (!flag) {
            evt.setCancel(true);
            return;
        }
        this.showOperatorForm(key);
    }

    private boolean checkUpdateReleaseTimeOnlyOne(String key) {
        DynamicObject currentDynamicObject = this.getCurrentDynamicObject("entryentity_actual");
        DynamicObject dynamicObject = currentDynamicObject.getDynamicObject("entry_aclbusinessbill");
        switch (key) {
            case "entry_releaseacltime": {
                if (!EmptyUtil.isNoEmpty((String)currentDynamicObject.getString("entry_aclupdatetimecode"))) break;
                String businessBillName = Objects.isNull(dynamicObject) ? "" : dynamicObject.getString("name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%1$s\u3011\u5df2\u914d\u7f6e\u5b9e\u5360\u66f4\u65b0\u65f6\u673a\u64cd\u4f5c\u65f6\u673a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ExecuteTimeEdit_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), businessBillName));
                return false;
            }
            case "entry_aclupdatetime": {
                if (!EmptyUtil.isNoEmpty((String)currentDynamicObject.getString("entry_releaseacltime"))) break;
                String businessBillName = Objects.isNull(dynamicObject) ? "" : dynamicObject.getString("name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%1$s\u3011\u5df2\u914d\u7f6e\u5b9e\u5360\u8fd4\u8fd8\uff08\u91ca\u653e\uff09\u64cd\u4f5c\u65f6\u673a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ExecuteTimeEdit_13", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), businessBillName));
                return false;
            }
        }
        return true;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_del": {
                this.showConfirmForDelete(evt);
                break;
            }
            case "btn_delacl": {
                this.checkIfCanDelete(evt);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "btn_del": {
                this.confirmOrCancle(result);
                break;
            }
            case "btn_delacl": {
                if (MessageBoxResult.No.equals((Object)result)) {
                    return;
                }
                this.getView().invokeOperation("deleteentryrow");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String entryEntity = "";
        switch (actionId) {
            case "entry_preemptedtime": 
            case "entry_unpreempted": 
            case "entry_release": {
                entryEntity = "entryentity";
                break;
            }
            case "entry_acldeduction": 
            case "entry_unacldeduction": 
            case "entry_releaseacltime": 
            case "entry_factbackamountname": 
            case "entry_aclupdatetime": 
            case "entry_aclupdateamtname": {
                entryEntity = "entryentity_actual";
                break;
            }
        }
        if (EmptyUtil.isEmpty((String)entryEntity)) {
            return;
        }
        Object returnData = closedCallBackEvent.getReturnData();
        this.setValueAndCode(actionId, entryEntity, returnData);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "bodysys": {
                this.resetData();
                break;
            }
            case "entry_businessbill": {
                this.cleanOperator(name);
                break;
            }
            case "entry_actualbusinessbill": {
                this.addOrUpdateAclEntryEntityIfNeed(e);
                break;
            }
            case "entry_aclbusinessbill": {
                this.setDefaultOperatorIfNeed(e);
                break;
            }
            case "entry_preemptedtime": 
            case "entry_unpreempted": 
            case "entry_release": 
            case "entry_acldeduction": 
            case "entry_unacldeduction": 
            case "entry_releaseacltime": 
            case "entry_factbackamountname": 
            case "entry_aclupdatetime": 
            case "entry_aclupdateamtname": {
                this.cleanCodeIfEmpty(e);
                this.setDefaultValueForUpdateAmtFieldIfNeed(e);
                break;
            }
            case "autorelease": {
                this.setTimeLimitRequiredIfNeed(e);
                break;
            }
        }
    }

    private void setDefaultValueForUpdateAmtFieldIfNeed(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (!Objects.equals("entry_aclupdatetime", name)) {
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        if (EmptyUtil.isEmpty((Object)oldValue) && EmptyUtil.isNoEmpty((Object)newValue)) {
            DynamicObject currentDynamicObject = this.getCurrentDynamicObject("entryentity_actual");
            DynamicObject businessBill = currentDynamicObject.getDynamicObject("entry_aclbusinessbill");
            if (EmptyUtil.isEmpty((DynamicObject)businessBill)) {
                return;
            }
            DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
            QFilter qFilter = new QFilter("bodysys", "=", bodySys.getPkValue()).and(new QFilter("detaildimtype", "=", (Object)DetailDimTypeEnum.PLAN_AMOUNT.getValue()));
            List list = QueryServiceHelper.queryPrimaryKeys((String)"fpm_detailplanfields", (QFilter[])new QFilter[]{qFilter}, null, (int)1);
            if (EmptyUtil.isEmpty((Collection)list)) {
                return;
            }
            String entryBusinessBillProp = String.join((CharSequence)".", "entryentity", "entry_businessbillfield");
            String entityName = StringHelper.getStringValue((Object)businessBill.getPkValue());
            QFilter qFilter_ = new QFilter("bodysys", "=", bodySys.getPkValue()).and(new QFilter("businessbill", "=", (Object)entityName)).and(new QFilter(String.join((CharSequence)".", "entryentity", "entry_dimensiondetail"), "=", list.get(0))).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter(String.join((CharSequence)".", "entryentity", "entry_dimensiontype"), "=", (Object)"fpm_detailplanfields"));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fpm_matchrule", (String)String.join((CharSequence)FIELD_SEPARATOR, entryBusinessBillProp, "linkentity"), (QFilter[])new QFilter[]{qFilter_});
            if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
                return;
            }
            String planAmountFiled = dynamicObject.getString(entryBusinessBillProp);
            if (EmptyUtil.isEmpty((String)planAmountFiled)) {
                return;
            }
            String linkEntry = dynamicObject.getString("linkentity");
            String propertyName = planAmountFiled;
            String entryPrefix = "";
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicProperty property = dataEntityType.getProperty(propertyName);
            if (!Objects.equals(linkEntry, entityName)) {
                propertyName = planAmountFiled.replace(linkEntry + ".", "");
                EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(linkEntry);
                entryPrefix = entityType.getDisplayName().getLocaleValue() + ".";
                property = (IDataEntityProperty)entityType.getProperties().get((Object)propertyName);
            }
            if (Objects.isNull(property)) {
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity_actual");
            this.getModel().setValue("entry_aclupdateamtfield", (Object)planAmountFiled, entryCurrentRowIndex);
            this.getModel().setValue("entry_aclupdateamtname", (Object)(entryPrefix + property.getDisplayName().getLocaleValue()), entryCurrentRowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void cleanOperator(String name) {
        String entityName = (String)ExecuteTimeProp.BUSINESS_BILL_ENTRY_ENTITY_MAP.get(name);
        if (EmptyUtil.isEmpty((String)entityName)) {
            return;
        }
        Set propCodeSet = (Set)ExecuteTimeProp.ENTRY_ENTTIY_BUSINESS_BILL_OPERATION_CODE_MAP.get(entityName);
        if (EmptyUtil.isEmpty((Collection)propCodeSet)) {
            return;
        }
        IDataModel model = this.getModel();
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex(entityName);
        Map<String, String> valueFieldMapToName = ExecuteTimeProp.OPERATOR_NAME_KEY_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        for (String codeProp : propCodeSet) {
            model.setValue(valueFieldMapToName.get(codeProp), (Object)"", entryCurrentRowIndex);
        }
        model.setValue("entry_actualbusinessbill", null, entryCurrentRowIndex);
    }

    private void cleanCodeIfEmpty(PropertyChangedArgs e) {
        ChangeData changeData;
        String newValue;
        ChangeData[] changeSet = e.getChangeSet();
        if (Objects.nonNull(changeSet) && changeSet.length > 0 && EmptyUtil.isEmpty((String)(newValue = (String)(changeData = changeSet[0]).getNewValue()))) {
            String name = e.getProperty().getName();
            String codeProp = (String)ExecuteTimeProp.OPERATOR_NAME_KEY_MAP.get(name);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex((String)ExecuteTimeProp.OPERATOR_FIELD_TO_ENTRY_ENTITY_MAP.get(name));
            this.getModel().setValue(codeProp, (Object)"", entryCurrentRowIndex);
            String amountFieldProp = (String)ExecuteTimeProp.OPERATOR_NAME_AMOUNT_FIELD_MAP.get(name);
            if (EmptyUtil.isNoEmpty((String)amountFieldProp)) {
                this.getModel().setValue(amountFieldProp, (Object)"", entryCurrentRowIndex);
            }
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String modelId = parentView.getPageCache().get("MATCH_RULE_BODY_SYS_ID_KEY");
            if (Objects.isNull(modelId)) {
                return;
            }
            if (modelId.indexOf("[") != -1) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(FIELD_SEPARATOR);
                modelId = modelIdArr[0].trim();
            }
            QFilter qFilter = new QFilter("bodysys", "=", (Object)Long.parseLong(modelId));
            List idList = QueryServiceHelper.queryPrimaryKeys((String)"fpm_executetime", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
            if (idList.size() == 1) {
                Object pkValue = idList.get(0);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(pkValue, (String)"fpm_executetime");
                if (dynamicObject.getInt("timelimit") < 30) {
                    dynamicObject.set("timelimit", (Object)30);
                }
                e.setDataEntity((Object)dynamicObject);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String modelId = parentView.getPageCache().get("MATCH_RULE_BODY_SYS_ID_KEY");
            if (Objects.isNull(modelId)) {
                return;
            }
            if (modelId.indexOf("[") != -1) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(FIELD_SEPARATOR);
                modelId = modelIdArr[0].trim();
            }
            this.getModel().setValue("bodysys", (Object)modelId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject value = (DynamicObject)this.getModel().getValue("bodysys");
        if (Objects.isNull(value)) {
            this.resetData();
            return;
        }
        QFilter qFilter = new QFilter("bodysys", "=", value.getPkValue());
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_executetime", (QFilter[])new QFilter[]{qFilter}, (String)"modifytime", (int)-1);
        if (EmptyUtil.isEmpty((Collection)ids)) {
            this.resetData();
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity_actual");
            boolean flag = false;
            for (DynamicObject dynamicObject : entryEntity) {
                String factBackAmountName;
                String factBackAmountField = dynamicObject.getString("entry_factbackamountfield");
                if (StringUtils.isEmpty((CharSequence)factBackAmountField) || EmptyUtil.isNoEmpty((String)(factBackAmountName = dynamicObject.getString("entry_factbackamountname")))) continue;
                DynamicObject businessBill = dynamicObject.getDynamicObject("entry_aclbusinessbill");
                String billPkValue = (String)businessBill.getPkValue();
                String factBackAmountNameIfEmpty = this.getFactBackAmountNameIfEmpty(billPkValue, factBackAmountField);
                dynamicObject.set("entry_factbackamountname", (Object)factBackAmountNameIfEmpty);
                flag = true;
            }
            if (flag) {
                this.getView().updateView("entryentity_actual");
            }
        }
        this.permissionContr();
    }

    private String getFactBackAmountNameIfEmpty(String businessBillNumber, String factBackAmountField) {
        String entryNumber;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)businessBillNumber);
        int index = factBackAmountField.indexOf(".");
        String string = entryNumber = index == -1 ? "" : factBackAmountField.substring(0, index);
        if (index != -1) {
            factBackAmountField = factBackAmountField.substring(index + 1);
        }
        Map allEntities = dataEntityType.getAllEntities();
        Map fieldColumn = ExpressionFromHelper.getFieldColumn((String)dataEntityType.getName(), (boolean)false, (boolean)true, (String[])new String[0]);
        LocaleString localeString = (LocaleString)fieldColumn.get(factBackAmountField);
        if (Objects.isNull(localeString)) {
            return "";
        }
        if (EmptyUtil.isEmpty((String)entryNumber)) {
            return localeString.getLocaleValue();
        }
        EntityType entityType = (EntityType)allEntities.get(entryNumber);
        if (EmptyUtil.isEmpty((Object)entityType)) {
            return localeString.getLocaleValue();
        }
        return this.getFullDisplayName(localeString, entityType.getDisplayName(), new StringBuilder()).getLocaleValue();
    }

    private LocaleString getFullDisplayName(LocaleString simpleDisplayName, LocaleString entryDisplayName, StringBuilder sb) {
        sb.delete(0, sb.length());
        LocaleString displayName = LocaleString.fromMap((Map)simpleDisplayName);
        for (Map.Entry localStringEntry : entryDisplayName.entrySet()) {
            String languageType = (String)localStringEntry.getKey();
            String displayNameSimple = (String)displayName.get((Object)languageType);
            displayNameSimple = Objects.isNull(displayNameSimple) ? "" : displayNameSimple;
            displayName.put(languageType, (Object)sb.append((String)localStringEntry.getValue()).append(".").append(displayNameSimple).toString());
            sb.delete(0, sb.length());
        }
        return displayName;
    }

    private String getOrDetermineEntry(DynamicObjectCollection queryResult) {
        DynamicObject dynamicObject = (DynamicObject)queryResult.get(0);
        String entryName = dynamicObject.getString("linkentity");
        if (StringUtils.isNotBlank((CharSequence)entryName)) {
            return entryName;
        }
        if (CollectionUtils.isEmpty((Collection)queryResult)) {
            return entryName;
        }
        String businessBillField = dynamicObject.getString("entryentity.entry_businessbillfield");
        int index = businessBillField.indexOf(".");
        if (index != -1) {
            return businessBillField.substring(0, index);
        }
        return entryName;
    }

    private void setDefaultOperatorIfNeed(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (Objects.isNull(newValue)) {
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity_actual");
            DynamicObject currentDynamicObject = this.getCurrentDynamicObject("entryentity_actual");
            DynamicObject dynamicObject = currentDynamicObject.getDynamicObject("entry_aclbusinessbill");
            if (Objects.isNull(dynamicObject)) {
                return;
            }
            if (dynamicObject.getPkValue().equals(newValue.getPkValue())) {
                this.setDefaultOperatorIfNeed(newValue, entryCurrentRowIndex);
            }
        }
    }

    private void checkIfCanDelete(BeforeItemClickEvent args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_actual");
        int[] selectRows = entryGrid.getSelectRows();
        if (Objects.isNull(selectRows) || selectRows.length == 0) {
            return;
        }
        DynamicObject currentDynamicObject = this.getCurrentDynamicObject("entryentity_actual");
        DynamicObjectCollection dynamicObjectCollection = currentDynamicObject.getDynamicObjectCollection("entry_preemptedbill");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            DynamicObject dynamicObject = currentDynamicObject.getDynamicObject("entry_aclbusinessbill");
            String detailMessage = ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u4e1a\u52a1\u5355\u636e\u201c%s\u201d\u7684\u5b9e\u5360\u65f6\u673a\u8bbe\u7f6e\u8bb0\u5f55\u3002\u8bf7\u5148\u5728\u9884\u5360\u65f6\u673a\u914d\u7f6e\u4e2d\u79fb\u9664\u5b9e\u5360\u4fe1\u606f\u7684\u5173\u8054\u3002", (String)"ExecuteTimeEdit_7", (String)"tmc-fpm-formplugin", (Object[])new Object[]{Objects.isNull(dynamicObject) ? "" : dynamicObject.getString("name")});
            this.getView().showErrorNotification(detailMessage);
            args.setCancel(true);
            return;
        }
        DynamicObject dynamicObject = currentDynamicObject.getDynamicObject("entry_aclbusinessbill");
        if (Objects.isNull(dynamicObject)) {
            return;
        }
        DynamicObject bodySysDy = (DynamicObject)this.getModel().getValue("bodysys");
        Object bodySys = bodySysDy.getPkValue();
        QFilter qFilter = new QFilter("bodysys", "=", bodySys).and("billbizetype", "=", (Object)dynamicObject.getString("number")).and("planexecuteop", "=", (Object)PlanExecuteOpType.WRITE.getValue()).and("deleteflag", "=", (Object)"0");
        boolean exists = TmcDataServiceHelper.exists((String)"fpm_executeplan", (QFilter[])new QFilter[]{qFilter});
        if (!exists) {
            return;
        }
        String detailMessage = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%1$s\u3011\u5728\u4f53\u7cfb\u4e0b\u5b58\u5728\u5b9e\u5360\u6267\u884c\u8bb0\u5f55\uff0c\u82e5\u5220\u9664\u914d\u7f6e\u4fe1\u606f\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u5b58\u7eed\u4e1a\u52a1\u5355\u636e\u9006\u5411\u6216\u8fd4\u8fd8\u64cd\u4f5c\u6240\u5173\u8054\u7684\u5b9e\u9645\u6570\u989d\u5ea6\u8fd4\u8fd8\u4e0d\u51c6\u786e\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u662f\u5426\u5220\u9664\u3002", (String)"ExecuteTimeEdit_8", (String)"tmc-fpm-formplugin", (Object[])new Object[]{dynamicObject.getString("name")});
        this.getView().showConfirm("", detailMessage, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("btn_delacl", (IFormPlugin)this));
        args.setCancel(true);
    }

    private void confirmOrCancle(MessageBoxResult result) {
        if (MessageBoxResult.No.equals((Object)result)) {
            return;
        }
        DynamicObject currentDynamicObject = this.getCurrentDynamicObject("entryentity");
        MulBasedataDynamicObjectCollection dynamicObjectCollection = (MulBasedataDynamicObjectCollection)currentDynamicObject.getDynamicObjectCollection("entry_actualbusinessbill");
        this.updateAclEntryEntityIfNeedForOldValue(dynamicObjectCollection);
        this.getView().invokeOperation("deleteentry");
    }

    private void showConfirmForDelete(BeforeItemClickEvent args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (Objects.isNull(selectRows) || selectRows.length == 0) {
            return;
        }
        DynamicObject currentDynamicObject = this.getCurrentDynamicObject("entryentity");
        DynamicObject dynamicObject = currentDynamicObject.getDynamicObject("entry_businessbill");
        if (Objects.isNull(dynamicObject)) {
            return;
        }
        DynamicObject bodySysDy = (DynamicObject)this.getModel().getValue("bodysys");
        Object bodySys = bodySysDy.getPkValue();
        QFilter qFilter = new QFilter("bodysys", "=", bodySys).and("billbizetype", "=", (Object)dynamicObject.getString("number")).and("planexecuteop", "=", (Object)PlanExecuteOpType.PRE_OCCUPY_WRITE.getValue()).and("deleteflag", "=", (Object)"0");
        boolean exists = QueryServiceHelper.exists((String)"fpm_executeplan", (QFilter[])new QFilter[]{qFilter});
        String billName = dynamicObject.getString("name");
        String detailMessage = ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u9700\u8981\u5220\u9664\u4e1a\u52a1\u5355\u636e\u201c%s\u201d\u7684\u9884\u5360\u65f6\u673a\u8bbe\u7f6e\u8bb0\u5f55\u4fe1\u606f\u3002", (String)"ExecuteTimeEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[]{billName});
        if (exists) {
            detailMessage = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%1$s\u3011\u5728\u4f53\u7cfb\u4e0b\u5b58\u5728\u9884\u5360\u6267\u884c\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u8be5\u5355\u636e\u5173\u8054\u7684\u6240\u6709\u9884\u5360\u8bb0\u5f55\u5df2\u88ab\u91ca\u653e\u540e\u518d\u6267\u884c\u5220\u884c\u64cd\u4f5c\uff0c\u907f\u514d\u51fa\u73b0\u9884\u5360\u6570\u636e\u4e0d\u51c6\u786e\u3002", (String)"ExecuteTimeEdit_9", (String)"tmc-fpm-formplugin", (Object[])new Object[]{billName});
        }
        this.getView().showConfirm("", detailMessage, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("btn_del", (IFormPlugin)this));
        args.setCancel(true);
    }

    private boolean checkActualReleaseTime() {
        int entryCurrentRowIndex;
        IDataModel model = this.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity_actual", entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity_actual"));
        String aclReleaseCode = entryRowEntity.getString("entry_releaseacltimecode");
        if (EmptyUtil.isEmpty((String)aclReleaseCode)) {
            DynamicObject dynamicObject = entryRowEntity.getDynamicObject("entry_aclbusinessbill");
            String businessBillName = Objects.isNull(dynamicObject) ? "" : dynamicObject.getString("name");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u4e1a\u52a1\u5355\u636e\u3010%s\u3011\u7684\u5b9e\u5360\u8fd4\u8fd8\uff08\u91ca\u653e\uff09\u65f6\u673a", (String)"ExecuteTimeEdit_10", (String)"tmc-fpm-formplugin", (Object[])new Object[]{businessBillName}));
            return false;
        }
        return true;
    }

    private boolean checkActualUpdateTime() {
        int entryCurrentRowIndex;
        IDataModel model = this.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity_actual", entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity_actual"));
        String aclUpdateCode = entryRowEntity.getString("entry_aclupdatetimecode");
        if (EmptyUtil.isEmpty((String)aclUpdateCode)) {
            DynamicObject dynamicObject = entryRowEntity.getDynamicObject("entry_aclbusinessbill");
            String businessBillName = Objects.isNull(dynamicObject) ? "" : dynamicObject.getString("name");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u4e1a\u52a1\u5355\u636e\u3010%1$s\u3011\u7684\u5b9e\u5360\u66f4\u65b0\u65f6\u673a", (String)"ExecuteTimeEdit_14", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), businessBillName));
            return false;
        }
        return true;
    }

    private boolean checkAclDeductionTime() {
        int entryCurrentRowIndex;
        IDataModel model = this.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity_actual", entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity_actual"));
        String aclDeductionCode = entryRowEntity.getString("entry_acldeductioncode");
        if (EmptyUtil.isEmpty((String)aclDeductionCode)) {
            DynamicObject dynamicObject = entryRowEntity.getDynamicObject("entry_aclbusinessbill");
            String businessBillName = Objects.isNull(dynamicObject) ? "" : dynamicObject.getString("name");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u4e1a\u52a1\u5355\u636e\u201c%s\u201d\u7684\u5b9e\u5360\u64cd\u4f5c\u65f6\u673a\u3002", (String)"ExecuteTimeEdit_3", (String)"tmc-fpm-formplugin", (Object[])new Object[]{businessBillName}));
            return false;
        }
        return true;
    }

    private boolean checkPreemptedTime() {
        int entryCurrentRowIndex;
        IDataModel model = this.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity"));
        String preemptedTimeCode = entryRowEntity.getString("entry_preemptedtimecode");
        if (EmptyUtil.isEmpty((String)preemptedTimeCode)) {
            DynamicObject dynamicObject = entryRowEntity.getDynamicObject("entry_businessbill");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e1a\u52a1\u5355\u636e\u201c%s\u201d\u7684\u9884\u5360\u8bb0\u5f55\u64cd\u4f5c\u65f6\u673a\u3002", (String)"ExecuteTimeEdit_4", (String)"tmc-fpm-formplugin", (Object[])new Object[]{dynamicObject.getString("name")}));
            return false;
        }
        return true;
    }

    private void resetData() {
        this.getModel().deleteEntryData("entryentity_actual");
        this.getModel().deleteEntryData("entryentity");
    }

    private void addOrUpdateAclEntryEntityIfNeed(PropertyChangedArgs propertyChangedArgs) {
        ChangeData[] changeSet = propertyChangedArgs.getChangeSet();
        MulBasedataDynamicObjectCollection newValue = new MulBasedataDynamicObjectCollection();
        MulBasedataDynamicObjectCollection oldValue = new MulBasedataDynamicObjectCollection();
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            newValue = (MulBasedataDynamicObjectCollection)changeData.getNewValue();
            oldValue = (MulBasedataDynamicObjectCollection)changeData.getOldValue();
        }
        this.updateAclEntryEntityIfNeedForOldValue(oldValue);
        this.addOrUpdateAclEntryEntityIfNeedForNewValue(newValue);
    }

    private void updateAclEntryEntityIfNeedForOldValue(MulBasedataDynamicObjectCollection oldValue) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)oldValue)) {
            return;
        }
        Map<Object, Set<Object>> entryBusinessBillSetByOldValue = this.getEntryBusinessBillSetByOldValue(oldValue);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntityActual = model.getEntryEntity("entryentity_actual");
        block0: for (int i = 0; i < entryEntityActual.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntityActual.get(i);
            for (Map.Entry<Object, Set<Object>> entry : entryBusinessBillSetByOldValue.entrySet()) {
                Object aclBusinessBillId = entry.getKey();
                Set<Object> preemptedBusinessBillSet = entry.getValue();
                DynamicObject aclBusinessBill = dynamicObject.getDynamicObject("entry_aclbusinessbill");
                if (Objects.isNull(aclBusinessBill)) continue block0;
                Object pkValue = aclBusinessBill.getPkValue();
                if (Objects.isNull(pkValue) || !aclBusinessBillId.equals(pkValue)) continue;
                this.getModel().setValue("entry_preemptedbill", (Object)preemptedBusinessBillSet.toArray(), i);
            }
        }
    }

    private Map<Object, Set<Object>> getEntryBusinessBillSetByOldValue(MulBasedataDynamicObjectCollection oldValue) {
        Set currentOldActualBillSet = oldValue.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        IDataModel model = this.getModel();
        DynamicObject currentDynamicObject = this.getCurrentDynamicObject("entryentity");
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        HashMap<Object, Set<Object>> resultMap = new HashMap<Object, Set<Object>>(currentOldActualBillSet.size());
        for (DynamicObject dynamicObject2 : entryEntity) {
            Set actualBusinessBillIdSet;
            DynamicObjectCollection dynamicObjectCollection;
            Object entryBusinessBillPkValue;
            DynamicObject entryBusinessBill = dynamicObject2.getDynamicObject("entry_businessbill");
            if (Objects.isNull(entryBusinessBill) || Objects.isNull(entryBusinessBillPkValue = entryBusinessBill.getPkValue()) || EmptyUtil.isEmpty((DynamicObjectCollection)(dynamicObjectCollection = dynamicObject2.getDynamicObjectCollection("entry_actualbusinessbill"))) || EmptyUtil.isEmpty(actualBusinessBillIdSet = dynamicObjectCollection.stream().map(dObject -> dObject.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toSet()))) continue;
            for (Object currentOldActualBillId : currentOldActualBillSet) {
                HashSet<Object> preemptedBusinessBillSet = (HashSet<Object>)resultMap.get(currentOldActualBillId);
                if (Objects.isNull(preemptedBusinessBillSet)) {
                    preemptedBusinessBillSet = new HashSet<Object>(8);
                    resultMap.put(currentOldActualBillId, preemptedBusinessBillSet);
                }
                if (dynamicObject2 == currentDynamicObject || !actualBusinessBillIdSet.contains(currentOldActualBillId)) continue;
                preemptedBusinessBillSet.add(entryBusinessBillPkValue);
            }
        }
        for (Object currentOldActualBillId : currentOldActualBillSet) {
            resultMap.putIfAbsent(currentOldActualBillId, Collections.emptySet());
        }
        return resultMap;
    }

    private void addOrUpdateAclEntryEntityIfNeedForNewValue(MulBasedataDynamicObjectCollection newValue) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)newValue)) {
            return;
        }
        Map<Object, DynamicObject> objectMap = newValue.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid")).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity_actual");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            this.addRows(objectMap.values());
            return;
        }
        Set<DynamicObject> addSet = this.updateRowsAndGetAddSet(objectMap, entryEntity);
        this.addRows(addSet);
    }

    private Set<DynamicObject> updateRowsAndGetAddSet(Map<Object, DynamicObject> objectMap, DynamicObjectCollection entryEntity) {
        HashSet<Object> updateObjectSet = new HashSet<Object>(4);
        DynamicObject currentDynamicObject = this.getCurrentDynamicObject("entryentity");
        DynamicObject currentBusinessBIll = currentDynamicObject.getDynamicObject("entry_businessbill");
        for (int i = 0; i < entryEntity.size(); ++i) {
            Object pkValue;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            DynamicObject businessBillObj = dynamicObject.getDynamicObject("entry_aclbusinessbill");
            if (Objects.isNull(businessBillObj) || !objectMap.containsKey(pkValue = businessBillObj.getPkValue())) continue;
            this.updateRow(i, currentBusinessBIll);
            updateObjectSet.add(pkValue);
        }
        return objectMap.entrySet().stream().filter(entry -> !updateObjectSet.contains(entry.getKey())).map(entry -> (DynamicObject)entry.getValue()).collect(Collectors.toSet());
    }

    private void updateRow(int index, DynamicObject dynamicObject) {
        IDataModel model = this.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity_actual", index);
        if (Objects.isNull(entryRowEntity)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = entryRowEntity.getDynamicObjectCollection("entry_preemptedbill");
        Set preemptedBillIdSet = dynamicObjectCollection.stream().map(dObject -> dObject.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
        preemptedBillIdSet.add(dynamicObject.getPkValue());
        model.setValue("entry_preemptedbill", (Object)preemptedBillIdSet.toArray(), index);
    }

    private void addRows(Collection<DynamicObject> collection) {
        if (EmptyUtil.isEmpty(collection)) {
            return;
        }
        IDataModel model = this.getModel();
        int[] addRowArr = model.batchCreateNewEntryRow("entryentity_actual", collection.size());
        int index = 0;
        DynamicObject currentDynamicObject = this.getCurrentDynamicObject("entryentity");
        DynamicObject businessBillObject = currentDynamicObject.getDynamicObject("entry_businessbill");
        for (DynamicObject dynamicObject : collection) {
            model.setValue("entry_aclbusinessbill", dynamicObject.getPkValue(), addRowArr[index]);
            if (Objects.isNull(businessBillObject)) continue;
            model.setValue("entry_preemptedbill", (Object)new Object[]{businessBillObject.getPkValue()}, addRowArr[index]);
            this.setDefaultOperatorIfNeed(dynamicObject, addRowArr[index]);
            ++index;
        }
    }

    private void setDefaultOperatorIfNeed(DynamicObject dynamicObject, int index) {
        String number = dynamicObject.getString("number");
        MatchRuleBusinessBillEnum enumByCode = MatchRuleBusinessBillEnum.getEnumByCode((String)number);
        if (Objects.isNull(enumByCode)) {
            return;
        }
        List<Map<String, String>> mapList = this.getAllOperationForBusinessBill(number, Collections::emptySet);
        Map operatorValueMapOperator = mapList.stream().collect(Collectors.toMap(map -> (String)map.get("key"), Function.identity()));
        Map<String, Set<String>> map2 = BILL_ACTUAL_DEFAULT_OPERATOR.get(enumByCode);
        if (Objects.isNull(map2)) {
            return;
        }
        IDataModel model = this.getModel();
        Map<String, String> valueFieldMapToName = ExecuteTimeProp.OPERATOR_NAME_KEY_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        for (Map.Entry<String, Set<String>> entry : map2.entrySet()) {
            String valueFieldName = entry.getKey();
            String nameField = valueFieldMapToName.get(valueFieldName);
            if (EmptyUtil.isEmpty((String)valueFieldName) || EmptyUtil.isEmpty((String)nameField)) continue;
            StringBuilder name = new StringBuilder();
            StringBuilder value = new StringBuilder();
            for (String operatorKey : entry.getValue()) {
                Map operatorMap = (Map)operatorValueMapOperator.get(operatorKey);
                if (Objects.isNull(operatorMap)) continue;
                name.append((String)operatorMap.get("name")).append(";");
                value.append((String)operatorMap.get("key")).append(FIELD_SEPARATOR);
            }
            if (name.length() <= 0) continue;
            name.deleteCharAt(name.length() - 1);
            value.deleteCharAt(value.length() - 1);
            model.setValue(nameField, (Object)name, index);
            model.setValue(valueFieldName, (Object)value, index);
        }
    }

    private void setValueAndCode(String fieldName, String entryEntity, Object returnData) {
        if (EmptyUtil.isEmpty((Object)returnData)) {
            return;
        }
        String codeField = (String)ExecuteTimeProp.OPERATOR_NAME_KEY_MAP.get(fieldName);
        Map map = (Map)returnData;
        IDataModel model = this.getModel();
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex(entryEntity);
        model.setValue(fieldName, map.get("name"), entryCurrentRowIndex);
        model.setValue(codeField, map.get("key"), entryCurrentRowIndex);
    }

    private void showOperatorForm(String key) {
        if (Objects.equals(key, "entry_factbackamountname") || Objects.equals(key, "entry_aclupdateamtname")) {
            this.doShowActualReleaseAmountFieldSelector(key);
            return;
        }
        String entryEntityName = (String)ExecuteTimeProp.OPERATOR_FIELD_TO_ENTRY_ENTITY_MAP.get(key);
        String billField = (String)ExecuteTimeProp.ENTRY_ENTITY_BUSINESS_BILL_MAP.get(entryEntityName);
        DynamicObject dynamicObject = this.getCurrentDynamicObject(entryEntityName);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_billoperation");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        DynamicObject businessBillObj = dynamicObject.getDynamicObject(billField);
        if (Objects.isNull(businessBillObj)) {
            this.showTipNotificationForBusinessBill();
            return;
        }
        String number = businessBillObj.getString("number");
        List<Map<String, String>> mapList = this.getAllOperationForBusinessBill(number, Collections::emptySet);
        showParameter.getCustomParams().put("operator", mapList);
        Set<String> currentSelectKey = this.getCurrentSelectKey(dynamicObject, key);
        showParameter.getCustomParams().put("operator_selected", currentSelectKey);
        this.getView().showForm(showParameter);
    }

    private void doShowActualReleaseAmountFieldSelector(String key) {
        DynamicObject currentDynamicObject = this.getCurrentDynamicObject("entryentity_actual");
        DynamicObject businessBillDy = currentDynamicObject.getDynamicObject("entry_aclbusinessbill");
        String businessBillNumber = (String)businessBillDy.getPkValue();
        DynamicObject bodySysDy = (DynamicObject)this.getModel().getValue("bodysys");
        Object bodySys = bodySysDy.getPkValue();
        QFilter qFilter = new QFilter("bodysys", "=", bodySys).and("businessbill", "=", (Object)businessBillNumber).and("enable", "=", (Object)"1");
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_matchrule", (String)String.join((CharSequence)FIELD_SEPARATOR, ID, "linkentity", "entryentity.entry_businessbillfield"), (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)queryResult)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)businessBillNumber);
            String billName = dataEntityType.getDisplayName().getLocaleValue();
            String detailMessage = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb:\u3010%1$s\u3011\u4e1a\u52a1\u5355\u636e\uff1a\u3010%2$s\u3011\uff0c\u4e0d\u5b58\u5728\u6709\u6548\u7684\u6267\u884c\u53d6\u6570\u89c4\u5219", (String)"ExecuteTimeEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), bodySysDy.getString("name"), billName);
            this.getView().showTipNotification(detailMessage);
            return;
        }
        String entryName = this.getOrDetermineEntry(queryResult);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_actualamountfield");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.setCustomParam("businessEntityType", (Object)businessBillNumber);
        showParameter.setCustomParam("entryName", (Object)entryName);
        showParameter.setCustomParam("amountField", (Object)currentDynamicObject.getString((String)ExecuteTimeProp.OPERATOR_NAME_KEY_MAP.get(key)));
        this.getView().showForm(showParameter);
    }

    private boolean checkBusinessField(String key) {
        String entryEntityName = (String)ExecuteTimeProp.OPERATOR_FIELD_TO_ENTRY_ENTITY_MAP.get(key);
        String billField = (String)ExecuteTimeProp.ENTRY_ENTITY_BUSINESS_BILL_MAP.get(entryEntityName);
        DynamicObject currentDynamicObject = this.getCurrentDynamicObject(entryEntityName);
        DynamicObject businessBill = currentDynamicObject.getDynamicObject(billField);
        if (Objects.isNull(businessBill)) {
            this.showTipNotificationForBusinessBill();
            return false;
        }
        return true;
    }

    private void showTipNotificationForBusinessBill() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u3002", (String)"ExecuteTimeEdit_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private Set<String> getCurrentSelectKey(DynamicObject dynamicObject, String key) {
        String string = dynamicObject.getString((String)ExecuteTimeProp.OPERATOR_NAME_KEY_MAP.get(key));
        if (EmptyUtil.isEmpty((String)string)) {
            return new HashSet<String>(2);
        }
        String[] split = string.split(FIELD_SEPARATOR);
        return new HashSet<String>(Arrays.asList(split));
    }

    private List<Map<String, String>> getAllOperationForBusinessBill(String number, Supplier<Set<String>> supplier) {
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)number);
        Set<String> codeSet = supplier.get();
        ArrayList<Map<String, String>> operatorMapList = new ArrayList<Map<String, String>>(64);
        for (Map map : dataEntityOperate) {
            HashMap<String, String> operatorProp = new HashMap<String, String>(8);
            boolean flag = false;
            for (String prop : OPERATOR_PROP) {
                String value = this.getValue(map, prop);
                if (EmptyUtil.isEmpty((String)value)) continue;
                if (StringUtils.equals((CharSequence)prop, (CharSequence)"key") && codeSet.contains(value)) {
                    flag = true;
                    break;
                }
                operatorProp.put(prop, value);
            }
            if (flag) continue;
            operatorMapList.add(operatorProp);
        }
        return operatorMapList;
    }

    private String getValue(Map<String, Object> map, String operatorKey) {
        if (!map.containsKey(operatorKey)) {
            return "";
        }
        Object obj = map.get(operatorKey);
        return this.getValue(obj);
    }

    private String getValue(Object obj) {
        if (EmptyUtil.isEmpty((Object)obj)) {
            return "";
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            Map map = (Map)obj;
            if (map.isEmpty()) {
                return "";
            }
            Object val = map.get(Lang.get().getLocale().toString());
            return this.getValue(val);
        }
        if (Collection.class.isAssignableFrom(obj.getClass())) {
            Collection collection = (Collection)obj;
            return this.getValue(collection.iterator().next());
        }
        if (String.class.isAssignableFrom(obj.getClass())) {
            return (String)obj;
        }
        if (Object[].class.isAssignableFrom(obj.getClass())) {
            Object[] arr = (Object[])obj;
            if (EmptyUtil.isEmpty((Object[])arr)) {
                return "";
            }
            return this.getValue(arr[0]);
        }
        return "";
    }

    private DynamicObject getCurrentDynamicObject(String entryEntityName) {
        IDataModel model = this.getModel();
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex(entryEntityName);
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryEntityName);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        return dynamicObject;
    }

    private void initF7Model() {
        this.bodySysF7Model();
        this.businessBillPreemptedF7Model();
        this.businessBillAclF7Model();
        this.aclBusinessBillPreemptedF7Model();
        this.controledReportTypeF7Model();
    }

    private void controledReportTypeF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("controlledreporttype");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
            if (Objects.isNull(bodySys)) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            bodySys = FpmDataServiceHelper.getBodySystemByCache((Long)((Long)bodySys.getPkValue()));
            DynamicObjectCollection applyrereportentry = bodySys.getDynamicObjectCollection("applyrereportentry");
            List ids = applyrereportentry.stream().filter(o -> o.getString("rereporttypestatus").equals("enable")).map(o -> o.getDynamicObject("rerporttype").getPkValue()).collect(Collectors.toList());
            QFilter qFilter = new QFilter(ID, "in", ids);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void businessBillAclF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("entry_actualbusinessbill");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
            if (Objects.isNull(bodySys)) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List<Object> objectList = this.getMatchRuledBusinessBillIdList(bodySys, obj -> true);
            QFilter businessBillFilter = new QFilter(ID, "in", objectList);
            showParameter.getListFilterParameter().setFilter(businessBillFilter);
        });
        modelBE.setF7MultipleSelect(true);
    }

    private void aclBusinessBillPreemptedF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("entry_aclbusinessbill");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
            if (Objects.isNull(bodySys)) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Set<Object> configedPreemptedBill = this.getConfigedPreemptedBill(bodySys);
            List<Object> objectList = this.getMatchRuledBusinessBillIdList(bodySys, obj -> !configedPreemptedBill.contains(obj));
            QFilter businessBillFilter = new QFilter(ID, "in", objectList);
            showParameter.getListFilterParameter().setFilter(businessBillFilter);
        });
    }

    private Set<Object> getConfigedPreemptedBill(DynamicObject bodySys) {
        if (Objects.isNull(bodySys)) {
            return new HashSet<Object>(2);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Set<Object> objectSet = entryEntity.stream().filter(dynamicObject -> !EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObject.getDynamicObjectCollection("entry_actualbusinessbill"))).flatMap(dynamicObject -> dynamicObject.getDynamicObjectCollection("entry_actualbusinessbill").stream()).map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
        return objectSet;
    }

    private void businessBillPreemptedF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("entry_businessbill");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
            if (Objects.isNull(bodySys)) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List<Object> objectList = this.getMatchRuledBusinessBillIdList(bodySys, obj -> true);
            QFilter businessBillFilter = new QFilter(ID, "in", objectList);
            showParameter.getListFilterParameter().setFilter(businessBillFilter);
        });
    }

    private List<Object> getMatchRuledBusinessBillIdList(DynamicObject bodySys, Predicate<Object> filter) {
        if (Objects.isNull(bodySys)) {
            return new ArrayList<Object>(2);
        }
        String selectFields = String.join((CharSequence)FIELD_SEPARATOR, ID, "businessbill");
        QFilter qFilter = new QFilter("bodysys", "=", bodySys.getPkValue()).and(new QFilter("enable", "=", (Object)"1")).and("fetchpurpose", "=", (Object)MatchRuleFetchPurposeEnum.EXECUTE_CONTROL.getCode());
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_matchrule", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)queryResult)) {
            return new ArrayList<Object>(0);
        }
        return queryResult.stream().map(dynamicObject -> dynamicObject.get("businessbill")).filter(filter).collect(Collectors.toList());
    }

    private void showBodySysNotification() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u4f53\u7cfb\u3002", (String)"ExecuteTimeEdit_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private void bodySysF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("bodysys");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter authQFilter = ModelHelper.getAuthQFilter();
            showParameter.getListFilterParameter().setFilter(authQFilter);
        });
    }

    private void setTimeLimitRequiredIfNeed(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            Boolean autoRelease = (Boolean)changeData.getNewValue();
            DecimalEdit timeLimit = (DecimalEdit)this.getControl("timelimit");
            timeLimit.setMustInput(autoRelease.booleanValue());
        }
    }

    private void permissionContr() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pageType");
        if ("view".equals(pageType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_modify", "bar_disable", "advcontoolbarap", "advcontoolbarap1"});
        }
    }
}

