/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.bd.TmcBaseDataEdit;
import kd.tmc.fpm.business.domain.model.sumplan.AccurateMatchScheme;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.bean.SubjectCancelConfig;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.InternalCancelConfigFlowEnum;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.property.InternalCancelRuleProp;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.listener.TmcBaseBeforeF7SelectListener;

public class InternalCancelRuleEdit
extends TmcBaseDataEdit {
    private static final String PROPERTY_CHANGE_IS_FROM_CALL_BACK = "PROPERTY_CHANGE_IS_FROM_CALL_BACK";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String modelId = parentView.getPageCache().get("INTERNAL_CANCEL_RULE_BODY_SYS_ID_KEY");
            if (Objects.isNull(modelId)) {
                return;
            }
            if (modelId.contains("[")) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
                modelId = modelIdArr[0].trim();
            }
            if (!StringUtils.isNumeric((CharSequence)modelId)) {
                return;
            }
            this.getModel().setValue("bodysys", (Object)modelId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"entry_inconfig", "entry_outconfig", "entry_offset_scheme", "entry_accurate_match_mode"});
        this.initF7();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if ("entry_offset_scheme".equals(key)) {
            this.openAccirateMatchSchemeWindow(key);
        } else {
            InternalCancelConfigFlowEnum configFlowEnum = InternalCancelConfigFlowEnum.getByField((String)key);
            if (configFlowEnum == null) {
                return;
            }
            this.showConfigForm(configFlowEnum);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (actionId.equals("entry_offset_scheme")) {
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                AccurateMatchScheme scheme = (AccurateMatchScheme)returnData;
                String serialize = FpmSerializeUtil.serialize((Object)scheme);
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("entry_offset_scheme", (Object)StringHelper.subString((String)scheme.getName(), (int)254), entryCurrentRowIndex);
                this.getModel().setValue("entry_offset_scheme_save_tag", (Object)serialize, entryCurrentRowIndex);
            }
        } else {
            InternalCancelConfigFlowEnum configFlowEnum = InternalCancelConfigFlowEnum.getByField((String)actionId);
            if (configFlowEnum == null) {
                return;
            }
            this.setSubjectConfig(configFlowEnum, returnData);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        IDataEntityProperty property = args.getProperty();
        switch (property.getName()) {
            case "entry_inconfig": 
            case "entry_outconfig": {
                this.cleanSubjectIfNeed(args);
                break;
            }
            case "apply_reportorg": {
                break;
            }
            case "entry_accurate_match_mode": {
                this.cleanOffsetScheme(args);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (Objects.isNull(operationResult) || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (EmptyUtil.isNoEmpty((Object)dataEntity.getPkValue()) && dataEntity.getBoolean("enable")) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"needlock", (Object)true);
        }
        this.initF7();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "sumdeleteentry": {
                String checkCanDelete = this.checkCanDelete(null);
                if (!EmptyUtil.isNoEmpty((String)checkCanDelete)) break;
                this.getView().showTipNotification(checkCanDelete);
                args.setCancel(true);
            }
        }
    }

    private String checkCanDelete(DynamicObject sumOrg) {
        if (sumOrg == null) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("apply_entryentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("apply_entryentity").get(entryCurrentRowIndex);
            sumOrg = dynamicObject.getDynamicObject("apply_reportorg");
        }
        if (sumOrg == null) {
            return "";
        }
        Object pkValue = sumOrg.getPkValue();
        DynamicObject[] summaryConfig = this.getSummaryConfig();
        HashSet<Object> children = new HashSet<Object>(16);
        for (DynamicObject sumConfig : summaryConfig) {
            boolean find = false;
            HashSet<Object> parentIds = new HashSet<Object>(8);
            parentIds.add(pkValue);
            DynamicObjectCollection treeEntity = sumConfig.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : treeEntity) {
                DynamicObject parent;
                DynamicObject sumConfigOrg = entry.getDynamicObject("sum_reportorg");
                Object sumOrgPkValue = sumConfigOrg.getPkValue();
                if (Objects.equals(pkValue, sumOrgPkValue)) {
                    find = true;
                    continue;
                }
                if (!find || EmptyUtil.isEmpty((DynamicObject)(parent = sumConfigOrg.getDynamicObject("parent"))) || !parentIds.contains(parent.getPkValue())) continue;
                parentIds.add(parent.getPkValue());
                if (!entry.getBoolean("sum_issumaudit")) continue;
                children.add(sumOrgPkValue);
            }
        }
        Optional<DynamicObject> first = this.getModel().getEntryEntity("apply_entryentity").stream().map(dy -> dy.getDynamicObject("apply_reportorg")).filter(Objects::nonNull).filter(dy -> children.contains(dy.getPkValue())).findFirst();
        if (first.isPresent()) {
            DynamicObject childOrg = first.get();
            return String.format(ResManager.loadKDString((String)"\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u5206\u5f55\u4e2d\u5b58\u5728\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u201c%1$s\u201d\u7684\u5b50\u7ea7\u6c47\u603b\u8282\u70b9\u201c%2$s\u201d\uff0c\u4e0d\u53ef\u5220\u9664\u3002\u8bf7\u786e\u8ba4\u3002", (String)"InternalCancelRuleEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), sumOrg.getString("name"), childOrg.getString("name"));
        }
        return "";
    }

    private void cleanSubjectIfNeed(PropertyChangedArgs args) {
        if (Objects.equals(this.getView().getPageCache().get(PROPERTY_CHANGE_IS_FROM_CALL_BACK), PROPERTY_CHANGE_IS_FROM_CALL_BACK)) {
            this.getView().getPageCache().remove(PROPERTY_CHANGE_IS_FROM_CALL_BACK);
            return;
        }
        ChangeData[] changeSet = args.getChangeSet();
        ChangeData changeData = changeSet[0];
        String newValue = (String)changeData.getNewValue();
        if (EmptyUtil.isNoEmpty((String)newValue)) {
            return;
        }
        String name = args.getProperty().getName();
        InternalCancelConfigFlowEnum configFlowEnum = InternalCancelConfigFlowEnum.getByField((String)name);
        if (configFlowEnum == null) {
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue(configFlowEnum.getStoreField(), (Object)"", entryCurrentRowIndex);
    }

    private void setSubjectConfig(InternalCancelConfigFlowEnum configFlowEnum, Object returnData) {
        if (!String.class.isInstance(returnData)) {
            return;
        }
        this.getView().getPageCache().put(PROPERTY_CHANGE_IS_FROM_CALL_BACK, PROPERTY_CHANGE_IS_FROM_CALL_BACK);
        String subjectConfig = (String)returnData;
        SubjectCancelConfig subjectCancelConfig = (SubjectCancelConfig)SerializationUtils.fromJsonString((String)subjectConfig, SubjectCancelConfig.class);
        List subjectList = subjectCancelConfig.getSubjectList();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        subjectList = CollectionUtils.isEmpty((Collection)subjectList) ? Collections.emptyList() : subjectList;
        String subjectNames = subjectList.stream().map(SubjectCancelConfig.Subject::getName).collect(Collectors.joining(";"));
        this.getModel().setValue(configFlowEnum.getField(), (Object)StringHelper.subString((String)subjectNames, (int)1024), entryCurrentRowIndex);
        this.getModel().setValue(configFlowEnum.getStoreField(), (Object)subjectConfig, entryCurrentRowIndex);
    }

    private void showConfigForm(InternalCancelConfigFlowEnum configFlowEnum) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject dynamicObject = dataEntity.getDynamicObject("bodysys");
        if (Objects.isNull(dynamicObject)) {
            this.showBodySysNotification();
            return;
        }
        String flow = configFlowEnum.getFlow();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String fieldValue = ((DynamicObject)entryEntity.get(entryCurrentRowIndex)).getString(configFlowEnum.getField());
        String configJson = EmptyUtil.isEmpty((String)fieldValue) ? SerializationUtils.toJsonString((Object)new SubjectCancelConfig((Long)dynamicObject.getPkValue(), flow)) : ((DynamicObject)entryEntity.get(entryCurrentRowIndex)).getString(configFlowEnum.getStoreField());
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fpm_subjectcancelconfig");
        formShowParameter.setCustomParam("SUBJECT_CANCEL_CONFIG", (Object)configJson);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, configFlowEnum.getField()));
        formShowParameter.setCaption(configFlowEnum.getCaption());
        this.getView().showForm(formShowParameter);
    }

    private void openAccirateMatchSchemeWindow(String key) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String configJson = ((DynamicObject)entryEntity.get(entryCurrentRowIndex)).getString("entry_offset_scheme_save_tag");
        DynamicObject dynamicObject = dataEntity.getDynamicObject("bodysys");
        if (Objects.isNull(dynamicObject)) {
            this.showBodySysNotification();
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fpm_accuratematchscheme");
        formShowParameter.setCustomParam("pass_param_accuratematchscheme", (Object)configJson);
        formShowParameter.setCustomParam("pass_param_system", dynamicObject.getPkValue());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        Boolean needLock = (Boolean)this.getModel().getValue("needlock");
        if (needLock != null && needLock.booleanValue()) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        this.getView().showForm(formShowParameter);
    }

    private void initF7() {
        for (String field : InternalCancelRuleProp.F7_FIELDS) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(field);
            basedataEdit.addBeforeF7SelectListener(this.getBeforeF7SelectListener());
        }
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("bodysys");
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            return;
        }
        String selectFields = String.join((CharSequence)",", "id", "number");
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_dimension", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", dynamicObject.getPkValue()).and("number", "not in", (Object)new String[]{DimsionEnums.ORG.getNumber(), DimsionEnums.PERIOD.getNumber(), DimsionEnums.SUBJECT.getNumber(), DimsionEnums.CURRENCY.getNumber(), DimsionEnums.METRIC.getNumber()})}, (String)"id");
        Map dynamicObjectMap = Arrays.stream(load).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        List dimIdList = Arrays.stream(load).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        for (String field : InternalCancelRuleProp.F7_OPTIONAL_DIM) {
            DynamicObject dimension;
            Long dimId;
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(field);
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(field);
            Boolean visible = Boolean.FALSE;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
                dimId = ((DynamicObject)dynamicObjectCollection.get(0)).getDynamicObject("fbasedataid").getDynamicObject("dimension").getLong("id");
                this.addF7Listener(basedataEdit, dimId);
                dimension = (DynamicObject)dynamicObjectMap.get(dimId);
                basedataEdit.setCaption(new LocaleString(EmptyUtil.isEmpty((DynamicObject)dimension) ? "" : dimension.getString("name")));
                dimIdList.remove(dimId);
                visible = Boolean.TRUE;
            } else if (EmptyUtil.isNoEmpty(dimIdList)) {
                dimId = (Long)dimIdList.get(0);
                this.addF7Listener(basedataEdit, dimId);
                dimIdList.remove(0);
                dimension = (DynamicObject)dynamicObjectMap.get(dimId);
                basedataEdit.setCaption(new LocaleString(EmptyUtil.isEmpty((DynamicObject)dimension) ? "" : dimension.getString("name")));
                visible = Boolean.TRUE;
            }
            this.getView().setVisible(visible, new String[]{field});
        }
    }

    private void addF7Listener(BasedataEdit basedataEdit, final Long dimId) {
        final DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("bodysys");
        basedataEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                if (dynamicObject == null) {
                    InternalCancelRuleEdit.this.showBodySysNotification();
                    evt.setCancel(true);
                    return;
                }
                ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                listFilterParameter.setFilter(new QFilter("bodysystem", "=", dynamicObject.getPkValue()).and(new QFilter("dimension", "=", (Object)dimId)));
                showParam.setListFilterParameter(listFilterParameter);
                showParam.setFormId("bos_listf7");
            }
        });
    }

    private BeforeF7SelectListener getBeforeF7SelectListener() {
        final DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("bodysys");
        return new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                QFilter qFilter;
                String name;
                if (dynamicObject == null) {
                    InternalCancelRuleEdit.this.showBodySysNotification();
                    beforeF7SelectEvent.setCancel(true);
                    return 2.qFilterResultBuilder().build();
                }
                IDataEntityProperty property = beforeF7SelectEvent.getProperty();
                switch (name = property.getName()) {
                    case "applyreporttype": {
                        DynamicObject bodySys = FpmDataServiceHelper.getBodySystemByCache((Long)((Long)dynamicObject.getPkValue()));
                        DynamicObjectCollection dynamicObjectCollection = bodySys.getDynamicObjectCollection("applyrereportentry");
                        List objectList = dynamicObjectCollection.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)"enable", (CharSequence)dynamicObject.getString("rereporttypestatus"))).map(dynamicObject -> dynamicObject.get("rerporttype.id")).collect(Collectors.toList());
                        qFilter = new QFilter("id", "in", objectList);
                        break;
                    }
                    case "apply_reportorg": {
                        DynamicObjectCollection reportType = (DynamicObjectCollection)InternalCancelRuleEdit.this.getModel().getValue("applyreporttype");
                        String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid", "id");
                        QFilter sumConfigFilter = new QFilter("bodysys", "=", dynamicObject.getPkValue()).and("enable", "=", (Object)"1").and(reportTypeProp, "in", reportType.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
                        String selectFields = String.join((CharSequence)",", String.join((CharSequence)".", "treeentryentity", "sum_issumaudit"), String.join((CharSequence)".", "treeentryentity", "sum_reportorg"));
                        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_summaryconfig", (String)selectFields, (QFilter[])new QFilter[]{sumConfigFilter});
                        Set collect = Arrays.stream(load).map(dy -> dy.getDynamicObjectCollection("treeentryentity")).flatMap(Collection::stream).filter(dy -> dy.getBoolean("sum_issumaudit")).map(dy -> dy.getDynamicObject("sum_reportorg")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                        qFilter = new QFilter("id", "in", collect).and("bodysystem", "=", dynamicObject.getPkValue());
                        break;
                    }
                    default: {
                        qFilter = new QFilter("bodysystem", "=", dynamicObject.getPkValue());
                    }
                }
                return 2.qFilterResultBuilder().qFilter(qFilter).build();
            }
        };
    }

    private void showBodySysNotification() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u4f53\u7cfb\u3002", (String)"InternalCancelRuleEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject[] getSummaryConfig() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject dynamicObject = dataEntity.getDynamicObject("bodysys");
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            this.showBodySysNotification();
            return new DynamicObject[0];
        }
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("applyreporttype");
        Set reportTypeSet = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid", "id");
        QFilter qFilter = new QFilter("bodysys", "=", dynamicObject.getPkValue()).and("enable", "=", (Object)"1");
        if (EmptyUtil.isNoEmpty(reportTypeSet)) {
            qFilter.and(reportTypeProp, "in", reportTypeSet);
        }
        String selectFields = String.join((CharSequence)",", String.join((CharSequence)".", "treeentryentity", "sum_reportorg"), String.join((CharSequence)".", "treeentryentity", "sum_issumaudit"));
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_summaryconfig", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return load;
    }

    private void cleanOffsetScheme(PropertyChangedArgs args) {
        ChangeData accurateMatchModeChangeData = args.getChangeSet()[0];
        Boolean newValue = (Boolean)accurateMatchModeChangeData.getNewValue();
        if (newValue.booleanValue()) {
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue("entry_offset_scheme", (Object)"", entryCurrentRowIndex);
        this.getModel().setValue("entry_offset_scheme_save_tag", (Object)"", entryCurrentRowIndex);
    }
}

