/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fpm.common.helper.FpmHelper;
import kd.tmc.fpm.common.helper.ModelHelper;

public class MatchRuleList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(MatchRuleList.class);
    private static final String MATCH_RULE_LIST_TOOLBAR_NEW = "new";
    private static final String MATCH_RULE_LIST_TOOLBAR_CONTROLCONFIG = "controlconfig";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        logger.info(String.format("\u8fc7\u6ee4\u6761\u4ef6\uff0c%s", JSON.toJSONString((Object)qFilters)));
        QFilter qFilterByKey = FpmHelper.getQFilterByKey((List)qFilters, (String)"bodysys.id");
        this.getPageCache().put("MATCH_RULE_BODY_SYS_ID_KEY", qFilterByKey != null ? qFilterByKey.getValue().toString() : null);
        logger.info(String.format("getPageCache\uff0c%s", this.getPageCache().get("MATCH_RULE_BODY_SYS_ID_KEY")));
        List modelIdList = ModelHelper.getAuthModelId();
        qFilters.add(new QFilter("bodysys.id", "in", (Object)modelIdList));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                this.checkBodySysIfNeedCancel(args);
                break;
            }
            case "controlconfig": {
                this.openControlConfigForm(args);
            }
        }
    }

    private void openControlConfigForm(BeforeDoOperationEventArgs args) {
        this.checkBodySysIfNeedCancel(args);
        if (args.isCancel()) {
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("fpm_executetime");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String bodySys = this.getPageCache().get("MATCH_RULE_BODY_SYS_ID_KEY");
        listShowParameter.getCustomParams().put("MATCH_RULE_BODY_SYS_ID_KEY", bodySys);
        this.getView().showForm((FormShowParameter)listShowParameter);
        args.setCancel(true);
    }

    private void checkBodySysIfNeedCancel(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String modelId = this.getPageCache().get("MATCH_RULE_BODY_SYS_ID_KEY");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"MatchRuleList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            beforeDoOperationEventArgs.setCancel(true);
        }
    }
}

