/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;

public class OperationEdit
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BTN_OK = "btnok";
    private static final String ENTRY_KEY = "key";
    private static final String ENTRY_NAME = "name";
    private static final String ENTRY_TYPE = "type";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_OK});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object value = this.getView().getFormShowParameter().getCustomParams().get("operator");
        List ops = (List)(value instanceof List ? value : new ArrayList());
        if (EmptyUtil.isEmpty((Collection)ops)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        int[] rowKeys = model.batchCreateNewEntryRow(ENTRY_ENTITY, ops.size());
        for (int i = 0; i < ops.size(); ++i) {
            Map objectMap = (Map)ops.get(i);
            String key = (String)objectMap.get(ENTRY_KEY);
            model.setValue(ENTRY_KEY, (Object)key, rowKeys[i]);
            model.setValue(ENTRY_NAME, objectMap.get(ENTRY_NAME), rowKeys[i]);
            model.setValue(ENTRY_TYPE, objectMap.get(ENTRY_TYPE), rowKeys[i]);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object selected = this.getView().getFormShowParameter().getCustomParams().get("operator_selected");
        List selectedList = (List)(selected instanceof List ? selected : new ArrayList());
        if (EmptyUtil.isEmpty((Collection)selectedList)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = new int[selectedList.size()];
        int index = 0;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            String key = ((DynamicObject)entryEntity.get(i)).getString(ENTRY_KEY);
            if (!selectedList.contains(key)) continue;
            selectRows[index++] = i;
        }
        entryGrid.selectRows(selectRows, selectRows[0]);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Button btn = (Button)evt.getSource();
        switch (key = btn.getKey()) {
            case "btnok": {
                this.close();
                break;
            }
        }
    }

    private void close() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashMap<String, String> map = new HashMap<String, String>(4);
        StringBuilder keyBuilder = new StringBuilder();
        StringBuilder nameBuilder = new StringBuilder();
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u8bb0\u5f55\u3002", (String)"OperationEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String key = dynamicObject.getString(ENTRY_KEY);
            keyBuilder.append(key).append(",");
            nameBuilder.append(dynamicObject.getString(ENTRY_NAME)).append(";");
        }
        if (keyBuilder.length() != 0) {
            keyBuilder.deleteCharAt(keyBuilder.length() - 1);
        }
        if (nameBuilder.length() != 0) {
            nameBuilder.deleteCharAt(nameBuilder.length() - 1);
        }
        map.put(ENTRY_KEY, keyBuilder.toString());
        map.put(ENTRY_NAME, nameBuilder.toString());
        this.getView().returnDataToParent(map);
        this.getView().close();
    }
}

