/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TimeEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FixedFrequencyType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl.FixedFrequencyDateReportGeneratePeriodStrategy;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.enums.OrgReportTypeCycleEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.utils.report.ReportPrepareHelper;
import org.apache.commons.lang3.StringUtils;

public class ReportPreparationEdit
extends AbstractBasePlugIn {
    public static final String CONFIRM_SAVE_CALLBACK = "confirm_save_callback";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initControlEvi();
    }

    protected void initControlEvi() {
        List sysIdList = ModelHelper.getAuthModelId();
        BasedataEdit sysManageEdit = (BasedataEdit)this.getControl("bodysysmanage");
        sysManageEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("id", "in", (Object)sysIdList);
            showParameter.getListFilterParameter().setFilter(filter);
        });
        DynamicObject sysObj = (DynamicObject)this.getModel().getValue("bodysysmanage");
        if (sysObj == null) {
            return;
        }
        Object sysId = sysObj.getPkValue();
        DynamicObject bodySysManage = FpmDataServiceHelper.getBodySystemByCache((Long)((Long)sysId));
        DynamicObjectCollection dynamicObjectCollection = bodySysManage.getDynamicObjectCollection("applyrereportentry");
        ArrayList<Long> orgreporttypeIds = new ArrayList<Long>(dynamicObjectCollection.size());
        for (DynamicObject dyObj : dynamicObjectCollection) {
            DynamicObject dynamicObject = dyObj.getDynamicObject("rerporttype");
            if (dynamicObject == null || !"1".equals(dynamicObject.getString("enable"))) continue;
            Long rerporttypeId = dynamicObject.getLong("id");
            orgreporttypeIds.add(rerporttypeId);
        }
        BasedataEdit linkParentEdit = (BasedataEdit)this.getControl("orgreporttype");
        linkParentEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("id", "in", (Object)orgreporttypeIds);
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }

    public void afterBindData(EventObject e) {
        Integer value;
        String customParam;
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (OperationStatus.ADDNEW.equals((Object)status) && Objects.equals(Boolean.TRUE, isCopy)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            entryEntity.clear();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_genreport"});
        }
        if ("1".equals(customParam = (String)this.getView().getFormShowParameter().getCustomParam("link"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bodysysmanage", "orgreporttype"});
        }
        boolean isOpen = (Boolean)this.getModel().getValue("isaccreportsubdefine");
        ComboEdit comb = (ComboEdit)this.getControl("reportsublevel");
        TimeEdit timeEdit = (TimeEdit)this.getControl("contrlevelstopreptime");
        if (isOpen) {
            comb.setMustInput(true);
            timeEdit.setMustInput(true);
        }
        if ((value = (Integer)this.getModel().getValue("fixedfrequencyendtime")) == null || value < 0) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"fixedfrequencyendtime", (Object)86399);
        }
        this.showExample();
        this.setMustIfNeed((Boolean)this.getModel().getValue("fixedfrequency"));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String sysId = (String)this.getView().getFormShowParameter().getCustomParam("bodysysmanage");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_genreport"});
        }
        this.getModel().setValue("defaultstopreptime", (Object)86399);
        this.getModel().setValue("contrlevelstopreptime", (Object)54000);
        this.getModel().setValue("fixedfrequencyendtime", (Object)86399);
        if (StringUtils.isNotEmpty((CharSequence)sysId)) {
            DynamicObject dynamicObject;
            this.getModel().setValue("bodysysmanage", (Object)Long.valueOf(sysId));
            DynamicObject bodySysManage = FpmDataServiceHelper.getBodySystemByCache((Long)Long.valueOf(sysId));
            DynamicObjectCollection dynamicObjectCollection = bodySysManage.getDynamicObjectCollection("applyrereportentry");
            for (DynamicObject dyObj : dynamicObjectCollection) {
                DynamicObject dynamicObject1 = dyObj.getDynamicObject("rerporttype");
                if (dynamicObject1 == null || !"1".equals(dynamicObject1.getString("enable"))) continue;
                Long reportTypeId = dynamicObject1.getLong("id");
                this.getModel().setValue("orgreporttype", (Object)reportTypeId);
                break;
            }
            if ((dynamicObject = bodySysManage.getDynamicObject("ratetype")) != null) {
                this.getModel().setValue("convexratetable", (Object)dynamicObject.getLong("id"));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_save")) {
            DynamicObject bodySysManage = (DynamicObject)this.getModel().getValue("bodysysmanage");
            DynamicObject orgReportType = (DynamicObject)this.getModel().getValue("orgreporttype");
            QFilter qFilter1 = new QFilter("bodysysmanage", "=", bodySysManage.getPkValue());
            QFilter qFilter2 = new QFilter("orgreporttype", "=", orgReportType.getPkValue());
            QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
            long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
            QFilter qFilter4 = new QFilter("id", "!=", (Object)pkValue);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_reportpreparation", (String)"id,bodysysmanage,orgreporttype.name,number", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4});
            if (query.size() > 0) {
                DynamicObject dynamicObject = (DynamicObject)query.get(0);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u65b0\u589e\u4fdd\u5b58\u8bb0\u5f55\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u201c\u7981\u7528\u201d\uff0c\u539f\u56e0\u4e3a\u672c\u4f53\u7cfb\u5df2\u5b58\u5728\u53ef\u7528\u72b6\u6001\u4e0b\u7684%1$s\u6240\u5bf9\u5e94\u7684\u7f16\u62a5\u51c6\u5907\u8bb0\u5f55%2$s\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"ReportPreparationEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), dynamicObject.getString("orgreporttype.name"), dynamicObject.getString("number")), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_SAVE_CALLBACK, (IFormPlugin)this));
                evt.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_genreport"});
                this.getView().invokeOperation("refresh");
                break;
            }
            case "genhisreport": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.showReportPeriod();
                break;
            }
            case "viewdetail": {
                String idStr = (String)this.getModel().getValue("planreportbillids_tag");
                String[] planReportBillIdsStr = idStr.split(";");
                List reportPlanIds = Stream.of(planReportBillIdsStr).map(stringId -> StringUtils.isEmpty((CharSequence)stringId) ? 0L : Long.parseLong(stringId)).collect(Collectors.toList());
                ListShowParameter createShowListForm = ShowFormHelper.createShowListForm((String)"fpm_report_process", (boolean)false, (int)2);
                createShowListForm.getListFilterParameter().setFilter(new QFilter("id", "in", reportPlanIds));
                createShowListForm.setCustomParam("viewtype", (Object)"f7");
                createShowListForm.setCaption(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba1\u5212\u5355\u636e\u5217\u8868", (String)"ReportPreparationEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                createShowListForm.setCustomParam("pageType", (Object)"view");
                createShowListForm.setCustomParam("okBtnVisible", (Object)false);
                this.getView().showForm((FormShowParameter)createShowListForm);
                break;
            }
        }
    }

    private void showReportPeriod() {
        DynamicObject reportTypeDy = (DynamicObject)this.getModel().getValue("orgreporttype");
        DynamicObject bodySystemDy = (DynamicObject)this.getModel().getValue("bodysysmanage");
        Long reportTypeId = (Long)reportTypeDy.getPkValue();
        ListShowParameter listShowParameter = CoreShowFormHelper.createShowListForm((String)"fpm_member", (boolean)true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setShowFrequent(false);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowUsed(true);
        listShowParameter.setMustInput(true);
        listShowParameter.setHasRight(true);
        listShowParameter.setListFilterParameter(new ListFilterParameter(ListHelper.asList((Object[])new QFilter[]{new QFilter("dimtype", "=", (Object)DimensionType.PERIOD.getNumber())}), null));
        Long systemId = (Long)bodySystemDy.getPkValue();
        String reportTypePeriodType = reportTypeDy.getString("orgreportcycle");
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("status", "=", (Object)BillStatus.AUDITED.getNumber()));
        qFilters.add(new QFilter("bodysystem", "=", (Object)systemId));
        qFilters.add(new QFilter("reporttype", "=", (Object)reportTypeId));
        List list = ListHelper.asList((Object[])new String[]{reportTypePeriodType});
        if (Objects.equals(OrgReportTypeCycleEnum.WEEK.getValue(), reportTypePeriodType)) {
            list.add(PeriodType.YEAR_WEEK.getNumber());
        }
        qFilters.add(new QFilter("periodtype", "in", (Object)list));
        qFilters.add(new QFilter("enddate", "<=", (Object)ReportPrepareHelper.getCurrentAndBeforeDate(systemId, reportTypeId, reportTypePeriodType)));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "genhisreport"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    /*
     * Unable to fully structure code
     */
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        var3_3 = propName = e.getProperty().getName();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case 556226896: {
                if (!var3_3.equals("isaccreportsubdefine")) break;
                var4_4 = 0;
                break;
            }
            case 1876504007: {
                if (!var3_3.equals("defaultstopreptime")) break;
                var4_4 = 1;
                break;
            }
            case 1320470564: {
                if (!var3_3.equals("contrlevelstopreptime")) break;
                var4_4 = 2;
                break;
            }
            case 2069809936: {
                if (!var3_3.equals("bodysysmanage")) break;
                var4_4 = 3;
                break;
            }
            case -1809858456: {
                if (!var3_3.equals("fixedfrequency")) break;
                var4_4 = 4;
                break;
            }
            case 275033389: {
                if (!var3_3.equals("fixedfrequencyendtype")) break;
                var4_4 = 5;
                break;
            }
            case 1922205492: {
                if (!var3_3.equals("fixedfrequencystarttype")) break;
                var4_4 = 6;
                break;
            }
            case 274533793: {
                if (!var3_3.equals("fixedfrequencyenddate")) break;
                var4_4 = 7;
                break;
            }
            case 1921705896: {
                if (!var3_3.equals("fixedfrequencystartdate")) break;
                var4_4 = 8;
                break;
            }
            case 275017920: {
                if (!var3_3.equals("fixedfrequencyendtime")) break;
                var4_4 = 9;
            }
        }
        switch (var4_4) {
            case 0: {
                newValue = (Boolean)e.getChangeSet()[0].getNewValue();
                comb = (ComboEdit)this.getControl("reportsublevel");
                timeEdit = (TimeEdit)this.getControl("contrlevelstopreptime");
                if (!newValue.booleanValue()) {
                    comb.setMustInput(false);
                    timeEdit.setMustInput(false);
                    break;
                }
                comb.setMustInput(true);
                timeEdit.setMustInput(true);
                break;
            }
            case 1: {
                isAccReportSubDefine = (Boolean)this.getModel().getValue("isaccreportsubdefine");
                time1 = (Integer)this.getModel().getValue("defaultstopreptime");
                time2 = (Integer)this.getModel().getValue("contrlevelstopreptime");
                if (!isAccReportSubDefine || time1 >= time2) break;
                this.getModel().setValue("defaultstopreptime", (Object)time2);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d7\u63a7\u5c42\u7ea7\u505c\u62a5\u65f6\u95f4\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u9ed8\u8ba4\u505c\u62a5\u65f6\u95f4\u3002", (String)"ReportPreparationEdit_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                break;
            }
            case 2: {
                fixedFrequency = (Boolean)this.getModel().getValue("fixedfrequency");
                if (Objects.nonNull(fixedFrequency) && fixedFrequency.booleanValue()) {
                    this.checkStopTime();
                    break;
                }
                isAccreportsubdefine1 = (Boolean)this.getModel().getValue("isaccreportsubdefine");
                time11 = (Integer)this.getModel().getValue("defaultstopreptime");
                time22 = (Integer)this.getModel().getValue("contrlevelstopreptime");
                if (!isAccreportsubdefine1 || time11 >= time22) break;
                this.getModel().setValue("contrlevelstopreptime", (Object)time11);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d7\u63a7\u5c42\u7ea7\u505c\u62a5\u65f6\u95f4\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u9ed8\u8ba4\u505c\u62a5\u65f6\u95f4\u3002", (String)"ReportPreparationEdit_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                break;
            }
            case 3: {
                sysManage = (DynamicObject)this.getModel().getValue("bodysysmanage");
                sysId = null;
                if (sysManage != null) {
                    sysId = sysManage.getLong("id");
                } else {
                    this.getModel().setValue("orgreporttype", (Object)0);
                }
                if (sysId == null) ** GOTO lbl96
                bodySysManage = FpmDataServiceHelper.getBodySystemByCache((Long)sysId);
                rateType = bodySysManage.getDynamicObject("ratetype");
                if (rateType != null) {
                    this.getModel().setValue("convexratetable", (Object)rateType.getLong("id"));
                }
                dynamicObjectCollection = bodySysManage.getDynamicObjectCollection("applyrereportentry");
                for (DynamicObject dyObj : dynamicObjectCollection) {
                    reportType = dyObj.getDynamicObject("rerporttype");
                    if (reportType == null || !"1".equals(reportType.getString("enable"))) continue;
                    reportTypeId = reportType.getLong("id");
                    this.getModel().setValue("orgreporttype", (Object)reportTypeId);
                    ** GOTO lbl98
                }
                ** GOTO lbl98
lbl96:
                // 1 sources

                this.getModel().setValue("convexratetable", (Object)0);
                this.getModel().setValue("orgreporttype", (Object)0);
lbl98:
                // 3 sources

                this.showExample();
                break;
            }
            case 4: {
                this.setValueIfNeed();
                this.updateMustInput(e);
                this.showExample();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.showExample(propName);
                if (!Objects.equals(propName, "fixedfrequencyendtime")) break;
                this.checkStopTime();
                break;
            }
        }
    }

    private void setValueIfNeed() {
        String fixedFrequencyEndType;
        Boolean fixedFrequency = (Boolean)this.getModel().getValue("fixedfrequency");
        if (fixedFrequency == null || !fixedFrequency.booleanValue()) {
            return;
        }
        String fixedFrequencyStartType = (String)this.getModel().getValue("fixedfrequencystarttype");
        if (EmptyUtil.isEmpty((String)fixedFrequencyStartType)) {
            this.getModel().setValue("fixedfrequencystarttype", (Object)FixedFrequencyType.LAST_MONTH.getNumber());
        }
        if (EmptyUtil.isEmpty((String)(fixedFrequencyEndType = (String)this.getModel().getValue("fixedfrequencyendtype")))) {
            this.getModel().setValue("fixedfrequencyendtype", (Object)FixedFrequencyType.LAST_MONTH.getNumber());
        }
    }

    private void checkStopTime() {
        Boolean subLevelDefine = (Boolean)this.getModel().getValue("isaccreportsubdefine");
        if (Objects.isNull(subLevelDefine) || !subLevelDefine.booleanValue()) {
            return;
        }
        int endTime = (Integer)this.getModel().getValue("fixedfrequencyendtime");
        int subLevelStopTIme = (Integer)this.getModel().getValue("contrlevelstopreptime");
        if (subLevelStopTIme > endTime) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d7\u63a7\u5c42\u7ea7\u505c\u62a5\u65f6\u95f4\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u56fa\u5b9a\u586b\u62a5\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReportPreparationEdit_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkFixedFrequencyDate(boolean showMessage) {
        String fixedFrequencyStartType = (String)this.getModel().getValue("fixedfrequencystarttype");
        String fixedFrequencyStartDate = (String)this.getModel().getValue("fixedfrequencystartdate");
        String fixedFrequencyEndType = (String)this.getModel().getValue("fixedfrequencyendtype");
        String fixedFrequencyEndDate = (String)this.getModel().getValue("fixedfrequencyenddate");
        if (!Objects.equals(fixedFrequencyStartType, fixedFrequencyEndType)) {
            return true;
        }
        if (EmptyUtil.isEmpty((String)fixedFrequencyStartDate) || EmptyUtil.isEmpty((String)fixedFrequencyEndDate)) {
            return true;
        }
        if (Integer.parseInt(fixedFrequencyStartDate) > Integer.parseInt(fixedFrequencyEndDate)) {
            if (showMessage) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u586b\u62a5\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u7b49\u4e8e\u56fa\u5b9a\u586b\u62a5\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReportPreparationEdit_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private boolean checkFixedFrequency(boolean showMessage) {
        String fixedFrequencyStartType = (String)this.getModel().getValue("fixedfrequencystarttype");
        String fixedFrequencyEndType = (String)this.getModel().getValue("fixedfrequencyendtype");
        if (Objects.equals(fixedFrequencyStartType, FixedFrequencyType.CURRENT_MONTH.getNumber()) && Objects.equals(fixedFrequencyEndType, FixedFrequencyType.LAST_MONTH.getNumber())) {
            if (showMessage) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u586b\u62a5\u5f00\u59cb\u6708\u4e3a\u5f53\u6708\uff0c\u671f\u95f4\u586b\u62a5\u7ed3\u675f\u6708\u4e0d\u5141\u8bb8\u4e3a\u4e0a\u6708\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReportPreparationEdit_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private void showExample() {
        this.showExample("");
    }

    private void showExample(String key) {
        QFilter qFilter;
        this.cleanTextDesc();
        if (!this.checkFixedFrequency(Objects.equals(key, "fixedfrequencystarttype") || Objects.equals(key, "fixedfrequencyendtype"))) {
            return;
        }
        if (!this.checkFixedFrequencyDate(Objects.equals(key, "fixedfrequencystartdate") || Objects.equals(key, "fixedfrequencyenddate"))) {
            return;
        }
        Boolean fixedFrequency = (Boolean)this.getModel().getValue("fixedfrequency");
        if (Objects.isNull(fixedFrequency) || !fixedFrequency.booleanValue()) {
            return;
        }
        String fixedFrequencyStartType = (String)this.getModel().getValue("fixedfrequencystarttype");
        String fixedFrequencyStartDate = (String)this.getModel().getValue("fixedfrequencystartdate");
        String fixedFrequencyEndType = (String)this.getModel().getValue("fixedfrequencyendtype");
        String fixedFrequencyEndDate = (String)this.getModel().getValue("fixedfrequencyenddate");
        Integer fixedFrequencyEndTime = (Integer)this.getModel().getValue("fixedfrequencyendtime");
        DynamicObject reportTypeDy = (DynamicObject)this.getModel().getValue("orgreporttype");
        DynamicObject bodySysDy = (DynamicObject)this.getModel().getValue("bodysysmanage");
        if (EmptyUtil.isEmpty((String)fixedFrequencyStartType) || EmptyUtil.isEmpty((String)fixedFrequencyStartDate) || EmptyUtil.isEmpty((String)fixedFrequencyEndType) || EmptyUtil.isEmpty((String)fixedFrequencyEndDate) || Objects.isNull(fixedFrequencyEndTime) || EmptyUtil.isEmpty((DynamicObject)reportTypeDy) || EmptyUtil.isEmpty((DynamicObject)bodySysDy)) {
            return;
        }
        FixedFrequencyType frequencyTypeStart = (FixedFrequencyType)ITypeEnum.getByNumber((String)fixedFrequencyStartType, FixedFrequencyType.class);
        if (EmptyUtil.isEmpty((Object)frequencyTypeStart)) {
            return;
        }
        FixedFrequencyType frequencyTypeEnd = (FixedFrequencyType)ITypeEnum.getByNumber((String)fixedFrequencyEndType, FixedFrequencyType.class);
        if (EmptyUtil.isEmpty((Object)frequencyTypeEnd)) {
            return;
        }
        String selectFields = String.join((CharSequence)",", "startdate", "id", "name");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{qFilter = new QFilter("bodysystem", "=", bodySysDy.getPkValue()).and(new QFilter("reporttype", "=", reportTypeDy.getPkValue())).and(new QFilter("periodtype", "=", (Object)reportTypeDy.getString("orgreportcycle"))).and("enable", "=", (Object)"1").and("startdate", ">", (Object)DateUtils.getCurrentDate())}, (String)"startdate", (int)3);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return;
        }
        int startDayOfDate = Integer.parseInt(fixedFrequencyStartDate);
        int endDayOfDate = Integer.parseInt(fixedFrequencyEndDate);
        FixedFrequencyDateReportGeneratePeriodStrategy.CalendarDate calendarDate = new FixedFrequencyDateReportGeneratePeriodStrategy.CalendarDate();
        String lineSeparator = System.getProperty("line.separator");
        LocalTime localTime = LocalTime.ofSecondOfDay(fixedFrequencyEndTime.intValue());
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject period : dynamicObjects) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(lineSeparator);
            }
            Date startDate = calendarDate.getDate(period.getDate("startdate"), frequencyTypeStart, startDayOfDate);
            String startDateStr = DateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd");
            Date endDate = calendarDate.getDate(period.getDate("startdate"), frequencyTypeEnd, endDayOfDate, localTime);
            String endDateStr = DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss");
            stringBuilder.append(period.getString("name")).append(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba1\u5212\u7533\u62a5\u5f00\u59cb\u65e5\u4e3a%1$s\uff0c\u7533\u62a5\u622a\u6b62\u65f6\u95f4\u4e3a%2$s", (String)"ReportPreparationEdit_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), startDateStr, endDateStr));
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"txtdesc", (Object)stringBuilder.toString());
    }

    private void cleanTextDesc() {
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"txtdesc", (Object)"");
    }

    private void updateMustInput(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Boolean newValue = (Boolean)changeData.getNewValue();
        this.setMustIfNeed(newValue);
    }

    private void setMustIfNeed(Boolean newValue) {
        if (newValue == null) {
            newValue = Boolean.FALSE;
        }
        ComboEdit startTypeCombo = (ComboEdit)this.getControl("fixedfrequencystarttype");
        ComboEdit startDateCombo = (ComboEdit)this.getControl("fixedfrequencystartdate");
        ComboEdit endTypeCombo = (ComboEdit)this.getControl("fixedfrequencyendtype");
        ComboEdit endDateCombo = (ComboEdit)this.getControl("fixedfrequencyenddate");
        startTypeCombo.setMustInput(newValue.booleanValue());
        startDateCombo.setMustInput(newValue.booleanValue());
        endTypeCombo.setMustInput(newValue.booleanValue());
        endDateCombo.setMustInput(newValue.booleanValue());
        TimeEdit timeEdit = (TimeEdit)this.getControl("fixedfrequencyendtime");
        timeEdit.setMustInput(newValue.booleanValue());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (Objects.equals(closedCallBackEvent.getActionId(), "genhisreport")) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            long reportPrepareId = this.getModel().getDataEntity().getLong("id");
            ReportPrepareHelper.generateHistoryReport(returnData, reportPrepareId, this.getView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)CONFIRM_SAVE_CALLBACK, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().setValue("enable", (Object)"0");
            this.getView().invokeOperation("save");
        }
    }
}

