/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.enums.OrgReportTypeCycleEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.formplugin.basesetting.FpmBaseFilterPlugin;
import kd.tmc.fpm.utils.report.ReportPrepareHelper;
import kd.tmc.fpm.utils.system.DefaultModelHelper;

public class ReportPreparationList
extends FpmBaseFilterPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        List modelIdList = ModelHelper.getAuthModelId();
        qFilters.add(new QFilter("bodysysmanage.id", "in", (Object)modelIdList));
    }

    @Override
    protected String getBodySystemProp() {
        return "bodysysmanage";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "genreportop": 
            case "genreportopnonmq": 
            case "genhisreport": {
                if (this.getSelectedRows().size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u6267\u884c\u3002", (String)"ReportPreparationList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (this.getSelectedRows().size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u6267\u884c\u751f\u6210\u8ba1\u5212\u7f16\u5236\u5355\u3002", (String)"ReportPreparationList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    private void showReportPeriod(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            return;
        }
        Long reportPrepareId = (Long)operationResult.getSuccessPkIds().get(0);
        String reportTypeIdProp = String.join((CharSequence)".", "orgreporttype", "id");
        String reportTypePeriodType = String.join((CharSequence)".", "orgreporttype", "orgreportcycle");
        String selectFields = String.join((CharSequence)",", "bodysysmanage", reportTypeIdProp, reportTypePeriodType);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fpm_reportpreparation", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportPrepareId)});
        if (dynamicObject == null) {
            return;
        }
        ListShowParameter listShowParameter = CoreShowFormHelper.createShowListForm((String)"fpm_member", (boolean)true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setShowFrequent(false);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowUsed(true);
        listShowParameter.setMustInput(true);
        listShowParameter.setHasRight(true);
        listShowParameter.setListFilterParameter(new ListFilterParameter(ListHelper.asList((Object[])new QFilter[]{new QFilter("dimtype", "=", (Object)DimensionType.PERIOD.getNumber())}), null));
        long systemId = dynamicObject.getLong("bodysysmanage");
        long reportTypeId = dynamicObject.getLong(reportTypeIdProp);
        String reportTypePeriodTypeStr = dynamicObject.getString(reportTypePeriodType);
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("status", "=", (Object)BillStatus.AUDITED.getNumber()));
        qFilters.add(new QFilter("bodysystem", "=", (Object)systemId));
        qFilters.add(new QFilter("reporttype", "=", (Object)reportTypeId));
        List list = ListHelper.asList((Object[])new String[]{reportTypePeriodTypeStr});
        if (Objects.equals(OrgReportTypeCycleEnum.WEEK.getValue(), reportTypePeriodTypeStr)) {
            list.add(PeriodType.YEAR_WEEK.getNumber());
        }
        qFilters.add(new QFilter("periodtype", "in", (Object)list));
        qFilters.add(new QFilter("enddate", "<=", (Object)ReportPrepareHelper.getCurrentAndBeforeDate(systemId, reportTypeId, reportTypePeriodTypeStr)));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "genhisreport"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("genreportop".equals(operateKey)) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                List errIdList = allErrorOrValidateInfo.stream().map(item -> Long.valueOf(item.getPkValue().toString())).collect(Collectors.toList());
                operationResult.getSuccessPkIds().removeAll(errIdList);
            }
        } else if (Objects.equals("genhisreport", operateKey)) {
            this.showReportPeriod(afterDoOperationEventArgs.getOperationResult());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("newExit".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (Objects.equals(actionId, "genhisreport")) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            Long primaryKeyValue = (Long)this.getSelectedRows().get(0).getPrimaryKeyValue();
            ReportPrepareHelper.generateHistoryReport(returnData, primaryKeyValue, this.getView());
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter showParameter = e.getParameter();
        Map customParams = showParameter.getCustomParams();
        if (customParams != null && customParams.size() == 0) {
            showParameter.setCustomParam("link", (Object)"1");
        }
    }

    @Override
    protected void initFilterItem(FilterContainerInitArgs args) {
        Long systemId;
        super.initFilterItem(args);
        if (EmptyUtil.isEmpty((Object)this.currModelId) && EmptyUtil.isNoEmpty((Long)(systemId = DefaultModelHelper.getBaseDataDefaultSystemId()))) {
            this.currModelId = systemId;
            this.getPageCache().put("bodysysmanage", this.currModelId.toString());
        }
        if (this.currModelId != null) {
            this.getPageCache().put("bodysysmanage", this.currModelId.toString());
            this.getView().getFormShowParameter().setCustomParam("bodysysmanage", (Object)this.currModelId.toString());
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("orgreporttype")) continue;
            commonFilterColumn.setDefaultValue("");
            if (this.currModelId == null) continue;
            DynamicObject bodySysManage = FpmDataServiceHelper.getBodySystemByCache((Long)Long.parseLong(this.currModelId.toString()));
            DynamicObjectCollection dynamicObjectCollection = bodySysManage.getDynamicObjectCollection("applyrereportentry");
            ArrayList<Long> orgReportTypeIds = new ArrayList<Long>(dynamicObjectCollection.size());
            for (DynamicObject dyObj : dynamicObjectCollection) {
                DynamicObject dynamicObject = dyObj.getDynamicObject("rerporttype");
                if (dynamicObject == null) continue;
                Long reportTypeId = dynamicObject.getLong("id");
                orgReportTypeIds.add(reportTypeId);
            }
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            if (this.currModelId == null) {
                commonFilterColumn.setComboItems(new ArrayList());
                return;
            }
            qFilterList.add(new QFilter("id", "in", orgReportTypeIds));
            commonFilterColumn.setComboItems(this.initOrgReportType(qFilterList.toArray(new QFilter[0])));
        }
    }

    private List<ComboItem> initOrgReportType(QFilter[] qFilterArr) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_orgreporttype", (String)"id,name", (QFilter[])qFilterArr);
        if (!CollectionUtils.isEmpty((Collection)queryResult)) {
            for (DynamicObject orgReportType : queryResult) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(orgReportType.getString("name")));
                item.setValue(orgReportType.getString("id"));
                items.add(item);
            }
        }
        return items;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (Objects.equals("tblnew", itemKey)) {
            evt.setCancel(true);
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setAppId("fpm");
            parameter.setFormId("fpm_reportpreparation");
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setCustomParam("bodysysmanage", (Object)this.getPageCache().get("bodysysmanage"));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newExit"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    @Override
    protected void fillPageData() {
    }

    @Override
    protected String getEntityName() {
        return null;
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("orgreporttype")) {
            args.getQfilters().clear();
            if (EmptyUtil.isEmpty((Object)this.currModelId) || Objects.equals("-1", this.currModelId)) {
                args.getQfilters().add(new QFilter("-1", "=", (Object)1));
                return;
            }
            DynamicObject bodySysManage = FpmDataServiceHelper.getBodySystemByCache((Long)Long.parseLong(this.currModelId.toString()));
            DynamicObjectCollection dynamicObjectCollection = bodySysManage.getDynamicObjectCollection("applyrereportentry");
            ArrayList<Long> orgReportTypeIds = new ArrayList<Long>(dynamicObjectCollection.size());
            for (DynamicObject dyObj : dynamicObjectCollection) {
                DynamicObject dynamicObject = dyObj.getDynamicObject("rerporttype");
                if (dynamicObject == null) continue;
                Long reportTypeId = dynamicObject.getLong("id");
                orgReportTypeIds.add(reportTypeId);
            }
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            qFilterList.add(new QFilter("id", "in", orgReportTypeIds));
            args.getQfilters().addAll(qFilterList);
        }
    }
}

