/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.OperationSymbolEnum;
import kd.tmc.fpm.common.enums.WaysEnum;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SubjectFormulaEdit
extends AbstractFormPlugin
implements ClickListener,
TreeNodeQueryListener,
TreeNodeClickListener {
    private static final String DISABLE_NODE_COLOR = "#c6c6c6";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView accountTreeView = (TreeView)this.getView().getControl("accounttreeviewap");
        accountTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView calcTreeView = (TreeView)this.getView().getControl("calcctreeviewap");
        calcTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object modelId = fsp.getCustomParam("model");
        Object subjectId = fsp.getCustomParam("id");
        String enableIdsStr = (String)fsp.getCustomParam("enableIds");
        List enableIds = Optional.ofNullable(enableIdsStr).map(ids -> JSONArray.parseArray((String)ids, Long.class)).orElseGet(ArrayList::new);
        this.initSubjectTree(modelId, subjectId, enableIds);
        Object express = fsp.getCustomParam("express");
        Object expressDesc = fsp.getCustomParam("expressDesc");
        this.getModel().setValue("expression", express);
        this.getModel().setValue("expressiondesc", expressDesc);
        this.getModel().setValue("expressiondesc_tag", expressDesc);
        TreeView accountTreeView = (TreeView)this.getView().getControl("accounttreeviewap");
        accountTreeView.setRootVisible(true);
        this.initOperationTree();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("comfirm".equals(operateKey)) {
            this.validatorExpress(this.getModel().getValue("expression"), args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String operateKey = op.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if ("comfirm".equals(operateKey) && result.isSuccess()) {
            final String express = (String)this.getModel().getValue("expression");
            final String expressDesc = (String)this.getModel().getValue("expressiondesc_tag");
            HashMap<String, String> resultMap = new HashMap<String, String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("expression", express);
                    this.put("expressiondesc", expressDesc);
                }
            };
            this.getView().returnDataToParent((Object)resultMap);
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String key;
        System.out.println(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "accounttreeviewap": {
                Long selectNodeId = Optional.ofNullable(evt.getNodeId()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> null);
                if (null == selectNodeId || evt.getParentNodeId().toString().isEmpty()) {
                    return;
                }
                String enableIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("enableIds");
                List enableIds = Optional.ofNullable(enableIdsStr).map(ids -> JSONArray.parseArray((String)ids, Long.class)).orElseGet(ArrayList::new);
                if (!enableIds.isEmpty() && !enableIds.contains(selectNodeId)) {
                    return;
                }
                String formula = Optional.ofNullable(this.getModel().getValue("expression")).map(Objects::toString).orElseGet(() -> "");
                if (!(formula.isEmpty() || formula.endsWith("+") || formula.endsWith("-"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b97\u6570\u7b26\u53f7\uff0c\u6682\u65f6\u4ec5\u652f\u6301\u201c+\u201d\u548c\u201c-\u201d\u3002", (String)"SubjectFormulaEdit_01", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String newValue = String.format("%s[%s]", formula, selectNodeId);
                this.getModel().setValue("expression", (Object)newValue);
                break;
            }
            case "calcctreeviewap": {
                TreeView calcTreeView = (TreeView)this.getView().getControl("calcctreeviewap");
                String selectId = Optional.ofNullable(evt.getNodeId()).map(Objects::toString).orElseGet(() -> null);
                if (selectId.startsWith("sub") || selectId.startsWith("root")) break;
                String symbol = Optional.ofNullable(calcTreeView.getTreeState().getFocusNode().get("text")).map(Objects::toString).orElseGet(() -> "");
                String expressTag = Optional.ofNullable(this.getModel().getValue("expression")).map(Objects::toString).orElseGet(() -> "");
                if (expressTag.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u5b57\u6216\u9009\u62e9\u79d1\u76ee\u6210\u5458\uff0c\u518d\u8bbe\u7f6e\u8fd0\u7b97\u7b26\u3002", (String)"SubjectFormulaEdit_07", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    break;
                }
                String value = String.format("%s%s", expressTag, symbol);
                this.getModel().setValue("expression", (Object)value);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if ("expression".equals(name)) {
            if (newValue.toString().length() > 2000) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u957f\u5ea6\u5c0f\u4e8e\u7b49\u4e8e2000\u4e2a\u5b57\u7b26\u3002", (String)"SubjectFormulaEdit_08", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("expression", oldValue == null ? "" : oldValue);
                return;
            }
            this.validatorExpress(newValue, null);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    private void initSubjectTree(Object modelId, Object subjectId, List<Long> enableIds) {
        String rootName = ResManager.loadKDString((String)"\u79d1\u76ee", (String)"DimSysImportBasePlugin_15", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        TreeNode root = new TreeNode("", BigDecimal.ZERO.toString(), rootName);
        Map<String, TreeNode> allNode = this.getSubjectAllNodeByModelId(modelId, subjectId);
        for (Map.Entry<String, TreeNode> entry : allNode.entrySet()) {
            TreeNode node = entry.getValue();
            if (!"0".equals(node.getId()) && node.getId() != null) continue;
            root = node;
            break;
        }
        this.buildTree(allNode, root, enableIds);
        root.setParentid("");
        TreeView treeleft = (TreeView)this.getView().getControl("accounttreeviewap");
        treeleft.deleteAllNodes();
        treeleft.updateNode(root);
        treeleft.addNode(root);
        treeleft.expand(root.getId());
    }

    private void initOperationTree() {
        String rootName = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u7b26\u53f7", (String)"SubjectFormulaEdit_04", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        TreeNode root = new TreeNode("", String.format("%s-%s", "root", BigDecimal.ZERO.toString()), rootName);
        ArrayList<TreeNode> subNodes = new ArrayList<TreeNode>(10);
        TreeNode calcSummaryNode = this.buildSummarySubTree(subNodes, OperationSymbolEnum.getValueOfAllElement(), ResManager.loadKDString((String)"\u8ba1\u7b97\u7b26\u53f7", (String)"SubjectFormulaEdit_05", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), root);
        root.setChildren(subNodes);
        TreeView tree = (TreeView)this.getView().getControl("calcctreeviewap");
        tree.updateNode(root);
        tree.addNode(root);
        tree.expand(calcSummaryNode.getId());
        tree.expand(root.getId());
    }

    private TreeNode buildSummarySubTree(List<TreeNode> subNodes, String[] symbols, String name, TreeNode root) {
        String summaryId = String.valueOf(DB.genGlobalLongId());
        TreeNode summaryNode = new TreeNode(root.getId(), String.format("%s-%s", "sub", summaryId), name);
        ArrayList<TreeNode> sonNodes = new ArrayList<TreeNode>(symbols.length);
        for (String value : symbols) {
            TreeNode node = new TreeNode(summaryId, String.valueOf(DB.genGlobalLongId()), value);
            sonNodes.add(node);
        }
        summaryNode.setChildren(sonNodes);
        subNodes.add(summaryNode);
        return summaryNode;
    }

    private Map<String, TreeNode> getSubjectAllNodeByModelId(Object modelId, Object subjectId) {
        LinkedHashMap<String, TreeNode> allNode = new LinkedHashMap<String, TreeNode>(16);
        allNode.put("0", this.createTreeNode(null));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("bodysysmanage", "=", modelId));
        qFilters.add(new QFilter("dimtype", "=", (Object)DimsionEnums.SUBJECT.getNumber()));
        if (null != subjectId) {
            qFilters.add(new QFilter("id", "!=", subjectId));
        }
        String selectFields = "id as id,name as name,number as number,parent.id as parentid,isleaf,longnumber,level as dseq,level,sourceid,sourceparentid";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SubjectFormula.getSubjectTreeOfFormula", (String)"fpm_member", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"level");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (!StringUtils.isNotEmpty((CharSequence)row.getString("id"))) continue;
                TreeNode treeNode = this.createTreeNode(row);
                allNode.put(row.getString("id"), treeNode);
            }
        }
        return allNode;
    }

    private TreeNode createTreeNode(Row nodeData) {
        TreeNode node = new TreeNode();
        String rootName = ResManager.loadKDString((String)"\u79d1\u76ee", (String)"DimSysImportBasePlugin_15", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        node.setId(nodeData == null ? "0" : nodeData.getString("id"));
        node.setParentid(nodeData == null ? "" : nodeData.getString("parentid"));
        node.setText(nodeData == null ? rootName : nodeData.getString("name"));
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("id", nodeData == null ? "0" : nodeData.getString("id"));
        data.put("name", nodeData == null ? rootName : nodeData.getString("name"));
        data.put("number", nodeData == null ? "ROOT" : nodeData.getString("number"));
        data.put("parentid", nodeData == null ? "" : nodeData.getString("parentid"));
        data.put("sourceid", nodeData == null ? "" : nodeData.getLong("sourceid"));
        data.put("sourceparentid", nodeData == null ? "" : nodeData.getLong("sourceparentid"));
        data.put("isleaf", nodeData == null ? Boolean.FALSE : nodeData.getBoolean("isleaf"));
        data.put("level", nodeData == null ? Integer.valueOf(0) : nodeData.getInteger("level"));
        node.setData(data);
        return node;
    }

    private void buildTree(Map<String, TreeNode> map, TreeNode root, List<Long> enableIds) {
        for (Map.Entry<String, TreeNode> entry : map.entrySet()) {
            String id = entry.getKey();
            TreeNode node = entry.getValue();
            String partntId = node.getParentid();
            if (!enableIds.isEmpty() && !enableIds.contains(Long.valueOf(id))) {
                node.setColor(DISABLE_NODE_COLOR);
            }
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)partntId)) continue;
            if (!"0".equals(partntId) && map.get(partntId) != null) {
                TreeNode parent = map.get(partntId);
                parent.addChild(node);
                continue;
            }
            if (id.equals(root.getId())) continue;
            root.addChild(node);
        }
    }

    private Set<Long> initExpressDesc(Set<Long> ids, String express) {
        DynamicObjectCollection datas = null;
        if (!express.isEmpty()) {
            datas = QueryServiceHelper.query((String)"fpm_member", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            for (DynamicObject data : datas) {
                String id = data.getString("id");
                String name = data.getString("name");
                express = express.replace(id, name);
            }
        }
        this.getModel().setValue("expressiondesc", (Object)express);
        this.getModel().setValue("expressiondesc_tag", (Object)express);
        return datas == null ? ids : datas.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
    }

    private Pair<Set<Long>, Boolean> checkLegitimacyOfExpress(String express, BeforeDoOperationEventArgs opEvent) {
        HashSet<Long> subjectIds = new HashSet<Long>(16);
        Boolean checkResult = Boolean.TRUE;
        if (opEvent != null && (express.endsWith("+") || express.endsWith("-"))) {
            return new MutablePair(null, (Object)Boolean.FALSE);
        }
        if (express.contains("+-") || express.contains("-+") || express.contains("++") || express.contains("--")) {
            return new MutablePair(null, (Object)Boolean.FALSE);
        }
        String regex = "[\\+|\\-]";
        String[] expressUnits = express.split(regex);
        String isDigitalRegex = "^[0-9]*$";
        String isDoubleBracketRegex = "^(\\[)[0-9]+(\\])$";
        for (String expressUnit : expressUnits) {
            if (expressUnit.isEmpty()) {
                return new MutablePair(null, (Object)Boolean.FALSE);
            }
            boolean isDigit = expressUnit.matches(isDigitalRegex);
            if (isDigit) continue;
            boolean isDoubleBracket = expressUnit.matches(isDoubleBracketRegex);
            if (isDoubleBracket) {
                subjectIds.add(Long.valueOf(Optional.ofNullable(expressUnit).map(o -> o.replaceAll("\\[|]", "")).orElseGet(() -> "")));
                continue;
            }
            checkResult = Boolean.FALSE;
            break;
        }
        return new MutablePair(subjectIds, (Object)checkResult);
    }

    private void validatorExpress(Object express, BeforeDoOperationEventArgs opEvent) {
        String expressStr = Optional.ofNullable(express).map(Objects::toString).orElseGet(() -> null);
        Pair<Set<Long>, Boolean> result = this.checkLegitimacyOfExpress(expressStr, opEvent);
        this.getModel().setValue("expression", (Object)expressStr);
        if (!((Boolean)result.getRight()).booleanValue()) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u7684\u6b63\u786e\u6027\u3002\u53ef\u80fd\u51fa\u73b0\u7684\u60c5\u51b5\u5305\u62ec\uff1a\u8fde\u7eed\u7684\u7b97\u672f\u7b26\u53f7\u3001\u201c%1$s\u201d\u4e0d\u6210\u5bf9\u51fa\u73b0\u3001\u201c%2$s\u201d\u4e2d\u5305\u542b\u7684\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"SubjectFormulaEdit_02", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), "[]", "[]");
            this.showErrorMsg(opEvent, errMsg);
            return;
        }
        boolean circleCheck = this.checkCircleFormulaEdit(expressStr);
        if (!circleCheck) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            DynamicObject tSubjectMem = QueryServiceHelper.queryOne((String)"fpm_member", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", fsp.getCustomParam("model")).and("dimtype", "=", (Object)DimsionEnums.SUBJECT.getNumber()).and("id", "=", fsp.getCustomParam("id"))});
            String errMsg = String.format(ResManager.loadKDString((String)"\u5faa\u73af\u516c\u5f0f\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a\u6240\u9009\u79d1\u76ee\u7684\u516c\u5f0f\u4e2d\u5305\u542b\u5f53\u524d\u201c%s\u201d\u79d1\u76ee\u3002", (String)"SubjectFormulaEdit_09", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), tSubjectMem.getString("name"));
            this.showErrorMsg(opEvent, errMsg);
            return;
        }
        Set<Long> lookupIds = this.initExpressDesc((Set)result.getLeft(), expressStr);
        if (lookupIds.size() != ((Set)result.getLeft()).size()) {
            Set loseIds = (Set)result.getLeft();
            loseIds.removeAll(lookupIds);
            String loseIdStr = loseIds.stream().map(o -> Optional.ofNullable(o).map(Objects::toString).orElseGet(() -> "")).collect(Collectors.joining(", "));
            String errMsg = String.format(ResManager.loadKDString((String)"ID\uff1a%s\u5bf9\u5e94\u7684\u79d1\u76ee\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u3002", (String)"SubjectFormulaEdit_03", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), loseIdStr);
            Optional.ofNullable(opEvent).ifPresent(event -> event.setCancel(true));
            this.showErrorMsg(opEvent, errMsg);
            return;
        }
    }

    private boolean checkCircleFormulaEdit(String expressStr) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object modelId = fsp.getCustomParam("model");
        Long subjectId = Long.valueOf(fsp.getCustomParam("id").toString());
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"fpm_member", (String)"id,parent.id,ways,formulavalue", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", modelId).and("dimtype", "=", (Object)DimsionEnums.SUBJECT.getNumber())});
        List<DynamicObject> doSubjectList = datas.stream().collect(Collectors.toList());
        String cacheSubjectStr = (String)fsp.getCustomParam("cachesubject");
        if (cacheSubjectStr != null) {
            Map cacheSubjectMap = (Map)JSON.parse((String)cacheSubjectStr);
            ArrayList<DynamicObject> subjectList = new ArrayList<DynamicObject>();
            for (DynamicObject data : datas) {
                Object cachesubject = cacheSubjectMap.get(data.getLong("id"));
                if (cachesubject != null) {
                    Map subject = (Map)cachesubject;
                    data.set("parent.id", subject.get("parent.id"));
                    data.set("ways", subject.get("ways"));
                    data.set("formulavalue", subject.get("formulavalue"));
                }
                subjectList.add(data);
            }
            doSubjectList = subjectList;
        }
        return this.getCircleFormulaIds(doSubjectList, subjectId, this.getFormulaValueIds(expressStr));
    }

    private boolean getCircleFormulaIds(List<DynamicObject> datas, Long subjectId, Set<Long> ids) {
        List tMemberList = datas.stream().filter(item -> ids.contains(item.getLong("id"))).collect(Collectors.toList());
        Iterator iterator = tMemberList.iterator();
        if (iterator.hasNext()) {
            DynamicObject tMember = (DynamicObject)iterator.next();
            ids.remove(tMember.getLong("id"));
            ids.addAll(this.getFormulaValueIds(tMember.getString("formulavalue")));
            if (WaysEnum.SUMMARY_ITEM.getValue().equals(tMember.getString("ways"))) {
                ids.addAll(datas.stream().filter(item -> item.getLong("parent.id") == tMember.getLong("id")).map(v -> v.getLong("id")).collect(Collectors.toList()));
            }
            if (ids.contains(subjectId)) {
                return false;
            }
            return this.getCircleFormulaIds(datas, subjectId, ids);
        }
        return true;
    }

    private Set<Long> getFormulaValueIds(String express) {
        HashSet<Long> subjectIds = new HashSet<Long>(1);
        String regex = "[\\+|\\-]";
        if (StringUtils.isEmpty((CharSequence)express)) {
            return subjectIds;
        }
        String[] expressUnits = express.split(regex);
        String isDigitalRegex = "^[0-9]*$";
        String isDoubleBracketRegex = "^(\\[)[0-9]+(\\])$";
        for (String expressUnit : expressUnits) {
            if (expressUnit.isEmpty() || expressUnit.matches(isDigitalRegex) || !expressUnit.matches(isDoubleBracketRegex)) continue;
            subjectIds.add(Long.valueOf(Optional.ofNullable(expressUnit).map(o -> o.replaceAll("\\[|]", "")).orElseGet(() -> "")));
        }
        return subjectIds;
    }

    private void showErrorMsg(BeforeDoOperationEventArgs opEvent, String errMsg) {
        if (opEvent == null) {
            this.getModel().setValue("expressiondesc", (Object)errMsg);
            this.getModel().setValue("expressiondesc_tag", (Object)errMsg);
        } else {
            this.getView().showErrorNotification(errMsg);
            opEvent.setCancel(true);
        }
    }
}

