/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.bd.TmcBaseDataEdit;
import kd.tmc.fpm.common.bean.CurrencyMapConfig;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.property.SummaryConfigProp;
import kd.tmc.fpm.formplugin.domain.BaseMemberTree;
import kd.tmc.fpm.formplugin.helper.F7ListenerHelper;
import org.apache.commons.collections.CollectionUtils;

public class SummaryConfigEdit
extends TmcBaseDataEdit {
    private static final String DISABLE_VALUE_FOR_REFRESH = "DISABLE_VALUE_FOR_REFRESH";
    private static final String PROPERTY_CHANGE_IS_FROM_CALL_BACK = "PROPERTY_CHANGE_IS_FROM_CALL_BACK";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"expandall", "expandalldes", "closeall", "closealldes", "sum_currencymapcase"});
        this.addItemClickListeners(new String[]{"batchset"});
        this.initF7();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String modelId = parentView.getPageCache().get("SUMMARY_CONFIG_BODY_SYS_ID_KEY");
            if (Objects.isNull(modelId)) {
                return;
            }
            if (modelId.contains("[")) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
                modelId = modelIdArr[0].trim();
            }
            if (!StringUtils.isNumeric((CharSequence)modelId)) {
                return;
            }
            this.getModel().setValue("bodysys", (Object)modelId);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        boolean flag;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"closeall", "closealldes"});
        IDataModel model = this.getModel();
        Object value = model.getValue("bodysys");
        if (Objects.isNull(value)) {
            return;
        }
        DynamicObject bodySys = (DynamicObject)value;
        String enable = (String)model.getValue("enable");
        String number = (String)model.getValue("number");
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        boolean existConfig = QueryServiceHelper.exists((String)"fpm_summaryconfig", (QFilter[])new QFilter[]{qFilter});
        boolean bl = flag = !existConfig;
        if (flag) {
            this.doGrabReportOrgByBodySys(bodySys);
        }
        if (!flag && StringUtils.equals((CharSequence)enable, (CharSequence)"1")) {
            this.getPageCache().put(DISABLE_VALUE_FOR_REFRESH, DISABLE_VALUE_FOR_REFRESH);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"needlock", (Object)true);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        IDataEntityProperty property = args.getProperty();
        switch (property.getName()) {
            case "sum_currencymapcase": {
                this.cleanCaseIfNeed(args);
                break;
            }
            case "sum_issumaudit": {
                this.triggerByIsSumAudit(args);
            }
        }
    }

    private void triggerByIsSumAudit(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        Boolean isSumAudit = (Boolean)changeData.getNewValue();
        if (!isSumAudit.booleanValue()) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"sum_currencymapcase", null, (int)rowIndex);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "expandall": 
            case "expandalldes": {
                this.expandAll();
                break;
            }
            case "closeall": 
            case "closealldes": {
                this.closeAll(true);
                break;
            }
            case "sum_currencymapcase": {
                this.showCurrencyMapConfigForm();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "batchset": {
                this.showBatchSetForm(args);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (Objects.isNull(operationResult) || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "batchset": {
                this.batchSetEntry(closedCallBackEvent);
                break;
            }
            case "sum_currencymapcase": {
                this.setCurrencyMapCase(closedCallBackEvent.getReturnData());
            }
        }
    }

    private void cleanCaseIfNeed(PropertyChangedArgs args) {
        if (Objects.equals(this.getView().getPageCache().get(PROPERTY_CHANGE_IS_FROM_CALL_BACK), PROPERTY_CHANGE_IS_FROM_CALL_BACK)) {
            this.getView().getPageCache().remove(PROPERTY_CHANGE_IS_FROM_CALL_BACK);
            return;
        }
        ChangeData[] changeSet = args.getChangeSet();
        ChangeData changeData = changeSet[0];
        String newValue = (String)changeData.getNewValue();
        if (EmptyUtil.isNoEmpty((String)newValue)) {
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        this.getModel().setValue("sum_currencymapcasereal_tag", (Object)"", entryCurrentRowIndex);
    }

    private void showCurrencyMapConfigForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fpm_currencymapconfig");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject dynamicObject = dataEntity.getDynamicObject("bodysys");
        if (Objects.isNull(dynamicObject)) {
            this.showBodySysNotification();
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("treeentryentity");
        DynamicObject entry = (DynamicObject)dynamicObjectCollection.get(entryCurrentRowIndex);
        String currencyMapConfigJson = entry.getString("sum_currencymapcasereal_tag");
        if (StringUtils.isEmpty((CharSequence)entry.getString("sum_currencymapcase"))) {
            CurrencyMapConfig currencyMapConfig = new CurrencyMapConfig((Long)dynamicObject.getPkValue());
            currencyMapConfigJson = SerializationUtils.toJsonString((Object)currencyMapConfig);
        }
        formShowParameter.setCustomParam("CURRENCY_MAP_CONFIG", (Object)currencyMapConfigJson);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sum_currencymapcase"));
        Boolean needLock = (Boolean)this.getModel().getValue("needlock");
        if (needLock != null && needLock.booleanValue()) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        this.getView().showForm(formShowParameter);
    }

    private void setCurrencyMapCase(Object returnData) {
        if (!String.class.isInstance(returnData)) {
            return;
        }
        String currencyMapConfigJson = (String)returnData;
        CurrencyMapConfig currencyMapConfig = (CurrencyMapConfig)SerializationUtils.fromJsonString((String)currencyMapConfigJson, CurrencyMapConfig.class);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        this.getView().getPageCache().put(PROPERTY_CHANGE_IS_FROM_CALL_BACK, PROPERTY_CHANGE_IS_FROM_CALL_BACK);
        this.getModel().setValue("sum_currencymapcase", (Object)String.join((CharSequence)":", currencyMapConfig.getNumber(), currencyMapConfig.getName()), entryCurrentRowIndex);
        this.getModel().setValue("sum_currencymapcasereal_tag", (Object)currencyMapConfigJson, entryCurrentRowIndex);
    }

    private void batchSetEntry(ClosedCallBackEvent closedCallBackEvent) {
        String jsonString = (String)closedCallBackEvent.getReturnData();
        if (EmptyUtil.isEmpty((String)jsonString)) {
            return;
        }
        Map resultMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("treeentryentity");
        for (int selectIndex : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectIndex);
            this.setSummaryConfigValue(model, dynamicObject, selectIndex, resultMap);
        }
    }

    private void setSummaryConfigValue(IDataModel model, DynamicObject dynamicObject, int index, Map<Object, Object> resultMap) {
        DynamicObject orgObj = dynamicObject.getDynamicObject("sum_reportorg");
        boolean isLeaf = orgObj.getBoolean("isleaf");
        for (Map.Entry entry : SummaryConfigProp.BATCH_SET_FIELDS_FOR_LEAF.entrySet()) {
            String prop = String.join((CharSequence)"_", "sum", (CharSequence)entry.getKey());
            if (isLeaf || !((Boolean)entry.getValue()).booleanValue()) continue;
            model.setValue(prop, resultMap.get(entry.getKey()), index);
        }
    }

    private void showBatchSetForm(BeforeDoOperationEventArgs args) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (Objects.isNull(selectRows) || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6279\u91cf\u8bbe\u7f6e\u7684\u8bb0\u5f55\u3002", (String)"SummaryConfigEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject bodySys = this.getModel().getDataEntity().getDynamicObject("bodysys");
        if (Objects.isNull(bodySys)) {
            this.showBodySysNotification();
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_summaryconfigbatchset");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("bodysysid", bodySys.getPkValue());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchset"));
        this.getView().showForm(showParameter);
    }

    private void doGrabReportOrgByBodySys(DynamicObject newValue) {
        DynamicObject bodySysNewObject = newValue;
        Long bodySysPkValue = (Long)bodySysNewObject.getPkValue();
        List<DynamicObject> reportOrgByBodySys = this.getReportOrgByBodySys(bodySysPkValue);
        IDataModel model = this.getModel();
        model.deleteEntryData("treeentryentity");
        List<BaseMemberTree> baseMemberTreeList = BaseMemberTree.convertToBaseMemberTree(reportOrgByBodySys);
        this.setEntryReportOrgField(baseMemberTreeList);
        this.closeAll(false);
    }

    private void expandAll() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        treeEntryGrid.setCollapse(false);
        this.getView().updateView("treeentryentity");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"expandall", "expandalldes"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"closeall", "closealldes"});
        this.disableIfNeed();
    }

    private void closeAll(boolean needUpdateView) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        if (needUpdateView) {
            treeEntryGrid.setCollapse(true);
            this.getView().updateView("treeentryentity");
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"expandall", "expandalldes"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"closeall", "closealldes"});
        this.disableIfNeed();
    }

    private void disableIfNeed() {
        String disable = this.getPageCache().get(DISABLE_VALUE_FOR_REFRESH);
        if (EmptyUtil.isEmpty((String)disable)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"needlock", (Object)false);
            return;
        }
    }

    private List<DynamicObject> getReportOrgByBodySys(Long bodySysPkValue) {
        String parentIdProp = "parent.id";
        String selectFields = String.join((CharSequence)",", "id", "number", "name", "level", parentIdProp, "isleaf");
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)bodySysPkValue).and("dimtype", "=", (Object)DimsionEnums.ORG.getNumber()).and(new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()));
        DynamicObjectCollection reportOrgDyColl = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"sortcode");
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)DimsionEnums.ORG.getMetadata());
        HashMap leaf2ParentIdMap = new HashMap(reportOrgDyColl.size() / 2);
        HashMap orgId2DyMap = new HashMap(reportOrgDyColl.size());
        List<DynamicObject> reportOrgDyList = reportOrgDyColl.stream().map(arg_0 -> SummaryConfigEdit.lambda$getReportOrgByBodySys$0((DynamicObjectType)orgType, parentIdProp, leaf2ParentIdMap, orgId2DyMap, arg_0)).collect(Collectors.toList());
        reportOrgDyList.forEach(arg_0 -> SummaryConfigEdit.lambda$getReportOrgByBodySys$1(leaf2ParentIdMap, orgId2DyMap, (DynamicObjectType)orgType, arg_0));
        return reportOrgDyList;
    }

    private void setEntryReportOrgField(List<BaseMemberTree> baseMemberTreeList) {
        IDataModel model = this.getModel();
        boolean dataChanged = model.getDataChanged();
        for (BaseMemberTree baseMemberTree : baseMemberTreeList) {
            int newEntryRow = model.createNewEntryRow("treeentryentity");
            this.setValue(model, baseMemberTree, newEntryRow);
            List<BaseMemberTree> children = baseMemberTree.getChildren();
            if (!CollectionUtils.isNotEmpty(children)) continue;
            this.createChildrenEntryAndSet(children, newEntryRow);
        }
        if (!dataChanged) {
            model.setDataChanged(false);
        }
    }

    private void createChildrenEntryAndSet(List<BaseMemberTree> children, int parentIndex) {
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        IDataModel model = this.getModel();
        for (BaseMemberTree baseMemberTree : children) {
            int insertEntryRow = model.insertEntryRow("treeentryentity", parentIndex);
            this.setValue(model, baseMemberTree, insertEntryRow);
            List<BaseMemberTree> childList = baseMemberTree.getChildren();
            if (!CollectionUtils.isNotEmpty(childList)) continue;
            this.createChildrenEntryAndSet(childList, insertEntryRow);
        }
    }

    private void setValue(IDataModel model, BaseMemberTree baseMemberTree, int newEntryRow) {
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"sum_reportorg", (Object)baseMemberTree.getId(), (int)newEntryRow);
    }

    private void initF7() {
        for (String field : SummaryConfigProp.F7_FIELDS) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(field);
            basedataEdit.addBeforeF7SelectListener(F7ListenerHelper.sumPlanBeforeF7SelectListener(this.getModel(), this.getView()));
        }
    }

    private void showBodySysNotification() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u4f53\u7cfb\u3002", (String)"SummaryConfigEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private static /* synthetic */ void lambda$getReportOrgByBodySys$1(Map leaf2ParentIdMap, Map orgId2DyMap, DynamicObjectType orgType, DynamicObject dy) {
        Long id = dy.getLong("id");
        if (leaf2ParentIdMap.containsKey(id)) {
            Long parentId = (Long)leaf2ParentIdMap.get(id);
            if (orgId2DyMap.containsKey(parentId)) {
                DynamicObject parentOrgDy = (DynamicObject)orgId2DyMap.get(parentId);
                dy.set("parent", (Object)parentOrgDy);
            } else {
                DynamicObject parentOrgDy = (DynamicObject)orgType.createInstance();
                parentOrgDy.set("id", (Object)parentId);
                dy.set("parent", (Object)parentOrgDy);
            }
        }
    }

    private static /* synthetic */ DynamicObject lambda$getReportOrgByBodySys$0(DynamicObjectType orgType, String parentIdProp, Map leaf2ParentIdMap, Map orgId2DyMap, DynamicObject dy) {
        DynamicObject newDy = (DynamicObject)orgType.createInstance();
        Long id = dy.getLong("id");
        newDy.set("id", (Object)id);
        newDy.set("number", (Object)dy.getString("number"));
        newDy.set("name", (Object)dy.getString("name"));
        newDy.set("level", (Object)dy.getInt("level"));
        newDy.set("isleaf", (Object)dy.getBoolean("isleaf"));
        Long parentId = dy.getLong(parentIdProp);
        if (EmptyUtil.isNoEmpty((Long)parentId)) {
            leaf2ParentIdMap.put(id, parentId);
        }
        orgId2DyMap.put(id, newDy);
        return newDy;
    }
}

