/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fpm.business.domain.enums.ReportValueFormulaTypeEnum;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ValueFormulaEdit
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener {
    private static final String DISABLE_NODE_COLOR = "#c6c6c6";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView accountTreeView = (TreeView)this.getView().getControl("accounttreeviewap");
        accountTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView calcTreeView = (TreeView)this.getView().getControl("calcctreeviewap");
        calcTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object modelId = fsp.getCustomParam("model");
        Object id = fsp.getCustomParam("id");
        String enableIdsStr = (String)fsp.getCustomParam("enableIds");
        List enableIds = Optional.ofNullable(enableIdsStr).map(ids -> JSONArray.parseArray((String)ids, Long.class)).orElseGet(ArrayList::new);
        this.initSubjectTree(modelId, id, enableIds);
        Object express = fsp.getCustomParam("expression");
        Object expressDesc = fsp.getCustomParam("expressiondesc");
        this.getModel().setValue("expression", express);
        this.getModel().setValue("expressiondesc", expressDesc);
        this.getModel().setValue("expressiondesc_tag", expressDesc);
        TreeView accountTreeView = (TreeView)this.getView().getControl("accounttreeviewap");
        accountTreeView.setRootVisible(true);
        this.initOperationTree();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "confirm": {
                this.validatorExpress(this.getModel().getValue("expression"), args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String operateKey = op.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        switch (operateKey) {
            case "confirm": {
                if (!result.isSuccess()) break;
                String express = (String)this.getModel().getValue("expression");
                String expressDesc = (String)this.getModel().getValue("expressiondesc");
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("expression", express);
                resultMap.put("expressiondesc", expressDesc);
                this.getView().returnDataToParent(resultMap);
                this.getView().close();
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String key;
        TreeView control = (TreeView)evt.getSource();
        if (Objects.isNull(control)) {
            return;
        }
        TreeView.TreeState treeState = control.getTreeState();
        if (Objects.isNull(treeState)) {
            return;
        }
        Map focusNode = treeState.getFocusNode();
        if (MapUtils.isEmpty((Map)focusNode)) {
            return;
        }
        switch (key = control.getKey()) {
            case "accounttreeviewap": {
                String selectNodeId = Optional.ofNullable(evt.getNodeId()).map(String::valueOf).orElse(null);
                if (null == selectNodeId || evt.getParentNodeId().toString().isEmpty()) {
                    return;
                }
                String enableIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("enableIds");
                List enableIds = Optional.ofNullable(enableIdsStr).map(ids -> JSONArray.parseArray((String)ids, String.class)).orElseGet(ArrayList::new);
                if (!enableIds.isEmpty() && !enableIds.contains(selectNodeId)) {
                    return;
                }
                String formula = Optional.ofNullable(this.getModel().getValue("expression")).map(Objects::toString).orElse("").replaceAll(" ", "");
                if (!(StringUtils.isEmpty((CharSequence)formula) || formula.endsWith("+") || formula.endsWith("-") || formula.endsWith("*") || formula.endsWith("/") || formula.endsWith("(") || formula.endsWith(")"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b97\u6570\u7b26\u53f7\u3002", (String)"ValueFormulaEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String newValue = String.format("%s%s", formula, selectNodeId);
                this.getModel().setValue("expression", (Object)newValue);
                break;
            }
            case "calcctreeviewap": {
                TreeView calcTreeView = (TreeView)this.getView().getControl("calcctreeviewap");
                String selectId = Optional.ofNullable(evt.getNodeId()).map(Objects::toString).orElse("");
                if (selectId.startsWith("sub") || selectId.startsWith("root")) break;
                String symbol = Optional.ofNullable(calcTreeView.getTreeState().getFocusNode().get("text")).map(Objects::toString).orElse("");
                String expressTag = Optional.ofNullable(this.getModel().getValue("expression")).map(Objects::toString).orElse("").replaceAll(" ", "");
                if (StringUtils.isEmpty((CharSequence)expressTag) && !StringUtils.equals((CharSequence)symbol, (CharSequence)"(")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6570\u5b57\u6216\u8005\u9009\u62e9\u6307\u6807\u9879\u5728\u8bbe\u7f6e\u8fd0\u7b97\u7b26\u3002", (String)"SubjectFormulaEdit_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    break;
                }
                String expressTagValue = Optional.ofNullable(this.getModel().getValue("expressiondesc")).map(Objects::toString).orElse("").replaceAll(" ", "");
                String value = String.format("%s%s", expressTag, symbol);
                String valueDesc = String.format("%s%s", expressTagValue, symbol);
                this.getModel().setValue("expression", (Object)value);
                this.getModel().setValue("expressiondesc", (Object)valueDesc);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if ("expression".equals(name)) {
            if (newValue.toString().length() > 255) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u957f\u5ea6\u8d85\u51fa 255 \u4e2a\u5b57\u7b26", (String)"SubjectFormulaEdit_11", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("expression", oldValue == null ? "" : oldValue);
                return;
            }
            this.validatorExpress(newValue, null);
        }
    }

    private void initSubjectTree(Object modelId, Object subjectId, List<Long> enableIds) {
        TreeNode root = new TreeNode("", BigDecimal.ZERO.toString(), ResManager.loadKDString((String)"\u6307\u6807\u9879", (String)"ValueFormulaEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        Map<String, TreeNode> allNode = this.getSubjectAllNodeByModelId();
        for (Map.Entry<String, TreeNode> entry : allNode.entrySet()) {
            TreeNode node = entry.getValue();
            if (!"0".equals(node.getId()) && node.getId() != null) continue;
            root = node;
            break;
        }
        this.buildTree(allNode, root, enableIds);
        root.setParentid("");
        TreeView treeleft = (TreeView)this.getView().getControl("accounttreeviewap");
        treeleft.deleteAllNodes();
        treeleft.updateNode(root);
        treeleft.addNode(root);
        treeleft.expand(root.getId());
    }

    private void initOperationTree() {
        String rootName = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u7b26\u53f7", (String)"SubjectFormulaEdit_04", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        TreeNode root = new TreeNode("", String.format("%s-%s", "root", BigDecimal.ZERO.toString()), rootName);
        ArrayList<TreeNode> subNodes = new ArrayList<TreeNode>(10);
        TreeNode calcSummaryNode = this.buildSummarySubTree(subNodes, new String[]{"+", "-", "*", "/", "(", ")"}, ResManager.loadKDString((String)"\u8ba1\u7b97\u7b26\u53f7", (String)"SubjectFormulaEdit_05", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), root);
        root.setChildren(subNodes);
        TreeView tree = (TreeView)this.getView().getControl("calcctreeviewap");
        tree.updateNode(root);
        tree.addNode(root);
        tree.expand(calcSummaryNode.getId());
        tree.expand(root.getId());
    }

    private TreeNode buildSummarySubTree(List<TreeNode> subNodes, String[] symbols, String name, TreeNode root) {
        String summaryId = String.valueOf(DB.genGlobalLongId());
        TreeNode summaryNode = new TreeNode(root.getId(), String.format("%s-%s", "sub", summaryId), name);
        ArrayList<TreeNode> sonNodes = new ArrayList<TreeNode>(symbols.length);
        for (String value : symbols) {
            TreeNode node = new TreeNode(summaryId, String.valueOf(DB.genGlobalLongId()), value);
            sonNodes.add(node);
        }
        summaryNode.setChildren(sonNodes);
        subNodes.add(summaryNode);
        return summaryNode;
    }

    private Map<String, TreeNode> getSubjectAllNodeByModelId() {
        LinkedHashMap<String, TreeNode> allNode = new LinkedHashMap<String, TreeNode>(16);
        allNode.put("0", this.createTreeNode(null));
        int index = 1;
        for (ReportValueFormulaTypeEnum formulaTypeEnum : ReportValueFormulaTypeEnum.values()) {
            HashMap<String, Object> nodeData = new HashMap<String, Object>();
            nodeData.put("id", formulaTypeEnum.getValue());
            nodeData.put("parentid", 0);
            nodeData.put("name", formulaTypeEnum.getName());
            nodeData.put("isleaf", Boolean.TRUE);
            nodeData.put("level", 1);
            TreeNode treeNode = this.createTreeNode(nodeData);
            allNode.put(String.valueOf(nodeData.get("id")), treeNode);
            ++index;
        }
        return allNode;
    }

    private TreeNode createTreeNode(Map<String, Object> nodeData) {
        TreeNode node = new TreeNode();
        String rootName = ResManager.loadKDString((String)"\u6307\u6807\u9879", (String)"ValueFormulaEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        node.setId(nodeData == null ? "0" : String.valueOf(nodeData.get("id")));
        node.setParentid(nodeData == null ? "" : String.valueOf(nodeData.get("parentid")));
        node.setText(nodeData == null ? rootName : String.valueOf(nodeData.get("name")));
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("id", nodeData == null ? "0" : nodeData.get("id"));
        data.put("name", nodeData == null ? rootName : nodeData.get("name"));
        data.put("number", nodeData == null ? "ROOT" : nodeData.get("number"));
        data.put("parentid", nodeData == null ? "" : nodeData.get("parentid"));
        data.put("sourceid", nodeData == null ? "" : nodeData.get("sourceid"));
        data.put("sourceparentid", nodeData == null ? "" : nodeData.get("sourceparentid"));
        data.put("isleaf", nodeData == null ? Boolean.FALSE : nodeData.get("isleaf"));
        data.put("level", nodeData == null ? Integer.valueOf(0) : nodeData.get("level"));
        node.setData(data);
        return node;
    }

    private void buildTree(Map<String, TreeNode> map, TreeNode root, List<Long> enableIds) {
        for (Map.Entry<String, TreeNode> entry : map.entrySet()) {
            String id = entry.getKey();
            TreeNode node = entry.getValue();
            String partntId = node.getParentid();
            if (!enableIds.isEmpty() && !enableIds.contains(Long.valueOf(id))) {
                node.setColor(DISABLE_NODE_COLOR);
            }
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)partntId)) continue;
            if (!"0".equals(partntId) && map.get(partntId) != null) {
                TreeNode parent = map.get(partntId);
                parent.addChild(node);
                continue;
            }
            if (id.equals(root.getId())) continue;
            root.addChild(node);
        }
    }

    private Pair<List<String>, Boolean> checkLegitimacyOfExpress(String express, BeforeDoOperationEventArgs opEvent) {
        if (opEvent != null && (express.endsWith("+") || express.endsWith("-"))) {
            return new MutablePair(null, (Object)Boolean.FALSE);
        }
        if (express.contains("+-") || express.contains("-+") || express.contains("++") || express.contains("--")) {
            return new MutablePair(null, (Object)Boolean.FALSE);
        }
        List<String> variables = Arrays.stream(ReportValueFormulaTypeEnum.values()).map(ReportValueFormulaTypeEnum::getValue).collect(Collectors.toList());
        boolean validate = this.validate(express, variables);
        return new MutablePair(variables, (Object)validate);
    }

    private boolean validate(String expression, List<String> variables) {
        String[] splits;
        if ((expression = expression.replaceAll(" ", "")).split("[\\+\\-\\*\\/]{2,}").length > 1) {
            return false;
        }
        if (StringUtils.contains((CharSequence)expression, (CharSequence)"()")) {
            return false;
        }
        expression = expression.replaceAll("\\)\\(", "\\)*\\(");
        expression = expression.replaceAll("\\(\\-", "\\(0-");
        expression = expression.replaceAll("\\(\\+", "\\(0+");
        for (String split : splits = expression.split("\\+|\\-|\\*|\\/|\\(|\\)")) {
            if (StringUtils.isBlank((CharSequence)split) || Pattern.matches("-?(0|([1-9]\\d*))(\\.\\d+)?", split) || variables.contains(split)) continue;
            return false;
        }
        Character preChar = null;
        Stack<Character> stack = new Stack<Character>();
        for (int i = 0; i < expression.length(); ++i) {
            char currChar = expression.charAt(i);
            if (i == 0 && Pattern.matches("\\*|\\/", String.valueOf(currChar))) {
                return false;
            }
            if ('(' == currChar) {
                stack.push(Character.valueOf('('));
            } else if (')' == currChar) {
                if (stack.size() > 0) {
                    stack.pop();
                } else {
                    return false;
                }
            }
            if (preChar != null && preChar.charValue() == '(' && Pattern.matches("[\\+\\-\\*\\/]+", String.valueOf(currChar))) {
                return false;
            }
            if (preChar != null && preChar.charValue() == ')' && !Pattern.matches("[\\+\\-\\*\\/]+", String.valueOf(currChar))) {
                return false;
            }
            if (i == expression.length() - 1 && Pattern.matches("\\+|\\-|\\*|\\/", String.valueOf(currChar))) {
                return false;
            }
            preChar = Character.valueOf(currChar);
        }
        return stack.size() == 0;
    }

    private void validatorExpress(Object express, BeforeDoOperationEventArgs opEvent) {
        String expressStr = Optional.ofNullable(express).map(Objects::toString).orElse("");
        Pair<List<String>, Boolean> result = this.checkLegitimacyOfExpress(expressStr, opEvent);
        this.getModel().setValue("expression", (Object)expressStr);
        if (!((Boolean)result.getRight()).booleanValue()) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u7684\u6b63\u786e\u6027\u3002\u53ef\u80fd\u51fa\u73b0\u7684\u60c5\u51b5\u5305\u62ec\uff1a\u8fde\u7eed\u7684\u7b97\u672f\u7b26\u53f7\u3001\u201c%1$s\u201d\u4e0d\u6210\u5bf9\u51fa\u73b0\u3001\u201c%2$s\u201d\u4e2d\u5305\u542b\u7684\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"SubjectFormulaEdit_02", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), "[]", "[]");
            this.showErrorMsg(opEvent, errMsg);
            return;
        }
        this.initExpressDesc((List)result.getLeft(), expressStr);
    }

    private void initExpressDesc(List<String> expressItem, String express) {
        if (!StringUtils.isEmpty((CharSequence)express)) {
            for (String item : expressItem) {
                ReportValueFormulaTypeEnum formulaTypeEnum = ReportValueFormulaTypeEnum.get((String)item);
                if (!Objects.nonNull(formulaTypeEnum)) continue;
                express = express.replace(item, formulaTypeEnum.getName());
            }
        }
        this.getModel().setValue("expressiondesc", (Object)express);
        this.getModel().setValue("expressiondesc_tag", (Object)express);
    }

    private void showErrorMsg(BeforeDoOperationEventArgs opEvent, String errMsg) {
        if (opEvent == null) {
            this.getModel().setValue("expressiondesc", (Object)errMsg);
            this.getModel().setValue("expressiondesc_tag", (Object)errMsg);
        } else {
            this.getView().showErrorNotification(errMsg);
            opEvent.setCancel(true);
        }
    }
}

