/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IPageCache;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.mvc.converter.DimensionPOConverter;
import kd.tmc.fpm.common.bean.UserAuthModel;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.utils.system.DefaultModelHelper;

public abstract class FpmFilterBaseList
extends AbstractTmcListPlugin {
    protected static final String AUTH_BODY_SYSTEM_IDS = "authBodySystemIds";
    protected static final String AUTH_MEMBER_ORG_IDS = "authMemberOrgIds";
    protected static final String CURR_MODEL_ID = "currModelId";
    protected FilterContainerInitArgs initArgs;
    private Object currModelId = null;

    protected abstract String getAuthEntityName();

    protected String getBodySystemProp() {
        return null;
    }

    protected String getReportOrgProp() {
        return null;
    }

    protected String getCurrencyProp() {
        return null;
    }

    protected boolean authSystemManager() {
        return false;
    }

    protected Object getCurrModelId() {
        return this.currModelId;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        this.initArgs = args;
        String filterMode = this.getFilterMode();
        if (!Objects.equals(this.getPageCache().get("filterMode"), filterMode)) {
            this.getPageCache().remove("init");
        }
        this.getPageCache().put("filterMode", filterMode);
        if (this.getPageCache().get("init") == null) {
            this.getPageCache().put("init", "true");
            this.initFilterItem(args);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        IPageCache pageCache = this.getPageCache();
        this.currModelId = pageCache.get(CURR_MODEL_ID);
        String systemProp = this.getBodySystemProp();
        String reportOrgProp = this.getReportOrgProp();
        String currencyProp = this.getCurrencyProp();
        if (systemProp != null && fieldName.startsWith(systemProp)) {
            args.getQfilters().add(new QFilter("id", "in", this.getAuthBodySystemIds()));
            return;
        }
        if (reportOrgProp != null && fieldName.startsWith(reportOrgProp)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            if (EmptyUtil.isEmpty((Object)this.currModelId)) {
                qFilterList.add(new QFilter("bodysystem", "=", (Object)-1));
            } else {
                qFilterList.add(new QFilter("id", "in", this.getAuthMemberOrgIds()));
                qFilterList.add(new QFilter("enable", "=", (Object)"1"));
                qFilterList.add(new QFilter("bodysystem", "=", (Object)Long.valueOf(this.currModelId.toString())));
                qFilterList.add(new QFilter("dimtype", "=", (Object)DimsionEnums.ORG.getNumber()));
            }
            args.getQfilters().clear();
            args.getQfilters().addAll(qFilterList);
            return;
        }
        if (currencyProp != null && fieldName.startsWith(currencyProp)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
            if (EmptyUtil.isEmpty((Object)this.currModelId)) {
                qFilterList.add(new QFilter("bodysystem", "=", (Object)-1));
            } else {
                qFilterList.add(new QFilter("enable", "=", (Object)"1"));
                qFilterList.add(new QFilter("bodysystem", "=", (Object)Long.valueOf(this.currModelId.toString())));
                qFilterList.add(new QFilter("dimtype", "=", (Object)DimsionEnums.CURRENCY.getNumber()));
            }
            args.getQfilters().addAll(qFilterList);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValue = args.getFilterValues();
        List customFilterList = (List)filterValue.get("customfilter");
        if (customFilterList != null) {
            this.customSearchClickFilter(customFilterList);
        }
        this.initFilterItem(this.initArgs);
    }

    protected List<Long> getAuthMemberOrgIds() {
        String orgIds = this.getPageCache().get(AUTH_MEMBER_ORG_IDS);
        return EmptyUtil.isNoEmpty((String)orgIds) ? (List)SerializationUtils.fromJsonString((String)orgIds, List.class) : new ArrayList(10);
    }

    protected List<Long> getAuthBodySystemIds() {
        String orgIds = this.getPageCache().get(AUTH_BODY_SYSTEM_IDS);
        return EmptyUtil.isNoEmpty((String)orgIds) ? (List)SerializationUtils.fromJsonString((String)orgIds, List.class) : new ArrayList(10);
    }

    protected void customSearchClickFilter(List<Map<String, List<Object>>> customFilterList) {
        boolean systemIsChanged = Boolean.FALSE;
        String systemCache = this.getPageCache().get(CURR_MODEL_ID);
        for (Map<String, List<Object>> map : customFilterList) {
            String value;
            String fieldName = map.get("FieldName").size() > 0 ? map.get("FieldName").get(0).toString() : "";
            String string = value = map.get("Value").size() > 0 ? map.get("Value").get(0).toString() : "";
            if (!fieldName.startsWith(this.getBodySystemProp()) || !EmptyUtil.isNoEmpty((String)value)) continue;
            if (!Objects.equals(value, systemCache)) {
                systemIsChanged = Boolean.TRUE;
            }
            this.currModelId = value;
            this.getPageCache().put(CURR_MODEL_ID, this.currModelId.toString());
            DefaultModelHelper.save(Long.valueOf(value));
        }
        if (systemIsChanged) {
            customFilterList.removeIf(t -> ((List)t.get("FieldName")).size() > 0 && ((List)t.get("FieldName")).get(0).toString().startsWith(this.getReportOrgProp()));
        }
    }

    protected void initFilterItem(FilterContainerInitArgs args) {
        String systemProp = this.getBodySystemProp();
        String reportOrgProp = this.getReportOrgProp();
        String currencyProp = this.getCurrencyProp();
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        FilterColumn systemColumn = filterColumns.stream().filter(f -> systemProp != null && f.getFieldName().startsWith(systemProp)).findFirst().orElse(null);
        if (systemColumn != null && EmptyUtil.isEmpty((Object)this.currModelId)) {
            if (this.authSystemManager()) {
                this.initAuthSystems();
            } else {
                this.initAuthSystemAndOrgMembers();
            }
        }
        for (FilterColumn filterColumn : filterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (systemProp != null && fieldName.startsWith(systemProp)) {
                this.initBodySystemFilter(commonFilterColumn);
                continue;
            }
            if (reportOrgProp != null && fieldName.startsWith(reportOrgProp)) {
                this.initReportOrgFilter(commonFilterColumn);
                continue;
            }
            if (currencyProp == null || !fieldName.startsWith(currencyProp)) continue;
            this.initCurrencyFilter(commonFilterColumn);
        }
    }

    private void initAuthSystemAndOrgMembers() {
        UserAuthModel authModel = ModelHelper.getAuthScopeModel((String)this.getView().getFormShowParameter().getAppId(), (String)this.getAuthEntityName());
        IPageCache pageCache = this.getPageCache();
        List systemIds = authModel.getSystemIds();
        List reportOrgIds = authModel.getOrgIds();
        pageCache.put(AUTH_BODY_SYSTEM_IDS, SerializationUtils.toJsonString((Object)systemIds));
        pageCache.put(AUTH_MEMBER_ORG_IDS, SerializationUtils.toJsonString((Object)reportOrgIds));
        if (!systemIds.isEmpty()) {
            this.currModelId = DefaultModelHelper.getDefaultSystemIfExist(systemIds);
            pageCache.put(CURR_MODEL_ID, this.currModelId.toString());
        }
    }

    private void initAuthSystems() {
        UserAuthModel authModel = ModelHelper.getAuthScopeModelWithCheckManager((String)this.getView().getFormShowParameter().getAppId(), (String)this.getAuthEntityName());
        IPageCache pageCache = this.getPageCache();
        List systemIds = authModel.getSystemIds();
        List reportOrgIds = authModel.getOrgIds();
        pageCache.put(AUTH_BODY_SYSTEM_IDS, SerializationUtils.toJsonString((Object)systemIds));
        pageCache.put(AUTH_MEMBER_ORG_IDS, SerializationUtils.toJsonString((Object)reportOrgIds));
        Long systemId = DefaultModelHelper.getDefaultSystemIfExist(systemIds);
        if (EmptyUtil.isNoEmpty((Long)systemId) && EmptyUtil.isEmpty((Object)this.currModelId)) {
            this.currModelId = systemId;
            this.getPageCache().put(CURR_MODEL_ID, this.currModelId.toString());
        }
    }

    protected void initBodySystemFilter(CommonFilterColumn commonFilterColumn) {
        if (Objects.equals(this.getView().getFormShowParameter().getCustomParam("viewtype"), "f7")) {
            return;
        }
        commonFilterColumn.setDefaultValue(this.currModelId != null ? this.currModelId.toString() : "");
        DynamicObjectCollection objColl = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)"id,name", (QFilter[])new QFilter("id", "in", this.getAuthBodySystemIds()).toArray(), (String)"number");
        commonFilterColumn.setComboItems(this.createComboItems(objColl));
    }

    protected void initReportOrgFilter(CommonFilterColumn commonFilterColumn) {
        if (Objects.equals(this.getView().getFormShowParameter().getCustomParam("viewtype"), "f7")) {
            return;
        }
        commonFilterColumn.setDefaultValue("");
        if (this.currModelId == null) {
            commonFilterColumn.setComboItems(new ArrayList(0));
        } else {
            QFilter qFilter = new QFilter("id", "in", this.getAuthMemberOrgIds()).and("bodysystem", "=", (Object)Long.valueOf(this.currModelId.toString()));
            DynamicObjectCollection objColl = QueryServiceHelper.query((String)"fpm_member", (String)"id,name", (QFilter[])qFilter.toArray());
            commonFilterColumn.setComboItems(this.createComboItems(objColl));
        }
    }

    protected void initCurrencyFilter(CommonFilterColumn commonFilterColumn) {
        if (Objects.equals(this.getView().getFormShowParameter().getCustomParam("viewtype"), "f7")) {
            return;
        }
        commonFilterColumn.setDefaultValue("");
        if (this.currModelId == null) {
            commonFilterColumn.setComboItems(new ArrayList(0));
        } else {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1").and("dimtype", "=", (Object)DimsionEnums.CURRENCY.getNumber()).and("bodysystem", "=", (Object)Long.valueOf(this.currModelId.toString()));
            DynamicObjectCollection objColl = QueryServiceHelper.query((String)"fpm_member", (String)"id,name", (QFilter[])qFilter.toArray());
            commonFilterColumn.setComboItems(this.createComboItems(objColl));
        }
    }

    protected List<ComboItem> createComboItems(DynamicObjectCollection objColl) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (DynamicObject obj : objColl) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(obj.getString("name")));
            item.setValue(obj.getString("id"));
            items.add(item);
        }
        return items;
    }

    protected String getFilterMode() {
        return String.valueOf(new ListCache(this.getPageCache()).getFilterMode().orElse(0));
    }

    protected List<DimMember> loadOrgWithAllChild(List<Long> authMemberOrgIds, Long systemId) {
        ArrayList<DimMember> result = new ArrayList<DimMember>(authMemberOrgIds.size());
        HashSet<Long> allOrgId = new HashSet<Long>(authMemberOrgIds.size());
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId);
        qFilter.and("number", "=", (Object)DimsionEnums.ORG.getNumber());
        List load = QueryServiceHelper.queryPrimaryKeys((String)"fpm_dimension", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (load.size() == 0) {
            return result;
        }
        Dimension dimension = this.getDimension((Long)load.get(0));
        for (Long orgId : authMemberOrgIds) {
            DimMember member = dimension.getDimMemberByDimId(DimMember.class, orgId);
            if (member == null) continue;
            if (allOrgId.add(orgId)) {
                result.add(member);
            }
            List allChildMember = member.getAllChildMember();
            allChildMember.forEach(e -> {
                if (!authMemberOrgIds.contains(e.getId()) && allOrgId.add(e.getId())) {
                    result.add(member);
                }
            });
        }
        return result;
    }

    private Dimension getDimension(Long dimensionId) {
        DynamicObject mainDimension = TmcDataServiceHelper.loadSingle((Object)dimensionId, (String)"fpm_dimension");
        String dimensionType = mainDimension.getString("basedata");
        DimsionEnums dimensionEnum = DimsionEnums.getDimsionByNumber((String)dimensionType);
        QFilter dimFilter = new QFilter("dimension", "=", mainDimension.getPkValue()).and("bodysystem", "=", (Object)mainDimension.getLong("bodysystem.id"));
        List memIds = QueryServiceHelper.queryPrimaryKeys((String)dimensionEnum.getMetadata(), (QFilter[])dimFilter.toArray(), null, (int)-1);
        DynamicObject[] memberArr = TmcDataServiceHelper.load((Object[])memIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dimensionEnum.getMetadata()));
        return DimensionPOConverter.convertToMainDimension((DynamicObject)mainDimension, Arrays.asList(memberArr));
    }
}

