/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MemberSumEnum;
import kd.tmc.fpm.common.enums.WaysEnum;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.formplugin.helper.MemberSortHelper;

public class MemberEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
        this.addClickListeners(new String[]{"bar_cancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ComboEdit sumTypeCombo = (ComboEdit)this.getView().getControl("sumtype");
        if (Objects.nonNull(sumTypeCombo)) {
            List sumTypeItemList = Arrays.stream(MemberSumEnum.values()).map(item -> new ComboItem(new LocaleString(item.getName()), item.getCode())).collect(Collectors.toList());
            sumTypeCombo.setComboItems(sumTypeItemList);
        }
    }

    private void initMustInput() {
        String dimtype = this.getModel().getDataEntity().getString("dimtype");
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        if (Objects.nonNull(allFields.get("relcaporg"))) {
            ((OrgProp)allFields.get("relcaporg")).setMustInput(false);
        }
        if (Objects.nonNull(allFields.get("bodysysmanage"))) {
            ((BasedataProp)allFields.get("bodysysmanage")).setMustInput(false);
        }
        if (Objects.nonNull(allFields.get("flow"))) {
            ((ComboProp)allFields.get("flow")).setMustInput(false);
        }
        if (Objects.nonNull(allFields.get("ways"))) {
            ((ComboProp)allFields.get("ways")).setMustInput(false);
        }
        if (Objects.nonNull(this.getControl("relcaporg"))) {
            ((OrgEdit)this.getControl("relcaporg")).setMustInput(false);
        }
        if (Objects.nonNull(this.getControl("bodysysmanage"))) {
            ((BasedataEdit)this.getControl("bodysysmanage")).setMustInput(false);
        }
        if (Objects.nonNull(this.getControl("flow"))) {
            ((ComboEdit)this.getControl("flow")).setMustInput(false);
        }
        if (Objects.nonNull(this.getControl("ways"))) {
            ((ComboEdit)this.getControl("ways")).setMustInput(false);
        }
        if (Objects.nonNull(allFields.get("caporg"))) {
            ((OrgProp)allFields.get("caporg")).setMustInput(false);
        }
        if (Objects.nonNull(this.getControl("caporg"))) {
            ((OrgEdit)this.getControl("caporg")).setMustInput(false);
        }
        if (Objects.nonNull(allFields.get("sumtype"))) {
            ((ComboProp)allFields.get("sumtype")).setMustInput(true);
        }
        if (DimsionEnums.COMPANY.getNumber().equals(dimtype)) {
            ((OrgProp)allFields.get("relcaporg")).setMustInput(true);
            ((OrgEdit)this.getControl("relcaporg")).setMustInput(true);
        } else if (DimsionEnums.SUBJECT.getNumber().equals(dimtype)) {
            if (Objects.nonNull(allFields.get("bodysysmanage"))) {
                ((BasedataProp)allFields.get("bodysysmanage")).setMustInput(true);
            }
            if (Objects.nonNull(allFields.get("flow"))) {
                ((ComboProp)allFields.get("flow")).setMustInput(true);
            }
            if (Objects.nonNull(allFields.get("ways"))) {
                ((ComboProp)allFields.get("ways")).setMustInput(true);
            }
            if (Objects.nonNull(this.getControl("bodysysmanage"))) {
                ((BasedataEdit)this.getControl("bodysysmanage")).setMustInput(true);
            }
            if (Objects.nonNull(this.getControl("flow"))) {
                ((ComboEdit)this.getControl("flow")).setMustInput(true);
            }
            if (Objects.nonNull(this.getControl("ways"))) {
                ((ComboEdit)this.getControl("ways")).setMustInput(true);
            }
        } else if (DimsionEnums.ORG.getNumber().equals(dimtype)) {
            ((OrgProp)allFields.get("caporg")).setMustInput(true);
            ((OrgEdit)this.getControl("caporg")).setMustInput(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null && params.size() > 0 && params.get("bodysystem") != null) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"bodysystem", (Object)Long.valueOf(params.get("bodysystem").toString()));
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"dimtype", (Object)params.get("dimensionNumber").toString());
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"dimension", (Object)Long.valueOf(params.get("dimensionId").toString()));
            if (DimsionEnums.SUBJECT.getNumber().equals(params.get("dimensionNumber").toString())) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"bodysysmanage", (Object)Long.valueOf(params.get("bodysystem").toString()));
            }
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumtype"});
        this.initMustInput();
        long modelId = this.getModel().getDataEntity().getLong("bodysystem.id");
        String dimtype = this.getModel().getDataEntity().getString("dimtype");
        if (DimsionEnums.ORG.getNumber().equals(dimtype)) {
            this.initPage4OrgDim(modelId);
        } else if (DimsionEnums.SUBJECT.getNumber().equals(dimtype)) {
            QFilter tQFilter = new QFilter("model", "=", (Object)modelId);
            tQFilter.and("dimsettingentry.plantemplatemember.fbasedataid", "in", (Object)new Object[]{this.getModel().getDataEntity().getPkValue()});
            if (TmcDataServiceHelper.exists((String)"fpm_template", (QFilter[])new QFilter[]{tQFilter})) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"parent"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("dimtype".equals(fieldKey)) {
            this.initMustInput();
        } else if ("ways".equals(fieldKey) && !WaysEnum.FORMULA_TERM.getValue().equals(changeData.getNewValue().toString())) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"formulavalue", null);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"formulavalue_tag", null);
            this.getModel().setValue("formula", null);
        }
    }

    private void initF7() {
        IDataModel model = this.getModel();
        DynamicObject tMember = model.getDataEntity();
        BasedataEdit linkParentEdit = (BasedataEdit)this.getControl("parent");
        if (Objects.isNull(linkParentEdit)) {
            return;
        }
        if (tMember.getDynamicObject("bodysystem") == null) {
            return;
        }
        linkParentEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("bodysystem", "=", tMember.getDynamicObject("bodysystem").getPkValue());
            filter.and("dimtype", "=", model.getValue("dimtype"));
            if (tMember.getPkValue() != null && !"0".equals(tMember.getPkValue().toString())) {
                filter.and("id", "!=", tMember.getPkValue());
            }
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), DimsionEnums.getDimsionByNumber((String)model.getValue("dimtype").toString()).getName()));
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if ("save".equals(operateKey)) {
            IDataModel model = this.getModel();
            long systemId = model.getDataEntity().getDynamicObject("bodysystem").getLong("id");
            String dimType = model.getDataEntity().getString("dimtype");
            Object dimensionId = 0L;
            if (EmptyUtil.isNoEmpty((DynamicObject)model.getDataEntity()) && EmptyUtil.isNoEmpty((DynamicObject)model.getDataEntity().getDynamicObject("dimension"))) {
                dimensionId = model.getDataEntity().getDynamicObject("dimension").getPkValue();
            }
            Object pkValue = model.getDataEntity().getPkValue();
            String number = model.getDataEntity().getString("number");
            boolean exists = TmcDataServiceHelper.exists((String)"fpm_member", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)systemId).and("dimension", "=", dimensionId).and("number", "=", (Object)number).and("id", "!=", pkValue)});
            if (exists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6210\u5458\u4fe1\u606f\uff0c\u4e0d\u53ef\u6dfb\u52a0\u76f8\u540c\u6570\u636e\u3002", (String)"MemberEditPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            OperationResult result = this.getView().invokeOperation("beforsave");
            if (result != null && !result.isSuccess()) {
                args.setCancel(true);
                return;
            }
            if (DimsionEnums.ORG.getNumber().equals(dimType)) {
                result = this.getView().invokeOperation("saveorg");
            } else if (DimsionEnums.COMPANY.getNumber().equals(dimType)) {
                result = this.getView().invokeOperation("savecompany");
            } else if (DimsionEnums.SUBJECT.getNumber().equals(dimType)) {
                result = this.handleSubject(args, result);
            }
            if (result != null && !result.isSuccess()) {
                args.setCancel(true);
            }
            MemberSortHelper.updateSortCodeIfParentChange(model.getDataEntity());
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"serial", (Object)System.nanoTime());
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"status", (Object)BillStatusEnum.AUDIT.getValue());
        }
    }

    private OperationResult handleSubject(BeforeDoOperationEventArgs args, OperationResult result) {
        Object save = this.getView().getFormShowParameter().getCustomParam("save");
        if (Objects.nonNull(save) && Boolean.parseBoolean(save.toString())) {
            return result;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String number = dataEntity.getString("number");
        String name = dataEntity.getString("name");
        String ways = dataEntity.getString("ways");
        String formula = dataEntity.getString("formula");
        if (WaysEnum.isFormulaTerm((String)ways)) {
            if (StringUtil.isEmpty((String)formula)) {
                String msg = ResManager.loadKDString((String)"\u5f53\u586b\u62a5\u65b9\u5f0f\u4e3a\u516c\u5f0f\u9879\uff0c\u516c\u5f0f\u5fc5\u987b\u6307\u5b9a", (String)"MemberEditPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return result;
            }
            long linkSubjectId = dataEntity.getLong("linksubject.id");
            String formulaValue = dataEntity.getString("formulavalue_tag");
            if (!NumberUtils.equalsZero((Long)linkSubjectId) && !formulaValue.contains(String.valueOf(linkSubjectId))) {
                String msg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u516c\u5f0f\u9879\u8868\u8fbe\u5f0f\u4e2d\u672a\u542b\u5173\u8054\u671f\u521d\u79d1\u76ee\u201c%2$s\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\u3002", (String)"MemberEditPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                String beginName = dataEntity.getString("linksubject.number") + dataEntity.getString("linksubject.name");
                String format = String.format(msg, number + name, beginName);
                this.getView().showConfirm(format, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("savesubject_callback"));
                args.setCancel(true);
            }
        }
        if (!args.isCancel()) {
            result = this.getView().invokeOperation("savesubject");
        }
        return result;
    }

    private void saveSubject() {
        IDataModel model = this.getModel();
        long systemId = model.getDataEntity().getDynamicObject("bodysystem").getLong("id");
        String dimType = model.getDataEntity().getString("dimtype");
        Object pkValue = model.getDataEntity().getPkValue();
        OperationResult result = this.getView().invokeOperation("savesubject");
        if (result == null || result.isSuccess()) {
            String formulaValueLeft = "[";
            String formulaValueRight = "]";
            DynamicObject subjectFormDb = QueryServiceHelper.queryOne((String)"fpm_member", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
            if (subjectFormDb != null) {
                DynamicObjectCollection queryMembers = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "formula", "formulavalue"), (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)systemId).and("dimtype", "=", (Object)dimType).and("formulavalue", "like", (Object)String.join((CharSequence)"", formulaValueLeft, pkValue.toString(), formulaValueRight))});
                ArrayList<DynamicObject> updateFormulaValue = new ArrayList<DynamicObject>(10);
                for (DynamicObject formulaValue : queryMembers) {
                    String formula = formulaValue.getString("formula").replace(String.join((CharSequence)"", formulaValueLeft, subjectFormDb.getString("name"), formulaValueRight), String.join((CharSequence)"", formulaValueLeft, model.getDataEntity().getString("name"), formulaValueRight));
                    formulaValue.set("formula", (Object)formula);
                    updateFormulaValue.add(formulaValue);
                }
                if (updateFormulaValue.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])updateFormulaValue.toArray(new DynamicObject[0]));
                }
            }
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"serial", (Object)System.nanoTime());
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"status", (Object)BillStatusEnum.AUDIT.getValue());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(opKey) && afterDoOperationEventArgs.getOperationResult().isSuccess() && ShowType.Modal.equals((Object)this.getView().getFormShowParameter().getOpenStyle().getShowType())) {
            this.getView().returnDataToParent((Object)"CLOSE_REFESHMEMBER");
            this.getView().close();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String opkey;
        super.beforeClick(evt);
        switch (opkey = ((Control)evt.getSource()).getKey()) {
            case "bar_cancel": {
                this.getView().getFormShowParameter().setCloseCallBack(null);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if ("savesubject_callback".equals(callBackId) && result.equals((Object)MessageBoxResult.Yes)) {
            this.saveSubject();
            this.getView().getFormShowParameter().setCustomParam("save", (Object)true);
            this.getView().invokeOperation("save");
        }
    }

    private void initPage4OrgDim(long modelId) {
        DynamicObject model;
        String orgName;
        String dimMemName = this.getModel().getDataEntity().getString("number");
        if (dimMemName.equals(orgName = (model = TmcDataServiceHelper.loadSingle((Object)modelId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_bodysysmanage"))).getDynamicObject("org").getString("number"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"parent"});
            return;
        }
        Long orgId = this.getModel().getDataEntity().getLong("id");
        Boolean isSum = this.getModel().getDataEntity().getBoolean("issum");
        List<Long> memberIdList = isSum != false ? Collections.singletonList(orgId) : this.getOrgAllMember(modelId, orgId);
        QFilter qFilter = new QFilter("reportorg", "in", memberIdList);
        Object[] reportArr = TmcDataServiceHelper.load((String)"fpm_report", (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])reportArr)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"parent"});
            return;
        }
        Object[] sumPlanReportArr = TmcDataServiceHelper.load((String)"fpm_reportplansum", (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])sumPlanReportArr)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"parent"});
        }
    }

    private List<Long> getOrgAllMember(Long systemId, Long parentOrgId) {
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("dimtype", "=", (Object)DimsionEnums.ORG.getNumber()).and("id", "<>", (Object)parentOrgId);
        DynamicObject[] orgDyArr = TmcDataServiceHelper.load((String)"fpm_member", (String)String.join((CharSequence)",", "id", "parent"), (QFilter[])qFilter.toArray(), (String)"level");
        ArrayList<Long> validOrgIds = new ArrayList<Long>(5);
        validOrgIds.add(parentOrgId);
        for (DynamicObject orgDy : orgDyArr) {
            Long currParentId;
            Long l = currParentId = EmptyUtil.isNoEmpty((DynamicObject)orgDy.getDynamicObject("parent")) ? Long.valueOf(orgDy.getDynamicObject("parent").getLong("id")) : null;
            if (!Objects.nonNull(currParentId) || !validOrgIds.contains(currParentId)) continue;
            validOrgIds.add(orgDy.getLong("id"));
        }
        return validOrgIds;
    }
}

