/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ControlContext;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.utils.DbTypeConverter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.property.TmcTreeNodeProp;
import kd.tmc.fbp.common.property.TmcTreeNodeRefProp;
import kd.tmc.fbp.common.property.TmcTreeNodeTypeProp;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.tree.AbstractTmcTreeList;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.helper.FpmHelper;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.formplugin.helper.MemberManagerListHelper;
import kd.tmc.fpm.utils.system.DefaultModelHelper;

public class MemberManagerTreeListPlugin
extends AbstractTmcTreeList {
    private static final Log logger = LogFactory.getLog(MemberManagerTreeListPlugin.class);
    private static final String TREE_PARENT_ID = "0";
    public static final String BODY_SYSTEM_NUMBER = "bodysystem.number";
    public static final String BODY_SYS_MANAGE_NUMBER = "bodysysmanage.number";
    public static final String PAGE_CACHE_ALL_DIM_NUMBER = "allDimensionNumbers";

    public void filterContainerInit(FilterContainerInitArgs args) {
        this.initfilterContainer(args);
        super.filterContainerInit(args);
    }

    private void initfilterContainer(FilterContainerInitArgs args) {
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith("bodysystem")) {
                DynamicObject[] authModelData = ModelHelper.getAuthModelData((String)"id,name,number");
                if (authModelData.length > 0) {
                    Object systemId;
                    ArrayList<ComboItem> tComboItemList = new ArrayList<ComboItem>(0);
                    for (DynamicObject tModelData : authModelData) {
                        ComboItem tCombolItem = new ComboItem(new LocaleString(tModelData.getString("name")), tModelData.getString("id"));
                        tComboItemList.add(tCombolItem);
                    }
                    commonFilterColumn.setComboItems(tComboItemList);
                    if (StringUtils.isBlank((CharSequence)this.getPageCache().get("bodysystem"))) {
                        systemId = DefaultModelHelper.getBaseDataDefaultSystemId();
                        commonFilterColumn.setDefaultValue(((Long)systemId).toString());
                        this.getPageCache().put("bodysystem", ((Long)systemId).toString());
                        continue;
                    }
                    systemId = this.getPageCache().get("bodysystem");
                    commonFilterColumn.setDefaultValue((String)systemId);
                    continue;
                }
                commonFilterColumn.setComboItems(new ArrayList(0));
                continue;
            }
            if (!fieldName.startsWith("enable")) continue;
            this.getPageCache().put("enable", commonFilterColumn.getDefValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String key = source.getOperateKey();
        if ("sort".equals(key)) {
            if (this.isSortAble()) {
                this.showSortForm();
            } else {
                args.setCancel(true);
            }
        }
    }

    private boolean isSortAble() {
        boolean isAble = true;
        Map focMap = this.treeListView.getTreeView().getTreeState().getFocusNode();
        String billFormId = ((IListView)this.getView()).getBillFormId();
        String errMsg = Objects.equals(billFormId, DimsionEnums.SUBJECT.getMetadata()) ? ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u4fa7\u8282\u70b9\u6811\u9009\u62e9\u4e00\u4e2a\u5b58\u5728\u4e0b\u7ea7\u7684\u8ba1\u5212\u79d1\u76ee\u3002", (String)"MemberManagerTreeListPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u4fa7\u8282\u70b9\u6811\u9009\u62e9\u4e00\u4e2a\u5b58\u5728\u4e0b\u7ea7\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberManagerTreeListPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        if (focMap == null) {
            isAble = false;
            this.getView().showTipNotification(errMsg);
        } else {
            Object isParent = focMap.get("isParent");
            if (isParent != null && !((Boolean)isParent).booleanValue()) {
                isAble = false;
                this.getView().showTipNotification(errMsg);
            }
        }
        return isAble;
    }

    private void showSortForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fpm_membersort");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String focusNodeId = this.treeListView.getTreeView().getTreeState().getFocusNodeId();
        TreeNode currNode = this.getNodeById(focusNodeId);
        List<TmcTreeNodeTypeProp> treeNodeTypeList = this.getTreeNodeTypeList();
        TmcTreeNodeProp treeNodeProp = new TmcTreeNodeProp(currNode, this.getTreeModel().getRoot(), treeNodeTypeList);
        TmcTreeNodeTypeProp nodeType = treeNodeProp.getNodeType();
        String dimType = this.convertDimType(nodeType);
        if (EmptyUtil.isEmpty((Object)treeNodeProp.getRefEntityPkValue()) || nodeType == TmcTreeNodeTypeProp.ROOT || DimsionEnums.PERIOD.getNumber().equals(dimType)) {
            return;
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6392\u5e8f", (String)"MemberManagerTreeListPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("parent", treeNodeProp.getRefEntityPkValue());
        formShowParameter.setCustomParam("dimensionid", (Object)this.getDimensionId(dimType, nodeType.getName()));
        formShowParameter.setCustomParam("system", (Object)this.getPageCache().get("bodysystem"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "memberSortClosedCallBack"));
        this.getView().showForm(formShowParameter);
    }

    private Long getDimensionId(String dimType, String nodeType) {
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)Long.valueOf(this.getPageCache().get("bodysystem")));
        if (DimensionType.CUSTOM.getNumber().equals(dimType)) {
            qFilter.and(new QFilter("number", "=", (Object)nodeType));
        } else {
            qFilter.and(new QFilter("number", "=", (Object)dimType));
        }
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"fpm_dimension", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        if (EmptyUtil.isEmpty((Collection)primaryKeys)) {
            return 0L;
        }
        return (Long)primaryKeys.get(0);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "memberSortClosedCallBack": {
                Object returnData = closedCallBackEvent.getReturnData();
                if (!Objects.equals(returnData, "save")) break;
                this.refreshTreeOnFocus();
                break;
            }
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        this.setBodySystem(args);
        FilterContainer container = (FilterContainer)this.getControl("filtercontainerap");
        ControlContext context = container.getContext();
        ControlFilters controlFilters = context.getControlFilters();
        if (controlFilters == null) {
            this.forceRefreshTree();
        } else {
            boolean hasFastFilter;
            List name = controlFilters.getFastFilter("name");
            List number = controlFilters.getFastFilter("number");
            boolean bl = hasFastFilter = !CollectionUtils.isEmpty((Collection)name) || !CollectionUtils.isEmpty((Collection)number);
            if (!hasFastFilter) {
                this.forceRefreshTree();
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        TreeNode currNode = this.getNodeById(e.getNodeId());
        String dimensionId = currNode.getId();
        List<TmcTreeNodeTypeProp> treeNodeTypeList = this.getTreeNodeTypeList();
        if (dimensionId.contains("#")) {
            String dimType = dimensionId.substring(dimensionId.indexOf("/") + 1, dimensionId.indexOf("#"));
            boolean noneMatch = treeNodeTypeList.stream().noneMatch(item -> StringUtils.equals((CharSequence)item.getName(), (CharSequence)dimType));
            if (noneMatch) {
                String systemId = this.getPageCache().get("bodysystem");
                this.reloadDimensionNumberCache(Long.valueOf(systemId));
                String allDimensionNumbers = this.getPageCache().get(PAGE_CACHE_ALL_DIM_NUMBER);
                treeNodeTypeList = MemberManagerListHelper.buildByDimensionNumbers(allDimensionNumbers);
            }
        }
        TmcTreeNodeProp nodeProp = null;
        try {
            nodeProp = new TmcTreeNodeProp(currNode, this.getTreeModel().getRoot(), treeNodeTypeList);
        }
        catch (Exception ex) {
            logger.warn("node is deleted, need refresh, nodeId:{}", (Object)dimensionId);
        }
        if (Objects.isNull(nodeProp)) {
            return;
        }
        Object refId = nodeProp.getRefEntityPkValue();
        QFilter tQFilter = this.getTreeNodeTypeQFilter(nodeProp.getNodeType(), this.getBodySystem());
        if (refId != null && !TmcTreeNodeTypeProp.ROOT.equals((Object)nodeProp.getNodeType()) && !MemberManagerListHelper.NODE_PERIOD.equals((Object)nodeProp.getNodeType())) {
            if (MemberManagerListHelper.NODE_REPORTTYPE.equals((Object)nodeProp.getNodeType())) {
                QFilter t = new QFilter("reporttype.id", "=", (Object)Long.valueOf(nodeProp.getRefEntityPkValue().toString())).and("parent", "=", (Object)Long.valueOf(TREE_PARENT_ID));
                t.or(new QFilter("parent", "=", (Object)Long.valueOf(nodeProp.getRefEntityPkValue().toString())));
                tQFilter.and(t);
            } else {
                tQFilter.and("parent", "=", (Object)Long.valueOf(refId.toString()));
            }
        }
        this.getTreeModel().getTreeFilter().clear();
        this.getTreeModel().getTreeFilter().add(tQFilter);
        super.treeNodeClick(e);
        List tQFilter1 = this.getTreeModel().getTreeFilter();
    }

    private void refreshTreeOnFocus() {
        String tFocusDimNode;
        String[] tFocusDimNodes;
        ITreeListView treeListView = this.getTreeListView();
        if (treeListView == null) {
            return;
        }
        TreeNode tRefreshTreeNode = this.getTreeModel().getRoot();
        TreeView treeview = (TreeView)this.getControl("treeview");
        if (treeview.getTreeState().getFocusNodeId() != null && (tFocusDimNodes = (tFocusDimNode = treeview.getTreeState().getFocusNodeId()).split("/")).length > 1) {
            tRefreshTreeNode.setChildren(null);
            this.getTreeListView().getTreeView().queryTreeNodeChildren(tRefreshTreeNode.getParentid(), tRefreshTreeNode.getId());
            tRefreshTreeNode = tRefreshTreeNode.getTreeNode(tFocusDimNodes[0] + "/" + tFocusDimNodes[1], 99);
        }
        tRefreshTreeNode.setChildren(null);
        this.getTreeListView().getTreeView().treeNodeClick(tRefreshTreeNode.getParentid(), tRefreshTreeNode.getId());
    }

    private void forceRefreshTree() {
        ITreeListView treeListView = this.getTreeListView();
        if (treeListView == null) {
            return;
        }
        TreeNode tRefreshTreeNode = this.getTreeModel().getRoot();
        tRefreshTreeNode.setChildren(null);
        this.getTreeListView().getTreeView().queryTreeNodeChildren(tRefreshTreeNode.getParentid(), tRefreshTreeNode.getId());
        List rootChildren = tRefreshTreeNode.getChildren();
        if (rootChildren != null && rootChildren.size() > 0) {
            tRefreshTreeNode = (TreeNode)rootChildren.get(0);
        }
        this.getTreeListView().getTreeView().treeNodeClick(tRefreshTreeNode.getParentid(), tRefreshTreeNode.getId());
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        ListView tListView = (ListView)e.getSource();
        this.handleSearchAp();
        ListShowParameter showParameter = (ListShowParameter)tListView.getFormShowParameter();
        List leftTreeFilters = showParameter.getListFilterParameter().getQFilters();
        if (!CollectionUtils.isEmpty((Collection)leftTreeFilters)) {
            HashMap filterMap = new HashMap();
            leftTreeFilters.stream().map(item -> {
                List<Object> result = new ArrayList<QFilter>();
                List nests = item.getNests(true);
                if (BODY_SYS_MANAGE_NUMBER.equals(item.getProperty())) {
                    item.setProperty(BODY_SYSTEM_NUMBER);
                }
                if (!CollectionUtils.isEmpty((Collection)nests)) {
                    result = nests.stream().map(QFilter.QFilterNest::getFilter).collect(Collectors.toList());
                    result.add(new QFilter(item.getProperty(), item.getCP(), item.getValue()));
                } else {
                    result.add(item);
                }
                return result;
            }).flatMap(Collection::stream).forEach(item -> filterMap.putIfAbsent(item.toString(), item));
            for (QFilter treeFilter : filterMap.values()) {
                this.initPageCache(treeFilter);
            }
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("id"))) {
                leftTreeFilters.add(new QFilter("id", "not in", this.getAllChildNodeID(TmcTreeNodeTypeProp.ROOT, Long.valueOf(this.getPageCache().get("id")))));
            }
        }
        if (DimsionEnums.SUBJECT.getNumber().equals(this.getPageCache().get("dimtype"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanel_treebtn"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanel_treebtn", "btnnew", "btnedit", "btndel"});
        }
    }

    public void afterBindData(EventObject e) {
        Map focusNode;
        super.afterBindData(e);
        if (this.getTreeListView() == null) {
            return;
        }
        ITreeModel treeModel = this.getTreeModel();
        TreeNode tRefreshTreeNode = treeModel.getRoot();
        List rootChildren = tRefreshTreeNode.getChildren();
        if (rootChildren != null && rootChildren.size() > 0) {
            tRefreshTreeNode = (TreeNode)rootChildren.get(0);
        }
        if ((focusNode = this.getTreeListView().getTreeView().getTreeState().getFocusNode()) == null || focusNode.isEmpty()) {
            this.getTreeListView().getTreeView().focusNode(tRefreshTreeNode);
            this.getTreeListView().getTreeView().expand(tRefreshTreeNode.getId());
        }
    }

    private void initPageCache(QFilter tQFilter) {
        if ("bodysystem".equals(tQFilter.getProperty())) {
            this.getPageCache().put(tQFilter.getProperty(), tQFilter.getValue().toString());
        } else if ("dimtype".equals(tQFilter.getProperty())) {
            if ("=".equals(tQFilter.getCP())) {
                this.getPageCache().put(tQFilter.getProperty(), tQFilter.getValue().toString());
            } else if ("not in".equals(tQFilter.getCP())) {
                this.getPageCache().put("notdimtype", tQFilter.toSerializedString());
            }
        } else if ("dimension".equals(tQFilter.getProperty())) {
            this.getPageCache().put(tQFilter.getProperty(), tQFilter.getValue().toString());
        } else if ("id".equals(tQFilter.getProperty()) && "!=".equals(tQFilter.getCP())) {
            this.getPageCache().put(tQFilter.getProperty(), tQFilter.getValue().toString());
        } else if ("id".equals(tQFilter.getProperty()) && "in".equals(tQFilter.getCP())) {
            if (Objects.nonNull(tQFilter.getValue())) {
                String idsJson = SerializationUtils.toJsonString((Object)tQFilter.getValue());
                this.getPageCache().put("treeidin", idsJson);
            }
        } else if (BODY_SYSTEM_NUMBER.equals(tQFilter.getProperty())) {
            String systemNumbers = tQFilter.getValue().toString();
            String pattern = "(SYS-\\d+)";
            Pattern regex = Pattern.compile(pattern);
            Matcher matcher = regex.matcher(systemNumbers);
            if (matcher.find()) {
                String result = matcher.group(1);
                this.getPageCache().put(BODY_SYSTEM_NUMBER, result);
            }
        }
    }

    private String convertDimType(TmcTreeNodeTypeProp nodeType) {
        if (MemberManagerListHelper.NODE_ORG.equals((Object)nodeType)) {
            return DimsionEnums.ORG.getNumber();
        }
        if (MemberManagerListHelper.NODE_PERIOD.equals((Object)nodeType)) {
            return DimsionEnums.PERIOD.getNumber();
        }
        if (MemberManagerListHelper.NODE_REPORTTYPE.equals((Object)nodeType)) {
            return DimsionEnums.PERIOD.getNumber();
        }
        if (MemberManagerListHelper.NODE_CURRENCY.equals((Object)nodeType)) {
            return DimsionEnums.CURRENCY.getNumber();
        }
        if (MemberManagerListHelper.NODE_COMPANY.equals((Object)nodeType)) {
            return DimsionEnums.COMPANY.getNumber();
        }
        if (MemberManagerListHelper.NODE_SETLTMENT.equals((Object)nodeType)) {
            return DimsionEnums.SETLTMENT.getNumber();
        }
        if (MemberManagerListHelper.NODE_SUBJECT.equals((Object)nodeType)) {
            return DimsionEnums.SUBJECT.getNumber();
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("dimtype"))) {
            return this.getPageCache().get("dimtype");
        }
        if (Objects.nonNull(nodeType.getParent())) {
            return DimsionEnums.CUSTOM.getNumber();
        }
        return null;
    }

    private List<Long> getAllChildNodeID(TmcTreeNodeTypeProp nodeType, Long parentID) {
        return this.getAllChildNodeID(this.convertDimType(nodeType), parentID);
    }

    private List<Long> getAllChildNodeID(String dimtype, Long parentID) {
        QFilter tQFilter = new QFilter("bodysystem", "=", (Object)Long.valueOf(this.getView().getPageCache().get("bodysystem")));
        if (dimtype != null) {
            tQFilter.and("dimtype", "=", (Object)dimtype);
        }
        ArrayList<Long> childItems = new ArrayList<Long>();
        childItems.add(parentID);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "parent"), (QFilter[])new QFilter[]{tQFilter});
        childItems.addAll(this.getChildNodeID(col, parentID));
        return childItems;
    }

    private List<Long> getChildNodeID(DynamicObjectCollection col, Long parentID) {
        ArrayList<Long> childItems = new ArrayList<Long>(0);
        for (DynamicObject dynamicObject : col) {
            if (parentID.compareTo(dynamicObject.getLong("parent")) != 0) continue;
            Long par1 = dynamicObject.getLong("id");
            childItems.add(par1);
            childItems.addAll(this.getChildNodeID(col, par1));
        }
        return childItems;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String rootId;
        String curId = e.getNodeId().toString();
        if (!StringUtils.equals((CharSequence)curId, (CharSequence)(rootId = this.getTreeModel().getRoot().getId())) && !curId.contains("#")) {
            return;
        }
        super.buildTreeListFilter(e);
    }

    protected QFilter getBillListFilter(TmcTreeNodeProp nodeProp) {
        TmcTreeNodeTypeProp nodeType = nodeProp.getNodeType();
        Object refId = nodeProp.getRefEntityPkValue();
        QFilter tQFilter = null;
        if (refId == null) {
            this.getBodySystem();
            List<TmcTreeNodeRefProp> list = this.loadTreeNodeList(nodeProp);
            if (CollectionUtils.isEmpty(list)) {
                return new QFilter("1", "!=", (Object)1);
            }
            TmcTreeNodeRefProp tmcTreeNodeRefProp = list.get(0);
            String notDimType = this.getPageCache().get("notdimtype");
            if (StringUtils.isNotBlank((CharSequence)notDimType)) {
                tQFilter = QFilter.fromSerializedString((String)notDimType);
            }
            return this.getTreeNodeTypeQFilter(tmcTreeNodeRefProp.getNodeType(), tQFilter);
        }
        if (!TREE_PARENT_ID.equals(refId)) {
            if (MemberManagerListHelper.NODE_REPORTTYPE.equals((Object)nodeType)) {
                tQFilter = new QFilter("reporttype.id", "=", (Object)Long.valueOf(nodeProp.getRefEntityPkValue().toString())).and("parent", "in", this.getAllChildNodeID(nodeType, Long.valueOf(TREE_PARENT_ID)));
                tQFilter.or(new QFilter("parent", "in", this.getAllChildNodeID(nodeType, Long.valueOf(nodeProp.getRefEntityPkValue().toString()))));
            } else {
                tQFilter = new QFilter("parent", "in", this.getAllChildNodeID(nodeType, Long.valueOf(refId.toString())));
            }
            if (((Boolean)this.getModel().getValue("iscontainnow")).booleanValue()) {
                tQFilter.or("id", "=", (Object)Long.valueOf(refId.toString()));
            }
        }
        return this.getTreeNodeTypeQFilter(nodeType, tQFilter);
    }

    private QFilter getTreeNodeTypeQFilter(TmcTreeNodeTypeProp nodeType, QFilter tQFilter) {
        String flowType;
        String enable;
        String idInJson;
        tQFilter = this.initTreeNodeFilter(nodeType, tQFilter);
        String notDimType = this.getPageCache().get("notdimtype");
        if (StringUtils.isNotBlank((CharSequence)notDimType)) {
            tQFilter.and(QFilter.fromSerializedString((String)notDimType));
        }
        if (StringUtils.isNotBlank((CharSequence)(idInJson = this.getPageCache().get("treeidin")))) {
            List ids = SerializationUtils.fromJsonStringToList((String)idInJson, Long.class);
            tQFilter.and("id", "in", (Object)ids);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("id"))) {
            List<Long> tChildNodeItems = this.getAllChildNodeID(nodeType, Long.valueOf(this.getPageCache().get("id")));
            tQFilter.and("id", "not in", tChildNodeItems);
        }
        if (StringUtils.isNotBlank((CharSequence)(enable = this.getPageCache().get("enable")))) {
            tQFilter.and("enable", "=", (Object)enable);
        }
        if (StringUtils.isNotBlank((CharSequence)(flowType = this.getPageCache().get("flow")))) {
            tQFilter.and("flow", "=", (Object)flowType);
        }
        return tQFilter;
    }

    private QFilter initTreeNodeFilter(TmcTreeNodeTypeProp nodeType, QFilter tQFilter) {
        if (tQFilter == null) {
            tQFilter = this.getBodySystem();
        } else {
            tQFilter.and(this.getBodySystem());
        }
        String dimType = this.convertDimType(nodeType);
        if (null != dimType) {
            if (null != nodeType && null != nodeType.getParent() && dimType.equals(DimsionEnums.CUSTOM.getNumber())) {
                String dimensionNumber = nodeType.getName();
                DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((String)"fpm_dimension", (String)"id", (QFilter[])new QFilter[]{this.getBodySystem(), new QFilter("number", "=", (Object)dimensionNumber)});
                tQFilter.and("dimension", "=", dynamicObject.getPkValue());
            } else {
                tQFilter.and("dimtype", "=", (Object)dimType);
            }
        }
        return tQFilter;
    }

    protected List<TmcTreeNodeTypeProp> getTreeNodeTypeList() {
        String modelId;
        String allDimensionNumbers = this.getPageCache().get(PAGE_CACHE_ALL_DIM_NUMBER);
        if (StringUtils.isEmpty((CharSequence)allDimensionNumbers) && StringUtils.isNotEmpty((CharSequence)(modelId = this.getPageCache().get("bodysystem")))) {
            this.reloadDimensionNumberCache(Long.valueOf(modelId));
            allDimensionNumbers = this.getPageCache().get(PAGE_CACHE_ALL_DIM_NUMBER);
        }
        return MemberManagerListHelper.buildByDimensionNumbers(allDimensionNumbers);
    }

    protected List<TmcTreeNodeRefProp> loadTreeNodeList(TmcTreeNodeProp treenodeprop) {
        List<TmcTreeNodeRefProp> nodeRefList;
        TmcTreeNodeTypeProp nodeType = treenodeprop.getNodeType();
        if (TmcTreeNodeTypeProp.ROOT.equals((Object)nodeType)) {
            String dimId;
            QFilter memberFilter = this.getBodySystem();
            QFilter dimFilter = this.getBodySystem();
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("dimtype"))) {
                memberFilter.and("dimtype", "=", (Object)this.getPageCache().get("dimtype"));
                dimFilter.and("basedata", "=", (Object)this.getPageCache().get("dimtype"));
            }
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("notdimtype"))) {
                QFilter tQFilter = QFilter.fromSerializedString((String)this.getPageCache().get("notdimtype"));
                memberFilter.and("dimtype", tQFilter.getCP(), tQFilter.getValue());
                dimFilter.and("basedata", tQFilter.getCP(), tQFilter.getValue());
            }
            if (StringUtils.isNotBlank((CharSequence)(dimId = this.getPageCache().get("dimension")))) {
                memberFilter.and("dimension", "=", (Object)Long.valueOf(dimId));
                dimFilter.and("id", "=", (Object)Long.valueOf(dimId));
            }
            nodeRefList = this.loadRootTreeNodeList(new QFilter[]{dimFilter});
            this.getTreeModel().getTreeFilter().add(memberFilter);
        } else {
            nodeRefList = MemberManagerListHelper.NODE_PERIOD.equals((Object)nodeType) ? this.loadReportTypeTreeNodeList() : this.loadMemTreeNodeList(nodeType, this.getTreeTypeFilter(treenodeprop));
        }
        return nodeRefList;
    }

    private List<TmcTreeNodeRefProp> loadReportTypeTreeNodeList() {
        String modelId = this.getPageCache().get("bodysystem");
        QFilter qFilter = new QFilter("id", "=", (Object)(StringUtils.isBlank((CharSequence)modelId) ? -1L : Long.parseLong(modelId)));
        qFilter.and("applyrereportentry.rereporttypestatus", "=", (Object)"enable");
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)"applyrereportentry.rerporttype.id as id,applyrereportentry.rerporttype.number as number,applyrereportentry.rerporttype.name as name", (QFilter[])new QFilter[]{qFilter}, (String)"id");
        ArrayList<TmcTreeNodeRefProp> nodeRefList = new ArrayList<TmcTreeNodeRefProp>(dims.size());
        for (DynamicObject dim : dims) {
            TmcTreeNodeRefProp tTmcTreeNodeRefProp = new TmcTreeNodeRefProp();
            tTmcTreeNodeRefProp.setNodeName(dim.getString("name"));
            tTmcTreeNodeRefProp.setNodeType(MemberManagerListHelper.NODE_REPORTTYPE);
            tTmcTreeNodeRefProp.setRefEntityPkValue((Object)dim.getLong("id"));
            nodeRefList.add(tTmcTreeNodeRefProp);
        }
        return nodeRefList;
    }

    private List<TmcTreeNodeRefProp> loadMemTreeNodeList(TmcTreeNodeTypeProp nodeType, QFilter qFilter) {
        qFilter = this.getTreeNodeTypeQFilter(nodeType, qFilter);
        ArrayList<TmcTreeNodeRefProp> modelList = new ArrayList<TmcTreeNodeRefProp>(10);
        String selectFields = String.join((CharSequence)",", "longnumber", "number", "parent", "fullname", "id", "name");
        String orderBy = String.join((CharSequence)",", "sortcode", "longnumber");
        DynamicObjectCollection treeMemberColl = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)orderBy);
        List memberNodeIdList = treeMemberColl.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        ArrayList<DynamicObject> memberTreeNodeList = new ArrayList<DynamicObject>(0);
        for (DynamicObject plainMemberObj : treeMemberColl) {
            Long parentId = plainMemberObj.getLong("parent");
            if (!EmptyUtil.isEmpty((Long)parentId) && memberNodeIdList.contains(parentId)) continue;
            memberTreeNodeList.add(plainMemberObj);
        }
        for (DynamicObject dynamicObject : memberTreeNodeList) {
            TmcTreeNodeRefProp treeNodeRefProp = new TmcTreeNodeRefProp();
            treeNodeRefProp.setNodeName(dynamicObject.getString("name"));
            treeNodeRefProp.setNodeType(nodeType);
            treeNodeRefProp.setRefEntityPkValue((Object)dynamicObject.getString("id"));
            modelList.add(treeNodeRefProp);
        }
        return modelList;
    }

    protected boolean getNodeIsLeaf(TmcTreeNodeRefProp nodeRefModel) {
        QFilter tQFilter = this.getTreeNodeTypeQFilter(nodeRefModel.getNodeType(), null);
        if (MemberManagerListHelper.NODE_REPORTTYPE.equals((Object)nodeRefModel.getNodeType())) {
            QFilter t = new QFilter("reporttype.id", "=", (Object)Long.valueOf(nodeRefModel.getRefEntityPkValue().toString()));
            if (!TREE_PARENT_ID.equals(nodeRefModel.getRefEntityPkValue().toString())) {
                t.or(new QFilter("parent", "=", (Object)Long.valueOf(nodeRefModel.getRefEntityPkValue().toString())));
            }
            tQFilter.and(t);
        } else {
            if (MemberManagerListHelper.NODE_PERIOD.equals((Object)nodeRefModel.getNodeType())) {
                List<TmcTreeNodeRefProp> nodeRefList = this.loadReportTypeTreeNodeList();
                return nodeRefList.size() <= 0;
            }
            tQFilter.and("parent", "=", (Object)Long.valueOf(nodeRefModel.getRefEntityPkValue().toString()));
        }
        return !QueryServiceHelper.exists((String)"fpm_member", (QFilter[])new QFilter[]{tQFilter});
    }

    private List<TmcTreeNodeRefProp> loadRootTreeNodeList(QFilter[] qFilters) {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"fpm_dimension", (String)"id,name,number,basedata", (QFilter[])qFilters, (String)"id");
        ArrayList<TmcTreeNodeRefProp> nodeRefList = new ArrayList<TmcTreeNodeRefProp>(dims.size());
        for (DynamicObject dim : dims) {
            TmcTreeNodeRefProp tTmcTreeNodeRefProp = new TmcTreeNodeRefProp();
            tTmcTreeNodeRefProp.setNodeName(dim.getString("name"));
            TmcTreeNodeTypeProp tNodeType = new TmcTreeNodeTypeProp(dim.getString("number"), TmcTreeNodeTypeProp.ROOT, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
            tTmcTreeNodeRefProp.setNodeType(tNodeType);
            tTmcTreeNodeRefProp.setRefEntityPkValue((Object)TREE_PARENT_ID);
            nodeRefList.add(tTmcTreeNodeRefProp);
        }
        return nodeRefList;
    }

    private QFilter getTreeTypeFilter(TmcTreeNodeProp treenodeprop) {
        if (treenodeprop.isRoot()) {
            return null;
        }
        QFilter treeTypeFilter = null;
        Object treeTypeId = treenodeprop.getParentRefEntityPkValue(treenodeprop.getNodeType());
        if (MemberManagerListHelper.NODE_PERIOD.equals((Object)treenodeprop.getNodeType())) {
            treeTypeFilter = new QFilter("reporttype.id", "=", (Object)Long.valueOf(treeTypeId.toString()));
            treeTypeFilter.and("parent", "=", (Object)Long.valueOf(TREE_PARENT_ID));
        } else if (MemberManagerListHelper.NODE_REPORTTYPE.equals((Object)treenodeprop.getNodeType())) {
            treeTypeFilter = new QFilter("reporttype.id", "=", (Object)Long.valueOf(treeTypeId.toString()));
            if (!TREE_PARENT_ID.equals(treeTypeId.toString())) {
                treeTypeFilter.or(new QFilter("parent", "=", (Object)Long.valueOf(treeTypeId.toString())));
            }
        } else if (treeTypeId != null && !treeTypeId.toString().equals("null") && !treeTypeId.toString().equals(TREE_PARENT_ID)) {
            treeTypeFilter = new QFilter("parent", "=", (Object)Long.valueOf(treeTypeId.toString()));
        }
        if (MemberManagerListHelper.NODE_PERIOD.equals((Object)treenodeprop.getNodeType())) {
            QFilter tTypeStatus = new QFilter("applyrereportentry.rereporttypestatus", "=", (Object)"BaseDimMemberProp.ENABLE");
            tTypeStatus.and("id", "=", (Object)Long.valueOf(this.getPageCache().get("bodysystem")));
            DynamicObjectCollection tRerportTypes = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)"applyrereportentry.rerporttype.id", (QFilter[])new QFilter[]{tTypeStatus});
            List tRerportTypeLists = tRerportTypes.stream().map(v -> v.getLong("applyrereportentry.rerporttype.id")).collect(Collectors.toList());
            if (treeTypeFilter == null) {
                treeTypeFilter = new QFilter("reporttype.id", "in", tRerportTypeLists);
            } else {
                treeTypeFilter.and("reporttype.id", "in", tRerportTypeLists);
            }
        }
        return treeTypeFilter;
    }

    private void setBodySystem(FilterContainerSearchClickArgs args) {
        QFilter enableFilter;
        FilterContainer tFilterContainer = (FilterContainer)this.getControl("filtercontainerap");
        List tQFilters = tFilterContainer.getContext().getClientQueryFilterParameter().getQFilters();
        boolean columnFilterChange = false;
        QFilter systemQFilter = FpmHelper.getQFilterByKey((List)tQFilters, (String)"bodysystem.id");
        if (Objects.nonNull(systemQFilter)) {
            String sysIdStr = systemQFilter.getValue().toString();
            if (NumberUtils.isNumber((Object)sysIdStr)) {
                Long systemId = Long.valueOf(sysIdStr);
                columnFilterChange = !systemId.toString().equals(this.getPageCache().get("bodysystem"));
                this.getPageCache().put("bodysystem", systemId.toString());
                DefaultModelHelper.save(systemId);
                this.reloadDimensionNumberCache(systemId);
            } else {
                columnFilterChange = true;
            }
        }
        if (Objects.nonNull(enableFilter = FpmHelper.getQFilterByKey((List)tQFilters, (String)"enable"))) {
            Object enableValue = enableFilter.getValue();
            columnFilterChange = columnFilterChange || !enableValue.toString().equals(this.getPageCache().get("enable"));
            this.getPageCache().put("enable", enableFilter.getValue().toString());
        } else {
            this.getPageCache().remove("enable");
            String noLimit = this.getPageCache().get("enable_no_limit");
            boolean flag = false;
            if (EmptyUtil.isNoEmpty((String)noLimit) && Boolean.parseBoolean(noLimit)) {
                this.getPageCache().put("enable_no_limit", "false");
            } else if (EmptyUtil.isEmpty((String)noLimit) || Boolean.parseBoolean(noLimit)) {
                flag = true;
                this.getPageCache().put("enable_no_limit", "true");
            }
            columnFilterChange = columnFilterChange || flag;
        }
        QFilter flowFilter = FpmHelper.getQFilterByKey((List)tQFilters, (String)"flow");
        if (Objects.nonNull(flowFilter)) {
            Object flowValue = flowFilter.getValue();
            columnFilterChange = columnFilterChange || !flowValue.toString().equals(this.getPageCache().get("flow"));
            this.getPageCache().put("flow", flowFilter.getValue().toString());
        } else {
            columnFilterChange = columnFilterChange || !Objects.isNull(this.getPageCache().get("flow"));
            this.getPageCache().put("flow", null);
        }
        boolean fastFilterEmpty = CollectionUtils.isEmpty((Collection)args.getFastQFilters());
        if (columnFilterChange || fastFilterEmpty) {
            this.forceRefreshTree();
        }
    }

    private void reloadDimensionNumberCache(Long systemId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("bodysystem", "=", (Object)systemId)};
        DynamicObjectCollection dimension = QueryServiceHelper.query((String)"fpm_dimension", (String)"number", (QFilter[])qFilters);
        if (CollectionUtils.isEmpty((Collection)dimension)) {
            return;
        }
        String allDimNumberStr = dimension.stream().map(item -> item.getString("number")).collect(Collectors.joining(","));
        this.getPageCache().put(PAGE_CACHE_ALL_DIM_NUMBER, allDimNumberStr);
    }

    private QFilter getBodySystem() {
        String systemId = this.getPageCache().get("bodysystem");
        if (StringUtils.isNotBlank((CharSequence)systemId)) {
            return new QFilter("bodysystem", "=", (Object)Long.parseLong(systemId));
        }
        QFilter doNothingFilter = new QFilter("bodysystem", "=", (Object)-1L);
        String systemNumber = this.getPageCache().get(BODY_SYSTEM_NUMBER);
        if (StringUtils.isBlank((CharSequence)systemNumber)) {
            if (StringUtils.isBlank((CharSequence)this.getPageCache().get("bodysystem"))) {
                Long defaultSystemId = DefaultModelHelper.getBaseDataDefaultSystemId();
                if (Objects.isNull(defaultSystemId)) {
                    return doNothingFilter;
                }
                systemId = String.valueOf(defaultSystemId);
                this.getPageCache().put("bodysystem", systemId);
                return new QFilter("bodysystem", "=", (Object)Long.parseLong(systemId));
            }
            return doNothingFilter;
        }
        DynamicObject bodySysManager = QueryServiceHelper.queryOne((String)"fpm_bodysysmanage", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)systemNumber)});
        if (bodySysManager == null) {
            return doNothingFilter;
        }
        Long systemIdByNumber = bodySysManager.getLong("id");
        this.getPageCache().put("bodysystem", systemIdByNumber.toString());
        return new QFilter("bodysystem", "=", (Object)systemIdByNumber);
    }

    public void treeToolbarClick(EventObject e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (("iscontainnow".equals(key) || "isshowdisabled".equals(key)) && e.getChangeSet().length > 0 && this.getTreeListView().getTreeModel() != null && this.getTreeListView().getTreeModel().getCurrentNodeId() != null && this.getTreeListView().getTreeModel().getRoot() != null && this.getTreeListView().getTreeModel().getGroupProp() != null && this.getTreeListView().getTreeModel().getRoot().getTreeNode(this.getTreeListView().getTreeModel().getCurrentNodeId().toString(), 99) != null) {
            TreeNode rootNode = this.getTreeListView().getTreeModel().getRoot();
            GroupProp groupProp = this.getTreeListView().getTreeModel().getGroupProp();
            String currentNodeId = DbTypeConverter.safeConvert((int)groupProp.getDbType(), (Object)rootNode.getTreeNode(this.getTreeListView().getTreeModel().getCurrentNodeId().toString(), 99).getId()).toString();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(0);
            if (currentNodeId.indexOf("#") > 0 && !rootNode.getId().equals(currentNodeId)) {
                String dimtype = currentNodeId.substring(currentNodeId.indexOf("/") + 1, currentNodeId.indexOf("#"));
                QFilter qFiter = new QFilter("dimtype", "=", (Object)dimtype);
                if (currentNodeId.split("/").length > 2) {
                    String parentid = currentNodeId.substring(currentNodeId.lastIndexOf("#") + 1);
                    qFiter.and(groupProp.getName(), "in", this.getAllChildNodeID(dimtype, Long.valueOf(parentid)));
                    if (((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
                        qFiter.or(new QFilter("id", "=", (Object)Long.valueOf(parentid)));
                    }
                }
                filters.add(qFiter);
            }
            BillList billList = (BillList)this.getControl("billlistap");
            FieldEdit showDisabledDataEdit = (FieldEdit)this.getControl("isshowdisabled");
            boolean showDisabledData = false;
            if (showDisabledDataEdit != null) {
                showDisabledData = (Boolean)showDisabledDataEdit.getModel().getValue("isshowdisabled");
            }
            billList.setShowDisabledData(showDisabledData);
            billList.setQueryFilterParameter(new FilterParameter(filters, null));
            boolean isF7 = false;
            if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
                isF7 = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
            }
            if (!isF7) {
                billList.clearEntryState();
                billList.clearSelection();
            }
            billList.refresh();
        }
    }

    private void handleSearchAp() {
        String searchApStr = "searchap";
        String flexPanelStr = "flexpanel_treebtn";
        String flexPanelInFlexPanelStr = "flexpanel_treebtn_inflexpanel";
        String flexPanelInLabelStr = "flexpanel_treebtn_inlabel";
        String lineFlexPanelStr = "line_flexpanelap";
        String splitPanelStr = "splitpanelap";
        Control searchAp = this.getControl("searchap");
        if (Objects.isNull(searchAp)) {
            return;
        }
        String searchLabelInit = this.getPageCache().get("searchLabelInit");
        if (StringUtils.isNotEmpty((CharSequence)searchLabelInit) && Boolean.parseBoolean(searchLabelInit)) {
            return;
        }
        Container flexPanel = (Container)this.getView().getControl("flexpanel_treebtn");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"searchap"});
        LabelAp button = new LabelAp();
        button.setKey("flexpanel_treebtn_inlabel");
        button.setName(new LocaleString(ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"MemberManagerTreeListPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0])));
        button.setWidth(new LocaleString("60%"));
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("10%");
        style.setPadding(padding);
        button.setStyle(style);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("flexpanel_treebtn_inflexpanel");
        flexPanelAp.setJustifyContent("flex-start");
        flexPanelAp.getItems().add(button);
        flexPanel.insertControls(0, Collections.singletonList(flexPanelAp.createControl()));
        Container splitPanel = (Container)this.getView().getControl("splitpanelap");
        FlexPanelAp lineFlexPanelAp = new FlexPanelAp();
        lineFlexPanelAp.setKey("line_flexpanelap");
        lineFlexPanelAp.setWidth(new LocaleString("98%"));
        lineFlexPanelAp.setHeight(new LocaleString("5px"));
        lineFlexPanelAp.setGrow(0);
        lineFlexPanelAp.setShrink(0);
        lineFlexPanelAp.setBackColor("#f4f4f4");
        splitPanel.insertControls(1, Collections.singletonList(lineFlexPanelAp.createControl()));
        this.getPageCache().put("searchLabelInit", "true");
    }
}

