/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.operate.SetEntryBottom;
import kd.bos.form.operate.SetEntryTop;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.formplugin.domain.dimension.MemberSortVO;
import kd.tmc.fpm.formplugin.helper.MemberSortHelper;

public class MemberSortPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initMemberEntryEntity();
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnsettop": {
                this.setTop();
                break;
            }
            case "btnsetbottom": {
                this.setBottom();
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control c = (Control)evt.getSource();
        String itemKey = c.getKey().toLowerCase();
        if ("btnok".equals(itemKey)) {
            this.save();
        }
    }

    private void save() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        int count = entryEntity.size();
        ArrayList<Long> ids = new ArrayList<Long>(count);
        HashMap<Long, Integer> orgSortMap = new HashMap<Long, Integer>(count);
        int sort = 1;
        for (DynamicObject entryObj : entryEntity) {
            Long memberId = entryObj.getLong("memberid");
            orgSortMap.put(memberId, sort++);
            ids.add(memberId);
        }
        QFilter filter = new QFilter("parent", "=", (Object)this.getParentId());
        filter.and(new QFilter("id", "in", ids));
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = String.join((CharSequence)",", "level", "sortcode", "longnumber", "id", "parent");
        DynamicObjectCollection memberObjColl = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])filters);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)memberObjColl)) {
            return;
        }
        Set<Long> parentIdSet = memberObjColl.stream().map(memberObj -> memberObj.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection childrenMemberObjColl = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])this.getAllMemberFilters(parentIdSet));
        ArrayList<MemberSortVO> memberSortVOList = new ArrayList<MemberSortVO>(memberObjColl.size());
        for (DynamicObject memberObj2 : memberObjColl) {
            long pkId = memberObj2.getLong("id");
            Integer newSort = (Integer)orgSortMap.get(pkId);
            int currLevel = memberObj2.getInt("level");
            String oldSortCode = memberObj2.getString("sortcode");
            String newSortCode = EmptyUtil.isEmpty((String)oldSortCode) || !MemberSortHelper.isValidate(oldSortCode, currLevel) ? this.getSortCodeFromParent(newSort) : MemberSortHelper.getNewSortCodeCurrentLevel(oldSortCode, currLevel, newSort);
            MemberSortVO memberSortVO = new MemberSortVO(pkId, oldSortCode, newSortCode);
            memberSortVOList.add(memberSortVO);
            memberSortVOList.addAll(MemberSortHelper.getChildMemberSortVO(childrenMemberObjColl, memberSortVO));
        }
        memberSortVOList.sort(Comparator.comparing(MemberSortVO::getMemberId));
        new DataSaveServiceImpl().updateAndCheckResult(() -> "update t_fpm_member set fsortcode=? where fid=?", memberSortVOList, (a, b) -> {
            b.add(a.getNewSortCode());
            b.add(a.getMemberId());
        });
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().returnDataToParent((Object)"save");
        this.getView().close();
    }

    private String getSortCodeFromParent(int newSort) {
        QFilter filter = new QFilter("id", "=", (Object)this.getParentId());
        String selectFields = String.join((CharSequence)",", "sortcode", "longnumber", "id");
        DynamicObject parentMember = QueryServiceHelper.queryOne((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isEmpty((DynamicObject)parentMember)) {
            return MemberSortHelper.formatSortCode(newSort);
        }
        String parentSortCode = EmptyUtil.isNoEmpty((String)parentMember.getString("sortcode")) ? parentMember.getString("sortcode") : parentMember.getString("longnumber");
        return String.join((CharSequence)"!", parentSortCode, MemberSortHelper.formatSortCode(newSort));
    }

    private void setTop() {
        SetEntryTop setEntryTop = new SetEntryTop("entryentity", this.getView());
        setEntryTop.invokeOperation();
    }

    private void setBottom() {
        SetEntryBottom setEntryBottom = new SetEntryBottom("entryentity", this.getView());
        setEntryBottom.invokeOperation();
    }

    private void initMemberEntryEntity() {
        QFilter[] filters = this.getMemberFilters();
        String selectFields = String.join((CharSequence)",", "number", "name", "enable", "fullname", "description", "id");
        DynamicObjectCollection memberObjColl = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])filters, (String)"sortcode");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)memberObjColl)) {
            return;
        }
        int count = memberObjColl.size();
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("entryentity", count);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int rowIndex = 0;
        for (DynamicObject memberObj : memberObjColl) {
            DynamicObject row = (DynamicObject)entryEntity.get(rowIndex);
            row.set("number", memberObj.get("number"));
            row.set("name", memberObj.get("name"));
            row.set("enable", memberObj.get("enable"));
            row.set("fullname", memberObj.get("fullname"));
            row.set("description", memberObj.get("description"));
            row.set("memberid", memberObj.get("id"));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private QFilter[] getMemberFilters() {
        QFilter memberFilter = new QFilter("parent", "=", (Object)this.getParentId());
        memberFilter.and(new QFilter("dimension", "=", (Object)this.getDimensionId()));
        memberFilter.and(new QFilter("bodysystem", "=", (Object)this.getSystemId()));
        return new QFilter[]{memberFilter};
    }

    private QFilter[] getAllMemberFilters(Set<Long> parentIds) {
        QFilter memberFilter = new QFilter("id", "not in", parentIds);
        memberFilter.and(new QFilter("dimension", "=", (Object)this.getDimensionId()));
        memberFilter.and(new QFilter("bodysystem", "=", (Object)this.getSystemId()));
        return new QFilter[]{memberFilter};
    }

    private Long getParentId() {
        Object parentIdParam = this.getView().getFormShowParameter().getCustomParam("parent");
        return Long.valueOf(parentIdParam.toString());
    }

    private Long getSystemId() {
        Object systemIdParam = this.getView().getFormShowParameter().getCustomParam("system");
        return Long.valueOf(systemIdParam.toString());
    }

    private String getDimType() {
        return (String)this.getView().getFormShowParameter().getCustomParam("dimType");
    }

    private Long getDimensionId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("dimensionid");
    }
}

