/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.PeriodDirection;
import kd.tmc.fpm.common.enums.BeginOrEndMarkEnum;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.enums.WaysEnum;
import org.apache.commons.lang3.StringUtils;

public class MemberSubjectEditPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"formula", "flow"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject parentSubject;
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String subjectId = this.getView().getParentView().getPageCache().get("cache_subjectmember_id");
        if (null != subjectId && Objects.nonNull(parentSubject = QueryServiceHelper.queryOne((String)"fpm_member", (String)"id,flow", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(subjectId))}))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"flow", (Object)parentSubject.getString("flow"));
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"parent", (Object)Long.parseLong(subjectId));
        }
        this.getView().getParentView().getPageCache().remove("cache_subjectmember_id");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus.toString().equals("EDIT")) {
            boolean isleaf = (Boolean)this.getModel().getValue("isleaf");
            if (!isleaf) {
                ComboEdit waysCombo = (ComboEdit)this.getControl("ways");
                WaysEnum[] waysEnums = WaysEnum.values();
                ArrayList<ComboItem> items = new ArrayList<ComboItem>(waysEnums.length - 1);
                for (WaysEnum ways : waysEnums) {
                    if (ways.getValue().equals(WaysEnum.DETAILED_REPORT.getValue())) continue;
                    items.add(new ComboItem(new LocaleString(ways.getName()), ways.getValue()));
                }
                waysCombo.setComboItems(items);
            }
            this.initLinkEndSubject();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("formula".equals(key)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("fpm_subjectformula");
            final Object modelId = ((DynamicObject)this.getModel().getValue("bodysysmanage")).getPkValue();
            final Object express = this.getModel().getValue("formulavalue_tag");
            final Object expressDesc = this.getModel().getValue("formula");
            final Object subjectId = this.getModel().getValue("id");
            parameter.setCustomParams((Map)new HashMap<String, Object>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("model", modelId);
                    this.put("id", subjectId);
                    this.put("express", express);
                    this.put("expressDesc", expressDesc);
                }
            });
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_formulaedit"));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent ccevt) {
        super.closedCallBack(ccevt);
        String actionId = ccevt.getActionId();
        if ("close_formulaedit".equals(actionId)) {
            Map returnData = (Map)ccevt.getReturnData();
            if (null == returnData) {
                return;
            }
            String descript = (String)returnData.get("expressiondesc");
            this.getModel().setValue("formula", (Object)(descript.length() > 1000 ? descript.substring(0, 997) : descript));
            this.getModel().setValue("formulavalue", returnData.get("expression"));
            this.getModel().setValue("formulavalue_tag", returnData.get("expression"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                DynamicObject parentMember = (DynamicObject)this.getModel().getValue("parent");
                this.getView().getPageCache().put("cache_subjectmember_upid", Optional.ofNullable(parentMember).map(o -> o.getString("id")).orElseGet(() -> null));
                break;
            }
            case "new": {
                String subjectId = this.getView().getPageCache().get("cache_subjectmember_upid");
                Optional.ofNullable(subjectId).ifPresent(o -> {
                    this.getModel().setValue("parent", o);
                    DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
                    if (null != parent) {
                        this.getModel().setValue("flow", (Object)parent.getString("flow"));
                    }
                    this.getModel().setValue("parent", (Object)parent);
                });
                this.getPageCache().remove("cache_subjectmember_upid");
                break;
            }
        }
    }

    private void initLinkEndSubject() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean containBeginMarkProp = dataEntity.getDataEntityType().getProperties().containsKey((Object)"beginorendmark");
        if (!containBeginMarkProp) {
            return;
        }
        String beginMarkStr = dataEntity.getString("beginorendmark");
        PeriodDirection beginMark = (PeriodDirection)ITypeEnum.getByNumber((String)beginMarkStr, PeriodDirection.class);
        if (Objects.isNull(beginMark) || !beginMark.isBeginning()) {
            return;
        }
        long subjectId = dataEntity.getLong("id");
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])new QFilter[]{new QFilter("linksubject.id", "=", (Object)subjectId)}, null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        List<Long> pkValues = ids.stream().map(item -> Long.parseLong(item.toString())).collect(Collectors.toList());
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"linkendsubject", (Object)pkValues.toArray(new Long[0]));
    }

    private void initF7() {
        IDataModel model = this.getModel();
        DynamicObject subjectMember = model.getDataEntity();
        BasedataEdit linkSubjectEdit = (BasedataEdit)this.getControl("linksubject");
        linkSubjectEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("flow", "=", (Object)FlowEnum.BALANCE.getValue());
            filter.and("beginorendmark", "=", (Object)BeginOrEndMarkEnum.BEGIN_PERIOD.getValue());
            filter.and("dimtype", "=", model.getValue("dimtype"));
            filter.and("bodysystem", "=", subjectMember.getDynamicObject("bodysystem").getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
        });
        BasedataEdit linkParentEdit = (BasedataEdit)this.getControl("parent");
        linkParentEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String flow = subjectMember.getString("flow");
            if (StringUtils.isBlank((CharSequence)flow)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6d41\u5411", (String)"MemberSubjectEditPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and("ways", "!=", (Object)"3");
            filter.and("flow", "=", (Object)flow);
            showParameter.getListFilterParameter().setFilter(filter);
        });
        linkSubjectEdit.addAfterF7SelectListener(afterF7SelectEvent -> {
            String number;
            String repeatNumber;
            Long subjectId = null;
            ListSelectedRowCollection listSelectedRowCollection = afterF7SelectEvent.getListSelectedRowCollection();
            if (CollectionUtils.isNotEmpty((Collection)listSelectedRowCollection)) {
                ListSelectedRow listSelectedRow = listSelectedRowCollection.get(0);
                subjectId = Long.parseLong(listSelectedRow.getPrimaryKeyValue().toString());
            } else if (Objects.nonNull(afterF7SelectEvent.getInputValue())) {
                subjectId = Long.parseLong(afterF7SelectEvent.getInputValue().toString());
            }
            String prop = String.join((CharSequence)",", "number", "name", "linksubject.number", "linksubject.name");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fpm_member", (String)prop, (QFilter[])new QFilter[]{new QFilter("linksubject", "=", (Object)subjectId), new QFilter("bodysysmanage", "=", subjectMember.getDynamicObject("bodysystem").getPkValue())});
            if (Objects.nonNull(dynamicObject) && !StringUtils.equals((CharSequence)(repeatNumber = dynamicObject.getString("number")), (CharSequence)(number = subjectMember.getString("number")))) {
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u671f\u521d\u79d1\u76ee\u201c%1$s\u201d\u5df2\u88ab\u201c%2$s\u201d\u5173\u8054\uff0c\u7cfb\u7edf\u9650\u5236\u540c\u4e00\u4e2a\u671f\u521d\u79d1\u76ee\u4ec5\u5141\u8bb8\u88ab\u4e00\u4e2a\u671f\u672b\u8ba1\u5212\u79d1\u76ee\u5173\u8054\uff0c\u8bf7\u786e\u8ba4\u76f8\u5173\u914d\u7f6e\u3002", (String)"SubjectMemberEditPlugin_05", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                String beginName = dynamicObject.getString("linksubject.number") + dynamicObject.getString("linksubject.name");
                String endName = repeatNumber + dynamicObject.getString("name");
                this.getView().showErrorNotification(String.format(msg, beginName, endName));
                this.getView().getModel().setValue("linksubject", null);
            }
        });
    }
}

